/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.http.annotation.Controller;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.annotation.OpenAPIInclude;
import io.micronaut.openapi.annotation.OpenAPIIncludes;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.OpenApiControllerVisitor;
import io.micronaut.openapi.visitor.OpenApiEndpointVisitor;
import io.micronaut.openapi.visitor.OpenApiGroupInfoVisitor;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.processing.SupportedOptions;

@SupportedOptions(value={"micronaut.openapi.enabled"})
public class OpenApiIncludeVisitor
implements TypeElementVisitor<OpenAPIIncludes, Object> {
    public void start(VisitorContext context) {
        Utils.init(context);
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        if (!ConfigUtils.isOpenApiEnabled(context) || !ConfigUtils.isSpecGenerationEnabled(context)) {
            return;
        }
        for (AnnotationValue includeAnn : element.getAnnotationValuesByType(OpenAPIInclude.class)) {
            Object[] classes = includeAnn.stringValues();
            if (ArrayUtils.isEmpty((Object[])classes)) continue;
            List tagAnns = includeAnn.getAnnotations("tags", Tag.class);
            List securityAnns = includeAnn.getAnnotations("security", SecurityRequirement.class);
            String customUri = includeAnn.stringValue("uri").orElse(null);
            List<String> groups = List.of(includeAnn.stringValues("groups"));
            List<String> groupsExcluded = List.of(includeAnn.stringValues("groupsExcluded"));
            OpenApiGroupInfoVisitor groupVisitor = new OpenApiGroupInfoVisitor(groups, groupsExcluded);
            OpenApiControllerVisitor controllerVisitor = new OpenApiControllerVisitor(tagAnns, securityAnns, customUri);
            OpenApiEndpointVisitor endpointVisitor = new OpenApiEndpointVisitor(true, tagAnns.isEmpty() ? null : tagAnns, securityAnns.isEmpty() ? null : securityAnns);
            for (Object className : classes) {
                ClassElement classEl = ContextUtils.getClassElement((String)className, context);
                if (classEl == null) continue;
                groupVisitor.visitClass(classEl, context);
                if (classEl.isAnnotationPresent(Controller.class)) {
                    this.visit(controllerVisitor, context, classEl);
                    continue;
                }
                if (!classEl.isAnnotationPresent("io.micronaut.management.endpoint.annotation.Endpoint")) continue;
                this.visit(endpointVisitor, context, classEl);
            }
        }
    }

    private void visit(TypeElementVisitor<?, ?> visitor, VisitorContext context, ClassElement ce) {
        visitor.visitClass(ce, context);
        ce.getEnclosedElements(ElementQuery.ALL_METHODS.modifiers(mods -> !mods.contains(ElementModifier.STATIC) && !mods.contains(ElementModifier.PRIVATE)).named(name -> !name.contains("$"))).forEach(method -> visitor.visitMethod(method, context));
    }
}

