/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.EnumConstantElement;
import io.micronaut.inject.ast.EnumElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.GenericElement;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.PropertyElementQuery;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.ast.WildcardElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.OpenApiUtils;
import io.micronaut.openapi.javadoc.JavadocDescription;
import io.micronaut.openapi.swagger.core.util.PrimitiveType;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.ElementUtils;
import io.micronaut.openapi.visitor.NumberUtils;
import io.micronaut.openapi.visitor.OpenApiApplicationVisitor;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.ProtoUtils;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.micronaut.openapi.visitor.Utils;
import io.micronaut.openapi.visitor.VisibilityLevel;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.links.Link;
import io.swagger.v3.oas.annotations.links.LinkParameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.DiscriminatorMapping;
import io.swagger.v3.oas.annotations.media.Encoding;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.servers.ServerVariable;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;

@Internal
public final class SchemaDefinitionUtils {
    private static List<String> inProgressSchemas = new ArrayList<String>(10);
    private static Map<String, String> schemaNameToClassNameMap = new HashMap<String, String>();
    private static Map<String, Integer> shemaNameSuffixCounterMap = new HashMap<String, Integer>();
    private static Map<String, PropertyNamingStrategy> propertyNamingStrategyInstances = new HashMap<String, PropertyNamingStrategy>();

    private SchemaDefinitionUtils() {
    }

    public static void clean() {
        inProgressSchemas = new ArrayList<String>(10);
        schemaNameToClassNameMap = new HashMap<String, String>();
        shemaNameSuffixCounterMap = new HashMap<String, Integer>();
        propertyNamingStrategyInstances = new HashMap<String, PropertyNamingStrategy>();
    }

    public static Schema<?> readSchema(AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaValue, OpenAPI openAPI, VisitorContext context, @Nullable Element type, Map<String, ClassElement> typeArgs, @Nullable Element definingElement, List<MediaType> mediaTypes, @Nullable ClassElement jsonViewClass) {
        EnumElement enumEl;
        Schema schema = SchemaUtils.setSpecVersion(new Schema());
        SchemaDefinitionUtils.processSchemaAnn(schema, context, definingElement, (ClassElement)type, schemaValue);
        String elType = SchemaUtils.getType(schema);
        String elFormat = schema.getFormat();
        if (elType == null && type instanceof ClassElement) {
            EnumElement enumEl2;
            ClassElement classEl = (ClassElement)type;
            Pair<String, String> typeAndFormat = classEl instanceof EnumElement && ElementUtils.isEnum((ClassElement)(enumEl2 = (EnumElement)classEl)) ? ConvertUtils.checkEnumJsonValueType(context, enumEl2, null, elFormat) : ConvertUtils.getTypeAndFormatByClass(classEl.getName(), classEl.isArray(), classEl);
            elType = typeAndFormat.getFirst();
            schema.setType(elType);
            if (elFormat == null) {
                elFormat = typeAndFormat.getSecond();
                schema.setFormat(elFormat);
            }
        }
        if (type instanceof EnumElement && ElementUtils.isEnum((ClassElement)(enumEl = (EnumElement)type))) {
            if (CollectionUtils.isEmpty((Collection)schema.getEnum())) {
                schema.setEnum(SchemaDefinitionUtils.getEnumValues(enumEl, schema.getType(), schema.getFormat(), context));
            }
        } else {
            JavadocDescription javadoc = type != null ? Utils.getJavadocParser().parse(type.getDescription()) : null;
            SchemaDefinitionUtils.populateSchemaProperties(openAPI, context, type, typeArgs, schema, mediaTypes, javadoc, jsonViewClass);
            SchemaDefinitionUtils.checkAllOf((Schema<Object>)schema);
        }
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static Schema<?> getSchemaDefinition(OpenAPI openAPI, VisitorContext context, ClassElement type, Map<String, ClassElement> typeArgs, @Nullable Element definingElement, List<MediaType> mediaTypes, @Nullable ClassElement jsonViewClass) {
        ClassElement classEl;
        Schema<?> schema;
        boolean schemaAnnOnField = false;
        AnnotationValue schemaValue = null;
        if (definingElement != null) {
            if (definingElement instanceof PropertyElement) {
                Optional setterOpt;
                PropertyElement propertyEl = (PropertyElement)definingElement;
                Optional getterOpt = propertyEl.getReadMethod();
                if (getterOpt.isPresent()) {
                    schemaValue = ((MethodElement)getterOpt.get()).getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
                    boolean bl = schemaAnnOnField = schemaValue != null;
                }
                if (schemaValue == null && (setterOpt = propertyEl.getWriteMethod()).isPresent()) {
                    schemaValue = ((MethodElement)setterOpt.get()).getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
                    schemaAnnOnField = schemaValue != null;
                }
            } else {
                schemaValue = definingElement.getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
                boolean bl = schemaAnnOnField = schemaValue != null && definingElement instanceof FieldElement;
            }
        }
        if (schemaValue == null) {
            schemaValue = type.getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        }
        Map<String, Schema> schemas = SchemaUtils.resolveSchemas(openAPI);
        if (schemaValue == null) {
            boolean isBasicType = ElementUtils.isJavaBasicType(type.getName());
            PrimitiveType primitiveType = isBasicType ? (PrimitiveType)ClassUtils.forName((String)type.getName(), (ClassLoader)SchemaDefinitionUtils.class.getClassLoader()).map(PrimitiveType::fromType).orElse(null) : null;
            if (primitiveType != null) return SchemaUtils.setSpecVersion(primitiveType.createProperty());
            String schemaName = SchemaDefinitionUtils.computeDefaultSchemaName(null, definingElement, (Element)type, typeArgs, context, jsonViewClass);
            schema = schemas.get(schemaName);
            JavadocDescription javadoc = Utils.getJavadocParser().parse(type.getDocumentation().orElse(null));
            if (schema == null) {
                EnumElement enumEl;
                if (type instanceof EnumElement && ElementUtils.isEnum((ClassElement)(enumEl = (EnumElement)type))) {
                    schema = SchemaUtils.setSpecVersion(new Schema());
                    schema.setName(schemaName);
                    SchemaDefinitionUtils.processJacksonDescription((Element)enumEl, schema);
                    if (schema.getDescription() == null && javadoc != null && StringUtils.hasText((CharSequence)javadoc.getMethodDescription())) {
                        schema.setDescription(javadoc.getMethodDescription());
                    }
                    schemas.put(schemaName, schema);
                    Pair<String, String> typeAndFormat = ConvertUtils.checkEnumJsonValueType(context, enumEl, schema.getType(), schema.getFormat());
                    schema.setType(typeAndFormat.getFirst());
                    schema.setFormat(typeAndFormat.getSecond());
                    if (CollectionUtils.isEmpty((Collection)schema.getEnum())) {
                        schema.setEnum(SchemaDefinitionUtils.getEnumValues(enumEl, schema.getType(), schema.getFormat(), context));
                    }
                } else {
                    Schema<?> schemaWithSuperTypes = SchemaDefinitionUtils.processSuperTypes(null, schemaName, type, definingElement, openAPI, mediaTypes, schemas, context, jsonViewClass);
                    if (schemaWithSuperTypes != null) {
                        schema = schemaWithSuperTypes;
                    }
                    SchemaDefinitionUtils.processJacksonDescription((Element)type, schema);
                    if (schema != null && schema.getDescription() == null && javadoc != null && StringUtils.hasText((CharSequence)javadoc.getMethodDescription())) {
                        schema.setDescription(javadoc.getMethodDescription());
                    }
                    SchemaDefinitionUtils.populateSchemaProperties(openAPI, context, (Element)type, typeArgs, schema, mediaTypes, javadoc, jsonViewClass);
                    SchemaDefinitionUtils.checkAllOf(schema);
                }
            }
        } else {
            String schemaName = SchemaDefinitionUtils.computeDefaultSchemaName(!schemaAnnOnField ? (String)schemaValue.stringValue("name").orElse(null) : null, definingElement, (Element)type, typeArgs, context, jsonViewClass);
            schema = schemas.get(schemaName);
            if (schema == null) {
                if (inProgressSchemas.contains(schemaName)) {
                    return SchemaUtils.setSpecVersion(new Schema().$ref(SchemaUtils.schemaRef(schemaName)));
                }
                inProgressSchemas.add(schemaName);
                try {
                    Schema<?> originalTypeSchema;
                    schema = SchemaDefinitionUtils.readSchema((AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaValue, openAPI, context, (Element)type, typeArgs, (Element)(schemaAnnOnField ? definingElement : type), mediaTypes, jsonViewClass);
                    AnnotationValue typeSchema = type.getDeclaredAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
                    if (typeSchema != null && (originalTypeSchema = SchemaDefinitionUtils.readSchema((AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)typeSchema, openAPI, context, (Element)type, typeArgs, (Element)(schemaAnnOnField ? definingElement : type), mediaTypes, jsonViewClass)) != null && schema != null) {
                        if (StringUtils.isNotEmpty((CharSequence)originalTypeSchema.getDescription())) {
                            schema.setDescription(originalTypeSchema.getDescription());
                        }
                        if (originalTypeSchema.getNullable() != null && originalTypeSchema.getNullable().booleanValue() || Utils.isOpenapi31() && CollectionUtils.isNotEmpty((Collection)originalTypeSchema.getTypes()) && originalTypeSchema.getTypes().contains("null")) {
                            SchemaUtils.setNullable(schema);
                        }
                        schema.setRequired(originalTypeSchema.getRequired());
                    }
                    if (schema != null) {
                        SchemaDefinitionUtils.processSuperTypes(schema, schemaName, type, definingElement, openAPI, mediaTypes, schemas, context, jsonViewClass);
                    }
                }
                finally {
                    inProgressSchemas.remove(schemaName);
                }
            }
        }
        if (schema == null) return null;
        AnnotationValue externalDocsValue = type.getDeclaredAnnotation(io.swagger.v3.oas.annotations.ExternalDocumentation.class);
        ExternalDocumentation externalDocs = null;
        if (externalDocsValue != null) {
            externalDocs = SchemaDefinitionUtils.toValue(externalDocsValue.getValues(), context, ExternalDocumentation.class, null).orElse(null);
        }
        if (externalDocs != null) {
            schema.setExternalDocs(externalDocs);
        }
        SchemaDefinitionUtils.setSchemaDescription((Element)type, schema);
        Schema schemaRef = SchemaUtils.setSpecVersion(new Schema());
        schemaRef.set$ref(SchemaUtils.schemaRef(schema.getName()));
        if (!(definingElement instanceof ClassElement) || !(classEl = (ClassElement)definingElement).isIterable()) return schemaRef;
        schemaRef.setDescription(schema.getDescription());
        return schemaRef;
    }

    public static String computeDefaultSchemaName(String defaultSchemaName, Element definingElement, Element type, Map<String, ClassElement> typeArgs, VisitorContext context, @Nullable ClassElement jsonViewClass) {
        Object resultSchemaName;
        String genericSeparator = ConfigUtils.getGenericSeparator(context);
        String innerClassSeparator = ConfigUtils.getInnerClassSeparator(context);
        Object jsonViewPostfix = "";
        if (jsonViewClass != null) {
            String jsonViewClassName = jsonViewClass.getName();
            jsonViewPostfix = genericSeparator + ((jsonViewClassName = jsonViewClassName.replace("$", ".")).contains(".") ? jsonViewClassName.substring(jsonViewClassName.lastIndexOf(".") + 1) : jsonViewClassName);
        }
        Pair<String, String> pair = SchemaDefinitionUtils.computeFullClassNameWithGenerics(type, typeArgs, (String)jsonViewPostfix, context);
        String fullClassNameWithGenerics = pair.getSecond();
        if (defaultSchemaName != null) {
            resultSchemaName = defaultSchemaName;
        } else {
            String metaAnnName = null;
            if (definingElement != null) {
                metaAnnName = definingElement.getAnnotationNameByStereotype(io.swagger.v3.oas.annotations.media.Schema.class).orElse(null);
            }
            if (metaAnnName != null && !io.swagger.v3.oas.annotations.media.Schema.class.getName().equals(metaAnnName)) {
                resultSchemaName = NameUtils.getSimpleName((String)metaAnnName) + (String)jsonViewPostfix;
                if (!".".equals(innerClassSeparator)) {
                    resultSchemaName = ((String)resultSchemaName).replace(".", innerClassSeparator);
                }
            } else {
                resultSchemaName = pair.getFirst();
            }
        }
        String storedClassName = schemaNameToClassNameMap.get(resultSchemaName);
        if (storedClassName != null && !storedClassName.equals(fullClassNameWithGenerics)) {
            if (ConfigUtils.getSchemaDuplicateResolution(context) == ConfigUtils.DuplicateResolution.ERROR) {
                throw new ConfigurationException("Found 2 schemas with same name \"" + (String)resultSchemaName + "\" for classes " + storedClassName + " and " + fullClassNameWithGenerics);
            }
            int index = shemaNameSuffixCounterMap.getOrDefault(resultSchemaName, 0);
            shemaNameSuffixCounterMap.put((String)resultSchemaName, ++index);
            resultSchemaName = (String)resultSchemaName + genericSeparator + index;
        }
        schemaNameToClassNameMap.put((String)resultSchemaName, fullClassNameWithGenerics);
        return resultSchemaName;
    }

    /*
     * Unable to fully structure code
     */
    private static Pair<String, String> computeFullClassNameWithGenerics(Element type, Map<String, ClassElement> typeArgs, String jsonViewPostfix, VisitorContext context) {
        innerClassSeparator = ConfigUtils.getInnerClassSeparator(context);
        if (!(type instanceof TypedElement)) ** GOTO lbl-1000
        typedEl = (TypedElement)type;
        if (!(type instanceof EnumElement)) {
            typeType = typedEl.getType();
            isProtobufGenerated = ProtoUtils.isProtobufGenerated(typeType);
            packageName = typeType.getPackageName();
            resultSchemaName = CollectionUtils.isNotEmpty((Map)typeType.getTypeArguments()) ? SchemaDefinitionUtils.computeNameWithGenerics(typeType, typeArgs, context, isProtobufGenerated) : SchemaDefinitionUtils.computeNameWithGenerics(typeType, Collections.emptyMap(), context, isProtobufGenerated);
        } else lbl-1000:
        // 2 sources

        {
            resultSchemaName = type.getSimpleName();
            packageName = NameUtils.getPackageName((String)type.getName());
        }
        schemaDecorator = ConfigUtils.getSchemaDecoration(packageName, context);
        resultSchemaName = resultSchemaName.replace("$", innerClassSeparator) + jsonViewPostfix;
        if (schemaDecorator != null) {
            resultSchemaName = (StringUtils.hasText((CharSequence)schemaDecorator.getPrefix()) != false ? schemaDecorator.getPrefix() : "") + (String)resultSchemaName + (StringUtils.hasText((CharSequence)schemaDecorator.getPostfix()) != false ? schemaDecorator.getPostfix() : "");
        }
        return Pair.of(resultSchemaName, packageName + "." + (String)resultSchemaName);
    }

    public static List<Object> getEnumValues(EnumElement type, String schemaType, String schemaFormat, VisitorContext context) {
        boolean isProtobufGenerated = ProtoUtils.isProtobufGenerated((ClassElement)type);
        ArrayList<Object> enumValues = new ArrayList<Object>();
        for (EnumConstantElement element : type.elements()) {
            String jacksonValue;
            if (isProtobufGenerated) {
                Integer protoValue = null;
                for (FieldElement field : type.getFields()) {
                    if (!field.getName().equals(element.getSimpleName() + "_VALUE")) continue;
                    try {
                        protoValue = (Integer)field.getConstantValue();
                    }
                    catch (Exception exception) {}
                    break;
                }
                if (protoValue == null) continue;
                enumValues.add(protoValue);
                continue;
            }
            AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaAnn = ElementUtils.getAnnotation((Element)element, io.swagger.v3.oas.annotations.media.Schema.class);
            boolean isHidden = schemaAnn != null && schemaAnn.booleanValue("hidden").orElse(false) != false;
            if (isHidden || ElementUtils.isAnnotationPresent((Element)element, Hidden.class) || ElementUtils.isAnnotationPresent((Element)element, JsonIgnore.class)) continue;
            AnnotationValue<JsonProperty> jsonPropertyAnn = ElementUtils.getAnnotation((Element)element, JsonProperty.class);
            String string = jacksonValue = jsonPropertyAnn != null ? (String)jsonPropertyAnn.stringValue("value").orElse(null) : null;
            if (StringUtils.hasText(jacksonValue)) {
                try {
                    enumValues.add(ConvertUtils.normalizeValue(jacksonValue, schemaType, schemaFormat, context));
                }
                catch (JsonProcessingException e) {
                    ContextUtils.warn("Error converting jacksonValue " + jacksonValue + " : to " + type + ":\n" + Utils.printStackTrace(e), context, (Element)element);
                    enumValues.add(element.getSimpleName());
                }
                continue;
            }
            enumValues.add(element.getSimpleName());
        }
        return !enumValues.isEmpty() ? enumValues : null;
    }

    @Nullable
    public static Schema<?> resolveSchema(@Nullable Element definingElement, @Nullable ClassElement type, VisitorContext context, List<MediaType> mediaTypes, @Nullable ClassElement jsonViewClass) {
        return SchemaDefinitionUtils.resolveSchema(Utils.resolveOpenApi(context), definingElement, type, context, mediaTypes, jsonViewClass, null, null);
    }

    @Nullable
    public static Schema<?> resolveSchema(OpenAPI openApi, @Nullable Element definingElement, @Nullable ClassElement type, VisitorContext context, List<MediaType> mediaTypes, @Nullable ClassElement jsonViewClass, JavadocDescription fieldJavadoc, JavadocDescription classJavadoc) {
        EnumElement enumEl;
        ClassElement componentType;
        AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaAnnotationValue = null;
        if (definingElement != null) {
            schemaAnnotationValue = ElementUtils.getAnnotation(definingElement, io.swagger.v3.oas.annotations.media.Schema.class);
        }
        if (type != null && schemaAnnotationValue == null) {
            schemaAnnotationValue = ElementUtils.getAnnotation((Element)type, io.swagger.v3.oas.annotations.media.Schema.class);
        }
        boolean isSubstitutedType = false;
        if (schemaAnnotationValue != null) {
            String impl = schemaAnnotationValue.stringValue("implementation").orElse(null);
            if (StringUtils.isNotEmpty((CharSequence)impl)) {
                ClassElement typeEl = ContextUtils.getClassElement(impl, context);
                if (typeEl != null) {
                    type = typeEl;
                }
                isSubstitutedType = true;
            } else {
                String typeFromAnn = schemaAnnotationValue.stringValue("type").orElse(null);
                List<String> schemaTypes = Utils.isOpenapi31() && StringUtils.isEmpty((CharSequence)typeFromAnn) ? Arrays.asList(schemaAnnotationValue.stringValues("types")) : Collections.singletonList(typeFromAnn);
                for (String schemaType : schemaTypes) {
                    PrimitiveType primitiveType;
                    if (!StringUtils.isNotEmpty((CharSequence)schemaType) || type instanceof EnumElement || (primitiveType = PrimitiveType.fromName((String)schemaType)) == null || primitiveType == PrimitiveType.OBJECT) continue;
                    ClassElement typeEl = ContextUtils.getClassElement(primitiveType.getKeyClass().getName(), context);
                    if (typeEl != null) {
                        type = typeEl;
                    }
                    isSubstitutedType = true;
                    break;
                }
            }
        }
        if (type != null && ProtoUtils.isProtobufMessageClass(type)) {
            type = (ClassElement)type.getInterfaces().iterator().next();
        }
        Boolean isArray = null;
        Boolean isIterable = null;
        ClassElement classElement = componentType = type != null ? (ClassElement)type.getFirstTypeArgument().orElse(null) : null;
        if (type instanceof WildcardElement) {
            WildcardElement wildcardEl = (WildcardElement)type;
            type = CollectionUtils.isNotEmpty((Collection)wildcardEl.getUpperBounds()) ? (ClassElement)wildcardEl.getUpperBounds().get(0) : null;
        } else if (type instanceof GenericPlaceholderElement) {
            GenericPlaceholderElement placeholderEl = (GenericPlaceholderElement)type;
            isArray = type.isArray();
            isIterable = type.isIterable();
            if (!isArray.booleanValue()) {
                type = placeholderEl.getResolved().orElse(CollectionUtils.isNotEmpty((Collection)placeholderEl.getBounds()) ? (ClassElement)placeholderEl.getBounds().get(0) : null);
            }
        } else if (type instanceof GenericElement) {
            GenericElement genericEl = (GenericElement)type;
            isArray = type.isArray();
            isIterable = type.isIterable();
            type = genericEl.getResolved().orElse(null);
        }
        Map typeArgs = type != null ? type.getTypeArguments() : null;
        Schema schema = null;
        if (type instanceof EnumElement && ElementUtils.isEnum((ClassElement)(enumEl = (EnumElement)type))) {
            schema = SchemaDefinitionUtils.getSchemaDefinition(openApi, context, (ClassElement)enumEl, typeArgs, definingElement, mediaTypes, jsonViewClass);
            if (isArray != null && isArray.booleanValue()) {
                schema = SchemaUtils.arraySchema(schema);
            }
        } else if (type != null) {
            boolean isPublisher = false;
            boolean isObservable = false;
            boolean isNullable = false;
            if (type.isAssignable("io.micronaut.http.server.multipart.MultipartBody")) {
                isPublisher = true;
                type = type.getInterfaces().stream().filter(i -> i.isAssignable("org.reactivestreams.Publisher")).findFirst().flatMap(ClassElement::getFirstTypeArgument).orElse(null);
            } else if (!type.isAssignable("io.micronaut.http.multipart.StreamingFileUpload") && ElementUtils.isContainerType(type)) {
                isPublisher = (type.isAssignable("org.reactivestreams.Publisher") || type.isAssignable("kotlinx.coroutines.flow.Flow")) && !type.isAssignable("reactor.core.publisher.Mono");
                isObservable = (type.isAssignable("io.reactivex.Observable") || type.isAssignable("io.reactivex.rxjava3.core.Observable")) && !type.isAssignable("reactor.core.publisher.Mono");
                type = componentType;
                if (componentType != null) {
                    typeArgs = componentType.getTypeArguments();
                    componentType = componentType.getFirstTypeArgument().orElse(null);
                }
            } else if (ElementUtils.isTypeWithGenericNullable(type)) {
                isNullable = true;
                type = componentType;
                if (componentType != null) {
                    typeArgs = componentType.getTypeArguments();
                    componentType = componentType.getFirstTypeArgument().orElse(null);
                }
            }
            if (type != null) {
                String typeName = type.getName();
                ClassElement customTypeSchema = ConfigUtils.getCustomSchema(typeName, typeArgs, context);
                if (customTypeSchema != null) {
                    Map customTypeArgs = customTypeSchema.getTypeArguments();
                    if (customTypeArgs.isEmpty()) {
                        type = customTypeSchema;
                    } else {
                        HashMap<String, ClassElement> inheritedTypeArgs = new HashMap<String, ClassElement>(customTypeArgs);
                        for (String generic : customTypeArgs.keySet()) {
                            ClassElement element = (ClassElement)typeArgs.get(generic);
                            if (element == null) continue;
                            inheritedTypeArgs.put(generic, element);
                        }
                        type = customTypeSchema.withTypeArguments(inheritedTypeArgs);
                    }
                }
                if (isArray == null) {
                    isArray = type.isArray();
                }
                if (isIterable == null) {
                    isIterable = type.isIterable();
                }
                if (ElementUtils.isFileUpload(type)) {
                    isPublisher = isPublisher && !"io.micronaut.http.multipart.PartData".equals(typeName);
                    typeName = PrimitiveType.BINARY.name();
                }
                PrimitiveType primitiveType = PrimitiveType.fromName((String)typeName);
                schema = ProtoUtils.protobufTypeSchema(type);
                if (schema != null) {
                    return schema;
                }
                if (!isArray.booleanValue() && ClassUtils.isJavaLangType((String)typeName)) {
                    schema = SchemaDefinitionUtils.getPrimitiveType(type, typeName);
                } else if (!isArray.booleanValue() && primitiveType != null) {
                    schema = SchemaUtils.setSpecVersion(primitiveType.createProperty());
                } else if (type.isAssignable(Map.class)) {
                    schema = SchemaDefinitionUtils.processMapSchema(type, typeArgs, mediaTypes, openApi, jsonViewClass, classJavadoc, context);
                } else if (isIterable.booleanValue()) {
                    if (isArray.booleanValue()) {
                        schema = SchemaDefinitionUtils.resolveSchema(openApi, (Element)type, type.fromArray(), context, mediaTypes, jsonViewClass, null, classJavadoc);
                        if (schema != null) {
                            schema = SchemaUtils.arraySchema(schema);
                        }
                    } else {
                        List fields;
                        schema = componentType != null ? SchemaDefinitionUtils.resolveSchema(openApi, (Element)type, componentType, context, mediaTypes, jsonViewClass, null, classJavadoc) : SchemaDefinitionUtils.getPrimitiveType(null, Object.class.getName());
                        List list = fields = type.getPackageName().startsWith("java.util") ? Collections.emptyList() : type.getFields();
                        if (schema != null && fields.isEmpty()) {
                            schema = SchemaDefinitionUtils.processGenericAnnotations(schema, componentType);
                            schema = SchemaUtils.arraySchema(schema);
                        } else {
                            schema = SchemaDefinitionUtils.getSchemaDefinition(openApi, context, type, typeArgs, definingElement, mediaTypes, jsonViewClass);
                        }
                    }
                } else if (ElementUtils.isReturnTypeFile(type)) {
                    schema = SchemaUtils.setSpecVersion(PrimitiveType.FILE.createProperty());
                } else if (type.isAssignable(Boolean.class) || type.isAssignable(Boolean.TYPE)) {
                    schema = SchemaUtils.setSpecVersion(PrimitiveType.BOOLEAN.createProperty());
                } else if (type.isAssignable(Byte.class) || type.isAssignable(Byte.TYPE)) {
                    schema = SchemaUtils.setSpecVersion(PrimitiveType.BYTE.createProperty());
                } else if (type.isAssignable(UUID.class)) {
                    schema = SchemaUtils.setSpecVersion(PrimitiveType.UUID.createProperty());
                } else if (type.isAssignable(URL.class)) {
                    schema = SchemaUtils.setSpecVersion(PrimitiveType.URL.createProperty());
                } else if (type.isAssignable(URI.class)) {
                    schema = SchemaUtils.setSpecVersion(PrimitiveType.URI.createProperty());
                } else if (type.isAssignable(Character.class) || type.isAssignable(Character.TYPE)) {
                    schema = SchemaUtils.setSpecVersion(PrimitiveType.STRING.createProperty());
                } else if (type.isAssignable(Integer.class) || type.isAssignable(Integer.TYPE) || type.isAssignable(Short.class) || type.isAssignable(Short.TYPE) || type.isAssignable(OptionalInt.class)) {
                    schema = SchemaUtils.setSpecVersion(PrimitiveType.INT.createProperty());
                } else if (type.isAssignable(Long.class) || type.isAssignable(Long.TYPE) || type.isAssignable(OptionalLong.class)) {
                    schema = SchemaUtils.setSpecVersion(PrimitiveType.LONG.createProperty());
                } else if (type.isAssignable(Float.class) || type.isAssignable(Float.TYPE)) {
                    schema = SchemaUtils.setSpecVersion(PrimitiveType.FLOAT.createProperty());
                } else if (type.isAssignable(Double.class) || type.isAssignable(Double.TYPE) || type.isAssignable(OptionalDouble.class)) {
                    schema = SchemaUtils.setSpecVersion(PrimitiveType.DOUBLE.createProperty());
                } else if (type.isAssignable(BigInteger.class)) {
                    schema = SchemaUtils.setSpecVersion(PrimitiveType.INTEGER.createProperty());
                } else if (type.isAssignable(BigDecimal.class)) {
                    schema = SchemaUtils.setSpecVersion(PrimitiveType.DECIMAL.createProperty());
                } else if (type.isAssignable(Date.class) || type.isAssignable(Calendar.class) || type.isAssignable(LocalDateTime.class) || type.isAssignable(ZonedDateTime.class) || type.isAssignable(OffsetDateTime.class) || type.isAssignable(Instant.class) || type.isAssignable(XMLGregorianCalendar.class)) {
                    schema = SchemaUtils.setSpecVersion(new StringSchema().format("date-time"));
                } else if (type.isAssignable(LocalDate.class)) {
                    schema = SchemaUtils.setSpecVersion(new StringSchema().format("date"));
                } else if (type.isAssignable(LocalTime.class)) {
                    schema = SchemaUtils.setSpecVersion(new StringSchema().format("partial-time"));
                } else if (type.isAssignable(Number.class)) {
                    schema = SchemaUtils.setSpecVersion(PrimitiveType.NUMBER.createProperty());
                } else if (type.getName().equals(Object.class.getName())) {
                    schema = SchemaUtils.setSpecVersion(PrimitiveType.OBJECT.createProperty());
                } else {
                    schema = SchemaDefinitionUtils.getSchemaDefinition(openApi, context, type, typeArgs, definingElement, mediaTypes, jsonViewClass);
                    schema = SchemaDefinitionUtils.processGenericAnnotations(schema, componentType);
                }
            }
            if (schema != null) {
                if (isSubstitutedType) {
                    SchemaDefinitionUtils.processSchemaAnn(schema, context, definingElement, type, schemaAnnotationValue);
                }
                SchemaDefinitionUtils.processJacksonDescription(definingElement, schema);
                if (definingElement != null && StringUtils.isEmpty((CharSequence)schema.getDescription())) {
                    String paramJavadoc;
                    if (fieldJavadoc != null) {
                        if (StringUtils.hasText((CharSequence)fieldJavadoc.getMethodDescription())) {
                            schema.setDescription(fieldJavadoc.getMethodDescription());
                        }
                    } else if (classJavadoc != null && StringUtils.hasText((CharSequence)(paramJavadoc = classJavadoc.getParameters().get(definingElement.getName())))) {
                        schema.setDescription(paramJavadoc);
                    }
                }
                boolean isStream = false;
                if (CollectionUtils.isNotEmpty(mediaTypes)) {
                    for (MediaType mediaType : mediaTypes) {
                        if (!MediaType.TEXT_EVENT_STREAM_TYPE.equals((Object)mediaType) && !MediaType.APPLICATION_JSON_STREAM_TYPE.equals((Object)mediaType)) continue;
                        isStream = true;
                        break;
                    }
                }
                if (!isStream && (isPublisher || isObservable)) {
                    schema = SchemaUtils.arraySchema(schema);
                } else if (isNullable) {
                    SchemaUtils.setNullable(schema);
                }
            }
        }
        return schema;
    }

    public static Schema<?> bindSchemaForElement(VisitorContext context, TypedElement element, ClassElement elementType, Schema<?> schemaToBind, @Nullable ClassElement jsonViewClass) {
        boolean addSchemaToBind;
        Boolean isSchemaNullable;
        boolean isNullable;
        String defaultValue;
        PropertyElement propertyEl;
        Schema topLevelSchema;
        Schema composedSchema;
        AnnotationValue<io.swagger.v3.oas.annotations.media.ArraySchema> arraySchemaAnn;
        Schema schemaFromAnn;
        Schema originalSchema;
        AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaAnn = ElementUtils.getAnnotation((Element)element, io.swagger.v3.oas.annotations.media.Schema.class);
        Schema schema = originalSchema = schemaToBind != null ? schemaToBind : new Schema();
        if (originalSchema.get$ref() != null && (schemaFromAnn = SchemaDefinitionUtils.schemaFromAnnotation(context, (Element)element, elementType, schemaAnn)) != null) {
            schemaToBind = schemaFromAnn;
        }
        if (originalSchema.get$ref() == null && schemaAnn != null) {
            ClassElement implEl;
            String impl;
            schemaToBind = SchemaDefinitionUtils.bindSchemaAnnotationValue(context, element, schemaToBind, schemaAnn, jsonViewClass);
            String schemaName = schemaAnn.stringValue("name").orElse(null);
            if (schemaName != null) {
                schemaToBind.setName(schemaName);
            }
            if (StringUtils.isNotEmpty((CharSequence)(impl = (String)schemaAnn.stringValue("implementation").orElse(null))) && (implEl = ContextUtils.getClassElement(impl, context)) != null) {
                elementType = implEl;
            }
        }
        if ((arraySchemaAnn = ElementUtils.getAnnotation((Element)element, io.swagger.v3.oas.annotations.media.ArraySchema.class)) != null) {
            schemaToBind = SchemaDefinitionUtils.bindArraySchemaAnnotationValue(context, element, schemaToBind, arraySchemaAnn, jsonViewClass);
            arraySchemaAnn.stringValue("name").ifPresent(arg_0 -> schemaToBind.setName(arg_0));
        }
        SchemaDefinitionUtils.processJakartaValidationAnnotations((Element)element, elementType, schemaToBind);
        if (originalSchema.get$ref() != null) {
            topLevelSchema = composedSchema = SchemaUtils.setSpecVersion(new ComposedSchema());
        } else {
            composedSchema = SchemaUtils.setSpecVersion(new ComposedSchema());
            topLevelSchema = schemaToBind;
        }
        boolean notOnlyRef = false;
        SchemaDefinitionUtils.setSchemaDescription((Element)element, topLevelSchema);
        if (StringUtils.isNotEmpty((CharSequence)topLevelSchema.getDescription())) {
            notOnlyRef = true;
        }
        if (!(!ElementUtils.isAnnotationPresent((Element)element, Deprecated.class) || element instanceof PropertyElement && ProtoUtils.isProtobufGenerated((propertyEl = (PropertyElement)element).getOwningType()) && elementType.getName().equals(Map.class.getName()))) {
            topLevelSchema.setDeprecated(Boolean.valueOf(true));
            notOnlyRef = true;
        }
        if ((defaultValue = (String)ElementUtils.stringValue((Element)element, Bindable.class, "defaultValue").orElse(null)) != null && schemaToBind.getDefault() == null) {
            ConvertUtils.setDefaultValueObject(schemaToBind, defaultValue, (Element)elementType, schemaToBind.getType(), schemaToBind.getFormat(), true, context);
            notOnlyRef = true;
        }
        boolean bl = isNullable = (isSchemaNullable = (Boolean)element.booleanValue(io.swagger.v3.oas.annotations.media.Schema.class, "nullable").orElse(null)) == null && ElementUtils.isNullable(element) && !ElementUtils.isNotNullable((Element)element) || Boolean.TRUE.equals(isSchemaNullable);
        if (isNullable) {
            SchemaUtils.setNullable(topLevelSchema);
            notOnlyRef = true;
        }
        if (SchemaDefinitionUtils.processJacksonPropertyAnn((Element)element, elementType, topLevelSchema, schemaAnn, context)) {
            notOnlyRef = true;
        }
        boolean bl2 = addSchemaToBind = !SchemaUtils.isEmptySchema(schemaToBind);
        if (addSchemaToBind) {
            if ("object".equals(originalSchema.getType()) && !(originalSchema instanceof MapSchema)) {
                if (composedSchema.getType() == null) {
                    composedSchema.setType("object");
                }
                originalSchema.setType(null);
            }
            if (!SchemaUtils.isEmptySchema(originalSchema)) {
                composedSchema.addAllOfItem(originalSchema);
            }
        } else if (isNullable && CollectionUtils.isEmpty((Collection)composedSchema.getAllOf())) {
            composedSchema.addAllOfItem(originalSchema);
        }
        if (addSchemaToBind && !schemaToBind.equals(originalSchema)) {
            if ("object".equals(schemaToBind.getType()) && !(originalSchema instanceof MapSchema)) {
                if (composedSchema.getType() == null) {
                    composedSchema.setType("object");
                }
                originalSchema.setType(null);
            }
            composedSchema.addAllOfItem(schemaToBind);
        }
        if (!SchemaUtils.isEmptySchema(composedSchema) && (CollectionUtils.isNotEmpty((Collection)composedSchema.getAllOf()) && composedSchema.getAllOf().size() > 1 || CollectionUtils.isNotEmpty((Collection)composedSchema.getOneOf()) || CollectionUtils.isNotEmpty((Collection)composedSchema.getAnyOf()) || notOnlyRef)) {
            return composedSchema;
        }
        if (CollectionUtils.isNotEmpty((Collection)composedSchema.getAllOf()) && composedSchema.getAllOf().size() == 1) {
            return (Schema)composedSchema.getAllOf().get(0);
        }
        return originalSchema;
    }

    public static Schema<?> bindArraySchemaAnnotationValue(VisitorContext context, TypedElement element, Schema<?> schemaToBind, AnnotationValue<io.swagger.v3.oas.annotations.media.ArraySchema> schemaAnn, @Nullable ClassElement jsonViewClass) {
        JsonNode schemaJson = SchemaDefinitionUtils.toJson(schemaAnn.getValues(), context, jsonViewClass);
        if (schemaJson.isObject()) {
            JsonNode items;
            ObjectNode objNode = (ObjectNode)schemaJson;
            JsonNode arraySchema = objNode.remove("arraySchema");
            if (arraySchema != null && arraySchema.isObject()) {
                ((ObjectNode)arraySchema).remove("implementation");
                objNode.setAll((ObjectNode)arraySchema);
            }
            if ((items = objNode.remove("schema")) != null && schemaToBind != null && schemaToBind.getType() != null && schemaToBind.getType().equals("array")) {
                try {
                    schemaToBind.items((Schema)Utils.getJsonMapper().readerForUpdating((Object)schemaToBind.getItems()).readValue(items));
                }
                catch (IOException e) {
                    ContextUtils.warn("Error reading Swagger Schema for element [" + element + "]: " + e.getMessage(), context, (Element)element);
                }
            }
        }
        String elType = schemaJson.has("type") ? schemaJson.get("type").textValue() : null;
        String elFormat = schemaJson.has("format") ? schemaJson.get("format").textValue() : null;
        return SchemaDefinitionUtils.doBindSchemaAnnotationValue(context, element, schemaToBind, schemaJson, elType, elFormat, null, jsonViewClass);
    }

    public static Map<CharSequence, Object> toValueMap(Map<CharSequence, Object> values, VisitorContext context, @Nullable ClassElement jsonViewClass) {
        HashMap<CharSequence, Object> newValues = new HashMap<CharSequence, Object>(values.size());
        for (Map.Entry<CharSequence, Object> entry : values.entrySet()) {
            Map<String, Object> parsedJsonValue;
            CharSequence key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof AnnotationValue) {
                Map<CharSequence, Object> valueMap;
                AnnotationValue av = (AnnotationValue)value;
                if (av.getAnnotationName().equals(io.swagger.v3.oas.annotations.media.ArraySchema.class.getName())) {
                    valueMap = SchemaDefinitionUtils.resolveArraySchemaAnnotationValues(context, av, jsonViewClass);
                    newValues.put("schema", valueMap);
                    continue;
                }
                valueMap = SchemaDefinitionUtils.resolveAnnotationValues(context, av, jsonViewClass);
                newValues.put(key, valueMap);
                continue;
            }
            if (value instanceof AnnotationClassValue) {
                AnnotationClassValue acv = (AnnotationClassValue)value;
                acv.getType().ifPresent(aClass -> newValues.put(key, aClass));
                continue;
            }
            if (value == null) continue;
            if (value.getClass().isArray()) {
                Object[] a = (Object[])value;
                if (ArrayUtils.isNotEmpty((Object[])a)) {
                    Object first = a[0];
                    if (first instanceof AnnotationClassValue) {
                        ArrayList classes = new ArrayList(a.length);
                        for (Object o : a) {
                            AnnotationClassValue acv = (AnnotationClassValue)o;
                            acv.getType().ifPresent(classes::add);
                        }
                        newValues.put(key, classes);
                        continue;
                    }
                    if (first instanceof AnnotationValue) {
                        Object ref;
                        Map<CharSequence, Object> map;
                        String name2;
                        AnnotationValue sv;
                        Map<String, String> params;
                        HashMap<String, Object> extensions;
                        AnnotationValue annValue = (AnnotationValue)first;
                        String annotationName = annValue.getAnnotationName();
                        if (io.swagger.v3.oas.annotations.security.SecurityRequirement.class.getName().equals(annotationName)) {
                            ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>(a.length);
                            for (Object o : a) {
                                securityRequirements.add(ConvertUtils.mapToSecurityRequirement((AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>)((AnnotationValue)o)));
                            }
                            newValues.put(key, securityRequirements);
                            continue;
                        }
                        if (Extension.class.getName().equals(annotationName)) {
                            extensions = new HashMap<String, Object>();
                            for (Object o : a) {
                                SchemaUtils.processExtensions(extensions, (AnnotationValue<Extension>)((AnnotationValue)o));
                            }
                            newValues.put("extensions", extensions);
                            continue;
                        }
                        if (Encoding.class.getName().equals(annotationName)) {
                            Map<String, Object> encodings = SchemaDefinitionUtils.annotationValueArrayToSubmap(a, "name", context, null);
                            newValues.put(key, encodings);
                            continue;
                        }
                        if (Content.class.getName().equals(annotationName)) {
                            Map<String, Object> mediaTypes = SchemaDefinitionUtils.annotationValueArrayToSubmap(a, "mediaType", context, jsonViewClass);
                            newValues.put(key, mediaTypes);
                            continue;
                        }
                        if (Link.class.getName().equals(annotationName) || Header.class.getName().equals(annotationName)) {
                            Map<String, Object> linksOrHeaders = SchemaDefinitionUtils.annotationValueArrayToSubmap(a, "name", context, jsonViewClass);
                            HashMap<String, Object> newLinksOrHeaders = new HashMap<String, Object>(linksOrHeaders.size());
                            for (Map.Entry<String, Object> linkOrHeaderEntry : linksOrHeaders.entrySet()) {
                                Object headerExample;
                                Map linkOrHeaderMap = (Map)linkOrHeaderEntry.getValue();
                                if (linkOrHeaderMap.containsKey("hidden") && ((Boolean)linkOrHeaderMap.get("hidden")).booleanValue()) continue;
                                if (linkOrHeaderMap.containsKey("ref")) {
                                    linkOrHeaderMap.put("$ref", linkOrHeaderMap.remove("ref"));
                                }
                                if (linkOrHeaderMap.containsKey("schema")) {
                                    Map schemaMap = (Map)linkOrHeaderMap.get("schema");
                                    if (schemaMap.containsKey("ref")) {
                                        Object ref2 = schemaMap.get("ref");
                                        schemaMap.clear();
                                        schemaMap.put("$ref", ref2);
                                    }
                                    if (schemaMap.containsKey("defaultValue")) {
                                        schemaMap.put("default", schemaMap.remove("defaultValue"));
                                    }
                                    if (schemaMap.containsKey("allowableValues")) {
                                        schemaMap.put("enum", schemaMap.remove("allowableValues"));
                                    }
                                }
                                if (linkOrHeaderMap.containsKey("example") && (headerExample = linkOrHeaderMap.get("example")) != null) {
                                    try {
                                        Map headerSchema = (Map)linkOrHeaderMap.get("schema");
                                        String type = null;
                                        String format = null;
                                        if (headerSchema != null) {
                                            type = (String)headerSchema.get("type");
                                            format = (String)headerSchema.get("format");
                                            if (type == null) {
                                                type = SchemaUtils.getType(type, (Collection)headerSchema.get("types"));
                                            }
                                        }
                                        String headerExampleStr = OpenApiUtils.getConvertJsonMapper().writeValueAsString(headerExample);
                                        headerExampleStr = OpenApiApplicationVisitor.replacePlaceholders(headerExampleStr, context);
                                        linkOrHeaderMap.put("example", ConvertUtils.parseByTypeAndFormat(headerExampleStr, type, format, context, false));
                                    }
                                    catch (JsonProcessingException headerSchema) {
                                        // empty catch block
                                    }
                                }
                                newLinksOrHeaders.put(linkOrHeaderEntry.getKey(), linkOrHeaderEntry.getValue());
                            }
                            newValues.put(key, newLinksOrHeaders);
                            continue;
                        }
                        if (LinkParameter.class.getName().equals(annotationName)) {
                            params = ConvertUtils.toTupleSubMap(a, "name", "expression");
                            newValues.put(key, params);
                            continue;
                        }
                        if (OAuthScope.class.getName().equals(annotationName)) {
                            params = ConvertUtils.toTupleSubMap(a, "name", "description");
                            newValues.put(key, params);
                            continue;
                        }
                        if (ApiResponse.class.getName().equals(annotationName)) {
                            LinkedHashMap<String, Map<CharSequence, Object>> responses = new LinkedHashMap<String, Map<CharSequence, Object>>();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                name2 = sv.stringValue("responseCode").orElse("default");
                                map = SchemaDefinitionUtils.toValueMap(sv.getValues(), context, jsonViewClass);
                                if (map.containsKey("ref")) {
                                    ref = map.get("ref");
                                    map.clear();
                                    map.put("$ref", ref);
                                }
                                try {
                                    if (!map.containsKey("description")) {
                                        map.put("description", name2.equals("default") ? "OK response" : HttpStatus.valueOf((int)Integer.parseInt(name2)).getReason());
                                    }
                                }
                                catch (Exception e) {
                                    map.put("description", "Response " + name2);
                                }
                                responses.put(name2, map);
                            }
                            newValues.put(key, responses);
                            continue;
                        }
                        if (ExampleObject.class.getName().equals(annotationName)) {
                            LinkedHashMap<String, Map<CharSequence, Object>> examples = new LinkedHashMap<String, Map<CharSequence, Object>>();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                name2 = sv.stringValue("name").orElse("example");
                                map = SchemaDefinitionUtils.toValueMap(sv.getValues(), context, null);
                                if (map.containsKey("ref")) {
                                    ref = map.get("ref");
                                    map.clear();
                                    map.put("$ref", ref);
                                }
                                examples.put(name2, map);
                            }
                            newValues.put(key, examples);
                            continue;
                        }
                        if (Server.class.getName().equals(annotationName)) {
                            ArrayList<LinkedHashMap<CharSequence, Object>> servers = new ArrayList<LinkedHashMap<CharSequence, Object>>();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                LinkedHashMap<CharSequence, Object> variables = new LinkedHashMap<CharSequence, Object>(SchemaDefinitionUtils.toValueMap(sv.getValues(), context, null));
                                servers.add(variables);
                            }
                            newValues.put(key, servers);
                            continue;
                        }
                        if (ServerVariable.class.getName().equals(annotationName)) {
                            LinkedHashMap variables = new LinkedHashMap();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                sv.stringValue("name").ifPresent(name -> {
                                    Map<CharSequence, Object> map = SchemaDefinitionUtils.toValueMap(sv.getValues(), context, null);
                                    Object dv = map.get("defaultValue");
                                    if (dv != null) {
                                        map.put("default", dv);
                                    }
                                    if (map.containsKey("allowableValues")) {
                                        map.put("enum", map.remove("allowableValues"));
                                    }
                                    variables.put(name, map);
                                });
                            }
                            newValues.put(key, variables);
                            continue;
                        }
                        if (DiscriminatorMapping.class.getName().equals(annotationName)) {
                            extensions = new HashMap();
                            HashMap<String, String> mappings = new HashMap<String, String>();
                            Object[] objectArray = a;
                            int n = objectArray.length;
                            for (int o = 0; o < n; ++o) {
                                Object o2 = objectArray[o];
                                AnnotationValue dv = (AnnotationValue)o2;
                                Map<CharSequence, Object> valueMap = SchemaDefinitionUtils.resolveAnnotationValues(context, dv, null);
                                mappings.put(valueMap.get("value").toString(), valueMap.get("$ref").toString());
                                Map extValue = (Map)valueMap.get("extensions");
                                if (extValue == null) continue;
                                extensions.putAll(extValue);
                            }
                            Map<String, Object> discriminatorMap = SchemaDefinitionUtils.getDiscriminatorMap(newValues);
                            discriminatorMap.put("mapping", mappings);
                            if (CollectionUtils.isNotEmpty(extensions)) {
                                discriminatorMap.put("extensions", extensions);
                            }
                            newValues.put("discriminator", discriminatorMap);
                            continue;
                        }
                        if (a.length == 1) {
                            AnnotationValue av = (AnnotationValue)a[0];
                            Map<CharSequence, Object> valueMap = SchemaDefinitionUtils.resolveAnnotationValues(context, av, jsonViewClass);
                            newValues.put(key, SchemaDefinitionUtils.toValueMap(valueMap, context, jsonViewClass));
                            continue;
                        }
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (Object o : a) {
                            if (o instanceof AnnotationValue) {
                                AnnotationValue av = (AnnotationValue)o;
                                Map<CharSequence, Object> valueMap = SchemaDefinitionUtils.resolveAnnotationValues(context, av, jsonViewClass);
                                list.add(valueMap);
                                continue;
                            }
                            list.add(o);
                        }
                        newValues.put(key, list);
                        continue;
                    }
                    if (key.equals("types") && Utils.isOpenapi31()) {
                        newValues.put("type", value);
                        continue;
                    }
                    newValues.put(key, value);
                    continue;
                }
                newValues.put(key, a);
                continue;
            }
            if (key.equals("additionalProperties")) {
                if (Schema.AdditionalPropertiesValue.TRUE.toString().equals(value.toString())) {
                    newValues.put("additionalProperties", true);
                    continue;
                }
                if (!Schema.AdditionalPropertiesValue.FALSE.toString().equals(value.toString())) continue;
                newValues.put("additionalProperties", false);
                continue;
            }
            if (key.equals("types") && Utils.isOpenapi31()) {
                newValues.put("type", value);
                continue;
            }
            if (key.equals("discriminatorProperty")) {
                Map<String, Object> discriminatorMap = SchemaDefinitionUtils.getDiscriminatorMap(newValues);
                Parameter.StyleEnum[] parsedJsonValue2 = ConvertUtils.parseJsonString(value);
                discriminatorMap.put("propertyName", parsedJsonValue2 != null ? parsedJsonValue2 : value);
                newValues.put("discriminator", discriminatorMap);
                continue;
            }
            if (key.equals("style")) {
                Parameter.StyleEnum paramStyle = null;
                try {
                    paramStyle = Parameter.StyleEnum.valueOf((String)((String)value));
                }
                catch (Exception parsedJsonValue2) {
                    // empty catch block
                }
                if (paramStyle == null) {
                    for (Parameter.StyleEnum styleValue : Parameter.StyleEnum.values()) {
                        if (!styleValue.toString().equals(value)) continue;
                        paramStyle = styleValue;
                        newValues.put(key, styleValue.toString());
                        break;
                    }
                } else {
                    newValues.put(key, paramStyle.toString());
                }
                if (paramStyle != null) continue;
                Encoding.StyleEnum encodingStyle = null;
                try {
                    encodingStyle = Encoding.StyleEnum.valueOf((String)((String)value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (encodingStyle == null) {
                    for (Encoding.StyleEnum styleValue : Encoding.StyleEnum.values()) {
                        if (!styleValue.toString().equals(value)) continue;
                        encodingStyle = styleValue;
                        break;
                    }
                }
                if (encodingStyle == null) continue;
                newValues.put(key, encodingStyle.toString());
                continue;
            }
            if (key.equals("ref")) {
                newValues.put("$ref", value);
                continue;
            }
            if (key.equals("accessMode")) {
                if (Schema.AccessMode.READ_ONLY.toString().equals(value)) {
                    newValues.put("readOnly", Boolean.TRUE);
                    newValues.remove("writeOnly");
                    continue;
                }
                if (Schema.AccessMode.WRITE_ONLY.toString().equals(value)) {
                    newValues.remove("readOnly");
                    newValues.put("writeOnly", Boolean.TRUE);
                    continue;
                }
                if (!Schema.AccessMode.READ_WRITE.toString().equals(value)) continue;
                newValues.remove("readOnly");
                newValues.remove("writeOnly");
                continue;
            }
            if (key.equals("example")) {
                newValues.put("exampleSetFlag", true);
            }
            newValues.put(key, (parsedJsonValue = ConvertUtils.parseJsonString(value)) != null ? parsedJsonValue : value);
        }
        return newValues;
    }

    public static Map<CharSequence, Object> resolveArraySchemaAnnotationValues(VisitorContext context, AnnotationValue<?> av, @Nullable ClassElement jsonViewClass) {
        HashMap<CharSequence, Object> arraySchemaMap = new HashMap<CharSequence, Object>(10);
        av.get((CharSequence)"arraySchema", AnnotationValue.class).ifPresent(annotationValue -> SchemaDefinitionUtils.processAnnotationValue(context, annotationValue, arraySchemaMap, List.of("ref", "implementation"), Schema.class, null));
        av.get((CharSequence)"schema", AnnotationValue.class).ifPresent(annotationValue -> {
            Optional impl = annotationValue.stringValue("implementation");
            Optional type = annotationValue.stringValue("type");
            Optional format = annotationValue.stringValue("format");
            ClassElement classEl = null;
            PrimitiveType primitiveType = null;
            if (impl.isPresent()) {
                classEl = ContextUtils.getClassElement((String)impl.get(), context);
            } else if (type.isPresent()) {
                primitiveType = PrimitiveType.fromName((String)(format.isPresent() && ((String)format.get()).equals("binary") ? (String)format.get() : (String)type.get()));
                classEl = primitiveType == null ? ContextUtils.getClassElement((String)type.get(), context) : ContextUtils.getClassElement(primitiveType.getKeyClass().getName(), context);
            }
            if (classEl != null) {
                if (primitiveType == null) {
                    ArraySchema schema = SchemaUtils.arraySchema(SchemaDefinitionUtils.resolveSchema(null, classEl, context, Collections.emptyList(), jsonViewClass));
                    SchemaDefinitionUtils.schemaToValueMap(arraySchemaMap, schema);
                } else {
                    Schema items = SchemaUtils.setSpecVersion(primitiveType.createProperty());
                    items.setDescription((String)annotationValue.stringValue("description").orElse(null));
                    ArraySchema schema = SchemaUtils.arraySchema(items);
                    SchemaDefinitionUtils.schemaToValueMap(arraySchemaMap, schema);
                }
            } else {
                arraySchemaMap.putAll(SchemaDefinitionUtils.resolveAnnotationValues(context, annotationValue, jsonViewClass));
            }
        });
        SchemaDefinitionUtils.processAnnotationValue(context, av, arraySchemaMap, List.of("schema", "arraySchema"), ArraySchema.class, null);
        return arraySchemaMap;
    }

    public static Schema<?> bindSchemaAnnotationValue(VisitorContext context, TypedElement element, Schema<?> schemaToBind, AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaAnn, @Nullable ClassElement jsonViewClass) {
        EnumElement enumEl;
        ClassElement classEl = element.getType();
        if (ElementUtils.isContainerType(classEl)) {
            classEl = classEl.getFirstTypeArgument().orElse(context.getClassElement("java.lang.Object").orElse(classEl));
        }
        Pair<String, Object> typeAndFormat = classEl.isIterable() ? Pair.of("array", null) : (classEl instanceof EnumElement && ElementUtils.isEnum((ClassElement)(enumEl = (EnumElement)classEl)) ? ConvertUtils.checkEnumJsonValueType(context, enumEl, null, null) : ConvertUtils.getTypeAndFormatByClass(classEl.getName(), classEl.isArray(), classEl));
        JsonNode schemaJson = SchemaDefinitionUtils.toJson(schemaAnn.getValues(), context, jsonViewClass);
        return SchemaDefinitionUtils.doBindSchemaAnnotationValue(context, element, schemaToBind, schemaJson, schemaAnn.stringValue("type").orElse(typeAndFormat.getFirst()), schemaAnn.stringValue("format").orElse((String)typeAndFormat.getSecond()), schemaAnn, jsonViewClass);
    }

    public static <T> Optional<T> toValue(Map<CharSequence, Object> values, VisitorContext context, Class<T> type, @Nullable ClassElement jsonViewClass) {
        JsonNode node = SchemaDefinitionUtils.toJson(values, context, jsonViewClass);
        try {
            return Optional.ofNullable(ConvertUtils.treeToValue(node, type, context));
        }
        catch (JsonProcessingException e) {
            ContextUtils.warn("Error converting  [" + node + "]: to " + type + ":\n" + Utils.printStackTrace(e), context);
            return Optional.empty();
        }
    }

    public static JsonNode toJson(Map<CharSequence, Object> values, VisitorContext context, @Nullable ClassElement jsonViewClass) {
        Map<CharSequence, Object> newValues = SchemaDefinitionUtils.toValueMap(values, context, jsonViewClass);
        return Utils.getJsonMapper().valueToTree(newValues);
    }

    public static void processSchemaProperty(VisitorContext context, TypedElement element, ClassElement elementType, @Nullable ClassElement classElement, Schema<?> parentSchema, Schema<?> propertySchema) {
        if (propertySchema == null) {
            return;
        }
        AnnotationValue<JsonUnwrapped> jsonUnwrappedAnn = ElementUtils.getAnnotation((Element)element, JsonUnwrapped.class);
        if (jsonUnwrappedAnn != null && jsonUnwrappedAnn.booleanValue("enabled").orElse(Boolean.TRUE).booleanValue()) {
            SchemaDefinitionUtils.handleUnwrapped(context, (Element)element, elementType, parentSchema, jsonUnwrappedAnn);
        } else {
            boolean required;
            AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaAnn = ElementUtils.getAnnotation((Element)element, io.swagger.v3.oas.annotations.media.Schema.class);
            Boolean elementSchemaRequired = null;
            boolean isAutoRequiredMode = true;
            boolean isRequiredDefaultValueSet = false;
            if (schemaAnn != null) {
                elementSchemaRequired = schemaAnn.get((CharSequence)"required", Argument.BOOLEAN).orElse(null);
                isRequiredDefaultValueSet = !schemaAnn.contains("required");
                Schema.RequiredMode requiredMode = schemaAnn.enumValue("requiredMode", Schema.RequiredMode.class).orElse(null);
                if (requiredMode == Schema.RequiredMode.REQUIRED) {
                    elementSchemaRequired = true;
                    isAutoRequiredMode = false;
                } else if (requiredMode == Schema.RequiredMode.NOT_REQUIRED) {
                    elementSchemaRequired = false;
                    isAutoRequiredMode = false;
                }
            }
            boolean isNotNullable = ElementUtils.isNotNullable((Element)element);
            boolean isMandatoryInConstructor = SchemaDefinitionUtils.doesParamExistsMandatoryInConstructor((Element)element, (Element)classElement);
            boolean bl = elementSchemaRequired != null ? elementSchemaRequired : (required = isNotNullable || isMandatoryInConstructor);
            if (isRequiredDefaultValueSet && isAutoRequiredMode && isNotNullable) {
                required = true;
            }
            propertySchema = SchemaDefinitionUtils.bindSchemaForElement(context, element, elementType, propertySchema, null);
            String propertyName = SchemaDefinitionUtils.resolvePropertyName((Element)element, (Element)classElement, propertySchema);
            propertyName = ProtoUtils.normalizePropertyName(propertyName, classElement, elementType);
            propertySchema.setRequired(null);
            Schema<?> propertySchemaFinal = propertySchema;
            SchemaDefinitionUtils.addProperty(parentSchema, propertyName, propertySchema, required);
            if (schemaAnn != null) {
                schemaAnn.stringValue("defaultValue").ifPresent(value -> {
                    String elType = schemaAnn.stringValue("type").orElse(null);
                    String elFormat = schemaAnn.stringValue("format").orElse(null);
                    if (elType == null && elementType != null) {
                        EnumElement enumEl;
                        Pair<String, String> typeAndFormat = elementType instanceof EnumElement && ElementUtils.isEnum((ClassElement)(enumEl = (EnumElement)elementType)) ? ConvertUtils.checkEnumJsonValueType(context, enumEl, null, elFormat) : ConvertUtils.getTypeAndFormatByClass(elementType.getName(), elementType.isArray(), elementType);
                        elType = typeAndFormat.getFirst();
                        if (elFormat == null) {
                            elFormat = typeAndFormat.getSecond();
                        }
                    }
                    ConvertUtils.setDefaultValueObject(propertySchemaFinal, value, (Element)element, elType, elFormat, false, context);
                });
            }
        }
    }

    private static void populateSchemaProperties(OpenAPI openAPI, VisitorContext context, Element type, Map<String, ClassElement> typeArgs, Schema<?> schema, List<MediaType> mediaTypes, JavadocDescription classJavadoc, @Nullable ClassElement jsonViewClass) {
        ClassElement classElement = null;
        if (type instanceof ClassElement) {
            ClassElement classEl;
            classElement = classEl = (ClassElement)type;
        } else if (type instanceof TypedElement) {
            TypedElement typedEl = (TypedElement)type;
            classElement = typedEl.getType();
        }
        if (classElement != null && !ClassUtils.isJavaLangType((String)classElement.getName())) {
            List<PropertyElement> beanProperties;
            try {
                beanProperties = classElement.getBeanProperties(PropertyElementQuery.of((AnnotationMetadata)classElement).excludedAnnotations(Set.of(Hidden.class.getName(), JsonBackReference.class.getName(), JsonIgnore.class.getName()))).stream().filter(p -> !"groovy.lang.MetaClass".equals(p.getType().getName()) && !"java.lang.Class".equals(p.getType().getName()) && ElementUtils.getAnnotationMetadata((Element)p).booleanValue(io.swagger.v3.oas.annotations.media.Schema.class, "hidden").orElse(false) == false).toList();
            }
            catch (Exception e) {
                ContextUtils.warn("Error with getting properties for class " + classElement.getName() + ": " + e + "\n" + Utils.printStackTrace(e), context, (Element)classElement);
                beanProperties = Collections.emptyList();
            }
            beanProperties = ProtoUtils.filterProtobufProperties(classElement, beanProperties);
            SchemaDefinitionUtils.processPropertyElements(openAPI, context, type, typeArgs, schema, beanProperties, mediaTypes, classJavadoc, jsonViewClass);
            String visibilityLevelProp = ConfigUtils.getConfigProperty("micronaut.openapi.field.visibility.level", context);
            VisibilityLevel visibilityLevel = VisibilityLevel.PUBLIC;
            if (StringUtils.hasText((CharSequence)visibilityLevelProp)) {
                try {
                    visibilityLevel = VisibilityLevel.valueOf(visibilityLevelProp.toUpperCase());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Wrong value for visibility level property: " + ConfigUtils.getConfigProperty("micronaut.openapi.field.visibility.level", context));
                }
            }
            ArrayList<FieldElement> publicFields = new ArrayList<FieldElement>();
            for (FieldElement field : classElement.getFields()) {
                if (field.isStatic() || visibilityLevel == VisibilityLevel.PUBLIC && !field.isPublic() || visibilityLevel == VisibilityLevel.PROTECTED && !field.isPublic() && !field.isProtected() || visibilityLevel == VisibilityLevel.PACKAGE && !field.isPublic() && !field.isProtected() && !field.isPackagePrivate()) continue;
                boolean alreadyProcessed = false;
                for (PropertyElement prop : beanProperties) {
                    if (!prop.getName().equals(field.getName())) continue;
                    alreadyProcessed = true;
                    break;
                }
                if (alreadyProcessed) continue;
                publicFields.add(field);
            }
            SchemaDefinitionUtils.processPropertyElements(openAPI, context, type, typeArgs, schema, publicFields, mediaTypes, classJavadoc, jsonViewClass);
        }
    }

    private static Schema<?> processSuperTypes(Schema<?> schema, String schemaName, ClassElement type, @Nullable Element definingElement, OpenAPI openAPI, List<MediaType> mediaTypes, Map<String, Schema> schemas, VisitorContext context, @Nullable ClassElement jsonViewClass) {
        if (type == null || type.getName().equals(Object.class.getName())) {
            return null;
        }
        ClassElement classElement = type.getType();
        ArrayList<ClassElement> superTypes = new ArrayList<ClassElement>();
        Collection parentInterfaces = classElement.getInterfaces();
        if (classElement.isInterface() && !parentInterfaces.isEmpty()) {
            for (ClassElement parentInterface : parentInterfaces) {
                if (ClassUtils.isJavaLangType((String)parentInterface.getName()) || ProtoUtils.isProtobufGenerated(parentInterface) || parentInterface.getBeanProperties().isEmpty()) continue;
                superTypes.add(parentInterface);
            }
        } else {
            ClassElement superType = classElement.getSuperType().orElse(null);
            if (superType != null && !Enum.class.getName().equals(superType.getName()) && !ProtoUtils.isProtobufMessageClass(superType)) {
                superTypes.add(superType);
            }
        }
        if (!type.isRecord() && !superTypes.isEmpty()) {
            String firstSuperTypeName = ((ClassElement)superTypes.get(0)).getName();
            if (superTypes.size() == 1 && (firstSuperTypeName.equals(Enum.class.getName()) || firstSuperTypeName.equals(Object.class.getName()))) {
                if (schema != null) {
                    schema.setName(schemaName);
                    schemas.put(schemaName, schema);
                }
                return null;
            }
            if (schema == null) {
                schema = SchemaUtils.setSpecVersion(new ComposedSchema());
                schema.setType("object");
            }
            for (ClassElement sType : superTypes) {
                Map sTypeArgs = sType.getTypeArguments();
                ClassElement customStype = ConfigUtils.getCustomSchema(sType.getName(), sTypeArgs, context);
                if (customStype != null) {
                    sType = customStype;
                }
                SchemaDefinitionUtils.readAllInterfaces(openAPI, context, definingElement, mediaTypes, schema, sType, schemas, sTypeArgs, jsonViewClass);
            }
        } else if (schema == null) {
            schema = SchemaUtils.setSpecVersion(new Schema());
            schema.setType("object");
        }
        schema.setName(schemaName);
        schemas.put(schemaName, schema);
        return schema;
    }

    private static void readAllInterfaces(OpenAPI openAPI, VisitorContext context, @Nullable Element definingElement, List<MediaType> mediaTypes, Schema<?> schema, ClassElement superType, Map<String, Schema> schemas, Map<String, ClassElement> superTypeArgs, @Nullable ClassElement jsonViewClass) {
        String parentSchemaName = SchemaDefinitionUtils.computeDefaultSchemaName(superType.stringValue(io.swagger.v3.oas.annotations.media.Schema.class, "name").orElse(null), definingElement, (Element)superType, superTypeArgs, context, jsonViewClass);
        if (schemas.get(parentSchemaName) != null || SchemaDefinitionUtils.getSchemaDefinition(openAPI, context, superType, superTypeArgs, null, mediaTypes, jsonViewClass) != null) {
            Schema parentSchema = SchemaUtils.setSpecVersion(new Schema());
            parentSchema.set$ref(SchemaUtils.schemaRef(parentSchemaName));
            if (schema.getAllOf() == null || !schema.getAllOf().contains(parentSchema)) {
                schema.addAllOfItem(parentSchema);
            }
        }
        if (superType.isInterface()) {
            for (ClassElement interfaceEl : superType.getInterfaces()) {
                if (ClassUtils.isJavaLangType((String)interfaceEl.getName()) || interfaceEl.getBeanProperties().isEmpty()) continue;
                Map interfaceTypeArgs = interfaceEl.getTypeArguments();
                ClassElement customInterfaceType = ConfigUtils.getCustomSchema(interfaceEl.getName(), interfaceTypeArgs, context);
                if (customInterfaceType != null) {
                    interfaceEl = customInterfaceType;
                }
                SchemaDefinitionUtils.readAllInterfaces(openAPI, context, definingElement, mediaTypes, schema, interfaceEl, schemas, interfaceTypeArgs, jsonViewClass);
            }
        } else if (superType.getSuperType().isPresent()) {
            ClassElement superSuperType = (ClassElement)superType.getSuperType().get();
            Map superSuperTypeArgs = superSuperType.getTypeArguments();
            ClassElement customSuperSuperType = ConfigUtils.getCustomSchema(superSuperType.getName(), superSuperTypeArgs, context);
            if (customSuperSuperType != null) {
                superSuperType = customSuperSuperType;
            }
            SchemaDefinitionUtils.readAllInterfaces(openAPI, context, definingElement, mediaTypes, schema, superSuperType, schemas, superSuperTypeArgs, jsonViewClass);
        }
    }

    private static void checkAllOf(Schema<Object> composedSchema) {
        if (composedSchema == null || CollectionUtils.isEmpty((Collection)composedSchema.getAllOf()) || CollectionUtils.isEmpty((Map)composedSchema.getProperties())) {
            return;
        }
        if (composedSchema.getType() == null) {
            composedSchema.setType("object");
        }
        Schema propSchema = SchemaUtils.setSpecVersion(new Schema());
        propSchema.properties(composedSchema.getProperties());
        propSchema.setDescription(composedSchema.getDescription());
        propSchema.setRequired(composedSchema.getRequired());
        propSchema.setType(null);
        composedSchema.setProperties(null);
        composedSchema.setDescription(null);
        composedSchema.setRequired(null);
        composedSchema.addAllOfItem(propSchema);
    }

    private static void processJacksonDescription(@Nullable Element element, @Nullable Schema<?> schemaToBind) {
        if (element == null || schemaToBind == null || StringUtils.isNotEmpty((CharSequence)schemaToBind.getDescription())) {
            return;
        }
        ElementUtils.findAnnotation(element, element instanceof ClassElement ? "com.fasterxml.jackson.annotation.JsonClassDescription" : "com.fasterxml.jackson.annotation.JsonPropertyDescription").flatMap(ann -> ann.stringValue("value")).ifPresent(arg_0 -> schemaToBind.setDescription(arg_0));
    }

    private static void setSchemaDescription(Element element, Schema<?> schemaToBind) {
        JavadocDescription desc;
        MemberElement memberEl;
        List fields;
        if (StringUtils.isNotEmpty((CharSequence)schemaToBind.getDescription())) {
            return;
        }
        SchemaDefinitionUtils.processJacksonDescription(element, schemaToBind);
        if (StringUtils.isNotEmpty((CharSequence)schemaToBind.getDescription())) {
            return;
        }
        String doc = element.getDocumentation().orElse(null);
        if (StringUtils.isEmpty((CharSequence)doc) && element instanceof MemberElement && CollectionUtils.isNotEmpty((Collection)(fields = (memberEl = (MemberElement)element).getDeclaringType().getFields()))) {
            for (FieldElement field : fields) {
                if (!field.getName().equals(element.getName())) continue;
                doc = field.getDocumentation().orElse(null);
                break;
            }
        }
        if (doc != null && StringUtils.hasText((CharSequence)(desc = Utils.getJavadocParser().parse(doc)).getMethodDescription())) {
            schemaToBind.setDescription(desc.getMethodDescription());
        }
    }

    private static void processSchemaAnn(Schema schemaToBind, VisitorContext context, Element element, @Nullable ClassElement classEl, @Nullable AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaAnn) {
        String addProps;
        String schemaDefaultValue;
        String elType;
        Boolean schemaDeprecated;
        Schema.AccessMode schemaAccessMode;
        String accessModeStr;
        Boolean schemaExclusiveMinimum;
        String schemaMinimum;
        Boolean schemaExclusiveMaximum;
        String schemaMaximum;
        Double schemaMultipleOf;
        if (schemaAnn == null) {
            return;
        }
        Map annValues = schemaAnn.getValues();
        if (annValues.containsKey("name")) {
            schemaToBind.setName((String)annValues.get("name"));
        }
        if (annValues.containsKey("title")) {
            schemaToBind.setTitle((String)annValues.get("title"));
        }
        if (annValues.containsKey("ref")) {
            schemaToBind.set$ref((String)annValues.get("ref"));
        }
        if ((schemaMultipleOf = (Double)annValues.get("multipleOf")) != null) {
            schemaToBind.setMultipleOf(BigDecimal.valueOf(schemaMultipleOf));
        }
        if (NumberUtils.isCreatable(schemaMaximum = (String)annValues.get("maximum"))) {
            schemaToBind.setMaximum(new BigDecimal(schemaMaximum));
        }
        if (!Utils.isOpenapi31() && (schemaExclusiveMaximum = (Boolean)annValues.get("exclusiveMaximum")) != null && schemaExclusiveMaximum.booleanValue()) {
            schemaToBind.setExclusiveMaximum(Boolean.valueOf(true));
        }
        if (NumberUtils.isCreatable(schemaMinimum = (String)annValues.get("minimum"))) {
            schemaToBind.setMinimum(new BigDecimal(schemaMinimum));
        }
        if (!Utils.isOpenapi31() && (schemaExclusiveMinimum = (Boolean)annValues.get("exclusiveMinimum")) != null && schemaExclusiveMinimum.booleanValue()) {
            schemaToBind.setExclusiveMinimum(Boolean.valueOf(true));
        }
        if (annValues.containsKey("maxLength")) {
            schemaToBind.setMaxLength((Integer)annValues.get("maxLength"));
        }
        if (annValues.containsKey("minLength")) {
            schemaToBind.setMinLength((Integer)annValues.get("minLength"));
        }
        if (annValues.containsKey("pattern")) {
            schemaToBind.setPattern((String)annValues.get("pattern"));
        }
        if (annValues.containsKey("maxProperties")) {
            schemaToBind.setMaxProperties((Integer)annValues.get("maxProperties"));
        }
        if (annValues.containsKey("minProperties")) {
            schemaToBind.setMinProperties((Integer)annValues.get("minProperties"));
        }
        if (annValues.containsKey("requiredProperties")) {
            String[] requiredProperties = (String[])annValues.get("requiredProperties");
            schemaToBind.setRequired(new ArrayList<String>(Arrays.asList(requiredProperties)));
        }
        if (annValues.containsKey("description")) {
            schemaToBind.setDescription((String)annValues.get("description"));
        }
        String format = null;
        if (annValues.containsKey("format")) {
            format = (String)annValues.get("format");
            schemaToBind.setFormat(format);
        }
        if (annValues.containsKey("nullable") && !(element instanceof MemberElement)) {
            SchemaUtils.setNullable(schemaToBind);
        }
        if (StringUtils.isNotEmpty((CharSequence)(accessModeStr = (String)annValues.get("accessMode"))) && (schemaAccessMode = Schema.AccessMode.valueOf((String)accessModeStr)) != Schema.AccessMode.AUTO) {
            if (schemaAccessMode == Schema.AccessMode.READ_ONLY) {
                schemaToBind.setReadOnly(Boolean.valueOf(true));
                schemaToBind.setWriteOnly(null);
            } else if (schemaAccessMode == Schema.AccessMode.WRITE_ONLY) {
                schemaToBind.setReadOnly(null);
                schemaToBind.setWriteOnly(Boolean.valueOf(true));
            } else if (schemaAccessMode == Schema.AccessMode.READ_WRITE) {
                schemaToBind.setReadOnly(null);
                schemaToBind.setWriteOnly(null);
            }
        }
        AnnotationValue schemaExtDocs = (AnnotationValue)annValues.get("externalDocs");
        ExternalDocumentation externalDocs = null;
        if (schemaExtDocs != null) {
            externalDocs = SchemaDefinitionUtils.toValue(schemaExtDocs.getValues(), context, ExternalDocumentation.class, null).orElse(null);
        }
        if (externalDocs != null) {
            schemaToBind.setExternalDocs(externalDocs);
        }
        if ((schemaDeprecated = (Boolean)annValues.get("deprecated")) != null && schemaDeprecated.booleanValue()) {
            schemaToBind.setDeprecated(Boolean.valueOf(true));
        }
        String type = null;
        if (annValues.containsKey("type")) {
            type = (String)annValues.get("type");
            schemaToBind.setType(type);
        }
        Pair<String, Object> typeAndFormat = null;
        if (element instanceof ClassElement) {
            EnumElement enumEl;
            ClassElement classElement = (ClassElement)element;
            typeAndFormat = classElement.isIterable() ? Pair.of("array", null) : (element instanceof EnumElement && ElementUtils.isEnum((ClassElement)(enumEl = (EnumElement)element)) ? ConvertUtils.checkEnumJsonValueType(context, enumEl, null, null) : ConvertUtils.getTypeAndFormatByClass(classElement.getName(), classElement.isArray(), classElement));
        }
        String string = type != null ? type : (elType = typeAndFormat != null ? (String)typeAndFormat.getFirst() : null);
        String elFormat = format != null ? format : (typeAndFormat != null ? (String)typeAndFormat.getSecond() : null);
        String[] allowableValues = schemaAnn.stringValues("allowableValues");
        SchemaUtils.setAllowableValues(schemaToBind, allowableValues, element, elType, elFormat, context);
        if (Utils.isOpenapi31()) {
            Object[] schemaExamples = (String[])annValues.get("examples");
            if (ArrayUtils.isNotEmpty((Object[])schemaExamples)) {
                for (Object schemaExample : schemaExamples) {
                    schemaExample = OpenApiApplicationVisitor.replacePlaceholders((String)schemaExample, context);
                    schemaToBind.addExample(ConvertUtils.parseByTypeAndFormat((String)schemaExample, elType, elFormat, context, false));
                }
            }
        } else {
            String schemaExample = (String)annValues.get("example");
            if (StringUtils.isNotEmpty((CharSequence)schemaExample)) {
                schemaExample = OpenApiApplicationVisitor.replacePlaceholders(schemaExample, context);
                schemaToBind.setExample(ConvertUtils.parseByTypeAndFormat(schemaExample, elType, elFormat, context, false));
            }
        }
        if ((schemaDefaultValue = (String)annValues.get("defaultValue")) != null) {
            ConvertUtils.setDefaultValueObject(schemaToBind, schemaDefaultValue, (Element)classEl, schemaToBind.getType(), schemaToBind.getFormat(), false, context);
        }
        if (annValues.containsKey("discriminatorProperty")) {
            Discriminator discriminator = new Discriminator();
            schemaToBind.setDiscriminator(discriminator);
            discriminator.setPropertyName(annValues.get("discriminatorProperty").toString());
            if (annValues.containsKey("discriminatorMapping")) {
                AnnotationValue[] discriminatorMapping = (AnnotationValue[])annValues.get("discriminatorMapping");
                HashMap<String, Object> extensions = new HashMap<String, Object>();
                HashMap<String, String> mappings = new HashMap<String, String>();
                for (AnnotationValue discriminatorMappingAnn : discriminatorMapping) {
                    Map<CharSequence, Object> valueMap = SchemaDefinitionUtils.resolveAnnotationValues(context, discriminatorMappingAnn, null);
                    mappings.put(valueMap.get("value").toString(), valueMap.get("$ref").toString());
                    Map extValue = (Map)valueMap.get("extensions");
                    if (extValue == null) continue;
                    extensions.putAll(extValue);
                }
                discriminator.setMapping(mappings);
                if (CollectionUtils.isNotEmpty(extensions)) {
                    extensions.forEach((arg_0, arg_1) -> ((Discriminator)discriminator).addExtension(arg_0, arg_1));
                }
            }
        }
        if (annValues.containsKey("extensions")) {
            AnnotationValue[] extensionAnns = (AnnotationValue[])annValues.get("extensions");
            HashMap<String, Object> extensions = new HashMap<String, Object>();
            for (AnnotationValue extensionAnn : extensionAnns) {
                SchemaUtils.processExtensions(extensions, (AnnotationValue<Extension>)extensionAnn);
            }
            if (!extensions.isEmpty()) {
                extensions.forEach((arg_0, arg_1) -> ((Schema)schemaToBind).addExtension(arg_0, arg_1));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(addProps = (String)annValues.get("additionalProperties")))) {
            Schema.AdditionalPropertiesValue schemaAdditionalProperties = Schema.AdditionalPropertiesValue.valueOf((String)addProps);
            if (schemaAdditionalProperties == Schema.AdditionalPropertiesValue.TRUE) {
                schemaToBind.additionalProperties((Object)true);
            } else if (schemaAdditionalProperties == Schema.AdditionalPropertiesValue.FALSE) {
                schemaToBind.additionalProperties((Object)false);
            }
        }
        if (Utils.isOpenapi31()) {
            String exclusiveMaximum;
            String exclusiveMinimum;
            if (annValues.containsKey("contains")) {
                if (annValues.containsKey("minContains")) {
                    schemaToBind.setMinContains((Integer)annValues.get("minContains"));
                }
                if (annValues.containsKey("maxContains")) {
                    schemaToBind.setMaxContains((Integer)annValues.get("maxContains"));
                }
            }
            if (annValues.containsKey("types")) {
                schemaToBind.setTypes(new HashSet((Collection)annValues.get("types")));
            }
            if (annValues.containsKey("$id")) {
                schemaToBind.set$id((String)annValues.get("$id"));
            }
            if (annValues.containsKey("$schema")) {
                schemaToBind.set$schema((String)annValues.get("$schema"));
            }
            if (annValues.containsKey("$anchor")) {
                schemaToBind.set$anchor((String)annValues.get("$anchor"));
            }
            if (annValues.containsKey("$vocabulary")) {
                schemaToBind.set$vocabulary((String)annValues.get("$vocabulary"));
            }
            if (annValues.containsKey("$dynamicAnchor")) {
                schemaToBind.set$dynamicAnchor((String)annValues.get("$dynamicAnchor"));
            }
            if (annValues.containsKey("contentEncoding")) {
                schemaToBind.setContentEncoding((String)annValues.get("contentEncoding"));
            }
            if (annValues.containsKey("contentMediaType")) {
                schemaToBind.setContentMediaType((String)annValues.get("contentMediaType"));
            }
            if (annValues.containsKey("$comment")) {
                schemaToBind.set$comment((String)annValues.get("$comment"));
            }
            if (annValues.containsKey("_const")) {
                schemaToBind.setConst(annValues.get("_const"));
            }
            if (NumberUtils.isCreatable(exclusiveMinimum = (String)annValues.get("exclusiveMinimumValue"))) {
                schemaToBind.setExclusiveMinimumValue(new BigDecimal(exclusiveMinimum));
            }
            if (NumberUtils.isCreatable(exclusiveMaximum = (String)annValues.get("exclusiveMaximumValue"))) {
                schemaToBind.setExclusiveMaximumValue(new BigDecimal(exclusiveMaximum));
            }
            SchemaDefinitionUtils.parseAndSetClassValue("contains", Schema::contains, annValues, schemaToBind, context);
            SchemaDefinitionUtils.parseAndSetClassValue("contentSchema", Schema::contentSchema, annValues, schemaToBind, context);
            SchemaDefinitionUtils.parseAndSetClassValue("propertyNames", Schema::propertyNames, annValues, schemaToBind, context);
            SchemaDefinitionUtils.parseAndSetClassValue("unevaluatedProperties", Schema::unevaluatedProperties, annValues, schemaToBind, context);
            SchemaDefinitionUtils.parseAndSetClassValue("additionalItems", Schema::additionalItems, annValues, schemaToBind, context);
            SchemaDefinitionUtils.parseAndSetClassValue("unevaluatedItems", Schema::unevaluatedItems, annValues, schemaToBind, context);
            SchemaDefinitionUtils.parseAndSetClassValue("_if", Schema::_if, annValues, schemaToBind, context);
            SchemaDefinitionUtils.parseAndSetClassValue("_else", Schema::_else, annValues, schemaToBind, context);
            SchemaDefinitionUtils.parseAndSetClassValue("then", Schema::then, annValues, schemaToBind, context);
        }
        SchemaDefinitionUtils.processClassValues(schemaToBind, annValues, Collections.emptyList(), context, null);
    }

    private static void processClassValues(Schema<?> schemaToBind, Map<CharSequence, Object> annValues, List<MediaType> mediaTypes, VisitorContext context, @Nullable ClassElement jsonViewClass) {
        OpenAPI openApi = Utils.resolveOpenApi(context);
        SchemaDefinitionUtils.parseAndSetClassValue("not", Schema::not, annValues, schemaToBind, context);
        SchemaDefinitionUtils.processSchemasArray(schemaToBind, openApi, "allOf", annValues, mediaTypes, jsonViewClass, Schema::getAllOf, Schema::addAllOfItem, context);
        SchemaDefinitionUtils.processSchemasArray(schemaToBind, openApi, "anyOf", annValues, mediaTypes, jsonViewClass, Schema::getAnyOf, Schema::addAnyOfItem, context);
        SchemaDefinitionUtils.processSchemasArray(schemaToBind, openApi, "oneOf", annValues, mediaTypes, jsonViewClass, Schema::getOneOf, Schema::addOneOfItem, context);
    }

    private static void parseAndSetClassValue(String propName, BiConsumer<Schema, Schema> setter, Map<CharSequence, Object> annValues, Schema schema, VisitorContext context) {
        if (annValues.containsKey(propName)) {
            ClassElement classEl = ContextUtils.getClassElement(annValues.get(propName).toString(), context);
            Schema<?> resolvedSchema = SchemaDefinitionUtils.resolveSchema(null, classEl, context, Collections.emptyList(), null);
            setter.accept(schema, resolvedSchema);
        }
    }

    private static void processSchemasArray(Schema<?> schemaToBind, OpenAPI openApi, String propName, Map<CharSequence, Object> annValues, List<MediaType> mediaTypes, @Nullable ClassElement jsonViewClass, Function<Schema, List<Schema>> getter, BiConsumer<Schema, Schema> methodAdd, VisitorContext context) {
        Object[] oneOf = (AnnotationClassValue[])annValues.get(propName);
        if (ArrayUtils.isEmpty((Object[])oneOf)) {
            return;
        }
        for (Object classAnn : oneOf) {
            List<Schema> schemas;
            Schema<?> schema;
            ClassElement classEl = ContextUtils.getClassElement(classAnn.getName(), context);
            if (classEl == null) continue;
            Map classElementTypeArgs = classEl.getTypeArguments();
            ClassElement customClassEl = ConfigUtils.getCustomSchema(classEl.getName(), classElementTypeArgs, context);
            if (customClassEl != null) {
                classEl = customClassEl;
            }
            if ((schema = SchemaDefinitionUtils.getSchemaDefinition(openApi, context, classEl, classElementTypeArgs, null, mediaTypes, jsonViewClass)) == null) continue;
            if ("object".equals(schema.getType())) {
                if (schemaToBind.getType() == null) {
                    schemaToBind.setType("object");
                }
                schema.setType(null);
            }
            if (!CollectionUtils.isEmpty(schemas = getter.apply(schemaToBind)) && schemas.contains(schema)) continue;
            methodAdd.accept(schemaToBind, schema);
        }
    }

    private static Map<String, Object> annotationValueArrayToSubmap(Object[] a, String classifier, VisitorContext context, @Nullable ClassElement jsonViewClass) {
        LinkedHashMap<String, Object> mediaTypes = new LinkedHashMap<String, Object>();
        for (Object o : a) {
            AnnotationValue sv = (AnnotationValue)o;
            String name = sv.stringValue(classifier).orElse(null);
            if (name == null && classifier.equals("mediaType")) {
                name = "application/json";
            }
            if (name == null) continue;
            Map<CharSequence, Object> map = SchemaDefinitionUtils.toValueMap(sv.getValues(), context, jsonViewClass);
            mediaTypes.put(name, map);
        }
        return mediaTypes;
    }

    private static Schema<?> getPrimitiveType(ClassElement type, String typeName) {
        Class wrapperType;
        PrimitiveType primitiveType;
        Schema schema = null;
        Class aClass = ClassUtils.getPrimitiveType((String)typeName).orElse(null);
        if (aClass == null) {
            aClass = ClassUtils.forName((String)typeName, (ClassLoader)SchemaDefinitionUtils.class.getClassLoader()).orElse(null);
        }
        if (aClass != null && (primitiveType = PrimitiveType.fromType((Type)(wrapperType = ReflectionUtils.getWrapperType((Class)aClass)))) != null) {
            schema = SchemaUtils.setSpecVersion(primitiveType.createProperty());
        }
        SchemaDefinitionUtils.processArgTypeAnnotations(type, schema);
        return schema;
    }

    private static Schema<?> processGenericAnnotations(Schema<?> schema, ClassElement componentType) {
        if (componentType == null) {
            return schema;
        }
        Schema<?> primitiveComponentType = SchemaDefinitionUtils.getPrimitiveType(componentType, componentType.getName());
        if (primitiveComponentType == null) {
            Schema schemaFromTypeArgAnnotations = SchemaUtils.setSpecVersion(new Schema());
            SchemaDefinitionUtils.processArgTypeAnnotations(componentType, schemaFromTypeArgAnnotations);
            if (schemaFromTypeArgAnnotations.equals(SchemaUtils.EMPTY_SCHEMA)) {
                return schema;
            }
            ComposedSchema composedSchema = SchemaUtils.setSpecVersion(new ComposedSchema());
            composedSchema.addAllOfItem(schema);
            composedSchema.addAllOfItem(schemaFromTypeArgAnnotations);
            return composedSchema;
        }
        return schema;
    }

    private static void processArgTypeAnnotations(ClassElement type, @Nullable Schema<?> schema) {
        if (schema == null || type == null || type.getAnnotationNames().isEmpty()) {
            return;
        }
        if (ElementUtils.isNullable((TypedElement)type) && !ElementUtils.isNotNullable((Element)type)) {
            SchemaUtils.setNullable(schema);
        }
        SchemaDefinitionUtils.processJakartaValidationAnnotations((Element)type, type, schema);
    }

    private static boolean processJacksonPropertyAnn(Element element, ClassElement elType, Schema<?> schemaToBind, @Nullable AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaAnn, VisitorContext context) {
        String swaggerAccessMode = schemaAnn != null ? (String)schemaAnn.stringValue("accessMode").orElse(null) : null;
        String swaggerDefaultValue = schemaAnn != null ? (String)schemaAnn.stringValue("defaultValue").orElse(null) : null;
        AtomicReference<Boolean> reference = new AtomicReference<Boolean>(false);
        ElementUtils.findAnnotation(element, "com.fasterxml.jackson.annotation.JsonProperty").ifPresent(ann -> {
            if (swaggerAccessMode == null) {
                ann.get((CharSequence)"access", JsonProperty.Access.class).ifPresent(access -> {
                    switch (access) {
                        case READ_ONLY: {
                            schemaToBind.setWriteOnly(null);
                            schemaToBind.setReadOnly(Boolean.valueOf(true));
                            reference.set(true);
                            break;
                        }
                        case WRITE_ONLY: {
                            schemaToBind.setWriteOnly(Boolean.valueOf(true));
                            schemaToBind.setReadOnly(null);
                            reference.set(true);
                            break;
                        }
                        case READ_WRITE: {
                            schemaToBind.setWriteOnly(null);
                            schemaToBind.setReadOnly(null);
                            break;
                        }
                    }
                });
            }
            if (swaggerDefaultValue == null) {
                ann.stringValue("defaultValue").ifPresent(defaultValue -> {
                    Pair<String, Object> typeAndFormat;
                    if (elType.isIterable()) {
                        typeAndFormat = Pair.of("array", null);
                    } else if (elType instanceof EnumElement) {
                        EnumElement enumEl = (EnumElement)elType;
                        typeAndFormat = ConvertUtils.checkEnumJsonValueType(context, enumEl, null, null);
                    } else {
                        typeAndFormat = ConvertUtils.getTypeAndFormatByClass(elType.getName(), elType.isArray(), elType);
                    }
                    ConvertUtils.setDefaultValueObject(schemaToBind, defaultValue, (Element)elType, typeAndFormat.getFirst(), (String)typeAndFormat.getSecond(), false, context);
                    if (schemaToBind.getDefault() != null) {
                        reference.set(true);
                    }
                });
            }
        });
        return reference.get();
    }

    private static void processJakartaValidationAnnotations(Element element, ClassElement elementType, Schema<?> schemaToBind) {
        boolean isIterableOrMap;
        boolean bl = isIterableOrMap = elementType.isIterable() || elementType.isAssignable(Map.class);
        if (isIterableOrMap) {
            if (ElementUtils.isAnnotationPresent(element, "javax.validation.constraints.NotEmpty$List") || ElementUtils.isAnnotationPresent(element, "jakarta.validation.constraints.NotEmpty$List")) {
                schemaToBind.setMinItems(Integer.valueOf(1));
            }
            ElementUtils.findAnnotation(element, "javax.validation.constraints.Size$List").ifPresent(listAnn -> listAnn.getValue(AnnotationValue.class).ifPresent(ann -> ann.intValue("min").ifPresent(arg_0 -> ((Schema)schemaToBind).setMinItems(arg_0))));
            ElementUtils.findAnnotation(element, "jakarta.validation.constraints.Size$List").ifPresent(listAnn -> listAnn.getValue(AnnotationValue.class).ifPresent(ann -> ann.intValue("min").ifPresent(arg_0 -> ((Schema)schemaToBind).setMinItems(arg_0))));
            ElementUtils.findAnnotation(element, "javax.validation.constraints.Size$List").ifPresent(listAnn -> listAnn.getValue(AnnotationValue.class).ifPresent(ann -> ann.intValue("max").ifPresent(arg_0 -> ((Schema)schemaToBind).setMaxItems(arg_0))));
            ElementUtils.findAnnotation(element, "jakarta.validation.constraints.Size$List").ifPresent(listAnn -> listAnn.getValue(AnnotationValue.class).ifPresent(ann -> ann.intValue("max").ifPresent(arg_0 -> ((Schema)schemaToBind).setMaxItems(arg_0))));
        } else {
            if (PrimitiveType.STRING.getCommonName().equals(schemaToBind.getType())) {
                if (ElementUtils.isAnnotationPresent(element, "javax.validation.constraints.NotEmpty$List") || ElementUtils.isAnnotationPresent(element, "jakarta.validation.constraints.NotEmpty$List") || ElementUtils.isAnnotationPresent(element, "javax.validation.constraints.NotBlank$List") || ElementUtils.isAnnotationPresent(element, "jakarta.validation.constraints.NotBlank$List")) {
                    schemaToBind.setMinLength(Integer.valueOf(1));
                }
                ElementUtils.findAnnotation(element, "javax.validation.constraints.Size$List").ifPresent(listAnn -> {
                    for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                        ann.intValue("min").ifPresent(arg_0 -> ((Schema)schemaToBind).setMinLength(arg_0));
                        ann.intValue("max").ifPresent(arg_0 -> ((Schema)schemaToBind).setMaxLength(arg_0));
                    }
                });
                ElementUtils.findAnnotation(element, "jakarta.validation.constraints.Size$List").ifPresent(listAnn -> {
                    for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                        ann.intValue("min").ifPresent(arg_0 -> ((Schema)schemaToBind).setMinLength(arg_0));
                        ann.intValue("max").ifPresent(arg_0 -> ((Schema)schemaToBind).setMaxLength(arg_0));
                    }
                });
            }
            if (ElementUtils.isAnnotationPresent(element, "javax.validation.constraints.Negative$List") || ElementUtils.isAnnotationPresent(element, "jakarta.validation.constraints.Negative$List")) {
                schemaToBind.setMaximum(BigDecimal.ZERO);
                schemaToBind.exclusiveMaximum(Boolean.valueOf(true));
            }
            if (ElementUtils.isAnnotationPresent(element, "javax.validation.constraints.NegativeOrZero$List") || ElementUtils.isAnnotationPresent(element, "jakarta.validation.constraints.NegativeOrZero$List")) {
                schemaToBind.setMaximum(BigDecimal.ZERO);
            }
            if (ElementUtils.isAnnotationPresent(element, "javax.validation.constraints.Positive$List") || ElementUtils.isAnnotationPresent(element, "jakarta.validation.constraints.Positive$List")) {
                schemaToBind.setMinimum(BigDecimal.ZERO);
                schemaToBind.exclusiveMinimum(Boolean.valueOf(true));
            }
            if (ElementUtils.isAnnotationPresent(element, "javax.validation.constraints.PositiveOrZero$List") || ElementUtils.isAnnotationPresent(element, "jakarta.validation.constraints.PositiveOrZero$List")) {
                schemaToBind.setMinimum(BigDecimal.ZERO);
            }
            ElementUtils.findAnnotation(element, "javax.validation.constraints.Min$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinimum(arg_0));
                }
            });
            ElementUtils.findAnnotation(element, "jakarta.validation.constraints.Min$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinimum(arg_0));
                }
            });
            ElementUtils.findAnnotation(element, "javax.validation.constraints.Max$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaximum(arg_0));
                }
            });
            ElementUtils.findAnnotation(element, "jakarta.validation.constraints.Max$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaximum(arg_0));
                }
            });
            ElementUtils.findAnnotation(element, "javax.validation.constraints.DecimalMin$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinimum(arg_0));
                }
            });
            ElementUtils.findAnnotation(element, "jakarta.validation.constraints.DecimalMin$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMinimum(arg_0));
                }
            });
            ElementUtils.findAnnotation(element, "javax.validation.constraints.DecimalMax$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaximum(arg_0));
                }
            });
            ElementUtils.findAnnotation(element, "jakarta.validation.constraints.DecimalMax$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.getValue(BigDecimal.class).ifPresent(arg_0 -> ((Schema)schemaToBind).setMaximum(arg_0));
                }
            });
            ElementUtils.findAnnotation(element, "javax.validation.constraints.Email$List").ifPresent(listAnn -> {
                schemaToBind.setFormat(PrimitiveType.EMAIL.getCommonName());
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.stringValue("regexp").ifPresent(arg_0 -> ((Schema)schemaToBind).setPattern(arg_0));
                }
            });
            ElementUtils.findAnnotation(element, "jakarta.validation.constraints.Email$List").ifPresent(listAnn -> {
                schemaToBind.setFormat(PrimitiveType.EMAIL.getCommonName());
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.stringValue("regexp").ifPresent(arg_0 -> ((Schema)schemaToBind).setPattern(arg_0));
                }
            });
            ElementUtils.findAnnotation(element, "javax.validation.constraints.Pattern$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.stringValue("regexp").ifPresent(arg_0 -> ((Schema)schemaToBind).setPattern(arg_0));
                }
            });
            ElementUtils.findAnnotation(element, "jakarta.validation.constraints.Pattern$List").ifPresent(listAnn -> {
                for (AnnotationValue ann : listAnn.getAnnotations("value")) {
                    ann.stringValue("regexp").ifPresent(arg_0 -> ((Schema)schemaToBind).setPattern(arg_0));
                }
            });
            element.getValue("io.micronaut.http.annotation.Part", String.class).ifPresent(arg_0 -> schemaToBind.setName(arg_0));
        }
    }

    private static Schema<?> processMapSchema(ClassElement type, Map<String, ClassElement> typeArgs, List<MediaType> mediaTypes, OpenAPI openApi, ClassElement jsonViewClass, JavadocDescription classJavadoc, VisitorContext context) {
        Schema<?> enumSchema;
        Schema schema = SchemaUtils.setSpecVersion(new Schema());
        if (CollectionUtils.isEmpty(typeArgs)) {
            schema.setAdditionalProperties((Object)true);
            return schema;
        }
        ClassElement keyType = typeArgs.get("K");
        ClassElement valueType = typeArgs.get("V");
        if (ElementUtils.isEnum(keyType) && (enumSchema = SchemaDefinitionUtils.getSchemaDefinition(openApi, context, keyType, keyType.getTypeArguments(), null, mediaTypes, null)) != null && enumSchema.get$ref() != null) {
            List values = (enumSchema = SchemaUtils.getSchemaByRef(enumSchema, openApi)).getEnum();
            if (CollectionUtils.isNotEmpty((Collection)values)) {
                Schema<?> valueSchema = SchemaDefinitionUtils.getSchemaDefinition(openApi, context, valueType, valueType.getTypeArguments(), null, mediaTypes, jsonViewClass);
                for (Object value : values) {
                    schema.addProperty(value.toString(), valueSchema);
                }
            }
            return schema;
        }
        if (valueType.getName().equals(Object.class.getName())) {
            schema.setAdditionalProperties((Object)true);
        } else {
            schema.setAdditionalProperties(SchemaDefinitionUtils.resolveSchema(openApi, (Element)type, valueType, context, mediaTypes, jsonViewClass, null, classJavadoc));
        }
        return schema;
    }

    private static void processPropertyElements(OpenAPI openAPI, VisitorContext context, Element type, Map<String, ClassElement> typeArgs, Schema<?> schema, List<? extends TypedElement> publicFields, List<MediaType> mediaTypes, JavadocDescription classJavadoc, @Nullable ClassElement jsonViewClass) {
        ClassElement classElement = null;
        if (type instanceof ClassElement) {
            ClassElement classEl;
            classElement = classEl = (ClassElement)type;
        } else if (type instanceof TypedElement) {
            TypedElement typedEl = (TypedElement)type;
            classElement = typedEl.getType();
        }
        boolean withJsonView = jsonViewClass != null;
        String[] classLvlJsonViewClasses = null;
        if (withJsonView && classElement != null) {
            classLvlJsonViewClasses = classElement.getAnnotationMetadata().stringValues(JsonView.class);
        }
        for (TypedElement typedElement : publicFields) {
            MemberElement memberEl;
            if (SchemaDefinitionUtils.isHiddenElement(typedElement)) continue;
            boolean isGetterOverridden = false;
            JavadocDescription fieldJavadoc = null;
            if (classElement != null) {
                PropertyElement propertyEl;
                MethodElement readerMethod;
                for (FieldElement field : classElement.getFields()) {
                    if (!field.getName().equals(typedElement.getName())) continue;
                    fieldJavadoc = Utils.getJavadocParser().parse(typedElement.getDocumentation().orElse(field.getDocumentation().orElse(null)));
                    break;
                }
                if (typedElement instanceof PropertyElement && (readerMethod = (MethodElement)(propertyEl = (PropertyElement)typedElement).getReadMethod().orElse(null)) != null) {
                    List methods = classElement.getEnclosedElements(ElementQuery.ALL_METHODS.includeOverriddenMethods());
                    for (MethodElement method : methods) {
                        if (!readerMethod.overrides(method)) continue;
                        isGetterOverridden = CollectionUtils.isNotEmpty((Collection)readerMethod.getAnnotationNames()) || fieldJavadoc != null;
                        break;
                    }
                }
            }
            if (!(typedElement instanceof MemberElement) || !(memberEl = (MemberElement)typedElement).getDeclaringType().getType().getName().equals(type.getName()) && !isGetterOverridden) continue;
            ClassElement fieldType = typedElement.getGenericType();
            if (withJsonView && !SchemaDefinitionUtils.allowedByJsonView(typedElement, classLvlJsonViewClasses, jsonViewClass, context)) continue;
            Schema<?> propertySchema = SchemaDefinitionUtils.resolveSchema(openAPI, (Element)typedElement, fieldType, context, mediaTypes, jsonViewClass, fieldJavadoc, classJavadoc);
            SchemaDefinitionUtils.processSchemaProperty(context, typedElement, fieldType, classElement, schema, propertySchema);
        }
    }

    private static boolean isHiddenElement(TypedElement elementType) {
        boolean isHidden = ElementUtils.getAnnotationMetadata((Element)elementType).booleanValue(io.swagger.v3.oas.annotations.media.Schema.class, "hidden").orElse(false);
        AnnotationValue<JsonAnySetter> jsonAnySetterAnn = ElementUtils.getAnnotation((Element)elementType, JsonAnySetter.class);
        return elementType.getType().isAssignable(Class.class) || ElementUtils.isAnnotationPresent((Element)elementType, JsonIgnore.class) || ElementUtils.isAnnotationPresent((Element)elementType, JsonBackReference.class) || ElementUtils.isAnnotationPresent((Element)elementType, Hidden.class) || jsonAnySetterAnn != null && jsonAnySetterAnn.booleanValue("enabled").orElse(true) != false || isHidden;
    }

    private static boolean allowedByJsonView(TypedElement publicField, String[] classLvlJsonViewClasses, ClassElement jsonViewClassEl, VisitorContext context) {
        Object[] fieldJsonViewClasses = ElementUtils.getAnnotationMetadata((Element)publicField).stringValues(JsonView.class);
        if (ArrayUtils.isEmpty((Object[])fieldJsonViewClasses)) {
            fieldJsonViewClasses = classLvlJsonViewClasses;
        }
        if (ArrayUtils.isEmpty((Object[])fieldJsonViewClasses)) {
            return ConfigUtils.isJsonViewDefaultInclusion(context);
        }
        for (Object fieldJsonViewClass : fieldJsonViewClasses) {
            ClassElement classEl = ContextUtils.getClassElement((String)fieldJsonViewClass, context);
            if (classEl == null || !jsonViewClassEl.isAssignable(classEl)) continue;
            return true;
        }
        return false;
    }

    private static Schema<?> schemaFromAnnotation(VisitorContext context, Element element, ClassElement type, AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaAnn) {
        if (schemaAnn == null) {
            return null;
        }
        Schema schemaToBind = SchemaUtils.setSpecVersion(new Schema());
        SchemaDefinitionUtils.processSchemaAnn(schemaToBind, context, element, type, schemaAnn);
        return schemaToBind;
    }

    private static Schema<?> doBindSchemaAnnotationValue(VisitorContext context, TypedElement element, Schema schemaToBind, JsonNode schemaJson, String elType, String elFormat, AnnotationValue<io.swagger.v3.oas.annotations.media.Schema> schemaAnn, @Nullable ClassElement jsonViewClass) {
        if (schemaAnn != null && schemaAnn.annotationClassValue("implementation").isEmpty()) {
            Schema<?> resolvedSchema = SchemaDefinitionUtils.resolveSchema((Element)element, element != null ? element.getType() : null, context, List.of(), null);
            schemaToBind = SchemaUtils.appendSchema(schemaToBind, resolvedSchema);
        }
        schemaJson = OpenApiApplicationVisitor.resolvePlaceholders(schemaJson, s -> OpenApiApplicationVisitor.expandProperties(s, ConfigUtils.getExpandableProperties(context), context));
        try {
            schemaToBind = (Schema)Utils.getJsonMapper().readerForUpdating((Object)schemaToBind).readValue(schemaJson);
        }
        catch (IOException e) {
            ContextUtils.warn("Error reading Swagger Schema for element [" + element + "]: " + e.getMessage(), context, (Element)element);
        }
        if (schemaToBind.getExample() == null && !schemaToBind.getExampleSetFlag() && schemaJson.get("exampleSetFlag") != null) {
            schemaToBind.setExampleSetFlag(true);
        }
        String defaultValue = null;
        String[] allowableValues = null;
        if (schemaAnn != null) {
            defaultValue = schemaAnn.stringValue("defaultValue").orElse(null);
            allowableValues = schemaAnn.stringValues("allowableValues");
            Map annValues = schemaAnn.getValues();
            Map<CharSequence, Object> valueMap = SchemaDefinitionUtils.toValueMap(annValues, context, jsonViewClass);
            SchemaDefinitionUtils.bindSchemaIfNecessary(context, schemaAnn, valueMap, jsonViewClass);
            SchemaDefinitionUtils.processClassValues(schemaToBind, annValues, Collections.emptyList(), context, jsonViewClass);
        }
        if (elType == null && element != null) {
            EnumElement enumEl;
            ClassElement typeEl = element.getType();
            Pair<String, String> typeAndFormat = typeEl instanceof EnumElement && ElementUtils.isEnum((ClassElement)(enumEl = (EnumElement)typeEl)) ? ConvertUtils.checkEnumJsonValueType(context, enumEl, null, elFormat) : ConvertUtils.getTypeAndFormatByClass(typeEl.getName(), typeEl.isArray(), typeEl);
            elType = typeAndFormat.getFirst();
            if (elFormat == null) {
                elFormat = typeAndFormat.getSecond();
            }
        }
        if (StringUtils.isNotEmpty(defaultValue)) {
            ConvertUtils.setDefaultValueObject(schemaToBind, defaultValue, (Element)element, elType, elFormat, false, context);
        }
        SchemaUtils.setAllowableValues(schemaToBind, allowableValues, (Element)element, elType, elFormat, context);
        return schemaToBind;
    }

    private static void bindSchemaIfNecessary(VisitorContext context, AnnotationValue<?> av, Map<CharSequence, Object> valueMap, @Nullable ClassElement jsonViewClass) {
        String className;
        boolean isSchema;
        Optional impl = av.stringValue("implementation");
        Optional not = av.stringValue("not");
        Optional schema = av.stringValue("schema");
        String[] anyOfList = av.stringValues("anyOf");
        String[] oneOfList = av.stringValues("oneOf");
        String[] allOfList = av.stringValues("allOf");
        Object o = valueMap.remove("defaultValue");
        if (o != null) {
            valueMap.put("default", o);
        }
        if ((o = valueMap.remove("allowableValues")) != null) {
            valueMap.put("enum", o);
        }
        if (isSchema = io.swagger.v3.oas.annotations.media.Schema.class.getName().equals(av.getAnnotationName())) {
            if (impl.isPresent()) {
                className = (String)impl.get();
                SchemaDefinitionUtils.bindSchemaForClassName(context, valueMap, className, jsonViewClass);
            }
            if (not.isPresent()) {
                Schema<?> schemaNot = SchemaDefinitionUtils.resolveSchema(null, ContextUtils.getClassElement((String)not.get(), context), context, Collections.emptyList(), jsonViewClass);
                HashMap<CharSequence, Object> schemaMap = new HashMap<CharSequence, Object>();
                SchemaDefinitionUtils.schemaToValueMap(schemaMap, schemaNot);
                valueMap.put("not", schemaMap);
            }
            if (anyOfList.length > 0) {
                SchemaDefinitionUtils.bindSchemaForComposite(context, valueMap, anyOfList, "anyOf", jsonViewClass);
            }
            if (oneOfList.length > 0) {
                SchemaDefinitionUtils.bindSchemaForComposite(context, valueMap, oneOfList, "oneOf", jsonViewClass);
            }
            if (allOfList.length > 0) {
                SchemaDefinitionUtils.bindSchemaForComposite(context, valueMap, allOfList, "allOf", jsonViewClass);
            }
        }
        if (DiscriminatorMapping.class.getName().equals(av.getAnnotationName()) && schema.isPresent()) {
            className = (String)schema.get();
            SchemaDefinitionUtils.bindSchemaForClassName(context, valueMap, className, jsonViewClass);
        }
    }

    private static void bindSchemaForComposite(VisitorContext context, Map<CharSequence, Object> valueMap, String[] classNames, String key, @Nullable ClassElement jsonViewClass) {
        ArrayList<HashMap<CharSequence, Object>> namesToSchemas = new ArrayList<HashMap<CharSequence, Object>>();
        for (String className : classNames) {
            ClassElement classEl = ContextUtils.getClassElement(className, context);
            HashMap<CharSequence, Object> schemaMap = new HashMap<CharSequence, Object>();
            if (classEl != null) {
                Schema<?> schema = SchemaDefinitionUtils.resolveSchema(null, classEl, context, Collections.emptyList(), jsonViewClass);
                SchemaDefinitionUtils.schemaToValueMap(schemaMap, schema);
            }
            namesToSchemas.add(schemaMap);
        }
        valueMap.put(key, namesToSchemas);
    }

    private static void bindSchemaForClassName(VisitorContext context, Map<CharSequence, Object> valueMap, String className, @Nullable ClassElement jsonViewClass) {
        ClassElement classEl = ContextUtils.getClassElement(className, context);
        if (classEl != null) {
            Schema<?> schema = SchemaDefinitionUtils.resolveSchema(null, classEl, context, Collections.emptyList(), jsonViewClass);
            SchemaDefinitionUtils.schemaToValueMap(valueMap, schema);
        }
    }

    private static void schemaToValueMap(Map<CharSequence, Object> valueMap, Schema<?> schema) {
        if (schema == null) {
            return;
        }
        BeanMap beanMap = BeanMap.of(schema);
        for (Map.Entry entry : beanMap.entrySet()) {
            Object value = entry.getValue();
            if (value == null || ((String)entry.getKey()).equals("specVersion") || ((String)entry.getKey()).equals("exampleSetFlag") && "false".equals(value.toString())) continue;
            valueMap.put((CharSequence)entry.getKey(), value);
        }
        if (schema.get$ref() != null) {
            valueMap.put("$ref", schema.get$ref());
        }
    }

    private static String computeNameWithGenerics(ClassElement classElement, Map<String, ClassElement> typeArgs, VisitorContext context, boolean isProtobufGenerated) {
        String className = classElement.getSimpleName();
        if (isProtobufGenerated) {
            className = ProtoUtils.normalizeProtobufClassName(className);
        }
        StringBuilder builder = new StringBuilder(className);
        SchemaDefinitionUtils.computeNameWithGenerics(classElement, builder, new HashSet<String>(), typeArgs, context);
        return builder.toString();
    }

    private static void computeNameWithGenerics(ClassElement classElement, StringBuilder builder, Set<String> computed, Map<String, ClassElement> typeArgs, VisitorContext context) {
        String genericSeparator = ConfigUtils.getGenericSeparator(context);
        String innerClassSeparator = ConfigUtils.getInnerClassSeparator(context);
        computed.add(classElement.getName());
        Iterator<ClassElement> i = typeArgs.values().iterator();
        if (i.hasNext()) {
            builder.append(genericSeparator);
            while (i.hasNext()) {
                Set typeArgAnnotations;
                ClassElement ce = i.next();
                if (ClassUtils.isJavaLangType((String)ce.getName()) && CollectionUtils.isNotEmpty((Collection)(typeArgAnnotations = ce.getAnnotationNames()))) {
                    for (String typeArgAnnName : typeArgAnnotations) {
                        AnnotationValue annValue = ce.getAnnotation(typeArgAnnName);
                        builder.append(SchemaDefinitionUtils.addTypeArgsAnnotations(null, typeArgAnnName.endsWith("$List") ? annValue.getValues().get("value") : annValue, context));
                    }
                }
                builder.append(ce.getSimpleName());
                Map ceTypeArgs = ce.getTypeArguments();
                ClassElement customElement = ConfigUtils.getCustomSchema(ce.getName(), ceTypeArgs, context);
                if (customElement != null) {
                    ce = customElement;
                }
                if (!computed.contains(ce.getName())) {
                    SchemaDefinitionUtils.computeNameWithGenerics(ce, builder, computed, ceTypeArgs, context);
                }
                if (!i.hasNext()) continue;
                builder.append(innerClassSeparator);
            }
            builder.append(genericSeparator);
        }
    }

    private static String addTypeArgsAnnotations(String memberName, Object annValue, VisitorContext context) {
        String genericSeparator = ConfigUtils.getGenericSeparator(context);
        String innerClassSeparator = ConfigUtils.getInnerClassSeparator(context);
        StringBuilder result = new StringBuilder();
        if (annValue instanceof AnnotationValue) {
            AnnotationValue aValue = (AnnotationValue)annValue;
            String annName = aValue.getAnnotationName();
            Map values = aValue.getValues();
            int endPos = annName.contains("$") ? annName.lastIndexOf("$") : annName.length();
            result.append(annName, annName.lastIndexOf(".") + 1, endPos);
            if (CollectionUtils.isNotEmpty((Map)values)) {
                result.append(genericSeparator);
                for (Map.Entry entry : values.entrySet()) {
                    result.append(SchemaDefinitionUtils.addTypeArgsAnnotations((String)entry.getKey(), entry.getValue(), context));
                }
                result.append(genericSeparator);
            }
        } else if (annValue instanceof Iterable) {
            Iterable iterable = (Iterable)annValue;
            boolean isFirst = true;
            for (Object item : iterable) {
                if (!isFirst) {
                    result.append(genericSeparator);
                }
                if (memberName != null) {
                    result.append(memberName).append(genericSeparator);
                }
                result.append(SchemaDefinitionUtils.addTypeArgsAnnotations(null, item, context));
                isFirst = false;
            }
        } else {
            if (memberName != null && !memberName.equals("value")) {
                result.append(memberName).append(genericSeparator);
            }
            result.append(annValue);
        }
        String resultTypeName = result.toString();
        resultTypeName = resultTypeName.replace(".", innerClassSeparator);
        return resultTypeName;
    }

    private static String resolvePropertyName(Element element, Element classElement, Schema<?> propertySchema) {
        String nameFromSchema;
        String name;
        String string = name = propertySchema.getName() != null ? propertySchema.getName() : element.getName();
        if (ElementUtils.isAnnotationPresent(element, io.swagger.v3.oas.annotations.media.Schema.class) && (nameFromSchema = (String)ElementUtils.stringValue(element, io.swagger.v3.oas.annotations.media.Schema.class, "name").orElse(null)) != null) {
            return nameFromSchema;
        }
        if (ElementUtils.isAnnotationPresent(element, JsonProperty.class)) {
            return ElementUtils.stringValue(element, JsonProperty.class, "value").orElse(name);
        }
        if (classElement != null && classElement.hasAnnotation(JsonNaming.class)) {
            Optional propertyNamingStrategyClass = classElement.stringValue(JsonNaming.class);
            if (propertyNamingStrategyClass.isEmpty()) {
                return name;
            }
            PropertyNamingStrategy strategy = propertyNamingStrategyInstances.computeIfAbsent((String)propertyNamingStrategyClass.get(), clazz -> {
                try {
                    return (PropertyNamingStrategy)Class.forName((String)propertyNamingStrategyClass.get()).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot instantiate: " + clazz);
                }
            });
            if (strategy instanceof PropertyNamingStrategies.NamingBase) {
                PropertyNamingStrategies.NamingBase namingBase = (PropertyNamingStrategies.NamingBase)strategy;
                return namingBase.translate(name);
            }
        }
        return name;
    }

    private static void handleUnwrapped(VisitorContext context, Element element, ClassElement elementType, Schema<?> parentSchema, AnnotationValue<JsonUnwrapped> uw) {
        Map properties;
        String schemaName;
        Schema wrappedPropertySchema;
        AnnotationClassValue implClass;
        Map<String, Schema> schemas = SchemaUtils.resolveSchemas(Utils.resolveOpenApi(context));
        ClassElement customElementType = ConfigUtils.getCustomSchema(elementType.getName(), elementType.getTypeArguments(), context);
        ClassElement elType = customElementType != null ? customElementType : elementType;
        AnnotationValue schemaAnn = element.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        if (schemaAnn != null && (implClass = (AnnotationClassValue)schemaAnn.annotationClassValue("implementation").orElse(null)) != null) {
            elType = context.getClassElement(implClass.getName()).orElse(elType);
        }
        if ((wrappedPropertySchema = schemas.get(schemaName = SchemaDefinitionUtils.computeDefaultSchemaName(ElementUtils.stringValue(element, io.swagger.v3.oas.annotations.media.Schema.class, "name").orElse(null), null, (Element)elType, elementType.getTypeArguments(), context, null))) == null) {
            SchemaDefinitionUtils.getSchemaDefinition(Utils.resolveOpenApi(context), context, elType, elType.getTypeArguments(), element, Collections.emptyList(), null);
            wrappedPropertySchema = schemas.get(schemaName);
        }
        Map map = properties = wrappedPropertySchema != null ? wrappedPropertySchema.getProperties() : null;
        if (CollectionUtils.isEmpty((Map)properties)) {
            return;
        }
        String prefix = uw.stringValue("prefix").orElse("");
        String suffix = uw.stringValue("suffix").orElse("");
        for (Map.Entry prop : properties.entrySet()) {
            try {
                boolean isRequired;
                Object propertyName = (String)prop.getKey();
                Schema propertySchema = (Schema)prop.getValue();
                boolean bl = isRequired = wrappedPropertySchema.getRequired() != null && wrappedPropertySchema.getRequired().contains(propertyName);
                if (StringUtils.isNotEmpty((CharSequence)suffix) || StringUtils.isNotEmpty((CharSequence)prefix)) {
                    propertyName = prefix + (String)propertyName + suffix;
                    propertySchema = (Schema)Utils.getJsonMapper().readValue(Utils.getJsonMapper().writeValueAsString(prop.getValue()), Schema.class);
                    propertySchema.setName((String)propertyName);
                }
                SchemaDefinitionUtils.addProperty(parentSchema, (String)propertyName, propertySchema, isRequired);
            }
            catch (IOException e) {
                ContextUtils.warn("Exception cloning property " + e.getMessage(), context);
            }
        }
    }

    private static boolean doesParamExistsMandatoryInConstructor(Element element, @Nullable Element classElement) {
        if (classElement instanceof ClassElement) {
            ClassElement classEl = (ClassElement)classElement;
            if (classEl.isEnum()) {
                return true;
            }
            return classEl.getPrimaryConstructor().flatMap(methodElement -> Arrays.stream(methodElement.getParameters()).filter(parameterElement -> parameterElement.getName().equals(element.getName())).map(parameterElement -> !parameterElement.isNullable()).findFirst()).orElse(false);
        }
        return false;
    }

    private static void addProperty(Schema<?> parentSchema, String name, Schema<?> propertySchema, boolean required) {
        List requiredList;
        parentSchema.addProperty(name, propertySchema);
        if (required && ((requiredList = parentSchema.getRequired()) == null || !requiredList.contains(name))) {
            parentSchema.addRequiredItem(name);
        }
    }

    private static Map<String, Object> getDiscriminatorMap(Map<CharSequence, Object> newValues) {
        return newValues.containsKey("discriminator") ? (Map)newValues.get("discriminator") : new HashMap();
    }

    private static <T extends Schema<?>> void processAnnotationValue(VisitorContext context, AnnotationValue<?> annotationValue, Map<CharSequence, Object> arraySchemaMap, List<String> filters, Class<T> type, @Nullable ClassElement jsonViewClass) {
        Map<CharSequence, Object> values = annotationValue.getValues().entrySet().stream().filter(entry -> filters == null || !filters.contains((String)entry.getKey())).collect(Collectors.toMap(e -> ((CharSequence)e.getKey()).equals("requiredProperties") ? "required" : (CharSequence)e.getKey(), Map.Entry::getValue));
        SchemaDefinitionUtils.toValue(values, context, type, jsonViewClass).ifPresent(s -> SchemaDefinitionUtils.schemaToValueMap(arraySchemaMap, s));
    }

    private static Map<CharSequence, Object> resolveAnnotationValues(VisitorContext context, AnnotationValue<?> av, @Nullable ClassElement jsonViewClass) {
        Map<CharSequence, Object> valueMap = SchemaDefinitionUtils.toValueMap(av.getValues(), context, jsonViewClass);
        SchemaDefinitionUtils.bindSchemaIfNecessary(context, av, valueMap, jsonViewClass);
        String annotationName = av.getAnnotationName();
        if (Parameter.class.getName().equals(annotationName)) {
            Utils.normalizeEnumValues(valueMap, CollectionUtils.mapOf((Object[])new Object[]{"in", ParameterIn.class, "style", ParameterStyle.class}));
        }
        return valueMap;
    }

    public static Map<String, String> getSchemaNameToClassNameMap() {
        return schemaNameToClassNameMap;
    }
}

