/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.javadoc;

import com.github.chhorz.javadoc.JavaDoc;
import com.github.chhorz.javadoc.JavaDocParser;
import com.github.chhorz.javadoc.JavaDocParserBuilder;
import com.github.chhorz.javadoc.OutputType;
import com.github.chhorz.javadoc.tags.BlockTag;
import com.github.chhorz.javadoc.tags.DeprecatedTag;
import com.github.chhorz.javadoc.tags.ParamTag;
import com.github.chhorz.javadoc.tags.PropertyTag;
import com.github.chhorz.javadoc.tags.ReturnTag;
import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.openapi.javadoc.JavadocDescription;
import java.util.Collection;
import java.util.Set;

public class JavadocParser {
    private static final Set<String> IGNORED = CollectionUtils.setOf((Object[])new String[]{"see", "since", "author", "version", "throws", "exception", "category"});
    private final FlexmarkHtmlConverter htmlToMarkdownConverter = FlexmarkHtmlConverter.builder().build();

    public JavadocDescription parse(String text) {
        if (text == null) {
            return null;
        }
        JavaDocParser javaDocParser = JavaDocParserBuilder.withAllKnownTags().withOutputType(OutputType.HTML).build();
        JavaDoc javaDoc = javaDocParser.parse(text.strip());
        JavadocDescription javadocDescription = new JavadocDescription();
        javadocDescription.setMethodSummary(this.htmlToMarkdownConverter.convert(javaDoc.getSummary()).strip());
        javadocDescription.setMethodDescription(this.htmlToMarkdownConverter.convert(javaDoc.getDescription()).strip());
        if (CollectionUtils.isNotEmpty((Collection)javaDoc.getTags())) {
            for (BlockTag tag : javaDoc.getTags()) {
                String paramDesc;
                if (IGNORED.contains(tag.getTagName())) continue;
                if (tag instanceof ReturnTag) {
                    ReturnTag returnTag = (ReturnTag)tag;
                    javadocDescription.setReturnDescription(this.htmlToMarkdownConverter.convert(returnTag.getDescription()).strip());
                    continue;
                }
                if (tag instanceof ParamTag) {
                    ParamTag paramTag = (ParamTag)tag;
                    paramDesc = this.htmlToMarkdownConverter.convert(paramTag.getParamDescription()).strip();
                    javadocDescription.getParameters().put(paramTag.getParamName(), paramDesc);
                    continue;
                }
                if (tag instanceof PropertyTag) {
                    PropertyTag propertyTag = (PropertyTag)tag;
                    paramDesc = this.htmlToMarkdownConverter.convert(propertyTag.getParamDescription()).strip();
                    javadocDescription.getParameters().put(propertyTag.getPropertyName(), paramDesc);
                    continue;
                }
                if (!(tag instanceof DeprecatedTag)) continue;
                DeprecatedTag deprecatedTag = (DeprecatedTag)tag;
                javadocDescription.setDeprecatedDescription(this.htmlToMarkdownConverter.convert(deprecatedTag.getDeprecatedText()).strip());
            }
        }
        return javadocDescription;
    }
}

