/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.view;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.Toggleable;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.group.GroupProperties;
import io.micronaut.openapi.visitor.group.OpenApiInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractViewConfig
implements Toggleable {
    protected String prefix;
    protected String jsUrl = "";
    protected String specUrl;
    protected String urlPrefix;
    protected String fullUrlPrefix;
    protected String resourcesContextPath = "/res";
    protected String templatePath;
    protected boolean isDefaultJsUrl = true;
    protected boolean copyResources = true;
    protected boolean withFinalUrlPrefixCache = true;
    protected String primaryName;
    protected Boolean withUrls;
    protected List<OpenApiUrl> urls = new ArrayList<OpenApiUrl>();
    protected Map<String, Object> options = new HashMap<String, Object>();
    @Nullable
    protected Map<Pair<String, String>, OpenApiInfo> openApiInfos;

    protected AbstractViewConfig(String prefix, Map<Pair<String, String>, OpenApiInfo> openApiInfos) {
        this.prefix = prefix;
        this.openApiInfos = openApiInfos;
    }

    protected abstract Function<String, Object> getConverter(String var1);

    protected abstract List<String> getResources();

    public String getTemplatePath() {
        return this.templatePath;
    }

    public abstract String render(String var1, @Nullable VisitorContext var2);

    protected void addAttribute(Map.Entry<String, String> entry) {
        String key = entry.getKey().substring(this.prefix.length());
        Function<String, Object> converter = this.getConverter(key);
        if (converter != null) {
            this.options.put(key, converter.apply(entry.getValue()));
        }
    }

    protected String toHtmlAttributes() {
        return this.options.entrySet().stream().map(e -> (String)e.getKey() + "=\"" + e.getValue() + "\"").collect(Collectors.joining(" "));
    }

    protected String getFinalUrlPrefix(OpenApiViewConfig.RendererType rendererType, VisitorContext context) {
        String contextPath;
        Object finalUrl;
        if (this.fullUrlPrefix != null && this.withFinalUrlPrefixCache) {
            return this.fullUrlPrefix;
        }
        String serverContextPath = ConfigUtils.getConfigProperty("micronaut.openapi.server.context.path", context);
        if (serverContextPath == null) {
            serverContextPath = "";
        }
        Object object = finalUrl = serverContextPath.startsWith("/") ? serverContextPath : "/" + serverContextPath;
        if (!((String)finalUrl).endsWith("/")) {
            finalUrl = (String)finalUrl + "/";
        }
        if (!((String)(finalUrl = (String)finalUrl + ((contextPath = ConfigUtils.getServerContextPath(context)).startsWith("/") ? contextPath.substring(1) : contextPath))).endsWith("/")) {
            finalUrl = (String)finalUrl + "/";
        }
        this.urlPrefix = finalUrl;
        if (!((String)(finalUrl = (String)finalUrl + (((String)(finalUrl = (String)finalUrl + rendererType.getTemplatePath())).endsWith("/") ? this.resourcesContextPath.substring(1) : this.resourcesContextPath))).endsWith("/")) {
            finalUrl = (String)finalUrl + "/";
        }
        this.fullUrlPrefix = finalUrl;
        return finalUrl;
    }

    static <T extends AbstractViewConfig> T fromProperties(T cfg, Map<String, Object> defaultOptions, Map<String, String> properties, OpenApiViewConfig.RendererType rendererType, VisitorContext context) {
        String copyResources = properties.get(cfg.prefix + "copy-resources");
        if (StringUtils.isNotEmpty((CharSequence)copyResources) && "false".equalsIgnoreCase(copyResources)) {
            cfg.copyResources = false;
        }
        cfg.withUrls = cfg.openApiInfos != null && (cfg.openApiInfos.size() > 1 || cfg.openApiInfos.get(Pair.NULL_STRING_PAIR) == null);
        if (cfg.withUrls.booleanValue()) {
            String primaryName = null;
            ArrayList<OpenApiUrl> urls = new ArrayList<OpenApiUrl>();
            for (OpenApiInfo openApiInfo : cfg.openApiInfos.values()) {
                GroupProperties groupProperties;
                String groupName = openApiInfo.getGroupName();
                String version = openApiInfo.getVersion();
                if (StringUtils.isEmpty((CharSequence)groupName) && StringUtils.isEmpty((CharSequence)version)) continue;
                if (StringUtils.isEmpty((CharSequence)groupName)) {
                    groupName = version;
                }
                if ((groupProperties = ConfigUtils.getGroupProperties(groupName, context)) != null) {
                    if (groupProperties.getDisplayName() != null) {
                        groupName = groupProperties.getDisplayName();
                    }
                    if (groupProperties.getPrimary() != null && groupProperties.getPrimary().booleanValue()) {
                        primaryName = groupName;
                    }
                }
                cfg.getFinalUrlPrefix(OpenApiViewConfig.RendererType.SWAGGER_UI, context);
                String groupUrl = cfg.urlPrefix + (!cfg.urlPrefix.endsWith("/") ? "/swagger/" : "swagger/") + openApiInfo.getFilename();
                urls.add(new OpenApiUrl(groupUrl, groupName));
            }
            cfg.urls = urls;
            if (primaryName != null) {
                cfg.primaryName = primaryName;
            }
        } else {
            String specUrl = properties.get(cfg.prefix + "spec.url");
            if (specUrl != null) {
                String filenameFromContext = null;
                if (context != null && cfg.openApiInfos != null) {
                    filenameFromContext = cfg.openApiInfos.get(Pair.NULL_STRING_PAIR).getFilename();
                }
                cfg.specUrl = specUrl.replace("${filename}", filenameFromContext != null ? filenameFromContext : "");
            }
        }
        String jsUrl = properties.get(cfg.prefix + "js.url");
        if (StringUtils.isNotEmpty((CharSequence)jsUrl)) {
            cfg.jsUrl = jsUrl;
            cfg.isDefaultJsUrl = false;
        } else {
            String resourcesContextPath = properties.get(cfg.prefix + "resources.context.path");
            if (StringUtils.isNotEmpty((CharSequence)resourcesContextPath)) {
                cfg.resourcesContextPath = resourcesContextPath.startsWith("/") ? resourcesContextPath : "/" + resourcesContextPath;
            }
        }
        String templatePath = properties.get(cfg.prefix + "template.path");
        if (StringUtils.isNotEmpty((CharSequence)templatePath)) {
            cfg.templatePath = templatePath;
        }
        cfg.options.putAll(defaultOptions);
        for (Map.Entry entry : properties.entrySet()) {
            if (!((String)entry.getKey()).startsWith(cfg.prefix)) continue;
            cfg.addAttribute(entry);
        }
        return cfg;
    }

    public List<OpenApiUrl> getUrls() {
        return this.urls;
    }

    static Object asBoolean(String v) {
        return Boolean.valueOf(v);
    }

    static Object asInt(String v) {
        return Integer.valueOf(v);
    }

    static Object asString(String v) {
        return v;
    }

    static Object asQuotedString(String v) {
        return v == null ? null : "\"" + v + "\"";
    }

    public record OpenApiUrl(String url, String name) {
    }

    static class EnumConverter<T extends Enum<T>>
    implements Function<String, Object> {
        private final Class<T> type;

        EnumConverter(Class<T> type) {
            this.type = type;
        }

        @Override
        public Object apply(String v) {
            return v == null ? null : Enum.valueOf(this.type, v.toUpperCase(Locale.US));
        }
    }
}

