/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.view;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.scan.DefaultClassPathResourceLoader;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.view.AbstractViewConfig;
import io.micronaut.openapi.view.OpenApiExplorerConfig;
import io.micronaut.openapi.view.RapiPDFConfig;
import io.micronaut.openapi.view.RapidocConfig;
import io.micronaut.openapi.view.RedocConfig;
import io.micronaut.openapi.view.SwaggerUIConfig;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.FileUtils;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.group.OpenApiInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;

public final class OpenApiViewConfig {
    public static final String DEFAULT_SPEC_MAPPING_PATH = "swagger";
    public static final String RESOURCE_DIR = "res";
    public static final String THEMES_DIR = "theme";
    public static final String TEMPLATES = "templates";
    public static final String TEMPLATES_RAPIPDF = "rapipdf";
    public static final String TEMPLATES_SWAGGER_UI = "swagger-ui";
    public static final String TEMPLATES_REDOC = "redoc";
    public static final String TEMPLATES_RAPIDOC = "rapidoc";
    public static final String TEMPLATES_OPENAPI_EXPLORER = "openapi-explorer";
    private static final String TEMPLATE_INDEX_HTML = "index.html";
    private static final String REDOC = "redoc";
    private static final String RAPIDOC = "rapidoc";
    private static final String SWAGGER_UI = "swagger-ui";
    private static final String OPENAPI_EXPLORER = "openapi-explorer";
    private static final String TEMPLATE_OAUTH_2_REDIRECT_HTML = "oauth2-redirect.html";
    private String mappingPath;
    private String title;
    private String specFile;
    private SwaggerUIConfig swaggerUIConfig;
    private RedocConfig redocConfig;
    private RapidocConfig rapidocConfig;
    private OpenApiExplorerConfig openApiExplorerConfig;
    private final Map<Pair<String, String>, OpenApiInfo> openApiInfos;

    private OpenApiViewConfig(Map<Pair<String, String>, OpenApiInfo> openApiInfos) {
        this.openApiInfos = openApiInfos;
    }

    private static Map<String, String> parse(String specification) {
        if (specification == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String prop : specification.split(",")) {
            String value;
            if ((prop = prop.strip()).isEmpty()) continue;
            String[] keyValue = prop.split("=", 2);
            String key = keyValue[0].strip();
            String string = value = keyValue.length == 1 ? "" : keyValue[1].strip();
            if (key.isEmpty()) continue;
            result.put(key, value);
        }
        return result;
    }

    public static OpenApiViewConfig fromSpecification(String specification, Map<Pair<String, String>, OpenApiInfo> openApiInfos, Properties openApiProperties, VisitorContext context) {
        HashMap<String, String> openApiMap = new HashMap<String, String>(openApiProperties.size());
        openApiProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> openApiMap.put((String)key, (String)value)));
        openApiMap.putAll(OpenApiViewConfig.parse(specification));
        OpenApiViewConfig cfg = new OpenApiViewConfig(openApiInfos);
        RapiPDFConfig rapiPDFConfig = RapiPDFConfig.fromProperties(openApiMap, openApiInfos, context);
        if ("true".equals(openApiMap.getOrDefault("redoc.enabled", Boolean.FALSE.toString()))) {
            cfg.redocConfig = RedocConfig.fromProperties(openApiMap, openApiInfos, context);
            cfg.redocConfig.rapiPDFConfig = rapiPDFConfig;
        }
        if ("true".equals(openApiMap.getOrDefault("rapidoc.enabled", Boolean.FALSE.toString()))) {
            cfg.rapidocConfig = RapidocConfig.fromProperties(openApiMap, openApiInfos, context);
            cfg.rapidocConfig.rapiPDFConfig = rapiPDFConfig;
        }
        if ("true".equals(openApiMap.getOrDefault("openapi-explorer.enabled", Boolean.FALSE.toString()))) {
            cfg.openApiExplorerConfig = OpenApiExplorerConfig.fromProperties(openApiMap, openApiInfos, context);
            cfg.openApiExplorerConfig.rapiPDFConfig = rapiPDFConfig;
        }
        if ("true".equals(openApiMap.getOrDefault("swagger-ui.enabled", Boolean.FALSE.toString()))) {
            cfg.swaggerUIConfig = SwaggerUIConfig.fromProperties(openApiMap, openApiInfos, context);
            cfg.swaggerUIConfig.rapiPDFConfig = rapiPDFConfig;
        }
        cfg.mappingPath = openApiMap.getOrDefault("mapping.path", DEFAULT_SPEC_MAPPING_PATH);
        return cfg;
    }

    public boolean isEnabled() {
        return this.redocConfig != null || this.rapidocConfig != null || this.swaggerUIConfig != null || this.openApiExplorerConfig != null;
    }

    public void render(Path outputDir, VisitorContext context) throws IOException {
        if (this.redocConfig != null) {
            this.copyResources(outputDir, context, "redoc", "redoc", this.redocConfig, this.redocConfig.rapiPDFConfig);
        }
        if (this.rapidocConfig != null) {
            this.copyResources(outputDir, context, "rapidoc", "rapidoc", this.rapidocConfig, this.rapidocConfig.rapiPDFConfig);
        }
        if (this.openApiExplorerConfig != null) {
            Path openapiExplorerDir = outputDir.resolve("openapi-explorer");
            this.render(this.openApiExplorerConfig, openapiExplorerDir, "templates/openapi-explorer/index.html", context);
            this.copyResources(this.openApiExplorerConfig, openapiExplorerDir, "openapi-explorer", this.openApiExplorerConfig.getResources(), context);
            if (this.openApiExplorerConfig.rapiPDFConfig.enabled) {
                this.copyResources(this.openApiExplorerConfig.rapiPDFConfig, openapiExplorerDir, TEMPLATES_RAPIPDF, this.openApiExplorerConfig.rapiPDFConfig.getResources(), context);
            }
        }
        if (this.swaggerUIConfig != null) {
            Path swaggerUiDir = this.copyResources(outputDir, context, "swagger-ui", "swagger-ui", this.swaggerUIConfig, this.swaggerUIConfig.rapiPDFConfig);
            if (SwaggerUIConfig.hasOauth2Option(this.swaggerUIConfig.options)) {
                this.render(this.swaggerUIConfig, swaggerUiDir, "templates/swagger-ui/oauth2-redirect.html", context);
            }
            this.copySwaggerUiTheme(this.swaggerUIConfig, swaggerUiDir, "swagger-ui", context);
        }
    }

    private Path copyResources(@NonNull Path outputDir, @NonNull VisitorContext context, @NonNull String otherDir, @NonNull String templates, AbstractViewConfig viewConfig, AbstractViewConfig rapidPDFConfig) throws IOException {
        Path dir = outputDir.resolve(otherDir);
        this.render(viewConfig, dir, "templates/" + templates + "/index.html", context);
        this.copyResources(viewConfig, dir, templates, viewConfig.getResources(), context);
        if (rapidPDFConfig.isEnabled()) {
            this.copyResources(rapidPDFConfig, dir, TEMPLATES_RAPIPDF, rapidPDFConfig.getResources(), context);
        }
        return dir;
    }

    private void copySwaggerUiTheme(SwaggerUIConfig cfg, Path outputDir, String templatesDir, VisitorContext context) throws IOException {
        if (!cfg.copyTheme) {
            return;
        }
        String themeFileName = cfg.theme.getCss() + ".css";
        Path resDir = outputDir.resolve(RESOURCE_DIR);
        if (!Files.exists(resDir, new LinkOption[0])) {
            Files.createDirectories(resDir, new FileAttribute[0]);
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        try (InputStream is = classLoader.getResourceAsStream("templates/" + templatesDir + "/theme/" + themeFileName);){
            Files.copy(is, Paths.get(resDir.toString(), themeFileName), StandardCopyOption.REPLACE_EXISTING);
            Path file = resDir.resolve(themeFileName);
            if (context != null) {
                ContextUtils.info("Writing OpenAPI View Resources to destination: " + file, context);
                Path classesOutputPath = ContextUtils.getClassesOutputPath(context);
                if (classesOutputPath != null) {
                    ContextUtils.addGeneratedResource(classesOutputPath.relativize(file).toString(), context);
                }
            }
        }
        catch (Exception e) {
            ContextUtils.warn("Can't copy resource: " + themeFileName, context);
            throw new RuntimeException(e);
        }
    }

    private void copyResources(AbstractViewConfig cfg, Path outputDir, String templateDir, List<String> resources, VisitorContext context) throws IOException {
        if (!cfg.copyResources) {
            return;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        Path outputResDir = outputDir.resolve(RESOURCE_DIR);
        if (!Files.exists(outputResDir, new LinkOption[0])) {
            Files.createDirectories(outputResDir, new FileAttribute[0]);
        }
        if (CollectionUtils.isNotEmpty(resources)) {
            for (String resource : resources) {
                try {
                    InputStream is = classLoader.getResourceAsStream("templates/" + templateDir + "/" + resource);
                    try {
                        Files.copy(is, Paths.get(outputDir.toString(), resource), StandardCopyOption.REPLACE_EXISTING);
                        Path file = outputResDir.resolve(resource);
                        if (context == null) continue;
                        ContextUtils.info("Writing OpenAPI View Resources to destination: " + file, context);
                        Path classesOutputPath = ContextUtils.getClassesOutputPath(context);
                        if (classesOutputPath == null) continue;
                        ContextUtils.addGeneratedResource(classesOutputPath.relativize(file).toString(), context);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (Exception e) {
                    ContextUtils.warn("Can't copy resource: " + resource, context);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String readTemplateFromClasspath(String templateName) throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        try (InputStream in = classLoader.getResourceAsStream(templateName);){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                string = FileUtils.readFile(reader);
            }
            return string;
        }
        catch (Exception e) {
            throw new IOException("Fail to load " + templateName, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String readTemplateFromCustomPath(String customPathStr, @Nullable VisitorContext context) throws IOException {
        Path projectPath;
        Object projectDir = "";
        Path path = projectPath = context != null ? ConfigUtils.getProjectPath(context) : null;
        if (projectPath != null) {
            projectDir = projectPath.toString().replace("\\\\", "/");
        }
        if (((String)customPathStr).startsWith("project:")) {
            customPathStr = ((String)customPathStr).replace("project:", (CharSequence)projectDir);
        } else if (!((String)customPathStr).startsWith("file:") && !((String)customPathStr).startsWith("classpath:")) {
            if (!((String)projectDir).endsWith("/")) {
                projectDir = (String)projectDir + "/";
            }
            if (((String)customPathStr).startsWith("/")) {
                customPathStr = ((String)customPathStr).substring(1);
            }
            customPathStr = (String)projectDir + (String)customPathStr;
        } else if (((String)customPathStr).startsWith("file:")) {
            customPathStr = ((String)customPathStr).substring(5);
        } else if (((String)customPathStr).startsWith("classpath:")) {
            DefaultClassPathResourceLoader resourceLoader = new DefaultClassPathResourceLoader(this.getClass().getClassLoader());
            Optional inOpt = resourceLoader.getResourceAsStream((String)customPathStr);
            if (inOpt.isEmpty()) {
                throw new IOException("Fail to load " + (String)customPathStr);
            }
            try (InputStream in = (InputStream)inOpt.get();){
                String string;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                    string = FileUtils.readFile(reader);
                }
                return string;
            }
            catch (IOException e) {
                throw new IOException("Fail to load " + (String)customPathStr, e);
            }
        }
        Path templatePath = FileUtils.resolve(context, Paths.get((String)customPathStr, new String[0]));
        if (!Files.isReadable(templatePath)) {
            throw new IOException("Can't read file " + (String)customPathStr);
        }
        try (BufferedReader reader = Files.newBufferedReader(templatePath);){
            String string = FileUtils.readFile(reader);
            return string;
        }
        catch (IOException e) {
            throw new IOException("Fail to load " + (String)customPathStr, e);
        }
    }

    private void render(AbstractViewConfig cfg, Path outputDir, String templateName, @Nullable VisitorContext context) throws IOException {
        String template = StringUtils.isEmpty((CharSequence)cfg.templatePath) ? this.readTemplateFromClasspath(templateName) : this.readTemplateFromCustomPath(cfg.templatePath, context);
        template = cfg.render(template, context);
        template = OpenApiViewConfig.replacePlaceHolder(template, "specURL", this.getSpecURL(cfg, context), "");
        template = OpenApiViewConfig.replacePlaceHolder(template, "title", this.title, "");
        if (!Files.exists(outputDir, new LinkOption[0])) {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        String fileName = templateName.substring(templateName.lastIndexOf("/") + 1);
        Path file = outputDir.resolve(fileName);
        ContextUtils.info("Writing OpenAPI View to destination: " + file, context);
        Path classesOutputPath = ContextUtils.getClassesOutputPath(context);
        if (classesOutputPath != null) {
            ContextUtils.addGeneratedResource(classesOutputPath.relativize(file).toString(), context);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            writer.write(template);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSpecURL(AbstractViewConfig cfg, @Nullable VisitorContext context) {
        String contextPath;
        Object finalUrl;
        if (cfg.specUrl != null) {
            return cfg.specUrl;
        }
        if (this.specFile == null) {
            return "";
        }
        String serverContextPath = ConfigUtils.getConfigProperty("micronaut.openapi.server.context.path", context);
        if (serverContextPath == null) {
            serverContextPath = "";
        }
        Object object = finalUrl = serverContextPath.startsWith("/") ? serverContextPath : "/" + serverContextPath;
        if (!((String)finalUrl).endsWith("/")) {
            finalUrl = (String)finalUrl + "/";
        }
        if (!((String)(finalUrl = (String)finalUrl + ((contextPath = ConfigUtils.getServerContextPath(context)).startsWith("/") ? contextPath.substring(1) : contextPath))).endsWith("/")) {
            finalUrl = (String)finalUrl + "/";
        }
        if (!((String)(finalUrl = StringUtils.prependUri((String)finalUrl, (String)StringUtils.prependUri((String)this.mappingPath, (String)this.specFile)))).startsWith("/") && !((String)finalUrl).startsWith("$")) {
            finalUrl = "/" + (String)finalUrl;
        }
        return finalUrl;
    }

    public void setSpecFile(String specFile) {
        this.specFile = specFile;
    }

    static String replacePlaceHolder(String template, String placeHolder, String value, String valuePrefix) {
        return template.replace("{{" + placeHolder + "}}", (CharSequence)(StringUtils.isNotEmpty((CharSequence)value) ? valuePrefix + value : ""));
    }

    public SwaggerUIConfig getSwaggerUIConfig() {
        return this.swaggerUIConfig;
    }

    public RedocConfig getRedocConfig() {
        return this.redocConfig;
    }

    public RapidocConfig getRapidocConfig() {
        return this.rapidocConfig;
    }

    public OpenApiExplorerConfig getOpenApiExplorerConfig() {
        return this.openApiExplorerConfig;
    }

    public static enum RendererType {
        SWAGGER_UI("swagger-ui"),
        REDOC("redoc"),
        RAPIDOC("rapidoc"),
        OPENAPI_EXPLORER("openapi-explorer");

        private final String templatePath;

        private RendererType(String templatePath) {
            this.templatePath = templatePath;
        }

        public String getTemplatePath() {
            return this.templatePath;
        }
    }
}

