/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.GeneratedFile;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.OpenApiApplicationVisitor;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.group.OpenApiInfo;
import io.swagger.v3.oas.models.info.Info;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;

@Internal
public final class FileUtils {
    public static final String EXT_ADOC = ".adoc";
    public static final String EXT_YML = ".yml";
    public static final String EXT_YAML = ".yaml";
    public static final String EXT_JSON = ".json";

    private FileUtils() {
    }

    public static Path resolve(VisitorContext context, Path path) {
        Path projectPath;
        if (!path.isAbsolute() && context != null && (projectPath = ConfigUtils.getProjectPath(context)) != null) {
            path = projectPath.resolve(path);
        }
        return path.toAbsolutePath();
    }

    public static void createDirectories(Path f, VisitorContext context) {
        if (f.getParent() != null) {
            try {
                Files.createDirectories(f.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                ContextUtils.warn("Fail to create directories for" + f + ": " + e.getMessage(), context);
            }
        }
    }

    public static boolean isYaml(String path) {
        return path.endsWith(EXT_YML) || path.endsWith(EXT_YAML);
    }

    public static boolean isJson(String path) {
        return path.endsWith(EXT_JSON);
    }

    public static Path getViewsDestDir(Path defaultSwaggerFilePath, VisitorContext context) {
        String destDir = ConfigUtils.getConfigProperty("micronaut.openapi.views.dest.dir", context);
        if (StringUtils.isNotEmpty((CharSequence)destDir)) {
            Path destPath = FileUtils.resolve(context, Paths.get(destDir, new String[0]));
            FileUtils.createDirectories(destPath, context);
            return destPath;
        }
        return defaultSwaggerFilePath != null ? defaultSwaggerFilePath.getParent().resolve("views") : null;
    }

    public static Path getDefaultFilePath(String fileName, VisitorContext context) {
        URI uri;
        GeneratedFile generatedFile = ContextUtils.visitMetaInfFile("swagger/" + fileName, context);
        if (generatedFile != null && (uri = generatedFile.toURI()).getScheme() != null && !uri.getScheme().equals("mem")) {
            Path specPath = Paths.get(uri);
            FileUtils.createDirectories(specPath, context);
            return specPath;
        }
        ContextUtils.warn("Unable to get swagger/" + fileName + " file.", context);
        return null;
    }

    public static Path openApiSpecFile(String fileName, VisitorContext context) {
        Path path = FileUtils.userDefinedSpecFile(context);
        if (path != null) {
            return path;
        }
        return FileUtils.getDefaultFilePath(fileName, context);
    }

    public static Path userDefinedSpecFile(VisitorContext context) {
        String targetFile = ConfigUtils.getConfigProperty("micronaut.openapi.target.file", context);
        if (StringUtils.isEmpty((CharSequence)targetFile)) {
            return null;
        }
        Path specFile = FileUtils.resolve(context, Paths.get(targetFile, new String[0]));
        FileUtils.createDirectories(specFile, context);
        return specFile;
    }

    public static Pair<String, String> calcFinalFilename(String groupFileName, OpenApiInfo openApiInfo, boolean isSingleGroup, String ext, VisitorContext context) {
        Object fileName = "swagger" + ext;
        Object documentTitle = "OpenAPI";
        Info info = openApiInfo.getOpenApi().getInfo();
        if (info != null) {
            documentTitle = info.getTitle() != null ? info.getTitle() : "application";
            documentTitle = ((String)documentTitle).toLowerCase(Locale.US).replace(' ', '-');
            String version = info.getVersion();
            if (version != null) {
                documentTitle = (String)documentTitle + "-" + version;
            }
            fileName = (String)documentTitle + ext;
        }
        String versionFromInfo = info != null && info.getVersion() != null ? info.getVersion() : "";
        String fileNameFromConfig = ConfigUtils.getConfigProperty("micronaut.openapi.filename", context);
        if (StringUtils.isNotEmpty((CharSequence)fileNameFromConfig) && ((String)(fileName = OpenApiApplicationVisitor.replacePlaceholders(fileNameFromConfig, context) + ext)).contains("${version}")) {
            fileName = ((String)fileName).replaceAll("\\$\\{version}", versionFromInfo);
        }
        if (!isSingleGroup) {
            fileName = StringUtils.isNotEmpty((CharSequence)groupFileName) ? groupFileName : ((String)fileName).substring(0, ((String)fileName).length() - ext.length()) + (String)(openApiInfo.getGroupName() != null ? "-" + openApiInfo.getGroupName() : "") + (String)(openApiInfo.getVersion() != null ? "-" + openApiInfo.getVersion() : "");
            if (((String)(fileName = OpenApiApplicationVisitor.replacePlaceholders((String)fileName, context) + ext)).contains("${apiVersion}")) {
                fileName = ((String)fileName).replaceAll("\\$\\{apiVersion}", openApiInfo.getVersion() != null ? openApiInfo.getVersion() : versionFromInfo);
            }
            if (((String)fileName).contains("${version}")) {
                fileName = ((String)fileName).replaceAll("\\$\\{version}", versionFromInfo);
            }
            if (((String)fileName).contains("${group}")) {
                fileName = ((String)fileName).replaceAll("\\$\\{group}", openApiInfo.getGroupName() != null ? openApiInfo.getGroupName() : "");
            }
        }
        if (((String)fileName).contains("${")) {
            ContextUtils.warn("Can't set some placeholders in fileName: " + (String)fileName, context);
        }
        return Pair.of(documentTitle, fileName);
    }

    public static String readFile(BufferedReader reader) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder(1024);
        while ((line = reader.readLine()) != null) {
            buf.append(line).append('\n');
        }
        return buf.toString();
    }
}

