/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.EnumElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.javadoc.JavadocDescription;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.ElementUtils;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Internal
public final class GeneratorUtils {
    private GeneratorUtils() {
    }

    public static void addSchemaDeprecatedExtension(Element el, io.swagger.v3.oas.models.media.Schema<?> schema, VisitorContext context) {
        if (!ConfigUtils.isGeneratorExtensionsEnabled(context) || schema == null || el == null) {
            return;
        }
        Map extensions = schema.getExtensions() != null ? schema.getExtensions() : new HashMap();
        GeneratorUtils.addDeprecatedMessage(el, extensions, context);
        if (schema.getExtensions() == null && !extensions.isEmpty()) {
            schema.setExtensions(extensions);
        }
    }

    public static void addParameterDeprecatedExtension(TypedElement el, Parameter parameter, VisitorContext context) {
        if (!ConfigUtils.isGeneratorExtensionsEnabled(context) || parameter == null || el == null) {
            return;
        }
        Map extensions = parameter.getExtensions() != null ? parameter.getExtensions() : new HashMap();
        GeneratorUtils.addDeprecatedMessage((Element)el, extensions, context);
        if (parameter.getExtensions() == null && !extensions.isEmpty()) {
            parameter.setExtensions(extensions);
        }
    }

    public static void addOperationDeprecatedExtension(MethodElement el, Operation operation, VisitorContext context) {
        if (!ConfigUtils.isGeneratorExtensionsEnabled(context) || operation == null || el == null) {
            return;
        }
        Map extensions = operation.getExtensions() != null ? operation.getExtensions() : new HashMap();
        GeneratorUtils.addDeprecatedMessage((Element)el, extensions, context);
        if (!extensions.containsKey("x-deprecated-message")) {
            GeneratorUtils.addDeprecatedMessage((Element)el.getOwningType(), extensions, context);
        }
        if (operation.getExtensions() == null && !extensions.isEmpty()) {
            operation.setExtensions(extensions);
        }
    }

    private static void addDeprecatedMessage(Element el, Map<String, Object> extensions, VisitorContext context) {
        if (extensions.containsKey("x-deprecated-message")) {
            return;
        }
        String deprecatedMessage = null;
        AnnotationValue deprecatedAnn = el.getAnnotation("kotlin.Deprecated");
        if (deprecatedAnn != null) {
            deprecatedMessage = deprecatedAnn.stringValue().orElse(deprecatedAnn.stringValue("message").orElse(null));
        }
        if (deprecatedMessage == null) {
            String javadoc = el.getDocumentation().orElse(null);
            JavadocDescription javadocDescription = Utils.getJavadocParser().parse(javadoc);
            if (javadocDescription != null) {
                deprecatedMessage = javadocDescription.getDeprecatedDescription();
            }
        }
        if (StringUtils.isNotEmpty(deprecatedMessage)) {
            extensions.put("x-deprecated-message", deprecatedMessage);
        }
    }

    public static void addValidationMessages(Element el, io.swagger.v3.oas.models.media.Schema<?> schema, Map<String, String> messages, VisitorContext context) {
        if (!ConfigUtils.isGeneratorExtensionsEnabled(context) || schema == null || el == null) {
            return;
        }
        Map extensions = schema.getExtensions() != null ? schema.getExtensions() : new HashMap();
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            if (extensions.containsKey(entry.getKey())) continue;
            extensions.put(entry.getKey(), entry.getValue());
        }
        if (schema.getExtensions() == null && !extensions.isEmpty()) {
            schema.setExtensions(extensions);
        }
    }

    public static void addEnumExtensions(EnumElement enumEl, io.swagger.v3.oas.models.media.Schema<?> schema, VisitorContext context) {
        if (!ConfigUtils.isGeneratorExtensionsEnabled(context) || enumEl == null) {
            return;
        }
        HashMap<String, Object> extensions = schema.getExtensions();
        if (extensions == null) {
            extensions = new HashMap<String, Object>();
            schema.setExtensions(extensions);
        }
        String xType = null;
        String xFormat = null;
        ClassElement fieldType = ConvertUtils.findJsonValueType(enumEl, context);
        if (fieldType != null) {
            if (fieldType.isPrimitive()) {
                xType = fieldType.getSimpleName();
            } else {
                xType = fieldType.getSimpleName();
                if (xType.equalsIgnoreCase("byte")) {
                    xType = null;
                    xFormat = "int8";
                } else if (xType.equalsIgnoreCase("short")) {
                    xType = null;
                    xFormat = "int16";
                } else if (xType.equalsIgnoreCase("int") || xType.equalsIgnoreCase("integer") || xType.equalsIgnoreCase("long") || xType.equalsIgnoreCase("float") || xType.equalsIgnoreCase("double")) {
                    xType = null;
                } else if (xType.equalsIgnoreCase("boolean")) {
                    xType = null;
                } else if (xType.equalsIgnoreCase("char") || xType.equalsIgnoreCase("character")) {
                    xType = "char";
                }
            }
        }
        if (xType != null && !extensions.containsKey("x-type")) {
            extensions.put("x-type", xType);
        }
        if (xFormat != null && !extensions.containsKey("x-format")) {
            extensions.put("x-format", xFormat);
        }
        ArrayList<String> enumVarNameList = new ArrayList<String>();
        ArrayList<String> enumVarDocList = new ArrayList<String>();
        ArrayList<String> enumVarDeprecatedList = new ArrayList<String>();
        for (Object enumConstEl : enumEl.elements()) {
            JavadocDescription javadocDesc;
            String enumConstJavadoc;
            AnnotationValue schemaAnn = enumConstEl.getAnnotation(Schema.class);
            boolean isHidden = schemaAnn != null && schemaAnn.booleanValue("hidden").orElse(false) != false;
            if (isHidden || ElementUtils.isAnnotationPresent((Element)enumConstEl, Hidden.class) || ElementUtils.isAnnotationPresent((Element)enumConstEl, JsonIgnore.class)) continue;
            String enumVarName = null;
            if (schemaAnn != null) {
                enumVarName = schemaAnn.stringValue("name").orElse(null);
            }
            if (enumVarName == null) {
                enumVarName = enumConstEl.getName();
            }
            enumVarNameList.add(enumVarName);
            String enumVarDoc = null;
            if (schemaAnn != null) {
                enumVarDoc = schemaAnn.stringValue("description").orElse(null);
            }
            if (enumVarDoc == null && (enumConstJavadoc = (String)enumConstEl.getDocumentation().orElse(null)) != null && (javadocDesc = Utils.getJavadocParser().parse(enumConstJavadoc)) != null && StringUtils.isNotEmpty((CharSequence)javadocDesc.getMethodDescription())) {
                enumVarDoc = javadocDesc.getMethodDescription();
            }
            enumVarDocList.add(enumVarDoc != null ? enumVarDoc : "");
            Boolean isDeprecated = null;
            if (schemaAnn != null) {
                isDeprecated = schemaAnn.booleanValue("deprecated").orElse(null);
            }
            if (isDeprecated == null) {
                isDeprecated = ElementUtils.isDeprecated((Element)enumConstEl);
            }
            if (!isDeprecated.booleanValue()) continue;
            enumVarDeprecatedList.add(enumVarName);
        }
        ArrayList<String> generatedEnumVarNames = new ArrayList<String>(schema.getEnum().size());
        for (Object enumVal : schema.getEnum()) {
            generatedEnumVarNames.add(enumVal.toString().toUpperCase());
        }
        if (!(enumVarNameList.isEmpty() || extensions.containsKey("x-enum-varnames") || generatedEnumVarNames.equals(enumVarNameList))) {
            extensions.put("x-enum-varnames", enumVarNameList);
        }
        if (!enumVarDocList.isEmpty() && !extensions.containsKey("x-enum-descriptions")) {
            boolean foundNotEmpty = false;
            for (String enumVarDoc : enumVarDocList) {
                if (!StringUtils.isNotEmpty((CharSequence)enumVarDoc)) continue;
                foundNotEmpty = true;
                break;
            }
            if (foundNotEmpty) {
                extensions.put("x-enum-descriptions", enumVarDocList);
            }
        }
        if (!enumVarDeprecatedList.isEmpty() && !extensions.containsKey("x-deprecated")) {
            extensions.put("x-deprecated", enumVarDeprecatedList);
        }
    }
}

