/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.HttpMethodMapping;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.UriMapping;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.visitor.AbstractOpenApiEndpointVisitor;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.OpenApiApplicationVisitor;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.processing.SupportedOptions;

@SupportedOptions(value={"micronaut.openapi.enabled"})
public class OpenApiControllerVisitor
extends AbstractOpenApiEndpointVisitor
implements TypeElementVisitor<Object, HttpMethodMapping> {
    private final String customUri;
    private final List<AnnotationValue<Tag>> additionalTags;
    private final List<AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>> additionalSecurityRequirements;

    public OpenApiControllerVisitor() {
        this.additionalTags = Collections.emptyList();
        this.additionalSecurityRequirements = Collections.emptyList();
        this.customUri = null;
    }

    public OpenApiControllerVisitor(List<AnnotationValue<Tag>> additionalTags, List<AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>> additionalSecurityRequirements, String customUri) {
        this.additionalTags = additionalTags;
        this.additionalSecurityRequirements = additionalSecurityRequirements;
        this.customUri = customUri;
    }

    public void start(VisitorContext context) {
        Utils.init(context);
    }

    private boolean ignoreByRequires(Element element, VisitorContext context) {
        List requiresAnnotations = element.getDeclaredAnnotationValuesByType(Requires.class);
        if (CollectionUtils.isEmpty((Collection)requiresAnnotations)) {
            return false;
        }
        Environment environment = ConfigUtils.getEnv(context);
        HashSet<String> activeEnvs = environment != null ? environment.getActiveNames() : new HashSet<String>(ConfigUtils.getActiveEnvs(context));
        if (CollectionUtils.isEmpty((Collection)activeEnvs)) {
            return false;
        }
        for (AnnotationValue requiresAnn : requiresAnnotations) {
            String[] reqNotEnvs;
            String[] reqEnvs = requiresAnn.stringValues("env");
            if (reqEnvs.length != 0) {
                boolean result = Arrays.stream(reqEnvs).anyMatch(activeEnvs::contains);
                if (!result) {
                    return true;
                }
            }
            if ((reqNotEnvs = requiresAnn.stringValues("notEnv")).length == 0) continue;
            boolean result = Arrays.stream(reqNotEnvs).noneMatch(activeEnvs::contains);
            if (result) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean ignore(ClassElement element, VisitorContext context) {
        boolean isParentClass = ContextUtils.get("micronaut.internal.is.process.parent", Boolean.class, Boolean.valueOf(false), context);
        return !isParentClass && !element.isAnnotationPresent(Controller.class) || element.isAnnotationPresent(Hidden.class) || this.ignoreByRequires((Element)element, context);
    }

    @Override
    protected boolean ignore(MethodElement element, VisitorContext context) {
        AnnotationValue operationAnn = element.getAnnotation(Operation.class);
        boolean isHidden = operationAnn != null && operationAnn.booleanValue("hidden").orElse(false) != false;
        AnnotationValue jsonAnySetterAnn = element.getAnnotation(JsonAnySetter.class);
        return isHidden || this.ignore(element.getDeclaringType(), context) || element.isPrivate() || element.isStatic() || element.isAnnotationPresent(Hidden.class) || jsonAnySetterAnn != null && jsonAnySetterAnn.booleanValue("enabled").orElse(true) != false || this.ignoreByRequires((Element)element, context);
    }

    @Override
    protected HttpMethod httpMethod(MethodElement element) {
        Optional httpMethodOpt = element.getAnnotationTypeByStereotype(HttpMethodMapping.class);
        if (httpMethodOpt.isEmpty()) {
            return null;
        }
        try {
            return HttpMethod.valueOf((String)((Class)httpMethodOpt.get()).getSimpleName().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    protected List<MediaType> consumesMediaTypes(MethodElement element) {
        return this.mediaTypes(element, Consumes.class);
    }

    @Override
    protected List<MediaType> producesMediaTypes(MethodElement element) {
        return this.mediaTypes(element, Produces.class);
    }

    public int getOrder() {
        return 50;
    }

    private List<MediaType> mediaTypes(MethodElement element, Class<? extends Annotation> ann) {
        Object[] values = element.stringValues(ann);
        if (ArrayUtils.isEmpty((Object[])values)) {
            return Utils.DEFAULT_MEDIA_TYPES;
        }
        return Arrays.stream(values).map(Utils::getMediaType).distinct().toList();
    }

    @Override
    protected List<UriMatchTemplate> uriMatchTemplates(MethodElement element, VisitorContext context) {
        String controllerValue = element.getOwningType().getValue(UriMapping.class, String.class).orElse(element.getDeclaringType().getValue(UriMapping.class, String.class).orElse("/"));
        String childClassPath = ContextUtils.get("micronaut.internal.child.path", String.class, context);
        if (childClassPath != null) {
            controllerValue = childClassPath;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.customUri)) {
            controllerValue = this.customUri;
        }
        controllerValue = OpenApiApplicationVisitor.replacePlaceholders(controllerValue, context);
        UriMatchTemplate matchTemplate = UriMatchTemplate.of((String)controllerValue);
        Object[] uris = element.stringValues(HttpMethodMapping.class, "uris");
        if (ArrayUtils.isEmpty((Object[])uris)) {
            String methodValue = element.getValue(HttpMethodMapping.class, String.class).orElse("/");
            methodValue = OpenApiApplicationVisitor.replacePlaceholders(methodValue, context);
            return Collections.singletonList(matchTemplate.nest((CharSequence)methodValue));
        }
        ArrayList<UriMatchTemplate> matchTemplates = new ArrayList<UriMatchTemplate>(uris.length);
        for (Object methodValue : uris) {
            methodValue = OpenApiApplicationVisitor.replacePlaceholders((String)methodValue, context);
            matchTemplates.add(matchTemplate.nest((CharSequence)methodValue));
        }
        return matchTemplates;
    }

    @Override
    protected String description(MethodElement element) {
        return null;
    }

    @Override
    protected List<io.swagger.v3.oas.models.tags.Tag> getUserDefinedClassTags(ClassElement element, VisitorContext context) {
        return this.readTags(this.additionalTags, context);
    }

    @Override
    protected List<io.swagger.v3.oas.models.servers.Server> methodServers(MethodElement element, VisitorContext context) {
        return this.processOpenApiAnnotation((Element)element, context, Server.class, io.swagger.v3.oas.models.servers.Server.class, Collections.emptyList());
    }

    @Override
    protected List<SecurityRequirement> methodSecurityRequirements(MethodElement element, VisitorContext context) {
        List<SecurityRequirement> securityRequirements = this.readSecurityRequirements((Element)element);
        if (!this.additionalSecurityRequirements.isEmpty()) {
            securityRequirements = new ArrayList<SecurityRequirement>(securityRequirements);
            securityRequirements.addAll(this.readSecurityRequirements(this.additionalSecurityRequirements));
        }
        return securityRequirements;
    }
}

