/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.DefaultMutableConversionService;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.io.scan.DefaultClassPathResourceLoader;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.visitor.AnnProcessorEnvironment;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.EndpointsConfiguration;
import io.micronaut.openapi.visitor.FileUtils;
import io.micronaut.openapi.visitor.OpenApiConfigProperty;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.Utils;
import io.micronaut.openapi.visitor.group.GroupProperties;
import io.micronaut.openapi.visitor.group.OpenApiInfo;
import io.micronaut.openapi.visitor.group.RouterVersioningProperties;
import io.micronaut.openapi.visitor.security.InterceptUrlMapConverter;
import io.micronaut.openapi.visitor.security.InterceptUrlMapPattern;
import io.micronaut.openapi.visitor.security.SecurityProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

@Internal
public final class ConfigUtils {
    private static final String LOADED_POSTFIX = ".loaded";
    private static final String VALUE_POSTFIX = ".value";
    private static final String DEFAULT_SECURITY_SCHEMA_NAME = "Authorization";

    private ConfigUtils() {
    }

    public static SchemaDecorator getSchemaDecoration(String packageName, VisitorContext context) {
        Map<String, SchemaDecorator> schemaDecorators = ContextUtils.get("micronaut.internal.schema-decorators", ContextUtils.ARGUMENT_SCHEMA_DECORATORS_MAP, context);
        if (schemaDecorators != null) {
            return schemaDecorators.get(packageName);
        }
        schemaDecorators = new HashMap<String, SchemaDecorator>();
        Properties sysProps = System.getProperties();
        ConfigUtils.readSchemaDecorators(sysProps, schemaDecorators, context);
        Properties fileProps = ConfigUtils.readOpenApiConfigFile(context);
        ConfigUtils.readSchemaDecorators(fileProps, schemaDecorators, context);
        Environment environment = ConfigUtils.getEnv(context);
        if (environment != null) {
            SchemaDecorator decorator;
            for (Map.Entry entry : environment.getProperties("micronaut.openapi.schema-prefix", StringConvention.RAW).entrySet()) {
                decorator = schemaDecorators.computeIfAbsent((String)entry.getKey(), k -> new SchemaDecorator());
                decorator.setPrefix((String)entry.getValue());
            }
            for (Map.Entry entry : environment.getProperties("micronaut.openapi.schema-postfix", StringConvention.RAW).entrySet()) {
                decorator = schemaDecorators.computeIfAbsent((String)entry.getKey(), k -> new SchemaDecorator());
                decorator.setPostfix((String)entry.getValue());
            }
            for (Map.Entry entry : environment.getProperties("micronaut.openapi.schema.decorator.prefix", StringConvention.RAW).entrySet()) {
                decorator = schemaDecorators.computeIfAbsent((String)entry.getKey(), k -> new SchemaDecorator());
                decorator.setPrefix((String)entry.getValue());
            }
            for (Map.Entry entry : environment.getProperties("micronaut.openapi.schema.decorator.postfix", StringConvention.RAW).entrySet()) {
                decorator = schemaDecorators.computeIfAbsent((String)entry.getKey(), k -> new SchemaDecorator());
                decorator.setPostfix((String)entry.getValue());
            }
        }
        ContextUtils.put("micronaut.internal.schema-decorators", schemaDecorators, context);
        return schemaDecorators.get(packageName);
    }

    public static ClassElement getCustomSchema(String className, Map<String, ClassElement> typeArgs, VisitorContext context) {
        Map<String, CustomSchema> customSchemas = ContextUtils.get("micronaut.internal.custom.schemas", ContextUtils.ARGUMENT_CUSTOM_SCHEMA_MAP, context);
        if (customSchemas != null) {
            String key = ConfigUtils.getClassNameWithGenerics(className, typeArgs);
            CustomSchema customSchema = customSchemas.get(key);
            if (customSchema != null) {
                return customSchema.classElement;
            }
            customSchema = customSchemas.get(className);
            return customSchema != null ? customSchema.classElement : null;
        }
        customSchemas = new HashMap<String, CustomSchema>();
        Properties sysProps = System.getProperties();
        ConfigUtils.readCustomSchemas(sysProps, customSchemas, context);
        Properties fileProps = ConfigUtils.readOpenApiConfigFile(context);
        ConfigUtils.readCustomSchemas(fileProps, customSchemas, context);
        Environment environment = ConfigUtils.getEnv(context);
        if (environment != null) {
            String targetClassName;
            String prop;
            String configuredClassName;
            for (Map.Entry entry : environment.getProperties("micronaut.openapi.schema", StringConvention.RAW).entrySet()) {
                configuredClassName = (String)entry.getKey();
                prop = "micronaut.openapi.schema." + configuredClassName;
                if (ConfigUtils.isMicronautProperty(prop)) continue;
                targetClassName = (String)entry.getValue();
                ConfigUtils.readCustomSchema(configuredClassName, targetClassName, customSchemas, context);
            }
            for (Map.Entry entry : environment.getProperties("micronaut.openapi.schema.mapping", StringConvention.RAW).entrySet()) {
                configuredClassName = (String)entry.getKey();
                prop = "micronaut.openapi.schema." + configuredClassName;
                if (ConfigUtils.isMicronautProperty(prop)) continue;
                targetClassName = (String)entry.getValue();
                ConfigUtils.readCustomSchema(configuredClassName, targetClassName, customSchemas, context);
            }
        }
        ContextUtils.put("micronaut.internal.custom.schemas", customSchemas, context);
        if (customSchemas.isEmpty()) {
            return null;
        }
        String key = ConfigUtils.getClassNameWithGenerics(className, typeArgs);
        CustomSchema customSchema = customSchemas.get(key);
        if (customSchema != null) {
            return customSchema.classElement;
        }
        customSchema = customSchemas.get(className);
        return customSchema != null ? customSchema.classElement : null;
    }

    private static boolean isMicronautProperty(String prop) {
        return prop.startsWith("micronaut.openapi.schema-prefix") || prop.startsWith("micronaut.openapi.schema-postfix") || prop.startsWith("micronaut.openapi.schema.decorator.prefix") || prop.startsWith("micronaut.openapi.schema.decorator.postfix") || prop.startsWith("micronaut.openapi.schema.name.separator.empty") || prop.startsWith("micronaut.openapi.schema.name.separator.generic") || prop.startsWith("micronaut.openapi.schema.name.separator.inner-class") || prop.startsWith("micronaut.openapi.schema.duplicate-resolution") || prop.startsWith("micronaut.openapi.schema.extra.enabled");
    }

    private static String getClassNameWithGenerics(String className, Map<String, ClassElement> typeArgs) {
        StringBuilder key = new StringBuilder(className);
        if (!typeArgs.isEmpty()) {
            key.append('<');
            boolean isFirst = true;
            for (ClassElement typeArg : typeArgs.values()) {
                if (!isFirst) {
                    key.append(',');
                }
                key.append(typeArg.getName());
                isFirst = false;
            }
            key.append('>');
        }
        return key.toString();
    }

    @NonNull
    public static String getServerContextPath(VisitorContext context) {
        String contextPath = ConfigUtils.getConfigProperty("micronaut.server.context-path", context);
        if (contextPath == null) {
            contextPath = ConfigUtils.getConfigProperty("server.servlet.context-path", context);
        }
        if (contextPath == null) {
            contextPath = ConfigUtils.getConfigProperty("spring.webflux.base-path", context);
        }
        if (contextPath == null) {
            contextPath = "";
        }
        return contextPath;
    }

    public static DuplicateResolution getSchemaDuplicateResolution(VisitorContext context) {
        String value = ConfigUtils.getConfigProperty("micronaut.openapi.schema.duplicate-resolution", context);
        if (StringUtils.isNotEmpty((CharSequence)value) && DuplicateResolution.ERROR.name().equalsIgnoreCase(value)) {
            return DuplicateResolution.ERROR;
        }
        return DuplicateResolution.AUTO;
    }

    public static boolean isOpenApiEnabled(VisitorContext context) {
        boolean value = ConfigUtils.getBooleanProperty("micronaut.openapi.enabled", true, context);
        System.setProperty("micronaut.openapi.enabled", Boolean.toString(value));
        return value;
    }

    public static boolean isSchemaNameSeparatorEmpty(VisitorContext context) {
        boolean value = ConfigUtils.getBooleanProperty("micronaut.openapi.schema.name.separator.empty", false, context);
        System.setProperty("micronaut.openapi.schema.name.separator.empty", Boolean.toString(value));
        return value;
    }

    public static String getGenericSeparator(VisitorContext context) {
        if (ConfigUtils.isSchemaNameSeparatorEmpty(context)) {
            return "";
        }
        String value = ConfigUtils.getConfigProperty("micronaut.openapi.schema.name.separator.generic", context);
        return StringUtils.isNotEmpty((CharSequence)value) ? value : "_";
    }

    public static String getInnerClassSeparator(VisitorContext context) {
        if (ConfigUtils.isSchemaNameSeparatorEmpty(context)) {
            return "";
        }
        String value = ConfigUtils.getConfigProperty("micronaut.openapi.schema.name.separator.inner-class", context);
        return StringUtils.isNotEmpty((CharSequence)value) ? value : ".";
    }

    public static String getJsonSchemaDialect(VisitorContext context) {
        String value = ConfigUtils.getConfigProperty("micronaut.openapi.openapi31.json-schema-dialect", context);
        return StringUtils.isNotEmpty((CharSequence)value) ? value : null;
    }

    public static boolean isSpecGenerationEnabled(VisitorContext context) {
        boolean value = ConfigUtils.getBooleanProperty("micronaut.openapi.swagger.file.generation.enabled", true, context);
        System.setProperty("micronaut.openapi.swagger.file.generation.enabled", Boolean.toString(value));
        return value;
    }

    public static boolean isExtraSchemasEnabled(VisitorContext context) {
        return ConfigUtils.getBooleanProperty("micronaut.openapi.schema.extra.enabled", true, context);
    }

    public static boolean isJsonViewDefaultInclusion(VisitorContext context) {
        return ConfigUtils.getBooleanProperty("micronaut.openapi.json.view.default.inclusion", true, context);
    }

    public static boolean isGeneratorExtensionsEnabled(VisitorContext context) {
        return ConfigUtils.getBooleanProperty("micronaut.openapi.generator.extensions.enabled", true, context);
    }

    public static boolean isAdocEnabled(VisitorContext context) {
        return ConfigUtils.getBooleanProperty("micronaut.openapi.adoc.enabled", true, context);
    }

    public static List<Pair<String, String>> getExpandableProperties(VisitorContext context) {
        String key;
        Boolean propertiesLoaded = ContextUtils.get("micronaut.internal.expandable.props.loaded", Boolean.class, context);
        if (propertiesLoaded != null) {
            return ContextUtils.get("micronaut.internal.expandable.props", ContextUtils.EXPANDABLE_PROPERTIES_ARGUMENT, context);
        }
        ArrayList<Pair<String, String>> expandableProperties = new ArrayList<Pair<String, String>>();
        String expandPrefix = "micronaut.openapi.expand.";
        AnnProcessorEnvironment env = (AnnProcessorEnvironment)ConfigUtils.getEnv(context);
        Map propertiesFromEnv = null;
        if (env != null) {
            try {
                propertiesFromEnv = env.getProperties(expandPrefix.substring(0, expandPrefix.length() - 1), null);
            }
            catch (Exception e) {
                ContextUtils.warn("Error:\n" + Utils.printStackTrace(e), context);
            }
        }
        HashMap<String, String> expandedPropsMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(propertiesFromEnv)) {
            for (Map.Entry entry : propertiesFromEnv.entrySet()) {
                expandedPropsMap.put((String)entry.getKey(), entry.getValue().toString());
            }
        }
        Properties openapiProps = ConfigUtils.readOpenApiConfigFile(context);
        for (Map.Entry<Object, Object> entry : openapiProps.entrySet()) {
            key = entry.getKey().toString();
            if (!key.startsWith(expandPrefix)) continue;
            expandedPropsMap.put(key, entry.getValue().toString());
        }
        if (CollectionUtils.isNotEmpty((Map)System.getProperties())) {
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                key = entry.getKey().toString();
                if (!key.startsWith(expandPrefix)) continue;
                expandedPropsMap.put(key, entry.getValue().toString());
            }
        }
        for (Map.Entry<Object, Object> entry : expandedPropsMap.entrySet()) {
            Pair<CallSite, String> prop;
            key = (String)entry.getKey();
            if (key.startsWith(expandPrefix)) {
                key = key.substring(expandPrefix.length());
            }
            if (expandableProperties.contains(prop = Pair.of("\\$\\{" + key + "}", (String)entry.getValue()))) continue;
            expandableProperties.add(prop);
        }
        ContextUtils.put("micronaut.internal.expandable.props", expandableProperties, context);
        ContextUtils.put("micronaut.internal.expandable.props.loaded", true, context);
        return expandableProperties;
    }

    public static Map<String, String> getAdocProperties(OpenApiInfo openApiInfo, boolean isSingleGroup, VisitorContext context) {
        String key;
        HashMap<String, String> adocProperties = new HashMap<String, String>();
        adocProperties.put("micronaut.openapi.adoc.template.dir", ConfigUtils.getConfigProperty("micronaut.openapi.adoc.template.dir", context));
        adocProperties.put("micronaut.openapi.adoc.template.filename", ConfigUtils.getConfigProperty("micronaut.openapi.adoc.template.filename", context));
        adocProperties.put("micronaut.openapi.adoc.output.dir", ConfigUtils.getConfigProperty("micronaut.openapi.adoc.output.dir", context));
        adocProperties.put("micronaut.openapi.adoc.output.filename", ConfigUtils.getConfigProperty("micronaut.openapi.adoc.output.filename", context));
        adocProperties.put("micronaut.openapi.adoc.openapi.path", ConfigUtils.getConfigProperty("micronaut.openapi.adoc.openapi.path", context));
        String expandPrefix = "micronaut.openapi.expand.";
        AnnProcessorEnvironment env = (AnnProcessorEnvironment)ConfigUtils.getEnv(context);
        Map propertiesFromEnv = null;
        if (env != null) {
            try {
                propertiesFromEnv = env.getProperties("micronaut.openapi.adoc.templates.".substring(0, "micronaut.openapi.adoc.templates.".length() - 1), null);
            }
            catch (Exception e) {
                ContextUtils.warn("Error:\n" + Utils.printStackTrace(e), context);
            }
        }
        if (CollectionUtils.isNotEmpty(propertiesFromEnv)) {
            for (Map.Entry entry : propertiesFromEnv.entrySet()) {
                adocProperties.put((String)entry.getKey(), entry.getValue().toString());
            }
        }
        Properties openapiProps = ConfigUtils.readOpenApiConfigFile(context);
        for (Map.Entry<Object, Object> entry : openapiProps.entrySet()) {
            key = entry.getKey().toString();
            if (!key.startsWith(expandPrefix)) continue;
            adocProperties.put(key, entry.getValue().toString());
        }
        if (CollectionUtils.isNotEmpty((Map)System.getProperties())) {
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                key = entry.getKey().toString();
                if (!key.startsWith(expandPrefix)) continue;
                adocProperties.put(key, entry.getValue().toString());
            }
        }
        String string = StringUtils.isNotEmpty((CharSequence)openApiInfo.getAdocFilename()) ? openApiInfo.getAdocFilename() : (String)adocProperties.get("micronaut.openapi.adoc.output.filename");
        Pair<String, String> titleAndFilename = FileUtils.calcFinalFilename(openApiInfo.getAdocFilename(), openApiInfo, isSingleGroup, "adoc", context);
        return adocProperties;
    }

    public static boolean isJsonViewEnabled(VisitorContext context) {
        Boolean isJsonViewEnabled = ContextUtils.get("micronaut.internal.jackson.json-view.enabled", Boolean.class, context);
        if (isJsonViewEnabled != null) {
            return isJsonViewEnabled;
        }
        isJsonViewEnabled = ConfigUtils.getBooleanProperty("jackson.json-view.enabled", false, context);
        ContextUtils.put("micronaut.internal.jackson.json-view.enabled", isJsonViewEnabled, context);
        return isJsonViewEnabled;
    }

    public static SecurityProperties getSecurityProperties(VisitorContext context) {
        SecurityProperties securityProperties = ContextUtils.get("micronaut.internal.security.properties", SecurityProperties.class, context);
        if (securityProperties != null) {
            return securityProperties;
        }
        Environment environment = ConfigUtils.getEnv(context);
        List<InterceptUrlMapPattern> interceptUrlMapPatterns = environment != null ? environment.get((CharSequence)"micronaut.security.intercept-url-map", Argument.listOf(InterceptUrlMapPattern.class)).orElse(Collections.emptyList()) : Collections.emptyList();
        String defaultSchemaName = ConfigUtils.getConfigProperty("micronaut.openapi.security.default-schema-name", context);
        if (StringUtils.isEmpty((CharSequence)defaultSchemaName)) {
            defaultSchemaName = DEFAULT_SECURITY_SCHEMA_NAME;
        }
        boolean tokenEnabled = ConfigUtils.getBooleanProperty("micronaut.security.token.enabled", false, context);
        securityProperties = new SecurityProperties(ConfigUtils.getBooleanProperty("micronaut.openapi.security.enabled", true, context), ConfigUtils.getBooleanProperty("micronaut.security.enabled", false, context), defaultSchemaName, interceptUrlMapPatterns, tokenEnabled, ConfigUtils.getBooleanProperty("micronaut.security.token.jwt.enabled", tokenEnabled, context), ConfigUtils.getBooleanProperty("micronaut.security.token.jwt.bearer", tokenEnabled, context), ConfigUtils.getBooleanProperty("micronaut.security.token.jwt.cookie.enabled", false, context), ConfigUtils.getBooleanProperty("micronaut.security.oauth2.enabled", false, context), ConfigUtils.getBooleanProperty("micronaut.security.basic-auth.enabled", false, context));
        ContextUtils.put("micronaut.internal.security.properties", securityProperties, context);
        return securityProperties;
    }

    public static RouterVersioningProperties getRouterVersioningProperties(VisitorContext context) {
        RouterVersioningProperties routerVersioningProperties = ContextUtils.get("micronaut.internal.router.versioning.properties", RouterVersioningProperties.class, context);
        if (routerVersioningProperties != null) {
            return routerVersioningProperties;
        }
        routerVersioningProperties = new RouterVersioningProperties(ConfigUtils.getBooleanProperty("micronaut.openapi.versioning.enabled", true, context), ConfigUtils.getBooleanProperty("micronaut.router.versioning.enabled", false, context), ConfigUtils.getBooleanProperty("micronaut.router.versioning.header.enabled", false, context), ConfigUtils.getListStringsProperty("micronaut.router.versioning.header.names", Collections.singletonList("X-API-VERSION"), context), ConfigUtils.getBooleanProperty("micronaut.router.versioning.parameter.enabled", false, context), ConfigUtils.getListStringsProperty("micronaut.router.versioning.parameter.names", Collections.singletonList("api-version"), context));
        ContextUtils.put("micronaut.internal.router.versioning.properties", routerVersioningProperties, context);
        return routerVersioningProperties;
    }

    public static List<String> getListStringsProperty(String property, List<String> defaultValue, VisitorContext context) {
        String strValue = System.getProperty(property);
        if (StringUtils.isEmpty((CharSequence)strValue)) {
            strValue = ConfigUtils.readOpenApiConfigFile(context).getProperty(property);
        }
        if (StringUtils.isNotEmpty((CharSequence)strValue)) {
            ArrayList<String> result = new ArrayList<String>();
            for (String item : strValue.split(",")) {
                result.add(item.strip());
            }
            return result;
        }
        Environment env = ConfigUtils.getEnv(context);
        if (env != null) {
            return env.get((CharSequence)property, Argument.LIST_OF_STRING).orElse(defaultValue);
        }
        return defaultValue;
    }

    public static GroupProperties getGroupProperties(String groupName, VisitorContext context) {
        if (groupName == null) {
            return null;
        }
        Map<String, GroupProperties> allGroupsProperties = ConfigUtils.getGroupsPropertiesMap(context);
        return CollectionUtils.isNotEmpty(allGroupsProperties) ? allGroupsProperties.get(groupName) : null;
    }

    public static Map<String, GroupProperties> getGroupsPropertiesMap(VisitorContext context) {
        if (context == null) {
            return Collections.emptyMap();
        }
        Map<String, GroupProperties> groupPropertiesMap = ContextUtils.get("micronaut.internal.groups", ContextUtils.ARGUMENT_GROUP_PROPERTIES_MAP, context);
        if (groupPropertiesMap != null) {
            return groupPropertiesMap;
        }
        groupPropertiesMap = new HashMap<String, GroupProperties>();
        Properties sysProps = System.getProperties();
        ConfigUtils.readGroupsProperties(sysProps, groupPropertiesMap, context);
        Properties fileProps = ConfigUtils.readOpenApiConfigFile(context);
        ConfigUtils.readGroupsProperties(fileProps, groupPropertiesMap, context);
        Environment environment = ConfigUtils.getEnv(context);
        if (environment != null) {
            for (Map.Entry entry : environment.getProperties("micronaut.openapi.groups", StringConvention.RAW).entrySet()) {
                String entryKey = (String)entry.getKey();
                String[] propParts = entryKey.split("\\.");
                String propName = propParts[propParts.length - 1];
                String groupName = entryKey.substring(0, entryKey.length() - propName.length() - 1);
                ConfigUtils.setGroupProperty(groupName, propName, entry.getValue(), groupPropertiesMap, context);
            }
        }
        Utils.getAllKnownGroups().addAll(groupPropertiesMap.keySet());
        ContextUtils.put("micronaut.internal.groups", groupPropertiesMap, context);
        return groupPropertiesMap;
    }

    public static EndpointsConfiguration endpointsConfiguration(VisitorContext context) {
        EndpointsConfiguration cfg = ContextUtils.get("micronaut.internal.openapi.endpoints", EndpointsConfiguration.class, context);
        if (cfg != null) {
            return cfg;
        }
        EndpointsConfiguration conf = new EndpointsConfiguration(context, ConfigUtils.readOpenApiConfigFile(context));
        ContextUtils.put("micronaut.internal.openapi.endpoints", conf, context);
        return conf;
    }

    private static void readGroupsProperties(Properties props, Map<String, GroupProperties> groupPropertiesMap, VisitorContext context) {
        for (String prop : props.stringPropertyNames()) {
            int groupNameIndexEnd;
            if (!prop.startsWith("micronaut.openapi.groups") || (groupNameIndexEnd = prop.indexOf(46, "micronaut.openapi.groups".length() + 1)) < 0) continue;
            String groupName = prop.substring("micronaut.openapi.groups".length() + 1, groupNameIndexEnd);
            String propertyName = prop.substring(groupNameIndexEnd + 1);
            String value = props.getProperty(prop);
            ConfigUtils.setGroupProperty(groupName, propertyName, value, groupPropertiesMap, context);
        }
    }

    private static void setGroupProperty(String groupName, String propertyName, Object value, Map<String, GroupProperties> groupPropertiesMap, VisitorContext context) {
        if (value == null) {
            return;
        }
        String valueStr = value.toString();
        GroupProperties groupProperties = groupPropertiesMap.computeIfAbsent(groupName, GroupProperties::new);
        switch (propertyName.toLowerCase()) {
            case "display-name": 
            case "displayname": {
                if (groupProperties.getDisplayName() != null) break;
                groupProperties.setDisplayName(valueStr);
                break;
            }
            case "file-name": 
            case "filename": {
                if (groupProperties.getFilename() != null) break;
                groupProperties.setFilename(valueStr);
                break;
            }
            case "adoc-file-name": 
            case "adocfilename": {
                if (groupProperties.getAdocFilename() != null) break;
                groupProperties.setAdocFilename(valueStr);
                break;
            }
            case "adoc-enabled": 
            case "adocenabled": {
                if (groupProperties.getAdocEnabled() != null) break;
                groupProperties.setAdocEnabled(Boolean.valueOf(valueStr));
                break;
            }
            case "packages": {
                if (groupProperties.getPackages() != null) break;
                ArrayList<GroupProperties.PackageProperties> packages = new ArrayList<GroupProperties.PackageProperties>();
                for (String groupPackage : valueStr.split(",")) {
                    packages.add(ConfigUtils.getPackageProperties(groupPackage));
                }
                groupProperties.setPackages(packages);
                break;
            }
            case "primary": {
                if (groupProperties.getPrimary() != null) break;
                groupProperties.setPrimary(Boolean.valueOf(valueStr));
                break;
            }
            case "commonexclude": 
            case "common-exclude": {
                if (groupProperties.getCommonExclude() != null) break;
                groupProperties.setCommonExclude(Boolean.valueOf(valueStr));
                break;
            }
            case "packagesexclude": 
            case "packages-exclude": {
                if (groupProperties.getPackagesExclude() != null) break;
                ArrayList<GroupProperties.PackageProperties> packagesExclude = new ArrayList<GroupProperties.PackageProperties>();
                for (String groupPackage : valueStr.split(",")) {
                    packagesExclude.add(ConfigUtils.getPackageProperties(groupPackage));
                }
                groupProperties.setPackagesExclude(packagesExclude);
                break;
            }
        }
    }

    private static GroupProperties.PackageProperties getPackageProperties(String groupPackage) {
        boolean includeSubpackages = (groupPackage = groupPackage.strip()).endsWith("*");
        if (includeSubpackages) {
            groupPackage = groupPackage.substring(0, groupPackage.length() - 2);
        }
        if (groupPackage.endsWith(".")) {
            groupPackage = groupPackage.substring(0, groupPackage.length() - 2);
        }
        return new GroupProperties.PackageProperties(groupPackage, includeSubpackages);
    }

    private static void readSchemaDecorators(Properties props, Map<String, SchemaDecorator> schemaDecorators, VisitorContext context) {
        for (String prop : props.stringPropertyNames()) {
            boolean isPrefix = false;
            String packageName = null;
            if (prop.startsWith("micronaut.openapi.schema-prefix")) {
                packageName = prop.substring("micronaut.openapi.schema-prefix".length() + 1);
                isPrefix = true;
            } else if (prop.startsWith("micronaut.openapi.schema-postfix")) {
                packageName = prop.substring("micronaut.openapi.schema-postfix".length() + 1);
            } else if (prop.startsWith("micronaut.openapi.schema.decorator.prefix")) {
                packageName = prop.substring("micronaut.openapi.schema.decorator.prefix".length() + 1);
                isPrefix = true;
            } else if (prop.startsWith("micronaut.openapi.schema.decorator.postfix")) {
                packageName = prop.substring("micronaut.openapi.schema.decorator.postfix".length() + 1);
            }
            if (StringUtils.isEmpty((CharSequence)packageName)) continue;
            SchemaDecorator schemaDecorator = schemaDecorators.computeIfAbsent(packageName, k -> new SchemaDecorator());
            if (isPrefix) {
                schemaDecorator.setPrefix(props.getProperty(prop));
                continue;
            }
            schemaDecorator.setPostfix(props.getProperty(prop));
        }
    }

    private static void readCustomSchemas(Properties props, Map<String, CustomSchema> customSchemas, VisitorContext context) {
        for (String prop : props.stringPropertyNames()) {
            String className;
            if (ConfigUtils.isMicronautProperty(prop)) continue;
            if (prop.startsWith("micronaut.openapi.schema.mapping")) {
                className = prop.substring("micronaut.openapi.schema.mapping".length() + 1);
            } else {
                if (!prop.startsWith("micronaut.openapi.schema")) continue;
                className = prop.substring("micronaut.openapi.schema".length() + 1);
            }
            String targetClassName = props.getProperty(prop);
            ConfigUtils.readCustomSchema(className, targetClassName, customSchemas, context);
        }
    }

    private static void readCustomSchema(String className, String targetClassName, Map<String, CustomSchema> customSchemas, VisitorContext context) {
        if (customSchemas.containsKey(className) || context == null) {
            return;
        }
        ClassElement targetClassElement = ContextUtils.getClassElement(targetClassName, context);
        if (targetClassElement == null) {
            ContextUtils.warn("Can't find class " + targetClassName + " for className " + className + " in classpath. Custom schemas: " + String.valueOf(customSchemas) + ". Skip it.", context);
            return;
        }
        ArrayList<String> configuredTypeArgs = null;
        int genericNameStart = className.indexOf(60);
        if (genericNameStart > 0) {
            String[] generics = className.substring(genericNameStart + 1, className.indexOf(62)).split(",");
            configuredTypeArgs = new ArrayList<String>();
            for (String generic : generics) {
                configuredTypeArgs.add(generic.strip());
            }
        }
        customSchemas.put(className, new CustomSchema(configuredTypeArgs, targetClassElement));
    }

    @Nullable
    public static Path getProjectPath(VisitorContext context) {
        Path projectPath = ContextUtils.get("micronaut.internal.openapi.project.dir", Path.class, context);
        if (projectPath != null) {
            return projectPath;
        }
        String projectDir = ContextUtils.getOptions(context).get("micronaut.openapi.project.dir");
        if (projectDir != null) {
            projectPath = Paths.get(projectDir, new String[0]);
        }
        if (projectPath == null) {
            try {
                if (context != null) {
                    projectPath = context.getProjectDir().orElse(Utils.isTestMode() ? Paths.get(System.getProperty("user.dir"), new String[0]) : null);
                }
                if (projectPath == null && Utils.isTestMode()) {
                    projectPath = Paths.get(System.getProperty("user.dir"), new String[0]);
                }
            }
            catch (Exception e) {
                projectPath = Paths.get(System.getProperty("user.dir"), new String[0]);
            }
        }
        ContextUtils.put("micronaut.internal.openapi.project.dir", projectPath, context);
        return projectPath;
    }

    public static String getConfigProperty(String key, VisitorContext context) {
        Boolean isLoaded;
        if (context != null && (isLoaded = ContextUtils.get(key + LOADED_POSTFIX, Boolean.class, context)) != null) {
            return ContextUtils.get(key + VALUE_POSTFIX, String.class, context);
        }
        String value = OpenApiConfigProperty.ALL.contains(key) && context != null ? ContextUtils.getOptions(context).get(key) : System.getProperty(key);
        if (value == null) {
            value = ConfigUtils.readOpenApiConfigFile(context).getProperty(key);
        }
        if (value != null) {
            return value;
        }
        Environment environment = ConfigUtils.getEnv(context);
        String string = value = environment != null ? (String)environment.get((CharSequence)key, String.class).orElse(null) : null;
        if (context != null) {
            ContextUtils.put(key + LOADED_POSTFIX, true, context);
            if (value != null) {
                ContextUtils.put(key + VALUE_POSTFIX, value, context);
            }
        }
        return value;
    }

    public static List<String> getAdditionalFiles(VisitorContext context) {
        return ConfigUtils.getListStringsProperty("micronaut.openapi.additional.files", null, context);
    }

    public static MergeMode getAdditionalFilesMergeMode(VisitorContext context) {
        String str = ConfigUtils.getConfigProperty("micronaut.openapi.additional.files-merge-mode", context);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return MergeMode.REPLACE;
        }
        try {
            return MergeMode.valueOf(str.toUpperCase());
        }
        catch (Exception e) {
            ContextUtils.warn("Unknown additional files mergeMode value: " + str, context);
            return MergeMode.REPLACE;
        }
    }

    public static boolean getBooleanProperty(String property, boolean defaultValue, VisitorContext context) {
        String str = ConfigUtils.getConfigProperty(property, context);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        return !"false".equalsIgnoreCase(str);
    }

    public static Properties readOpenApiConfigFile(VisitorContext context) {
        String cfgFile;
        Properties props = ContextUtils.get("micronaut.internal.openapi.properties", Properties.class, context);
        if (props != null) {
            return props;
        }
        Properties openApiProperties = new Properties();
        String string = cfgFile = context != null ? ContextUtils.getOptions(context).getOrDefault("micronaut.openapi.config.file", System.getProperty("micronaut.openapi.config.file", "openapi.properties")) : System.getProperty("micronaut.openapi.config.file", "openapi.properties");
        if (StringUtils.isNotEmpty((CharSequence)cfgFile)) {
            Path cfg = FileUtils.resolve(context, Paths.get(cfgFile, new String[0]));
            if (Files.isReadable(cfg)) {
                try (BufferedReader reader = Files.newBufferedReader(cfg);){
                    openApiProperties.load(reader);
                }
                catch (IOException e) {
                    ContextUtils.warn("Fail to read OpenAPI configuration file: " + e.getMessage(), null);
                }
            } else if (Files.exists(cfg, new LinkOption[0])) {
                ContextUtils.warn("Can not read configuration file: " + String.valueOf(cfg), context);
            }
        }
        if (context != null) {
            ContextUtils.put("micronaut.internal.openapi.properties", openApiProperties, context);
        }
        return openApiProperties;
    }

    @Nullable
    public static Environment getEnv(VisitorContext context) {
        if (!ConfigUtils.isEnvEnabled(context)) {
            return null;
        }
        Boolean envCreated = ContextUtils.get("micronaut.internal.environment.created", Boolean.class, context);
        if (envCreated != null && envCreated.booleanValue()) {
            return ContextUtils.get("micronaut.internal.environment", Environment.class, context);
        }
        Environment environment = ConfigUtils.createEnv(context);
        ContextUtils.put("micronaut.internal.environment", environment, context);
        ContextUtils.put("micronaut.internal.environment.created", true, context);
        return environment;
    }

    private static Environment createEnv(final VisitorContext context) {
        ApplicationContextConfiguration configuration = new ApplicationContextConfiguration(){

            public Optional<MutableConversionService> getConversionService() {
                DefaultMutableConversionService conversionService = new DefaultMutableConversionService();
                conversionService.addConverter(Map.class, InterceptUrlMapPattern.class, (TypeConverter)new InterceptUrlMapConverter((ConversionService)conversionService));
                return Optional.of(conversionService);
            }

            public ClassPathResourceLoader getResourceLoader() {
                ClassLoader classLoader = ApplicationContextConfiguration.class.getClassLoader();
                if (classLoader == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                if (classLoader == null) {
                    classLoader = ClassPathResourceLoader.class.getClassLoader();
                }
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                return new DefaultClassPathResourceLoader(classLoader, null, false, false);
            }

            @NonNull
            public List<String> getEnvironments() {
                return ConfigUtils.getActiveEnvs(context);
            }
        };
        AnnProcessorEnvironment environment = null;
        try {
            environment = new AnnProcessorEnvironment(configuration, context);
            environment.start();
            return environment;
        }
        catch (Exception e) {
            ContextUtils.warn("Can't create environment: " + e.getMessage() + ".\n" + Utils.printStackTrace(e), context);
            return environment;
        }
    }

    public static List<String> getActiveEnvs(VisitorContext context) {
        if (!ConfigUtils.isEnvEnabled(context)) {
            return Collections.emptyList();
        }
        String activeEnvStr = System.getProperty("micronaut.openapi.environments", ConfigUtils.readOpenApiConfigFile(context).getProperty("micronaut.openapi.environments"));
        ArrayList<String> activeEnvs = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)activeEnvStr)) {
            for (String activeEnv : activeEnvStr.split(",")) {
                activeEnvs.add(activeEnv.strip());
            }
        }
        return activeEnvs;
    }

    private static boolean isEnvEnabled(VisitorContext context) {
        if (context == null) {
            return true;
        }
        boolean isEnabled = true;
        String isEnabledStr = ContextUtils.getOptions(context).get("micronaut.environment.enabled");
        if (StringUtils.isEmpty((CharSequence)isEnabledStr)) {
            isEnabledStr = ConfigUtils.readOpenApiConfigFile(context).getProperty("micronaut.environment.enabled");
        }
        if (StringUtils.isNotEmpty((CharSequence)isEnabledStr)) {
            isEnabled = Boolean.parseBoolean(isEnabledStr);
        }
        ContextUtils.put("micronaut.environment.enabled", isEnabled, context);
        return isEnabled;
    }

    public static final class SchemaDecorator {
        private String prefix;
        private String postfix;

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getPostfix() {
            return this.postfix;
        }

        public void setPostfix(String postfix) {
            this.postfix = postfix;
        }
    }

    public record CustomSchema(List<String> typeArgs, ClassElement classElement) {
    }

    public static enum DuplicateResolution {
        AUTO,
        ERROR;

    }

    public static enum MergeMode {
        APPEND,
        REPLACE;

    }
}

