/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.view;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.view.AbstractViewConfig;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.view.RapiPDFConfig;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.group.OpenApiInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ScalarConfig
extends AbstractViewConfig {
    public static final String SCALAR_PREFIX = "scalar.";
    private static final String DEFAULT_SCALAR_JS_PATH = "res/";
    private static final List<String> RESOURCE_FILES = List.of("res/standalone.js");
    private static final Map<String, Object> DEFAULT_OPTIONS = new HashMap<String, Object>();
    private static final Map<String, Function<String, Object>> VALID_OPTIONS = new HashMap<String, Function<String, Object>>(61);
    String style = "";
    RapiPDFConfig rapiPDFConfig;

    private ScalarConfig(Map<Pair<String, String>, OpenApiInfo> openApiInfos) {
        super(SCALAR_PREFIX, openApiInfos);
        this.jsUrl = DEFAULT_SCALAR_JS_PATH;
    }

    private String toOptions() {
        return this.options.entrySet().stream().filter(e -> VALID_OPTIONS.containsKey(e.getKey())).sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + ": " + e.getValue()).collect(Collectors.joining(",\n"));
    }

    static ScalarConfig fromProperties(Map<String, String> properties, Map<Pair<String, String>, OpenApiInfo> openApiInfos, VisitorContext context) {
        ScalarConfig cfg = new ScalarConfig(openApiInfos);
        cfg.style = properties.get(cfg.prefix + "style");
        return AbstractViewConfig.fromProperties(cfg, DEFAULT_OPTIONS, properties, OpenApiViewConfig.RendererType.SCALAR, context);
    }

    @Override
    public String render(String template, @Nullable VisitorContext context) {
        template = this.rapiPDFConfig.render(template, OpenApiViewConfig.RendererType.SCALAR, context);
        template = OpenApiViewConfig.replacePlaceHolder(template, "scalar.js.url.prefix", this.isDefaultJsUrl ? this.getFinalUrlPrefix(OpenApiViewConfig.RendererType.SCALAR, context) : this.jsUrl, "");
        template = OpenApiViewConfig.replacePlaceHolder(template, "style", (String)(StringUtils.isNotEmpty((CharSequence)this.style) ? "<style>" + this.style + "</style>" : ""), "");
        return OpenApiViewConfig.replacePlaceHolder(template, "scalar.attributes", this.toOptions(), "");
    }

    @Override
    protected Function<String, Object> getConverter(String key) {
        return VALID_OPTIONS.get(key);
    }

    @Override
    protected List<String> getResources() {
        return RESOURCE_FILES;
    }

    static {
        VALID_OPTIONS.put("customDomain", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("theme", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("isEditable", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("spec", AbstractViewConfig::asString);
        VALID_OPTIONS.put("proxyUrl", AbstractViewConfig::asString);
        VALID_OPTIONS.put("showSidebar", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("hideModels", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("hideDownloadButton", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("hideTestRequestButton", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("hideSearch", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("darkMode", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("forceDarkModeState", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("hideDarkModeToggle", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("customCss", AbstractViewConfig::asString);
        VALID_OPTIONS.put("searchHotKey", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("baseServerURL", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("servers", AbstractViewConfig::asString);
        VALID_OPTIONS.put("metadata", AbstractViewConfig::asString);
        VALID_OPTIONS.put("favicon", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("defaultHttpClient", AbstractViewConfig::asString);
        VALID_OPTIONS.put("hiddenClients", AbstractViewConfig::asString);
        VALID_OPTIONS.put("onSpecUpdate", AbstractViewConfig::asString);
        VALID_OPTIONS.put("authentication", AbstractViewConfig::asString);
        VALID_OPTIONS.put("generateHeadingSlug", AbstractViewConfig::asString);
        VALID_OPTIONS.put("generateModelSlug", AbstractViewConfig::asString);
        VALID_OPTIONS.put("generateTagSlug", AbstractViewConfig::asString);
        VALID_OPTIONS.put("generateOperationSlug", AbstractViewConfig::asString);
        VALID_OPTIONS.put("generateWebhookSlug", AbstractViewConfig::asString);
        VALID_OPTIONS.put("onLoaded", AbstractViewConfig::asString);
        VALID_OPTIONS.put("withDefaultFonts", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("defaultOpenAllTags", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("tagsSorter", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("operationsSorter", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("hideClientButton", AbstractViewConfig::asBoolean);
        DEFAULT_OPTIONS.put("defaultHttpClient", "{targetKey: 'shell', clientKey: 'curl'}");
        DEFAULT_OPTIONS.put("hiddenClients", "['libcurl', 'clj_http', 'httpclient', 'restsharp', 'native', 'http1.1', 'asynchttp', 'okhttp', 'unirest', 'xhr', 'jquery', 'native', 'request', 'unirest', 'ofetch', 'nsurlsession', 'cohttp', 'guzzle', 'http', 'http1', 'http2', 'restmethod', 'python3', 'requests', 'httr', 'native', 'curl', 'httpie', 'wget', 'nsurlsession', 'undici'],");
    }
}

