/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.postprocessors;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.openapi.swagger.core.util.PrimitiveType;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.List;

public class JacksonDiscriminatorPostProcessor {
    public void addMissingDiscriminatorType(OpenAPI openAPI) {
        if (openAPI.getComponents() == null || openAPI.getComponents().getSchemas() == null) {
            return;
        }
        for (Schema schema : openAPI.getComponents().getSchemas().values()) {
            if (schema.getDiscriminator() == null || schema.getDiscriminator().getMapping() == null) continue;
            String discriminatorProperty = schema.getDiscriminator().getPropertyName();
            ArrayList<String> schemasToUpdate = new ArrayList<String>(schema.getDiscriminator().getMapping().values());
            this.addDiscriminatorProperty(openAPI, schemasToUpdate, discriminatorProperty);
        }
    }

    private void addDiscriminatorProperty(OpenAPI openAPI, List<String> schemasToUpdate, @NonNull String discriminatorProperty) {
        for (String s : schemasToUpdate) {
            Schema schema = (Schema)openAPI.getComponents().getSchemas().get(this.extractComponentSchemaName(s));
            if (schema.getProperties() == null || schema.getProperties().containsKey(discriminatorProperty)) continue;
            schema.addProperty(discriminatorProperty, PrimitiveType.STRING.createProperty(Utils.isOpenapi31()));
        }
    }

    private String extractComponentSchemaName(@NonNull String mapping) {
        return mapping.replace("#/components/schemas/", "");
    }
}

