/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.JsonNode;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.format.Format;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.CookieValue;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.Headers;
import io.micronaut.http.annotation.Part;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.annotation.RequestBean;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.annotation.UriMapping;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.http.uri.UriMatchVariable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.OpenApiUtils;
import io.micronaut.openapi.annotation.OpenAPIDecorator;
import io.micronaut.openapi.javadoc.JavadocDescription;
import io.micronaut.openapi.swagger.core.util.PrimitiveType;
import io.micronaut.openapi.visitor.AbstractOpenApiVisitor;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.ElementUtils;
import io.micronaut.openapi.visitor.GeneratorUtils;
import io.micronaut.openapi.visitor.GroupUtils;
import io.micronaut.openapi.visitor.MnParamFormat;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.ParamUtils;
import io.micronaut.openapi.visitor.SchemaDefinitionUtils;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.micronaut.openapi.visitor.SecurityUtils;
import io.micronaut.openapi.visitor.TagUtils;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Webhook;
import io.swagger.v3.oas.annotations.callbacks.Callbacks;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.CookieParameter;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractOpenApiEndpointVisitor
extends AbstractOpenApiVisitor {
    private static final int MAX_SUMMARY_LENGTH = 200;
    protected List<Tag> classTags;
    protected ExternalDocumentation classExternalDocs;

    public void visitClass(ClassElement element, VisitorContext context) {
        if (!ConfigUtils.isOpenApiEnabled(context) || !ConfigUtils.isSpecGenerationEnabled(context)) {
            return;
        }
        if (this.ignore(element, context)) {
            return;
        }
        this.incrementVisitedElements(context);
        SecurityUtils.processSecuritySchemes(element, context);
        this.processTags(element, context);
        this.processExternalDocs(element, context);
        ContextUtils.remove("micronaut.internal.child.path", context);
        if (element.isAnnotationPresent(Controller.class)) {
            element.stringValue(UriMapping.class).ifPresent(url -> ContextUtils.put("micronaut.internal.child.path", url, context));
            String prefix = "";
            String suffix = "";
            boolean addAlways = true;
            AnnotationValue apiDecoratorAnn = element.getDeclaredAnnotation(OpenAPIDecorator.class);
            if (apiDecoratorAnn != null) {
                prefix = apiDecoratorAnn.stringValue().orElse("");
                suffix = apiDecoratorAnn.stringValue("opIdSuffix").orElse("");
                addAlways = apiDecoratorAnn.booleanValue("addAlways").orElse(true);
            }
            ContextUtils.put("micronaut.internal.opId.prefix", prefix, context);
            ContextUtils.put("micronaut.internal.opId.suffix", suffix, context);
            ContextUtils.put("micronaut.internal.opId.suffixes.add.always", addAlways, context);
            ArrayList<ClassElement> superTypes = new ArrayList<ClassElement>();
            Collection parentInterfaces = element.getInterfaces();
            if (element.isInterface() && !parentInterfaces.isEmpty()) {
                for (Object parentInterface : parentInterfaces) {
                    if (ClassUtils.isJavaLangType((String)parentInterface.getName())) continue;
                    superTypes.add((ClassElement)parentInterface);
                }
            } else {
                element.getSuperType().ifPresent(superTypes::add);
            }
            if (CollectionUtils.isNotEmpty(superTypes)) {
                ContextUtils.put("micronaut.internal.is.process.parent", true, context);
                boolean hasSuperMethods = false;
                for (ClassElement superType : superTypes) {
                    if (!CollectionUtils.isNotEmpty((Collection)superType.getMethods())) continue;
                    hasSuperMethods = true;
                    break;
                }
                if (hasSuperMethods) {
                    List methods = element.getEnclosedElements(ElementQuery.ALL_METHODS.onlyInstance());
                    for (MethodElement method : methods) {
                        this.visitMethod(method, context);
                    }
                }
                ContextUtils.remove("micronaut.internal.is.process.parent", context);
            }
            ContextUtils.remove("micronaut.internal.opId.prefix", context);
            ContextUtils.remove("micronaut.internal.opId.suffix", context);
            ContextUtils.remove("micronaut.internal.opId.suffixes.add.always", context);
        }
        ContextUtils.remove("micronaut.internal.child.path", context);
    }

    private void processTags(ClassElement element, VisitorContext context) {
        this.classTags = TagUtils.readTags(element, context);
        List<Tag> userDefinedClassTags = this.getUserDefinedClassTags(element, context);
        if (CollectionUtils.isEmpty(this.classTags)) {
            this.classTags = userDefinedClassTags == null ? Collections.emptyList() : userDefinedClassTags;
        } else if (userDefinedClassTags != null) {
            for (Tag tag : userDefinedClassTags) {
                if (this.containsTag(tag.getName(), this.classTags)) continue;
                this.classTags.add(tag);
            }
        }
        if (CollectionUtils.isEmpty(this.classTags)) {
            this.classTags = TagUtils.generationTags(element, this.getClassDescription(context), context);
        }
    }

    private void processExternalDocs(ClassElement element, VisitorContext context) {
        AnnotationValue externalDocsAnn = element.findAnnotation(io.swagger.v3.oas.annotations.ExternalDocumentation.class).orElse(null);
        if (externalDocsAnn == null) {
            return;
        }
        this.classExternalDocs = SchemaDefinitionUtils.toValue(externalDocsAnn.getAnnotationName(), externalDocsAnn.getValues(), context, ExternalDocumentation.class, null);
    }

    private boolean containsTag(String name, List<Tag> tags) {
        for (Tag tag : tags) {
            if (!name.equals(tag.getName())) continue;
            return true;
        }
        return false;
    }

    protected abstract List<SecurityRequirement> methodSecurityRequirements(MethodElement var1, VisitorContext var2);

    protected abstract List<Server> methodServers(MethodElement var1, VisitorContext var2);

    protected abstract Map<String, Object> operationExtensions(MethodElement var1, VisitorContext var2);

    protected abstract List<Tag> getUserDefinedClassTags(ClassElement var1, VisitorContext var2);

    protected abstract boolean ignore(ClassElement var1, VisitorContext var2);

    protected abstract boolean ignore(MethodElement var1, VisitorContext var2);

    protected abstract HttpMethod httpMethod(MethodElement var1);

    protected abstract List<UriMatchTemplate> uriMatchTemplates(MethodElement var1, VisitorContext var2);

    protected abstract List<io.micronaut.http.MediaType> consumesMediaTypes(MethodElement var1);

    protected abstract List<io.micronaut.http.MediaType> producesMediaTypes(MethodElement var1);

    protected abstract String getClassDescription(VisitorContext var1);

    protected abstract String getMethodDescription(VisitorContext var1);

    public void visitMethod(MethodElement element, VisitorContext context) {
        AnnotationValue webhookValue;
        Pair<String, PathItem> webhookPair;
        if (!ConfigUtils.isOpenApiEnabled(context) || !ConfigUtils.isSpecGenerationEnabled(context)) {
            return;
        }
        if (this.ignore(element, context)) {
            return;
        }
        HttpMethod httpMethod = this.httpMethod(element);
        if (httpMethod == null) {
            return;
        }
        List<UriMatchTemplate> matchTemplates = this.uriMatchTemplates(element, context);
        if (CollectionUtils.isEmpty(matchTemplates)) {
            return;
        }
        this.incrementVisitedElements(context);
        OpenAPI openApi = Utils.resolveOpenApi(context);
        boolean permitsRequestBody = HttpMethod.permitsRequestBody((HttpMethod)httpMethod);
        Map<String, List<PathItem>> pathItemsMap = this.resolvePathItems(context, matchTemplates);
        List<io.micronaut.http.MediaType> consumesMediaTypes = this.consumesMediaTypes(element);
        List<io.micronaut.http.MediaType> producesMediaTypes = this.producesMediaTypes(element);
        ClassElement jsonViewClass = null;
        if (ConfigUtils.isJsonViewEnabled(context)) {
            String jsonViewClassName;
            AnnotationValue jsonViewAnn = element.findAnnotation(JsonView.class).orElse(null);
            if (jsonViewAnn == null) {
                jsonViewAnn = element.getOwningType().findAnnotation(JsonView.class).orElse(null);
            }
            if (jsonViewAnn != null && (jsonViewClassName = (String)jsonViewAnn.stringValue().orElse(null)) != null) {
                jsonViewClass = ContextUtils.getClassElement(jsonViewClassName, context);
            }
        }
        if ((webhookPair = this.readWebhook((AnnotationValue<Webhook>)(webhookValue = element.getAnnotation(Webhook.class)), httpMethod, context)) != null) {
            Utils.resolveWebhooks(openApi).put(webhookPair.getFirst(), webhookPair.getSecond());
        }
        for (Map.Entry<String, List<PathItem>> pathItemEntry : pathItemsMap.entrySet()) {
            List<PathItem> pathItems = pathItemEntry.getValue();
            Map<PathItem, io.swagger.v3.oas.models.Operation> swaggerOperations = this.readOperations(pathItemEntry.getKey(), httpMethod, pathItems, element, context, jsonViewClass);
            for (Map.Entry<PathItem, io.swagger.v3.oas.models.Operation> operationEntry : swaggerOperations.entrySet()) {
                ExternalDocumentation externalDocs;
                io.swagger.v3.oas.models.Operation swaggerOperation = operationEntry.getValue();
                io.swagger.v3.oas.models.Operation existedOperation = null;
                for (Map.Entry pathEntry : openApi.getPaths().entrySet()) {
                    if (!((String)pathEntry.getKey()).equals(pathItemEntry.getKey())) continue;
                    PathItem existedPathItem = (PathItem)pathEntry.getValue();
                    if (httpMethod == HttpMethod.GET) {
                        existedOperation = existedPathItem.getGet();
                        break;
                    }
                    if (httpMethod == HttpMethod.PUT) {
                        existedOperation = existedPathItem.getPut();
                        break;
                    }
                    if (httpMethod == HttpMethod.POST) {
                        existedOperation = existedPathItem.getPost();
                        break;
                    }
                    if (httpMethod == HttpMethod.DELETE) {
                        existedOperation = existedPathItem.getDelete();
                        break;
                    }
                    if (httpMethod == HttpMethod.OPTIONS) {
                        existedOperation = existedPathItem.getOptions();
                        break;
                    }
                    if (httpMethod == HttpMethod.HEAD) {
                        existedOperation = existedPathItem.getHead();
                        break;
                    }
                    if (httpMethod == HttpMethod.PATCH) {
                        existedOperation = existedPathItem.getPatch();
                        break;
                    }
                    if (httpMethod != HttpMethod.TRACE) break;
                    existedOperation = existedPathItem.getTrace();
                    break;
                }
                if ((externalDocs = this.readExternalDocs(element, context)) == null) {
                    externalDocs = this.classExternalDocs;
                }
                if (externalDocs != null) {
                    swaggerOperation.setExternalDocs(externalDocs);
                }
                TagUtils.readTags(element, context, swaggerOperation, this.classTags == null ? Collections.emptyList() : this.classTags, openApi);
                SecurityUtils.readSecurityRequirements(element, httpMethod, pathItemEntry.getKey(), swaggerOperation, this.methodSecurityRequirements(element, context), context);
                this.readApiResponses(element, context, swaggerOperation, jsonViewClass);
                this.readServers(element, context, swaggerOperation);
                this.readExtensions(element, context, swaggerOperation);
                this.readCallbacks(element, context, swaggerOperation, jsonViewClass);
                JavadocDescription javadocDescription = this.getMethodDescription(element, swaggerOperation, context);
                if (ElementUtils.isDeprecated((Element)element)) {
                    swaggerOperation.setDeprecated(Boolean.valueOf(true));
                }
                this.readResponse(element, context, openApi, swaggerOperation, existedOperation, javadocDescription, jsonViewClass);
                boolean isRequestBodySchemaSet = false;
                if (permitsRequestBody) {
                    Pair<RequestBody, Boolean> requestBodyPair = this.readSwaggerRequestBody((Element)element, consumesMediaTypes, context);
                    RequestBody requestBody = null;
                    if (requestBodyPair != null) {
                        requestBody = requestBodyPair.getFirst();
                        isRequestBodySchemaSet = requestBodyPair.getSecond();
                    }
                    if (requestBody != null) {
                        RequestBody currentRequestBody = swaggerOperation.getRequestBody();
                        if (currentRequestBody != null) {
                            swaggerOperation.setRequestBody(SchemaUtils.mergeRequestBody(currentRequestBody, requestBody));
                        } else {
                            swaggerOperation.setRequestBody(requestBody);
                        }
                    }
                }
                SchemaUtils.setOperationOnPathItem(operationEntry.getKey(), httpMethod, swaggerOperation);
                HashMap<String, UriMatchVariable> queryParams = new HashMap<String, UriMatchVariable>();
                HashMap<String, UriMatchVariable> pathVariables = new HashMap<String, UriMatchVariable>();
                for (UriMatchTemplate matchTemplate : matchTemplates) {
                    for (Map.Entry<String, UriMatchVariable> varEntry : this.uriVariables(matchTemplate).entrySet()) {
                        if (pathItemEntry.getKey().contains("{" + varEntry.getKey() + "}")) {
                            pathVariables.put(varEntry.getKey(), varEntry.getValue());
                        }
                        if (!varEntry.getValue().isQuery()) continue;
                        queryParams.put(varEntry.getKey(), varEntry.getValue());
                    }
                    this.processParameterAnnotationInMethod(element, openApi, matchTemplate, httpMethod, swaggerOperation, pathVariables, context);
                }
                ArrayList<TypedElement> extraBodyParameters = new ArrayList<TypedElement>();
                for (io.swagger.v3.oas.models.Operation operation : swaggerOperations.values()) {
                    this.processParameters(element, context, openApi, operation, javadocDescription, permitsRequestBody, pathVariables, queryParams, consumesMediaTypes, extraBodyParameters, httpMethod, matchTemplates, pathItems);
                    this.processExtraBodyParameters(context, httpMethod, openApi, operation, javadocDescription, isRequestBodySchemaSet, consumesMediaTypes, extraBodyParameters);
                    GroupUtils.processMicronautVersionAndGroup(operation, pathItemEntry.getKey(), httpMethod, consumesMediaTypes, producesMediaTypes, element, context);
                    this.addParamsByUriTemplate(pathItemEntry.getKey(), pathVariables, queryParams, swaggerOperation);
                }
                if (webhookPair == null) continue;
                SchemaUtils.mergeOperations(SchemaUtils.getOperationOnPathItem(webhookPair.getSecond(), httpMethod), swaggerOperation);
            }
        }
    }

    private void addParamsByUriTemplate(String path, Map<String, UriMatchVariable> pathVariables, Map<String, UriMatchVariable> queryParams, io.swagger.v3.oas.models.Operation operation) {
        UriMatchVariable pathVar;
        String varName;
        for (Map.Entry<String, UriMatchVariable> entry : pathVariables.entrySet()) {
            varName = entry.getKey();
            pathVar = entry.getValue();
            if (pathVar.isExploded() || !path.contains("{" + varName + "}") || path.contains("${" + varName + "}") || this.isAlreadyAdded(varName, operation)) continue;
            operation.addParametersItem(new io.swagger.v3.oas.models.parameters.Parameter().in(ParameterIn.PATH.toString()).name(varName).required(Boolean.valueOf(true)).schema(PrimitiveType.STRING.createProperty(Utils.isOpenapi31())));
        }
        for (Map.Entry<String, UriMatchVariable> entry : queryParams.entrySet()) {
            varName = entry.getKey();
            pathVar = entry.getValue();
            if (pathVar.isExploded() || this.isAlreadyAdded(varName, operation)) continue;
            operation.addParametersItem(new io.swagger.v3.oas.models.parameters.Parameter().in(ParameterIn.QUERY.toString()).name(varName).schema(PrimitiveType.STRING.createProperty(Utils.isOpenapi31())));
        }
    }

    private boolean isAlreadyAdded(String paramName, io.swagger.v3.oas.models.Operation operation) {
        if (CollectionUtils.isEmpty((Collection)operation.getParameters())) {
            return false;
        }
        for (io.swagger.v3.oas.models.parameters.Parameter param : operation.getParameters()) {
            if (!param.getName().equals(paramName)) continue;
            return true;
        }
        return false;
    }

    private void processExtraBodyParameters(VisitorContext context, HttpMethod httpMethod, OpenAPI openApi, io.swagger.v3.oas.models.Operation swaggerOperation, JavadocDescription javadocDescription, boolean isRequestBodySchemaSet, List<io.micronaut.http.MediaType> consumesMediaTypes, List<TypedElement> extraBodyParameters) {
        RequestBody requestBody = swaggerOperation.getRequestBody();
        if (HttpMethod.permitsRequestBody((HttpMethod)httpMethod) && !extraBodyParameters.isEmpty() && requestBody == null) {
            requestBody = new RequestBody();
            Content content = new Content();
            requestBody.setContent(content);
            requestBody.setRequired(Boolean.valueOf(true));
            swaggerOperation.setRequestBody(requestBody);
            consumesMediaTypes = CollectionUtils.isEmpty(consumesMediaTypes) ? Utils.DEFAULT_MEDIA_TYPES : consumesMediaTypes;
            consumesMediaTypes.forEach(mediaType -> {
                MediaType mt = new MediaType();
                Schema schema = SchemaUtils.createSchema();
                schema.setType("object");
                mt.setSchema(schema);
                content.addMediaType(mediaType.toString(), mt);
            });
        }
        if (requestBody != null && requestBody.getContent() != null && !extraBodyParameters.isEmpty()) {
            requestBody.getContent().forEach((mediaTypeName, mediaType) -> {
                Schema schema = mediaType.getSchema();
                if (schema == null || "string".equals(schema.getType())) {
                    Schema newSchema = SchemaUtils.createSchema();
                    if (schema != null) {
                        newSchema.setNullable(schema.getNullable());
                    }
                    mediaType.setSchema(newSchema);
                    schema = newSchema;
                }
                if (schema.get$ref() != null) {
                    if (isRequestBodySchemaSet) {
                        schema = SchemaUtils.getSchemaByRef(schema, openApi);
                    } else {
                        ComposedSchema composedSchema = SchemaUtils.createComposedSchema();
                        Schema extraBodyParametersSchema = SchemaUtils.createSchema();
                        composedSchema.addAllOfItem(schema);
                        composedSchema.addAllOfItem(extraBodyParametersSchema);
                        schema = extraBodyParametersSchema;
                        mediaType.setSchema((Schema)composedSchema);
                    }
                }
                for (TypedElement parameter : extraBodyParameters) {
                    if (!isRequestBodySchemaSet) {
                        this.processBodyParameter(context, openApi, javadocDescription, Utils.getMediaType(mediaTypeName), schema, parameter);
                    }
                    if (!mediaTypeName.equals("multipart/form-data") || !CollectionUtils.isNotEmpty((Map)schema.getProperties())) continue;
                    for (String prop : schema.getProperties().keySet()) {
                        Encoding encoding;
                        HashMap<String, Encoding> encodings = mediaType.getEncoding();
                        if (encodings == null) {
                            encodings = new HashMap<String, Encoding>();
                            mediaType.setEncoding(encodings);
                        }
                        if ((encoding = (Encoding)encodings.get(prop)) != null) continue;
                        if (ElementUtils.isFileUpload(parameter.getType()) || ElementUtils.isMapOfMultipartFiles(parameter) || ElementUtils.isMapOfListOfMultipartFiles(parameter) || ElementUtils.isIterableOfMultipartFiles(parameter)) {
                            encodings.put(prop, new Encoding().contentType("application/octet-stream").explode(Boolean.valueOf(ElementUtils.isIterableOfMultipartFiles(parameter) || ElementUtils.isMapOfListOfMultipartFiles(parameter))));
                            continue;
                        }
                        if (!ElementUtils.isMapOfStrings(parameter)) continue;
                        encodings.put(parameter.getName(), new Encoding().contentType("text/plain"));
                        schema.getProperties().put(prop, PrimitiveType.STRING.createProperty());
                    }
                }
            });
        }
    }

    private void processParameters(MethodElement element, VisitorContext context, OpenAPI openApi, io.swagger.v3.oas.models.Operation swaggerOperation, JavadocDescription javadocDescription, boolean permitsRequestBody, Map<String, UriMatchVariable> pathVariables, Map<String, UriMatchVariable> queryParams, List<io.micronaut.http.MediaType> consumesMediaTypes, List<TypedElement> extraBodyParameters, HttpMethod httpMethod, List<UriMatchTemplate> matchTemplates, List<PathItem> pathItems) {
        if (ArrayUtils.isEmpty((Object[])element.getParameters())) {
            return;
        }
        ArrayList<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters = swaggerOperation.getParameters();
        if (CollectionUtils.isEmpty((Collection)swaggerParameters)) {
            swaggerParameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
        }
        for (ParameterElement parameter : element.getParameters()) {
            if (this.alreadyProcessedParameter(swaggerParameters, parameter)) continue;
            this.processParameter(context, openApi, swaggerOperation, javadocDescription, permitsRequestBody, pathVariables, queryParams, consumesMediaTypes, swaggerParameters, (TypedElement)parameter, extraBodyParameters, httpMethod, matchTemplates, pathItems);
        }
        if (CollectionUtils.isNotEmpty(swaggerParameters)) {
            swaggerOperation.setParameters(swaggerParameters);
        }
    }

    private boolean alreadyProcessedParameter(List<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters, ParameterElement parameter) {
        if (CollectionUtils.isEmpty(swaggerParameters)) {
            return false;
        }
        for (io.swagger.v3.oas.models.parameters.Parameter param : swaggerParameters) {
            if (!param.getName().equals(parameter.getName()) || param.getIn() == null) continue;
            return true;
        }
        return false;
    }

    private Map<String, Example> readExamples(List<AnnotationValue<ExampleObject>> exampleAnns, Element element, VisitorContext context) {
        if (CollectionUtils.isEmpty(exampleAnns)) {
            return null;
        }
        HashMap<String, Example> result = new HashMap<String, Example>();
        for (AnnotationValue<ExampleObject> exampleAnn : exampleAnns) {
            try {
                Map<CharSequence, Object> exampleMap = SchemaDefinitionUtils.toValueMap(exampleAnn.getAnnotationName(), exampleAnn.getValues(), context, null);
                result.put((String)exampleMap.get("name"), (Example)Utils.getJsonMapper().convertValue(exampleMap, Example.class));
            }
            catch (Exception e) {
                ContextUtils.warn("Error reading Parameter example " + exampleAnn + " for element [" + element + "]: " + e.getMessage(), context, element);
            }
        }
        return !result.isEmpty() ? result : null;
    }

    private void processParameterAnnotationInMethod(MethodElement element, OpenAPI openApi, UriMatchTemplate matchTemplate, HttpMethod httpMethod, io.swagger.v3.oas.models.Operation operation, Map<String, UriMatchVariable> pathVariables, VisitorContext context) {
        List parameterAnns = element.getDeclaredAnnotationValuesByType(Parameter.class);
        for (AnnotationValue paramAnn : parameterAnns) {
            if (((Boolean)paramAnn.get((CharSequence)"hidden", Boolean.class, (Object)false)).booleanValue()) continue;
            io.swagger.v3.oas.models.parameters.Parameter parameter = new io.swagger.v3.oas.models.parameters.Parameter();
            parameter.schema(SchemaUtils.createSchema());
            paramAnn.stringValue("name").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).name(arg_0));
            paramAnn.enumValue("in", ParameterIn.class).ifPresent(in -> parameter.in(in.toString()));
            paramAnn.stringValue("description").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).description(arg_0));
            paramAnn.booleanValue("required").ifPresent(value -> parameter.setRequired(value != false ? Boolean.valueOf(true) : null));
            paramAnn.booleanValue("deprecated").ifPresent(value -> parameter.setDeprecated(value != false ? Boolean.valueOf(true) : null));
            paramAnn.booleanValue("allowEmptyValue").ifPresent(value -> parameter.setAllowEmptyValue(value != false ? Boolean.valueOf(true) : null));
            paramAnn.booleanValue("allowReserved").ifPresent(value -> parameter.setAllowReserved(value != false ? Boolean.valueOf(true) : null));
            paramAnn.stringValue("example").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).example(arg_0));
            paramAnn.stringValue("ref").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).$ref(arg_0));
            paramAnn.enumValue("style", ParameterStyle.class).ifPresent(style -> parameter.setStyle(ParamUtils.paramStyle(style, parameter.getIn())));
            Map<String, Example> examples = this.readExamples(paramAnn.getAnnotations("examples", ExampleObject.class), (Element)element, context);
            if (examples != null) {
                examples.forEach((arg_0, arg_1) -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).addExample(arg_0, arg_1));
            }
            if (parameter.getIn() == null) {
                for (ParameterElement paramEl : element.getParameters()) {
                    if (!paramEl.getName().equals(parameter.getName())) continue;
                    if (paramEl.isAnnotationPresent(PathVariable.class)) {
                        parameter.setIn(ParameterIn.PATH.toString());
                        continue;
                    }
                    if (paramEl.isAnnotationPresent(QueryValue.class)) {
                        parameter.setIn(ParameterIn.QUERY.toString());
                        continue;
                    }
                    if (paramEl.isAnnotationPresent(CookieValue.class)) {
                        parameter.setIn(ParameterIn.COOKIE.toString());
                        continue;
                    }
                    if (paramEl.isAnnotationPresent(Header.class)) {
                        parameter.setIn(ParameterIn.HEADER.toString());
                        continue;
                    }
                    UriMatchVariable pathVariable = pathVariables.get(parameter.getName());
                    if (pathVariable == null) {
                        UriMatchVariable variable;
                        Iterator iterator = matchTemplate.getVariables().iterator();
                        while (iterator.hasNext() && (!(variable = (UriMatchVariable)iterator.next()).getName().equals(parameter.getName()) || !variable.isOptional() || variable.isQuery() || variable.isExploded())) {
                        }
                    }
                    if (!(pathVariable == null || pathVariable.isOptional() || pathVariable.isQuery() || pathVariable.isExploded())) {
                        parameter.setIn(ParameterIn.PATH.toString());
                    }
                    if (parameter.getIn() != null || httpMethod != HttpMethod.GET) continue;
                    parameter.setIn(ParameterIn.QUERY.toString());
                }
            }
            operation.addParametersItem(parameter);
            PathItem pathItem = (PathItem)openApi.getPaths().get((Object)matchTemplate.toPathString());
            SchemaUtils.setOperationOnPathItem(pathItem, httpMethod, operation);
        }
    }

    private void processParameter(VisitorContext context, OpenAPI openApi, io.swagger.v3.oas.models.Operation swaggerOperation, JavadocDescription javadocDescription, boolean permitsRequestBody, Map<String, UriMatchVariable> pathVariables, Map<String, UriMatchVariable> queryParams, List<io.micronaut.http.MediaType> consumesMediaTypes, List<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters, TypedElement parameter, List<TypedElement> extraBodyParameters, HttpMethod httpMethod, List<UriMatchTemplate> matchTemplates, List<PathItem> pathItems) {
        Pair<RequestBody, Boolean> requestBodyPair;
        ClassElement parameterType = parameter.getGenericType();
        if (ElementUtils.isIgnoredParameter(parameter)) {
            return;
        }
        boolean hasSwaggerRequestBodyImpl = false;
        if (permitsRequestBody && swaggerOperation.getRequestBody() == null && (requestBodyPair = this.readSwaggerRequestBody((Element)parameter, consumesMediaTypes, context)) != null) {
            if (requestBodyPair.getFirst() != null) {
                swaggerOperation.setRequestBody(requestBodyPair.getFirst());
            }
            hasSwaggerRequestBodyImpl = requestBodyPair.getSecond();
        }
        List<io.micronaut.http.MediaType> list = consumesMediaTypes = CollectionUtils.isNotEmpty(consumesMediaTypes) ? consumesMediaTypes : Utils.DEFAULT_MEDIA_TYPES;
        if (parameter.isAnnotationPresent(Body.class) && !hasSwaggerRequestBodyImpl) {
            this.processBody(context, openApi, swaggerOperation, javadocDescription, permitsRequestBody, consumesMediaTypes, parameter, parameterType);
            return;
        }
        if (parameter.isAnnotationPresent(RequestBean.class)) {
            this.processRequestBean(context, openApi, swaggerOperation, javadocDescription, permitsRequestBody, pathVariables, queryParams, consumesMediaTypes, swaggerParameters, parameter, extraBodyParameters, httpMethod, matchTemplates, pathItems);
            return;
        }
        io.swagger.v3.oas.models.parameters.Parameter newParameter = this.processMethodParameterAnnotation(context, swaggerOperation, permitsRequestBody, pathVariables, queryParams, parameter, extraBodyParameters, httpMethod, matchTemplates);
        if (newParameter == null) {
            return;
        }
        if (newParameter.get$ref() != null) {
            this.addSwaggerParameter(newParameter, swaggerParameters);
            return;
        }
        if (newParameter.getExplode() != null && newParameter.getExplode().booleanValue() && "query".equals(newParameter.getIn()) && !parameterType.isIterable()) {
            Schema<?> explodedSchema = SchemaDefinitionUtils.resolveSchema(openApi, (Element)parameter, parameterType, context, consumesMediaTypes, null, null, null, null);
            if (explodedSchema != null) {
                if (openApi.getComponents() != null && openApi.getComponents().getSchemas() != null && StringUtils.isNotEmpty((CharSequence)explodedSchema.get$ref())) {
                    explodedSchema = SchemaUtils.getSchemaByRef(explodedSchema, openApi);
                }
                if (CollectionUtils.isNotEmpty((Map)explodedSchema.getProperties())) {
                    Map props = explodedSchema.getProperties();
                    for (Map.Entry entry : props.entrySet()) {
                        QueryParameter unwrappedParameter = new QueryParameter();
                        if (CollectionUtils.isNotEmpty((Collection)explodedSchema.getRequired()) && explodedSchema.getRequired().contains(entry.getKey())) {
                            unwrappedParameter.setRequired(Boolean.valueOf(true));
                        }
                        unwrappedParameter.setName((String)entry.getKey());
                        unwrappedParameter.setSchema((Schema)entry.getValue());
                        this.addSwaggerParameter((io.swagger.v3.oas.models.parameters.Parameter)unwrappedParameter, swaggerParameters);
                    }
                }
            }
        } else {
            CharSequence desc;
            if (StringUtils.isEmpty((CharSequence)newParameter.getName())) {
                newParameter.setName(parameter.getName());
            }
            if (!(newParameter.getRequired() != null || ElementUtils.isNullable(parameter) && !ElementUtils.isNotNullable((Element)parameter) || ContextUtils.get("micronaut.internal.endpoint.is-prometheus", Boolean.class, Boolean.valueOf(false), context).booleanValue() && "query".equalsIgnoreCase(newParameter.getIn()))) {
                newParameter.setRequired(Boolean.valueOf(true));
            }
            if (javadocDescription != null && StringUtils.isEmpty((CharSequence)newParameter.getDescription()) && (desc = (CharSequence)javadocDescription.getParameters().get(parameter.getName())) != null) {
                newParameter.setDescription(desc.toString());
            }
            this.addSwaggerParameter(newParameter, swaggerParameters);
            Schema<?> schema = newParameter.getSchema();
            if (schema == null) {
                schema = SchemaDefinitionUtils.resolveSchema(openApi, (Element)parameter, parameterType, context, consumesMediaTypes, null, null, null, null);
            }
            if (schema != null) {
                schema = SchemaDefinitionUtils.bindSchemaForElement(context, parameter, parameterType, schema, null, false);
                newParameter.setSchema(schema);
            }
        }
    }

    private void addSwaggerParameter(io.swagger.v3.oas.models.parameters.Parameter newParameter, List<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters) {
        if (newParameter.get$ref() != null) {
            swaggerParameters.add(newParameter);
            return;
        }
        for (io.swagger.v3.oas.models.parameters.Parameter swaggerParameter : swaggerParameters) {
            if (!newParameter.getName().equals(swaggerParameter.getName())) continue;
            return;
        }
        swaggerParameters.add(newParameter);
    }

    private void processBodyParameter(VisitorContext context, OpenAPI openApi, JavadocDescription javadocDescription, io.micronaut.http.MediaType mediaType, Schema schema, TypedElement parameter) {
        String doc;
        ClassElement jsonViewClass = ElementUtils.getJsonViewClass((Element)parameter, context);
        Schema propertySchema = SchemaDefinitionUtils.resolveSchema(openApi, (Element)parameter, parameter.getType(), context, Collections.singletonList(mediaType), jsonViewClass, null, null, null);
        if (propertySchema == null) {
            return;
        }
        if (ElementUtils.isMapOfMultipartFiles(parameter) || ElementUtils.isMapOfListOfMultipartFiles(parameter)) {
            propertySchema = (Schema)propertySchema.getAdditionalProperties();
        }
        parameter.stringValue(Parameter.class, "description").ifPresent(arg_0 -> ((Schema)propertySchema).setDescription(arg_0));
        SchemaDefinitionUtils.processSchemaProperty(context, parameter, parameter.getType(), null, schema, propertySchema);
        if (ElementUtils.isNullable(parameter) && !ElementUtils.isNotNullable((Element)parameter)) {
            SchemaUtils.setNullable(propertySchema);
        }
        if (javadocDescription != null && StringUtils.isEmpty((CharSequence)propertySchema.getDescription()) && (doc = javadocDescription.getParameters().get(parameter.getName())) != null) {
            propertySchema.setDescription(doc);
        }
    }

    private io.swagger.v3.oas.models.parameters.Parameter processMethodParameterAnnotation(VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation, boolean permitsRequestBody, Map<String, UriMatchVariable> pathVariables, Map<String, UriMatchVariable> queryParams, TypedElement parameter, List<TypedElement> extraBodyParameters, HttpMethod httpMethod, List<UriMatchTemplate> matchTemplates) {
        boolean isBodyParameter = false;
        QueryParameter newParameter = null;
        String parameterName = parameter.getName();
        if (!parameter.hasStereotype(Bindable.class) && pathVariables.containsKey(parameterName)) {
            UriMatchVariable urlVar = pathVariables.get(parameterName);
            newParameter = urlVar.isQuery() ? new QueryParameter() : new PathParameter();
            newParameter.setName(parameterName);
            boolean exploded = urlVar.isExploded();
            if (exploded) {
                newParameter.setExplode(Boolean.valueOf(exploded));
            }
        } else if (parameter.isAnnotationPresent(PathVariable.class)) {
            UriMatchVariable variable;
            String paramName = parameter.getValue(PathVariable.class, String.class).orElse(parameterName);
            if (paramName.isEmpty()) {
                paramName = parameterName;
            }
            if ((variable = pathVariables.get(paramName)) == null) {
                if (!ElementUtils.isNullable(parameter)) {
                    ContextUtils.warn("Path variable name: '" + paramName + "' not found in path, operation: " + swaggerOperation.getOperationId(), context, (Element)parameter);
                }
                return null;
            }
            newParameter = new PathParameter();
            newParameter.setName(paramName);
            boolean exploded = variable.isExploded();
            if (exploded) {
                newParameter.setExplode(Boolean.valueOf(true));
            }
        } else if (parameter.isAnnotationPresent(Header.class)) {
            String headerName = ParamUtils.getHeaderName(parameter, parameterName);
            if (headerName == null) {
                return null;
            }
            newParameter = new HeaderParameter();
            newParameter.setName(headerName);
        } else if (parameter.isAnnotationPresent(Headers.class)) {
            List headerAnns = parameter.getAnnotationValuesByType(Header.class);
            if (CollectionUtils.isNotEmpty((Collection)headerAnns)) {
                String headerName = ParamUtils.getHeaderName(parameter, parameterName);
                if (headerName == null) {
                    return null;
                }
                newParameter = new HeaderParameter();
                newParameter.setName(headerName);
            }
        } else if (parameter.isAnnotationPresent(CookieValue.class)) {
            String cookieName = parameter.stringValue(CookieValue.class).orElse(parameterName);
            newParameter = new CookieParameter();
            newParameter.setName(cookieName);
        } else if (parameter.isAnnotationPresent(QueryValue.class)) {
            boolean isExtraBodyParam = false;
            if (ElementUtils.isMapOfMultipartFiles(parameter) || ElementUtils.isMapOfListOfMultipartFiles(parameter) || ElementUtils.isIterableOfMultipartFiles(parameter)) {
                extraBodyParameters.add(parameter);
                isExtraBodyParam = true;
            } else if (ElementUtils.isMapOfStrings(parameter)) {
                String paramIn;
                AnnotationValue parameterAnn = parameter.getAnnotation(Parameter.class);
                String string = paramIn = parameterAnn != null ? (String)parameterAnn.stringValue("in").orElse(null) : null;
                if (paramIn != null) {
                    return null;
                }
                extraBodyParameters.add(parameter);
                isExtraBodyParam = true;
            }
            if (!isExtraBodyParam) {
                String queryVar = parameter.stringValue(QueryValue.class).orElse(parameterName);
                newParameter = new QueryParameter();
                newParameter.setName(queryVar);
            }
        } else if (parameter.isAnnotationPresent(Part.class) && permitsRequestBody) {
            extraBodyParameters.add(parameter);
            isBodyParameter = true;
        } else if (parameter.hasAnnotation("io.micronaut.management.endpoint.annotation.Selector")) {
            newParameter = new PathParameter();
            newParameter.setName(parameterName);
        } else if (ElementUtils.hasNoBindingAnnotationOrType(parameter)) {
            String paramIn;
            AnnotationValue parameterAnn = parameter.getAnnotation(Parameter.class);
            String string = paramIn = parameterAnn != null ? (String)parameterAnn.stringValue("in").orElse(null) : null;
            if (parameterAnn == null || !parameterAnn.booleanValue("hidden").orElse(false).booleanValue() && (paramIn == null || paramIn.equals(ParameterIn.DEFAULT.toString()))) {
                if (ElementUtils.isExtraBodyParameter(parameter, permitsRequestBody, matchTemplates, pathVariables, queryParams)) {
                    extraBodyParameters.add(parameter);
                    isBodyParameter = true;
                } else {
                    UriMatchVariable pathVariable = pathVariables.get(parameterName);
                    boolean isExploded = false;
                    if (pathVariable == null) {
                        block4: for (UriMatchTemplate uriMatchTemplate : matchTemplates) {
                            for (UriMatchVariable variable : uriMatchTemplate.getVariables()) {
                                if (!variable.getName().equals(parameterName)) continue;
                                isExploded = variable.isExploded();
                                if (!variable.isOptional() || variable.isQuery() || isExploded) continue block4;
                                return null;
                            }
                        }
                    }
                    if (pathVariable != null && !pathVariable.isOptional() && !pathVariable.isQuery()) {
                        newParameter = new PathParameter();
                        newParameter.setName(parameterName);
                        if (pathVariable.isExploded()) {
                            newParameter.setExplode(Boolean.valueOf(true));
                        }
                    }
                    if (newParameter == null && httpMethod == HttpMethod.GET) {
                        newParameter = new QueryParameter();
                        newParameter.setName(parameterName);
                    }
                    if (newParameter != null && isExploded) {
                        newParameter.setExplode(Boolean.valueOf(true));
                    }
                }
            }
        }
        if (isBodyParameter) {
            return null;
        }
        AnnotationValue paramAnn = parameter.findAnnotation(Parameter.class).orElse(null);
        if (paramAnn != null) {
            if (((Boolean)paramAnn.get((CharSequence)"hidden", Boolean.class, (Object)false)).booleanValue()) {
                return null;
            }
            Map<CharSequence, Object> paramValues = SchemaDefinitionUtils.toValueMap(paramAnn.getAnnotationName(), paramAnn.getValues(), context, null);
            Utils.normalizeEnumValues(paramValues, Collections.singletonMap("in", ParameterIn.class));
            if (parameter.isAnnotationPresent(Header.class)) {
                paramValues.put("in", ParameterIn.HEADER.toString());
            } else if (parameter.isAnnotationPresent(CookieValue.class)) {
                paramValues.put("in", ParameterIn.COOKIE.toString());
            } else if (parameter.isAnnotationPresent(QueryValue.class)) {
                paramValues.put("in", ParameterIn.QUERY.toString());
            }
            this.processExplode((AnnotationValue<Parameter>)paramAnn, paramValues);
            JsonNode jsonNode = Utils.getJsonMapper().valueToTree(paramValues);
            if (newParameter == null) {
                try {
                    JsonNode schemaNode;
                    newParameter = ConvertUtils.treeToValue(jsonNode, io.swagger.v3.oas.models.parameters.Parameter.class, context);
                    if (jsonNode.has("schema") && (schemaNode = jsonNode.get("schema")).has("$ref")) {
                        if (newParameter == null) {
                            newParameter = new io.swagger.v3.oas.models.parameters.Parameter();
                        }
                        newParameter.schema(SchemaUtils.createSchema().$ref(schemaNode.get("$ref").asText()));
                    }
                }
                catch (Exception e) {
                    ContextUtils.warn("Error reading Swagger Parameter for element [" + parameter + "]: " + e.getMessage(), context, (Element)parameter);
                }
            } else {
                try {
                    io.swagger.v3.oas.models.parameters.Parameter v = ConvertUtils.treeToValue(jsonNode, io.swagger.v3.oas.models.parameters.Parameter.class, context);
                    if (v == null) {
                        Map target = (Map)OpenApiUtils.getConvertJsonMapper().convertValue((Object)newParameter, ConvertUtils.MAP_TYPE);
                        for (CharSequence name : paramValues.keySet()) {
                            Object o = paramValues.get(name.toString());
                            if (o == null) continue;
                            target.put(name.toString(), o);
                        }
                        newParameter = (io.swagger.v3.oas.models.parameters.Parameter)OpenApiUtils.getConvertJsonMapper().convertValue((Object)target, io.swagger.v3.oas.models.parameters.Parameter.class);
                    } else {
                        BeanMap beanMap = BeanMap.of((Object)v);
                        Map map = (Map)OpenApiUtils.getConvertJsonMapper().convertValue((Object)newParameter, ConvertUtils.MAP_TYPE);
                        for (CharSequence name : beanMap.keySet()) {
                            Object o = beanMap.get((Object)name.toString());
                            if (o == null) continue;
                            map.put(name.toString(), o);
                        }
                        newParameter = (io.swagger.v3.oas.models.parameters.Parameter)OpenApiUtils.getConvertJsonMapper().convertValue((Object)map, io.swagger.v3.oas.models.parameters.Parameter.class);
                    }
                }
                catch (IOException e) {
                    ContextUtils.warn("Error reading Swagger Parameter for element [" + parameter + "]: " + e.getMessage(), context, (Element)parameter);
                }
            }
            if (newParameter != null && newParameter.get$ref() != null) {
                return newParameter;
            }
            if (newParameter != null) {
                Schema parameterSchema = newParameter.getSchema();
                if (paramAnn.contains("schema") && parameterSchema != null) {
                    paramAnn.get((CharSequence)"schema", AnnotationValue.class).ifPresent(schemaAnn -> SchemaDefinitionUtils.bindSchemaAnnotationValue(context, parameter, parameterSchema, (AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaAnn, null));
                }
            }
        }
        if (newParameter != null && ElementUtils.isNullable(parameter) && !ElementUtils.isNotNullable((Element)parameter)) {
            newParameter.setRequired(null);
        }
        if (newParameter != null && ElementUtils.isDeprecated((Element)parameter)) {
            newParameter.setDeprecated(Boolean.valueOf(true));
            GeneratorUtils.addParameterDeprecatedExtension(parameter, (io.swagger.v3.oas.models.parameters.Parameter)newParameter, context);
        }
        if (newParameter != null) {
            String mnFormatValue = parameter.stringValue(Format.class, "value").orElse(null);
            Parameter.StyleEnum style = ParamUtils.paramStyleByFormat(mnFormatValue, newParameter.getIn());
            if ("query".equalsIgnoreCase(newParameter.getIn()) && (mnFormatValue == null || MnParamFormat.getByName(mnFormatValue) == MnParamFormat.CSV) && newParameter.getExplode() == null) {
                newParameter.setExplode(Boolean.valueOf(false));
            }
            if (style != null && newParameter.getStyle() == null) {
                newParameter.setStyle(style);
            }
        }
        return newParameter;
    }

    private void processBody(VisitorContext context, OpenAPI openApi, io.swagger.v3.oas.models.Operation swaggerOperation, JavadocDescription javadocDescription, boolean permitsRequestBody, List<io.micronaut.http.MediaType> consumesMediaTypes, TypedElement parameter, ClassElement parameterType) {
        Content content;
        CharSequence desc;
        ClassElement jsonViewClass = ElementUtils.getJsonViewClass((Element)parameter, context);
        if (!permitsRequestBody) {
            return;
        }
        RequestBody requestBody = swaggerOperation.getRequestBody();
        if (requestBody == null) {
            requestBody = new RequestBody();
            swaggerOperation.setRequestBody(requestBody);
        }
        if (requestBody.getDescription() == null && javadocDescription != null && (desc = (CharSequence)javadocDescription.getParameters().get(parameter.getName())) != null && !desc.isEmpty()) {
            requestBody.setDescription(desc.toString());
        }
        if (requestBody.getRequired() == null && (!ElementUtils.isNullable((TypedElement)parameterType) || ElementUtils.isNotNullable((Element)parameterType))) {
            requestBody.setRequired(Boolean.valueOf(true));
        }
        if ((content = requestBody.getContent()) == null) {
            content = new Content();
            requestBody.setContent(content);
        }
        boolean isWrappedBodyParam = ElementUtils.isWrappedBodyParameter(parameter);
        AnnotationValue bodyAnn = parameter.getAnnotation(Body.class);
        String wrappedSchemaPropertyName = bodyAnn != null ? (String)bodyAnn.getValue(String.class).orElse(null) : null;
        for (io.micronaut.http.MediaType mediaType : consumesMediaTypes) {
            MediaType mt = (MediaType)content.get((Object)mediaType.toString());
            if (mt == null) {
                mt = new MediaType();
                content.addMediaType(mediaType.toString(), mt);
            }
            if (isWrappedBodyParam && wrappedSchemaPropertyName != null) {
                Schema wrapperSchema = mt.getSchema();
                if (wrapperSchema == null) {
                    wrapperSchema = SchemaUtils.createSchema();
                    mt.setSchema(wrapperSchema);
                }
                wrapperSchema.setType("object");
                if (ElementUtils.isNotNullable((Element)parameter)) {
                    wrapperSchema.addRequiredItem(wrappedSchemaPropertyName);
                }
                this.processBodyParameter(context, openApi, javadocDescription, mediaType, wrapperSchema, parameter);
                continue;
            }
            boolean needSetSchema = true;
            Schema<?> paramSchema = SchemaDefinitionUtils.resolveSchema(openApi, (Element)parameter, parameterType, context, Collections.singletonList(mediaType), jsonViewClass, null, null, null);
            if (mt.getSchema() != null) {
                if (mt.getSchema().get$ref() != null || CollectionUtils.isNotEmpty((Collection)mt.getSchema().getAnyOf()) || CollectionUtils.isNotEmpty((Collection)mt.getSchema().getAllOf()) || CollectionUtils.isNotEmpty((Collection)mt.getSchema().getOneOf())) {
                    needSetSchema = false;
                } else {
                    SchemaUtils.appendSchema(paramSchema, mt.getSchema());
                }
            }
            if (!needSetSchema) continue;
            mt.setSchema(paramSchema);
        }
        for (Map.Entry entry : content.entrySet()) {
            MediaType mediaType = (MediaType)entry.getValue();
            MediaType existedMediaType = (MediaType)content.get(entry.getKey());
            if (existedMediaType == null) {
                content.put((Object)((String)entry.getKey()), (Object)mediaType);
                continue;
            }
            if (existedMediaType.getSchema() == null) {
                existedMediaType.setSchema(mediaType.getSchema());
            }
            if (existedMediaType.getEncoding() == null) {
                existedMediaType.setEncoding(mediaType.getEncoding());
            }
            if (existedMediaType.getExtensions() == null) {
                existedMediaType.setExtensions(mediaType.getExtensions());
            }
            if (existedMediaType.getExamples() == null) {
                existedMediaType.setExamples(mediaType.getExamples());
            }
            if (existedMediaType.getExample() != null || !mediaType.getExampleSetFlag()) continue;
            existedMediaType.setExample(mediaType.getExample());
        }
    }

    private void processRequestBean(VisitorContext context, OpenAPI openApi, io.swagger.v3.oas.models.Operation swaggerOperation, JavadocDescription javadocDescription, boolean permitsRequestBody, Map<String, UriMatchVariable> pathVariables, Map<String, UriMatchVariable> queryParams, List<io.micronaut.http.MediaType> consumesMediaTypes, List<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters, TypedElement parameter, List<TypedElement> extraBodyParameters, HttpMethod httpMethod, List<UriMatchTemplate> matchTemplates, List<PathItem> pathItems) {
        for (FieldElement field : parameter.getType().getFields()) {
            if (field.isStatic()) continue;
            this.processParameter(context, openApi, swaggerOperation, javadocDescription, permitsRequestBody, pathVariables, queryParams, consumesMediaTypes, swaggerParameters, (TypedElement)field, extraBodyParameters, httpMethod, matchTemplates, pathItems);
        }
    }

    private void readResponse(MethodElement element, VisitorContext context, OpenAPI openApi, io.swagger.v3.oas.models.Operation swaggerOperation, io.swagger.v3.oas.models.Operation existedOperation, JavadocDescription javadocDescription, @Nullable ClassElement jsonViewClass) {
        boolean responseStatusNotSetOrSetByAnnotation;
        boolean withMethodResponses = element.hasDeclaredAnnotation(ApiResponses.class) || element.hasDeclaredAnnotation(io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        boolean isSuccessfulFromCode = ConfigUtils.isResponseReadSuccessfulFromCode(context);
        io.swagger.v3.oas.models.responses.ApiResponses existedResponses = existedOperation != null ? existedOperation.getResponses() : null;
        io.swagger.v3.oas.models.responses.ApiResponses responses = swaggerOperation.getResponses();
        HttpStatus methodResponseStatus = element.enumValue(Status.class, HttpStatus.class).orElse(null);
        boolean bl = responseStatusNotSetOrSetByAnnotation = element.hasAnnotation(Status.class) || methodResponseStatus == null;
        if (methodResponseStatus == null) {
            methodResponseStatus = HttpStatus.OK;
        } else if (existedResponses != null && existedResponses.getExtensions() != null && existedResponses.getExtensions().containsKey("x-micronaut-parent-response")) {
            existedOperation.setResponses(null);
        }
        String responseCode = Integer.toString(methodResponseStatus.getCode());
        ApiResponse response = null;
        boolean responseFromCode = isSuccessfulFromCode;
        if (responses == null) {
            responses = new io.swagger.v3.oas.models.responses.ApiResponses();
            swaggerOperation.setResponses(responses);
        } else {
            ApiResponse defaultResponse = (ApiResponse)responses.remove((Object)"default");
            response = (ApiResponse)responses.get((Object)responseCode);
            if (response == null && defaultResponse != null) {
                response = defaultResponse;
                responses.put((Object)responseCode, (Object)response);
            }
            boolean isResponseSetInAnnotation = false;
            for (String responseCodeFromAnn : responses.keySet()) {
                if (!responseCodeFromAnn.startsWith("2") && !responseCodeFromAnn.startsWith("3")) continue;
                isResponseSetInAnnotation = true;
                break;
            }
            if (response != null || isResponseSetInAnnotation) {
                responseFromCode = false;
            }
        }
        if (responseStatusNotSetOrSetByAnnotation) {
            responses.addExtension("x-micronaut-parent-response", (Object)true);
        }
        if (response == null && (!withMethodResponses || responseFromCode)) {
            response = new ApiResponse();
            if (javadocDescription == null || StringUtils.isEmpty((CharSequence)javadocDescription.getReturnDescription())) {
                response.setDescription(swaggerOperation.getOperationId() + " " + responseCode + " response");
            } else {
                response.setDescription(javadocDescription.getReturnDescription());
            }
            this.addResponseContent(element, context, openApi, response, jsonViewClass);
            responses.put((Object)responseCode, (Object)response);
        } else if (response != null && response.getContent() == null) {
            this.addResponseContent(element, context, openApi, response, jsonViewClass);
        }
    }

    private void addResponseContent(MethodElement element, VisitorContext context, OpenAPI openApi, ApiResponse response, @Nullable ClassElement jsonViewClass) {
        ClassElement returnType = this.returnType(element, context);
        if (returnType != null && !returnType.getCanonicalName().equals(Void.class.getName())) {
            List<io.micronaut.http.MediaType> producesMediaTypes = this.producesMediaTypes(element);
            Content content = producesMediaTypes.isEmpty() ? this.buildContent((Element)element, returnType, Utils.DEFAULT_MEDIA_TYPES, openApi, context, jsonViewClass) : this.buildContent((Element)element, returnType, producesMediaTypes, openApi, context, jsonViewClass);
            response.setContent(content);
        }
    }

    private ClassElement returnType(MethodElement element, VisitorContext context) {
        ClassElement returnType = element.getGenericReturnType();
        if (ElementUtils.isVoid(returnType) || ElementUtils.isReactiveAndVoid(returnType)) {
            returnType = null;
        } else if (ElementUtils.isResponseType(returnType)) {
            returnType = returnType.getFirstTypeArgument().orElse(returnType);
        } else if (ElementUtils.isSingleResponseType(returnType) && (returnType = (ClassElement)returnType.getFirstTypeArgument().orElse(null)) != null) {
            returnType = returnType.getFirstTypeArgument().orElse(returnType);
        }
        return returnType;
    }

    private Map<String, UriMatchVariable> uriVariables(UriMatchTemplate matchTemplate) {
        List pv = matchTemplate.getVariables();
        LinkedHashMap<String, UriMatchVariable> pathVariables = new LinkedHashMap<String, UriMatchVariable>(pv.size());
        for (UriMatchVariable variable : pv) {
            pathVariables.put(variable.getName(), variable);
        }
        return pathVariables;
    }

    private JavadocDescription getMethodDescription(MethodElement element, io.swagger.v3.oas.models.Operation swaggerOperation, VisitorContext context) {
        String descr = this.getMethodDescription(context);
        if (StringUtils.isNotEmpty((CharSequence)descr) && StringUtils.isEmpty((CharSequence)swaggerOperation.getDescription())) {
            Object summary;
            swaggerOperation.setDescription(descr);
            Object object = summary = descr.contains(".") ? descr.substring(0, descr.indexOf(46) + 1) : descr;
            if (((String)summary).length() > 200) {
                summary = ((String)summary).substring(0, 200) + "...";
            }
            swaggerOperation.setSummary((String)summary);
        }
        JavadocDescription javadocDescription = element.getDocumentation().map(Utils.getJavadocParser()::parse).orElse(null);
        if (javadocDescription != null) {
            if (StringUtils.isEmpty((CharSequence)swaggerOperation.getDescription()) && StringUtils.hasText((CharSequence)javadocDescription.getMethodDescription())) {
                swaggerOperation.setDescription(javadocDescription.getMethodDescription());
            }
            if (StringUtils.isEmpty((CharSequence)swaggerOperation.getSummary()) && StringUtils.hasText((CharSequence)javadocDescription.getMethodSummary())) {
                swaggerOperation.setSummary(javadocDescription.getMethodSummary());
            }
        }
        return javadocDescription;
    }

    private Pair<String, PathItem> readWebhook(@Nullable AnnotationValue<Webhook> webhookAnnValue, HttpMethod httpMethod, VisitorContext context) {
        HttpMethod method;
        io.swagger.v3.oas.models.Operation operation;
        if (webhookAnnValue == null) {
            return null;
        }
        String name = webhookAnnValue.stringValue("name").orElse(null);
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        AnnotationValue operationAnn = webhookAnnValue.getAnnotation("operation", Operation.class).orElse(null);
        if (operationAnn != null) {
            operation = SchemaDefinitionUtils.toValue(operationAnn.getAnnotationName(), operationAnn.getValues(), context, io.swagger.v3.oas.models.Operation.class, null);
            method = HttpMethod.parse((String)operationAnn.stringValue("method").orElse(httpMethod.name()));
        } else {
            operation = new io.swagger.v3.oas.models.Operation();
            method = HttpMethod.POST;
        }
        PathItem pathItem = new PathItem();
        SchemaUtils.setOperationOnPathItem(pathItem, method, operation);
        return Pair.of(name, pathItem);
    }

    private Map<PathItem, io.swagger.v3.oas.models.Operation> readOperations(String path, HttpMethod httpMethod, List<PathItem> pathItems, MethodElement element, VisitorContext context, @Nullable ClassElement jsonViewClass) {
        HashMap<PathItem, io.swagger.v3.oas.models.Operation> swaggerOperations = new HashMap<PathItem, io.swagger.v3.oas.models.Operation>(pathItems.size());
        AnnotationValue operationAnn = element.findAnnotation(Operation.class).orElse(null);
        for (PathItem pathItem : pathItems) {
            boolean addAlways;
            String suffix;
            String prefix;
            AnnotationValue apiDecoratorAnn;
            List paramAnns;
            Object[] methodParams;
            io.swagger.v3.oas.models.Operation swaggerOperation;
            io.swagger.v3.oas.models.Operation operation = swaggerOperation = operationAnn != null ? SchemaDefinitionUtils.toValue(operationAnn.getAnnotationName(), operationAnn.getValues(), context, io.swagger.v3.oas.models.Operation.class, jsonViewClass) : null;
            if (swaggerOperation == null) {
                swaggerOperation = new io.swagger.v3.oas.models.Operation();
            }
            GeneratorUtils.addOperationDeprecatedExtension(element, swaggerOperation, context);
            if (CollectionUtils.isNotEmpty((Collection)swaggerOperation.getParameters())) {
                swaggerOperation.getParameters().removeIf(Objects::isNull);
            }
            if (ArrayUtils.isNotEmpty((Object[])(methodParams = element.getParameters())) && operationAnn != null && CollectionUtils.isNotEmpty((Collection)(paramAnns = operationAnn.getAnnotations("parameters", Parameter.class)))) {
                for (Object methodParam : methodParams) {
                    AnnotationValue paramAnn = null;
                    for (AnnotationValue param : paramAnns) {
                        String paramName = param.stringValue("name").orElse(null);
                        if (!methodParam.getName().equals(paramName)) continue;
                        paramAnn = param;
                        break;
                    }
                    io.swagger.v3.oas.models.parameters.Parameter swaggerParam = null;
                    if (paramAnn != null && !paramAnn.booleanValue("hidden").orElse(false).booleanValue()) {
                        ParameterStyle style;
                        Boolean allowReserved;
                        Boolean allowEmptyValue;
                        String paramName = paramAnn.stringValue("name").orElse(null);
                        if (paramName != null && CollectionUtils.isNotEmpty((Collection)swaggerOperation.getParameters())) {
                            for (io.swagger.v3.oas.models.parameters.Parameter createdParameter : swaggerOperation.getParameters()) {
                                if (!createdParameter.getName().equals(paramName)) continue;
                                swaggerParam = createdParameter;
                                break;
                            }
                        }
                        if (swaggerParam == null) {
                            if (swaggerOperation.getParameters() == null) {
                                swaggerOperation.setParameters(new ArrayList());
                            }
                            swaggerParam = new io.swagger.v3.oas.models.parameters.Parameter();
                            swaggerOperation.getParameters().add(swaggerParam);
                        }
                        if (paramName != null) {
                            swaggerParam.setName(paramName);
                        }
                        paramAnn.stringValue("description").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)swaggerParam).setDescription(arg_0));
                        Boolean required = paramAnn.booleanValue("required").orElse(false);
                        if (required.booleanValue()) {
                            swaggerParam.setRequired(Boolean.valueOf(true));
                        }
                        if ((allowEmptyValue = paramAnn.booleanValue("allowEmptyValue").orElse(false)).booleanValue()) {
                            swaggerParam.setAllowEmptyValue(Boolean.valueOf(true));
                        }
                        if ((allowReserved = paramAnn.booleanValue("allowReserved").orElse(false)).booleanValue()) {
                            swaggerParam.setAllowReserved(Boolean.valueOf(true));
                        }
                        paramAnn.stringValue("example").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)swaggerParam).setExample(arg_0));
                        Map<String, Example> examples = this.readExamples(paramAnn.getAnnotations("examples", ExampleObject.class), (Element)element, context);
                        if (examples != null) {
                            examples.forEach((arg_0, arg_1) -> ((io.swagger.v3.oas.models.parameters.Parameter)swaggerParam).addExample(arg_0, arg_1));
                        }
                        paramAnn.stringValue("ref").ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)swaggerParam).set$ref(arg_0));
                        Optional inOpt = paramAnn.get((CharSequence)"in", ParameterIn.class);
                        if (inOpt.isPresent()) {
                            ParameterIn in = (ParameterIn)inOpt.get();
                            if (in == ParameterIn.DEFAULT) {
                                swaggerParam.setIn(ParamUtils.calcIn(path, httpMethod, (ParameterElement)methodParam));
                            } else {
                                swaggerParam.setIn(in.toString());
                            }
                        }
                        if ((style = paramAnn.get((CharSequence)"style", ParameterStyle.class).orElse(ParameterStyle.DEFAULT)) != ParameterStyle.DEFAULT) {
                            swaggerParam.setStyle(ParamUtils.paramStyle(style, swaggerParam.getIn()));
                        }
                    }
                    if (swaggerParam == null || !StringUtils.isEmpty((CharSequence)swaggerParam.getIn())) continue;
                    swaggerParam.setIn(ParamUtils.calcIn(path, httpMethod, (ParameterElement)methodParam));
                }
            }
            if ((apiDecoratorAnn = element.getDeclaredAnnotation(OpenAPIDecorator.class)) != null) {
                prefix = apiDecoratorAnn.stringValue().orElse("");
                suffix = apiDecoratorAnn.stringValue("opIdSuffix").orElse("");
                addAlways = apiDecoratorAnn.booleanValue("addAlways").orElse(true);
            } else {
                prefix = ContextUtils.get("micronaut.internal.opId.prefix", String.class, "", context);
                suffix = ContextUtils.get("micronaut.internal.opId.suffix", String.class, "", context);
                addAlways = ContextUtils.get("micronaut.internal.opId.suffixes.add.always", Boolean.class, Boolean.valueOf(true), context);
            }
            String postfix = "";
            if (CollectionUtils.isNotEmpty((Map)pathItem.getExtensions()) && pathItem.getExtensions().containsKey("x-micronaut-op-postfix")) {
                postfix = pathItem.getExtensions().get("x-micronaut-op-postfix").toString();
            }
            if (StringUtils.isEmpty((CharSequence)swaggerOperation.getOperationId())) {
                swaggerOperation.setOperationId(prefix + element.getName() + postfix + suffix);
            } else if (addAlways) {
                swaggerOperation.setOperationId(prefix + swaggerOperation.getOperationId() + postfix + suffix);
            }
            if (swaggerOperation.getDescription() != null && swaggerOperation.getDescription().isEmpty()) {
                swaggerOperation.setDescription(null);
            }
            swaggerOperations.put(pathItem, swaggerOperation);
        }
        return swaggerOperations;
    }

    private ExternalDocumentation readExternalDocs(MethodElement element, VisitorContext context) {
        AnnotationValue externalDocsAnn = element.findAnnotation(io.swagger.v3.oas.annotations.ExternalDocumentation.class).orElse(null);
        if (externalDocsAnn == null) {
            return null;
        }
        return SchemaDefinitionUtils.toValue(externalDocsAnn.getAnnotationName(), externalDocsAnn.getValues(), context, ExternalDocumentation.class, null);
    }

    private void processExplode(AnnotationValue<Parameter> paramAnn, Map<CharSequence, Object> paramValues) {
        Optional explode = paramAnn.enumValue("explode", Explode.class);
        if (explode.isEmpty()) {
            return;
        }
        block0 : switch ((Explode)explode.get()) {
            case TRUE: {
                paramValues.put("explode", Boolean.TRUE);
                break;
            }
            case FALSE: {
                paramValues.put("explode", Boolean.FALSE);
                break;
            }
            default: {
                String in = (String)paramValues.get("in");
                if (StringUtils.isEmpty((CharSequence)in)) {
                    in = "default";
                }
                switch (ParameterIn.valueOf((String)in.toUpperCase(Locale.ENGLISH))) {
                    case COOKIE: 
                    case QUERY: {
                        paramValues.put("explode", Boolean.TRUE);
                        break block0;
                    }
                }
                paramValues.put("explode", Boolean.FALSE);
            }
        }
    }

    private void readApiResponses(MethodElement element, VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation, @Nullable ClassElement jsonViewClass) {
        List methodResponseAnns = element.getAnnotationValuesByType(io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        this.processResponses(swaggerOperation, methodResponseAnns, element, context, jsonViewClass);
        List classResponseAnns = element.getDeclaringType().getAnnotationValuesByType(io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        this.processResponses(swaggerOperation, classResponseAnns, element, context, jsonViewClass);
    }

    private void processResponses(io.swagger.v3.oas.models.Operation operation, List<AnnotationValue<io.swagger.v3.oas.annotations.responses.ApiResponse>> responseAnns, MethodElement element, VisitorContext context, @Nullable ClassElement jsonViewClass) {
        io.swagger.v3.oas.models.responses.ApiResponses apiResponses = operation.getResponses();
        if (apiResponses == null) {
            apiResponses = new io.swagger.v3.oas.models.responses.ApiResponses();
            operation.setResponses(apiResponses);
        }
        if (CollectionUtils.isEmpty(responseAnns)) {
            return;
        }
        for (AnnotationValue<io.swagger.v3.oas.annotations.responses.ApiResponse> responseAnn : responseAnns) {
            ApiResponse newApiResponse;
            String responseCode = responseAnn.stringValue("responseCode").orElse("default");
            if (apiResponses.containsKey((Object)responseCode) || (newApiResponse = SchemaDefinitionUtils.toValue(responseAnn.getAnnotationName(), responseAnn.getValues(), context, ApiResponse.class, jsonViewClass)) == null) continue;
            if (responseAnn.booleanValue("useReturnTypeSchema").orElse(false).booleanValue() && element != null) {
                this.addResponseContent(element, context, Utils.resolveOpenApi(context), newApiResponse, jsonViewClass);
            } else {
                Content newContent;
                List<io.micronaut.http.MediaType> producesMediaTypes = this.producesMediaTypes(element);
                Object[] contentAnns = responseAnn.get((CharSequence)"content", io.swagger.v3.oas.annotations.media.Content[].class).orElse(null);
                ArrayList<String> mediaTypes = new ArrayList<String>();
                if (ArrayUtils.isNotEmpty((Object[])contentAnns)) {
                    for (Object contentAnn : contentAnns) {
                        if (StringUtils.isNotEmpty((CharSequence)contentAnn.mediaType())) {
                            mediaTypes.add(contentAnn.mediaType());
                            continue;
                        }
                        mediaTypes.add("application/json");
                    }
                }
                if ((newContent = newApiResponse.getContent()) != null) {
                    MediaType defaultMediaType = (MediaType)newContent.get((Object)"application/json");
                    Content contentFromProduces = new Content();
                    for (String mt : mediaTypes) {
                        if (mt.equals("application/json")) {
                            for (io.micronaut.http.MediaType mediaType : producesMediaTypes) {
                                contentFromProduces.put((Object)mediaType.toString(), (Object)defaultMediaType);
                            }
                            continue;
                        }
                        contentFromProduces.put((Object)mt, (Object)((MediaType)newContent.get((Object)mt)));
                    }
                    newApiResponse.setContent(contentFromProduces);
                }
            }
            try {
                if (StringUtils.isEmpty((CharSequence)newApiResponse.getDescription())) {
                    newApiResponse.setDescription(responseCode.equals("default") ? "OK response" : HttpStatus.getDefaultReason((int)Integer.parseInt(responseCode)));
                }
            }
            catch (Exception e) {
                newApiResponse.setDescription("Response " + responseCode);
            }
            apiResponses.put((Object)responseCode, (Object)newApiResponse);
        }
        operation.setResponses(apiResponses);
    }

    private Pair<RequestBody, Boolean> readSwaggerRequestBody(Element element, List<io.micronaut.http.MediaType> consumesMediaTypes, VisitorContext context) {
        AnnotationValue schemaAnn;
        AnnotationValue requestBodyAnn = element.findAnnotation(io.swagger.v3.oas.annotations.parameters.RequestBody.class).orElse(null);
        if (requestBodyAnn == null) {
            return null;
        }
        boolean hasSchemaImplementation = false;
        AnnotationValue contentAnn = requestBodyAnn.getAnnotation("content", io.swagger.v3.oas.annotations.media.Content.class).orElse(null);
        if (contentAnn != null && (schemaAnn = (AnnotationValue)contentAnn.getAnnotation("schema", io.swagger.v3.oas.annotations.media.Schema.class).orElse(null)) != null) {
            hasSchemaImplementation = schemaAnn.stringValue("implementation").orElse(null) != null;
        }
        ClassElement jsonViewClass = element instanceof ParameterElement ? ElementUtils.getJsonViewClass(element, context) : null;
        RequestBody requestBody = SchemaDefinitionUtils.toValue(requestBodyAnn.getAnnotationName(), requestBodyAnn.getValues(), context, RequestBody.class, jsonViewClass);
        if (contentAnn != null && contentAnn.stringValue("mediaType").isEmpty() && requestBody != null && requestBody.getContent() != null && !consumesMediaTypes.equals(Utils.DEFAULT_MEDIA_TYPES)) {
            MediaType defaultSwaggerMediaType = (MediaType)requestBody.getContent().remove((Object)"application/json");
            for (io.micronaut.http.MediaType mediaType : consumesMediaTypes) {
                requestBody.getContent().put((Object)mediaType.toString(), (Object)defaultSwaggerMediaType);
            }
        }
        return Pair.of(requestBody, hasSchemaImplementation);
    }

    private void readServers(MethodElement element, VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation) {
        for (Server server : this.methodServers(element, context)) {
            swaggerOperation.addServersItem(server);
        }
    }

    private void readExtensions(MethodElement element, VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation) {
        for (Map.Entry<String, Object> entry : this.operationExtensions(element, context).entrySet()) {
            swaggerOperation.addExtension(entry.getKey(), entry.getValue());
        }
    }

    private void readCallbacks(MethodElement element, VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation, @Nullable ClassElement jsonViewClass) {
        AnnotationValue callbacksAnn = element.getAnnotation(Callbacks.class);
        List callbackAnns = callbacksAnn != null ? callbacksAnn.getAnnotations("value") : element.getAnnotationValuesByType(io.swagger.v3.oas.annotations.callbacks.Callback.class);
        if (CollectionUtils.isEmpty((Collection)callbackAnns)) {
            return;
        }
        for (AnnotationValue callbackAnn : callbackAnns) {
            String callbackName = callbackAnn.stringValue("name").orElse(null);
            if (StringUtils.isEmpty((CharSequence)callbackName)) continue;
            String ref = callbackAnn.stringValue("ref").orElse(null);
            if (StringUtils.isNotEmpty((CharSequence)ref)) {
                String refCallback = ref.substring("#/components/callbacks/".length());
                this.processCallbackReference(context, swaggerOperation, callbackName, refCallback);
                continue;
            }
            String expr = callbackAnn.stringValue("callbackUrlExpression").orElse(null);
            if (StringUtils.isNotEmpty((CharSequence)expr)) {
                this.processUrlCallbackExpression(context, swaggerOperation, (AnnotationValue<io.swagger.v3.oas.annotations.callbacks.Callback>)callbackAnn, callbackName, expr, jsonViewClass);
                continue;
            }
            this.processCallbackReference(context, swaggerOperation, callbackName, null);
        }
    }

    private void processCallbackReference(VisitorContext context, io.swagger.v3.oas.models.Operation swaggerOperation, String callbackName, String refCallback) {
        Utils.resolveComponents(Utils.resolveOpenApi(context));
        Map<String, Callback> callbacks = this.initCallbacks(swaggerOperation);
        Callback callbackRef = new Callback();
        callbackRef.set$ref((String)(refCallback != null ? refCallback : "#/components/callbacks/" + callbackName));
        callbacks.put(callbackName, callbackRef);
    }

    private void processUrlCallbackExpression(VisitorContext context, io.swagger.v3.oas.models.Operation operation, AnnotationValue<io.swagger.v3.oas.annotations.callbacks.Callback> callbackAnn, String callbackName, String callbackUrl, @Nullable ClassElement jsonViewClass) {
        List operationAnns = callbackAnn.getAnnotations("operation", Operation.class);
        PathItem pathItem = new PathItem();
        if (CollectionUtils.isNotEmpty((Collection)operationAnns)) {
            for (AnnotationValue operationAnn : operationAnns) {
                io.swagger.v3.oas.models.Operation op;
                HttpMethod httpMethod = operationAnn.get((CharSequence)"method", HttpMethod.class).orElse(null);
                if (httpMethod == null || (op = SchemaDefinitionUtils.toValue(operationAnn.getAnnotationName(), operationAnn.getValues(), context, io.swagger.v3.oas.models.Operation.class, jsonViewClass)) == null) continue;
                SchemaUtils.setOperationOnPathItem(pathItem, httpMethod, op);
            }
        }
        Map<String, Callback> callbacks = this.initCallbacks(operation);
        Callback callback = new Callback();
        callback.addPathItem(callbackUrl, pathItem);
        callbacks.put(callbackName, callback);
    }

    private Map<String, Callback> initCallbacks(io.swagger.v3.oas.models.Operation swaggerOperation) {
        LinkedHashMap callbacks = swaggerOperation.getCallbacks();
        if (callbacks == null) {
            callbacks = new LinkedHashMap();
            swaggerOperation.setCallbacks(callbacks);
        }
        return callbacks;
    }

    private Content buildContent(Element definingElement, ClassElement type, List<io.micronaut.http.MediaType> mediaTypes, OpenAPI openApi, VisitorContext context, @Nullable ClassElement jsonViewClass) {
        Content content = new Content();
        for (io.micronaut.http.MediaType mediaType : mediaTypes) {
            MediaType mt = new MediaType();
            mt.setSchema(SchemaDefinitionUtils.resolveSchema(openApi, definingElement, type, context, Collections.singletonList(mediaType), jsonViewClass, null, null, null));
            content.addMediaType(mediaType.toString(), mt);
        }
        return content;
    }
}

