/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.micronaut.openapi.visitor.UrlUtils;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.parboiled.common.StringUtils;

@Internal
abstract class AbstractOpenApiVisitor {
    private static final Lock VISITED_ELEMENTS_LOCK = new ReentrantLock();

    AbstractOpenApiVisitor() {
    }

    void incrementVisitedElements(VisitorContext context) {
        VISITED_ELEMENTS_LOCK.lock();
        try {
            ContextUtils.put("io.micronaut.OPENAPI.visited.elements", ContextUtils.getVisitedElements(context) + 1, context);
        }
        finally {
            VISITED_ELEMENTS_LOCK.unlock();
        }
    }

    int visitedElements(VisitorContext context) {
        VISITED_ELEMENTS_LOCK.lock();
        try {
            int n = ContextUtils.getVisitedElements(context);
            return n;
        }
        finally {
            VISITED_ELEMENTS_LOCK.unlock();
        }
    }

    Map<String, Object> readExtensions(List<AnnotationValue<Extension>> annotations) {
        if (CollectionUtils.isEmpty(annotations)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>(annotations.size());
        for (AnnotationValue<Extension> ann : annotations) {
            String name;
            List extensionProps = ann.getAnnotations("properties", ExtensionProperty.class);
            if (extensionProps.isEmpty() || (name = (String)ann.stringValue("name").orElse(null)) == null) continue;
            name = SchemaUtils.prependIfMissing(name, "x-");
            HashMap<String, String> extMap = new HashMap<String, String>(extensionProps.size());
            for (AnnotationValue prop : extensionProps) {
                String propName = prop.stringValue("name").orElse(null);
                String propValue = prop.stringValue("value").orElse(null);
                if (StringUtils.isEmpty((String)propName) || StringUtils.isEmpty((String)propValue)) continue;
                String processedValue = propValue;
                Boolean propertyAsJson = (Boolean)prop.get((CharSequence)"parseValue", Boolean.TYPE, (Object)false);
                if (propertyAsJson.booleanValue()) {
                    try {
                        processedValue = Utils.getJsonMapper().readTree(propValue);
                        extMap.put(propName, processedValue);
                    }
                    catch (Exception e) {
                        extMap.put(propName, processedValue);
                    }
                    continue;
                }
                extMap.put(propName, processedValue);
            }
            result.put(name, extMap);
        }
        return result;
    }

    Map<String, List<PathItem>> resolvePathItems(VisitorContext context, List<UriMatchTemplate> matchTemplates) {
        OpenAPI openApi = Utils.resolveOpenApi(context);
        Paths paths = openApi.getPaths();
        if (paths == null) {
            paths = new Paths();
            openApi.setPaths(paths);
        }
        HashMap<String, List<PathItem>> resultPathItemsMap = new HashMap<String, List<PathItem>>();
        for (UriMatchTemplate matchTemplate : matchTemplates) {
            List<UrlUtils.Segment> segments = UrlUtils.parsePathSegments(matchTemplate.toPathString());
            List<UrlUtils.OpPath> finalPaths = UrlUtils.buildUrls(segments, context);
            for (UrlUtils.OpPath finalPath : finalPaths) {
                List resultPathItems = resultPathItemsMap.computeIfAbsent(finalPath.url(), k -> new ArrayList());
                PathItem pathItem = (PathItem)paths.computeIfAbsent((Object)finalPath.url(), key -> new PathItem());
                String opIdPostfix = finalPath.opIdPostfix();
                if (!opIdPostfix.isEmpty()) {
                    pathItem.addExtension("x-micronaut-op-postfix", (Object)opIdPostfix);
                }
                resultPathItems.add(pathItem);
            }
        }
        return resultPathItemsMap;
    }
}

