/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.annotation.CookieValue;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.openapi.swagger.core.util.PrimitiveType;
import io.micronaut.openapi.visitor.ElementUtils;
import io.micronaut.openapi.visitor.MnParamFormat;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@Internal
public final class ParamUtils {
    private static final String DEFAULT_PARAM_VERSION_DESCRIPTION = "API version";

    private ParamUtils() {
    }

    public static String calcIn(String path, HttpMethod httpMethod, ParameterElement methodParam) {
        String paramName = methodParam.getName();
        Set paramAnnNames = methodParam.getAnnotationNames();
        if (CollectionUtils.isNotEmpty((Collection)paramAnnNames)) {
            if (paramAnnNames.contains(QueryValue.class.getName())) {
                return ParameterIn.QUERY.toString();
            }
            if (paramAnnNames.contains(PathVariable.class.getName())) {
                return ParameterIn.PATH.toString();
            }
            if (paramAnnNames.contains(Header.class.getName())) {
                return ParameterIn.HEADER.toString();
            }
            if (paramAnnNames.contains(CookieValue.class.getName())) {
                return ParameterIn.COOKIE.toString();
            }
        }
        if (httpMethod == HttpMethod.GET) {
            if (path.contains("{" + paramName + "}")) {
                return ParameterIn.PATH.toString();
            }
            return ParameterIn.QUERY.toString();
        }
        if (path.contains("{" + paramName + "}")) {
            return ParameterIn.PATH.toString();
        }
        return null;
    }

    public static Parameter.StyleEnum paramStyle(ParameterStyle paramAnnStyle, String in) {
        if (paramAnnStyle == null) {
            return null;
        }
        if (in != null) {
            if (in.equalsIgnoreCase(ParameterIn.HEADER.toString())) {
                return switch (paramAnnStyle) {
                    default -> throw new IncompatibleClassChangeError();
                    case ParameterStyle.SIMPLE -> Parameter.StyleEnum.SIMPLE;
                    case ParameterStyle.DEFAULT, ParameterStyle.DEEPOBJECT, ParameterStyle.PIPEDELIMITED, ParameterStyle.SPACEDELIMITED, ParameterStyle.FORM, ParameterStyle.LABEL, ParameterStyle.MATRIX -> null;
                };
            }
            if (in.equalsIgnoreCase(ParameterIn.PATH.toString())) {
                return switch (paramAnnStyle) {
                    default -> throw new IncompatibleClassChangeError();
                    case ParameterStyle.MATRIX -> Parameter.StyleEnum.MATRIX;
                    case ParameterStyle.LABEL -> Parameter.StyleEnum.LABEL;
                    case ParameterStyle.SIMPLE -> Parameter.StyleEnum.SIMPLE;
                    case ParameterStyle.DEFAULT, ParameterStyle.DEEPOBJECT, ParameterStyle.PIPEDELIMITED, ParameterStyle.SPACEDELIMITED, ParameterStyle.FORM -> null;
                };
            }
            if (in.equalsIgnoreCase(ParameterIn.QUERY.toString())) {
                return switch (paramAnnStyle) {
                    default -> throw new IncompatibleClassChangeError();
                    case ParameterStyle.FORM -> Parameter.StyleEnum.FORM;
                    case ParameterStyle.SPACEDELIMITED -> Parameter.StyleEnum.SPACEDELIMITED;
                    case ParameterStyle.PIPEDELIMITED -> Parameter.StyleEnum.PIPEDELIMITED;
                    case ParameterStyle.DEEPOBJECT -> Parameter.StyleEnum.DEEPOBJECT;
                    case ParameterStyle.SIMPLE, ParameterStyle.DEFAULT, ParameterStyle.LABEL, ParameterStyle.MATRIX -> null;
                };
            }
            if (in.equalsIgnoreCase(ParameterIn.COOKIE.toString())) {
                return switch (paramAnnStyle) {
                    default -> throw new IncompatibleClassChangeError();
                    case ParameterStyle.FORM -> Parameter.StyleEnum.FORM;
                    case ParameterStyle.SIMPLE, ParameterStyle.DEFAULT, ParameterStyle.DEEPOBJECT, ParameterStyle.PIPEDELIMITED, ParameterStyle.SPACEDELIMITED, ParameterStyle.LABEL, ParameterStyle.MATRIX -> null;
                };
            }
        }
        return switch (paramAnnStyle) {
            default -> throw new IncompatibleClassChangeError();
            case ParameterStyle.MATRIX -> Parameter.StyleEnum.MATRIX;
            case ParameterStyle.LABEL -> Parameter.StyleEnum.LABEL;
            case ParameterStyle.FORM -> Parameter.StyleEnum.FORM;
            case ParameterStyle.SPACEDELIMITED -> Parameter.StyleEnum.SPACEDELIMITED;
            case ParameterStyle.PIPEDELIMITED -> Parameter.StyleEnum.PIPEDELIMITED;
            case ParameterStyle.DEEPOBJECT -> Parameter.StyleEnum.DEEPOBJECT;
            case ParameterStyle.SIMPLE -> Parameter.StyleEnum.SIMPLE;
            case ParameterStyle.DEFAULT -> null;
        };
    }

    public static Parameter.StyleEnum paramStyleByFormat(String format, String in) {
        if (format == null) {
            return null;
        }
        return MnParamFormat.getStyleByFormatName(format, in);
    }

    public static String getHeaderName(TypedElement parameter, String parameterName) {
        if (ElementUtils.isIgnoredParameter(parameter)) {
            return null;
        }
        String headerName = parameter.stringValue(Header.class, "name").orElse(parameter.stringValue(Header.class).orElseGet(() -> NameUtils.hyphenate((String)parameterName)));
        if (SchemaUtils.isIgnoredHeader(headerName)) {
            return null;
        }
        return headerName;
    }

    public static void addVersionParameters(Operation swaggerOperation, List<String> names, boolean isHeader) {
        String in = isHeader ? ParameterIn.HEADER.toString() : ParameterIn.QUERY.toString();
        for (String parameterName : names) {
            Parameter parameter = new Parameter().in(in).description(DEFAULT_PARAM_VERSION_DESCRIPTION).name(parameterName).schema(SchemaUtils.setSpecVersion(PrimitiveType.STRING.createProperty()));
            swaggerOperation.addParametersItem(parameter);
        }
    }
}

