/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.StringUtil;
import java.util.ArrayList;
import java.util.List;

@Internal
public final class UrlUtils {
    private static final String PREFIX_FIRST = "With";
    private static final String PREFIX_NEXT = "And";

    private UrlUtils() {
    }

    public static List<OpPath> buildUrls(List<Segment> segments, VisitorContext context) {
        ArrayList<PathBuilders> results = new ArrayList<PathBuilders>();
        Segment prevSegment = null;
        for (Segment segment : segments) {
            UrlUtils.appendSegment(segment, prevSegment, results);
            prevSegment = segment;
        }
        Object contextPath = ConfigUtils.getServerContextPath(context);
        if (StringUtils.isNotEmpty((CharSequence)contextPath)) {
            if (!((String)contextPath).startsWith("/") && !((String)contextPath).startsWith("$")) {
                contextPath = "/" + (String)contextPath;
            }
            if (((String)contextPath).endsWith("/")) {
                contextPath = ((String)contextPath).substring(0, ((String)contextPath).length() - 1);
            }
        }
        ArrayList<OpPath> resultOpPaths = new ArrayList<OpPath>();
        for (PathBuilders res : results) {
            Object url = res.urlBuilder.toString();
            if (((String)url).endsWith("/") && ((String)url).length() > 1) {
                url = ((String)url).substring(0, ((String)url).length() - "/".length());
            } else if (!((String)url).startsWith("/") && !((String)url).startsWith("$")) {
                url = "/" + (String)url;
            } else if (((String)url).startsWith("/$")) {
                url = ((String)url).substring(1);
            }
            if (StringUtils.isNotEmpty((CharSequence)contextPath)) {
                url = (String)contextPath + (String)url;
            }
            boolean alreadyAdded = false;
            for (OpPath opPath : resultOpPaths) {
                if (!opPath.url.equals(url)) continue;
                alreadyAdded = true;
                break;
            }
            if (alreadyAdded) continue;
            resultOpPaths.add(new OpPath((String)url, res.opIdBuilder.toString()));
        }
        return resultOpPaths;
    }

    private static void appendSegment(Segment segment, Segment prevSegment, List<PathBuilders> results) {
        SegmentType type = segment.type;
        String value = segment.value;
        if (results.isEmpty()) {
            StringBuilder opIdBuilder;
            if (type == SegmentType.PLACEHOLDER) {
                results.add(new PathBuilders(new StringBuilder(value), new StringBuilder(), true));
                return;
            }
            boolean isFirst = true;
            if (type == SegmentType.OPT_VAR) {
                opIdBuilder = new StringBuilder(PREFIX_FIRST).append(StringUtil.capitalizedPathVar(value));
                isFirst = false;
            } else {
                opIdBuilder = new StringBuilder();
            }
            results.add(new PathBuilders(new StringBuilder(value), opIdBuilder, isFirst));
            if (type == SegmentType.OPT_VAR) {
                results.add(new PathBuilders(new StringBuilder(), new StringBuilder(), true));
            }
            return;
        }
        if (type == SegmentType.CONST || type == SegmentType.REQ_VAR || type == SegmentType.PLACEHOLDER) {
            for (PathBuilders result : results) {
                result.urlBuilder.append(value);
            }
            return;
        }
        ArrayList<PathBuilders> newResults = new ArrayList<PathBuilders>();
        for (PathBuilders result : results) {
            newResults.add(new PathBuilders(new StringBuilder(result.urlBuilder), new StringBuilder(result.opIdBuilder), result.isFirst));
        }
        for (PathBuilders result : results) {
            if (prevSegment.type == SegmentType.OPT_VAR && result.urlBuilder.indexOf(prevSegment.value) < 0) continue;
            result.urlBuilder.append('/').append(value);
            result.opIdBuilder.append(result.isFirst ? PREFIX_FIRST : PREFIX_NEXT).append(StringUtil.capitalizedPathVar(value));
            result.isFirst = false;
        }
        results.addAll(newResults);
    }

    public static List<Segment> parsePathSegments(String pathString) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        int startPos = 0;
        while (true) {
            int startBlockPos;
            SegmentType type;
            int varStartPos;
            if ((varStartPos = pathString.indexOf(123, startPos)) < 0) break;
            int varEndPos = pathString.indexOf(125, varStartPos);
            String constSegment = pathString.substring(startPos, varStartPos);
            char nextChar = pathString.charAt(varStartPos + 1);
            if (nextChar == '?' || nextChar == '.' || nextChar == '+' || nextChar == '0') {
                UrlUtils.addConstValue(constSegment, segments);
                startPos = varEndPos + 1;
                continue;
            }
            if (varStartPos >= 1 && pathString.charAt(varStartPos - 1) == '$') {
                if (!constSegment.isEmpty()) {
                    UrlUtils.addConstValue(constSegment.substring(0, constSegment.length() - 1), segments);
                }
                segments.add(new Segment(SegmentType.PLACEHOLDER, pathString.substring(varStartPos - 1, varEndPos + 1)));
                startPos = varEndPos + 1;
                continue;
            }
            SegmentType segmentType = type = nextChar == '/' ? SegmentType.OPT_VAR : SegmentType.REQ_VAR;
            if (!constSegment.isEmpty()) {
                UrlUtils.addConstValue(constSegment, segments);
            }
            if (pathString.charAt((startBlockPos = varStartPos) + 1) == '/') {
                ++startBlockPos;
            }
            while (true) {
                int dotPos = pathString.indexOf(44, startBlockPos + 1);
                int dotPos2 = pathString.indexOf(58, startBlockPos + 1);
                int minEndPos = dotPos > 0 && dotPos < varEndPos ? dotPos : varEndPos;
                minEndPos = dotPos2 > 0 && dotPos2 < minEndPos ? dotPos2 : minEndPos;
                String varName = pathString.substring(startBlockPos + 1, minEndPos);
                segments.add(new Segment(type, "{" + varName + "}"));
                if (minEndPos != dotPos) break;
                startBlockPos = minEndPos;
            }
            startPos = varEndPos + 1;
        }
        UrlUtils.addConstValue(pathString.substring(startPos), segments);
        if (segments.isEmpty()) {
            segments.add(new Segment(SegmentType.CONST, "/"));
        }
        return segments;
    }

    private static void addConstValue(String constValue, List<Segment> segments) {
        if (!constValue.isEmpty()) {
            segments.add(new Segment(SegmentType.CONST, constValue));
        }
    }

    public static String parsePath(String path) {
        if (StringUtils.isNotEmpty((CharSequence)path) && !path.endsWith("/")) {
            return path + "/";
        }
        return path;
    }

    public record Segment(SegmentType type, String value) {
    }

    static class PathBuilders {
        StringBuilder urlBuilder;
        StringBuilder opIdBuilder;
        boolean isFirst;

        public PathBuilders(StringBuilder urlBuilder, StringBuilder opIdBuilder, boolean isFirst) {
            this.urlBuilder = urlBuilder;
            this.opIdBuilder = opIdBuilder;
            this.isFirst = isFirst;
        }
    }

    public record OpPath(String url, String opIdPostfix) {
    }

    static enum SegmentType {
        REQ_VAR,
        OPT_VAR,
        CONST,
        PLACEHOLDER;

    }
}

