/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor.security;

import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpMethod;
import io.micronaut.openapi.visitor.security.InterceptUrlMapPattern;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Internal
public class InterceptUrlMapConverter
implements TypeConverter<Map, InterceptUrlMapPattern> {
    private static final String PATTERN = "pattern";
    private static final String ACCESS = "access";
    private static final String HTTP_METHOD = "http-method";
    private final ConversionService conversionService;

    public InterceptUrlMapConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Optional<InterceptUrlMapPattern> convert(Map m, Class<InterceptUrlMapPattern> targetType, ConversionContext context) {
        if (m == null) {
            return Optional.empty();
        }
        Optional optionalPattern = this.conversionService.convert((m = this.transform(m)).get(PATTERN), String.class);
        if (optionalPattern.isPresent()) {
            Optional<List> optionalAccessList = this.conversionService.convert(m.get(ACCESS), Argument.LIST_OF_STRING);
            if ((optionalAccessList = optionalAccessList.map(list -> list.stream().map(o -> this.conversionService.convert(o, String.class)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()))).isPresent()) {
                Optional httpMethod;
                if (m.containsKey(HTTP_METHOD)) {
                    httpMethod = this.conversionService.convert(m.get(HTTP_METHOD), HttpMethod.class);
                    if (httpMethod.isEmpty()) {
                        throw new ConfigurationException(String.format("interceptUrlMap configuration record %s rejected due to invalid %s key.", m, HTTP_METHOD));
                    }
                } else {
                    httpMethod = Optional.empty();
                }
                List accessList = optionalAccessList.get();
                return optionalPattern.map(pattern -> new InterceptUrlMapPattern((String)pattern, accessList, httpMethod.orElse(null)));
            }
            throw new ConfigurationException(String.format("interceptUrlMap configuration record %s rejected due to missing or empty %s key.", m, ACCESS));
        }
        throw new ConfigurationException(String.format("interceptUrlMap configuration record %s rejected due to missing %s key.", m, PATTERN));
    }

    private Map<String, Object> transform(Map<String, Object> map) {
        HashMap<String, Object> transformed = new HashMap<String, Object>();
        StringConvention convention = StringConvention.HYPHENATED;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            transformed.put(convention.format(entry.getKey()), entry.getValue());
        }
        return transformed;
    }
}

