/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.version.annotation.Version;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.MediaType;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PackageElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.annotation.OpenAPIGroup;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ParamUtils;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.micronaut.openapi.visitor.Utils;
import io.micronaut.openapi.visitor.group.EndpointGroupInfo;
import io.micronaut.openapi.visitor.group.EndpointInfo;
import io.micronaut.openapi.visitor.group.GroupProperties;
import io.micronaut.openapi.visitor.group.RouterVersioningProperties;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.models.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public final class GroupUtils {
    private GroupUtils() {
    }

    public static void processMicronautVersionAndGroup(Operation swaggerOperation, String url, HttpMethod httpMethod, List<MediaType> consumesMediaTypes, List<MediaType> producesMediaTypes, MethodElement methodEl, VisitorContext context) {
        Map<String, List<EndpointInfo>> endpointInfosMap;
        String methodKey = httpMethod.name() + "#" + url + "#" + CollectionUtils.toString(CollectionUtils.isEmpty(consumesMediaTypes) ? Utils.DEFAULT_MEDIA_TYPES : consumesMediaTypes) + "#" + CollectionUtils.toString(CollectionUtils.isEmpty(producesMediaTypes) ? Utils.DEFAULT_MEDIA_TYPES : producesMediaTypes);
        Map<String, GroupProperties> groupPropertiesMap = ConfigUtils.getGroupsPropertiesMap(context);
        HashMap<String, EndpointGroupInfo> groups = new HashMap<String, EndpointGroupInfo>();
        ArrayList<String> excludedGroups = new ArrayList<String>();
        ClassElement classEl = methodEl.getDeclaringType();
        PackageElement packageEl = classEl.getPackage();
        String packageName = packageEl.getName();
        GroupUtils.processGroups(groups, excludedGroups, methodEl.getAnnotationValuesByType(OpenAPIGroup.class), groupPropertiesMap);
        GroupUtils.processGroups(groups, excludedGroups, packageEl.getAnnotationValuesByType(OpenAPIGroup.class), groupPropertiesMap);
        GroupUtils.processGroupsFromIncludedEndpoints(groups, excludedGroups, classEl.getName());
        for (GroupProperties groupProperties : groupPropertiesMap.values()) {
            if (CollectionUtils.isNotEmpty(groupProperties.getPackages())) {
                for (GroupProperties.PackageProperties groupPackage : groupProperties.getPackages()) {
                    boolean isInclude = groupPackage.isIncludeSubpackages() ? packageName.startsWith(groupPackage.getName()) : packageName.equals(groupPackage.getName());
                    if (!isInclude) continue;
                    groups.put(groupProperties.getName(), new EndpointGroupInfo(groupProperties.getName()));
                }
            }
            if (!CollectionUtils.isNotEmpty(groupProperties.getPackagesExclude())) continue;
            for (GroupProperties.PackageProperties excludePackage : groupProperties.getPackagesExclude()) {
                boolean isExclude = excludePackage.isIncludeSubpackages() ? packageName.startsWith(excludePackage.getName()) : packageName.equals(excludePackage.getName());
                if (!isExclude) continue;
                excludedGroups.add(groupProperties.getName());
            }
        }
        RouterVersioningProperties versioningProperties = ConfigUtils.getRouterVersioningProperties(context);
        boolean isVersioningEnabled = versioningProperties.isEnabled() && versioningProperties.isRouterVersioningEnabled() && (versioningProperties.isHeaderEnabled() || versioningProperties.isParameterEnabled());
        String version = null;
        if (isVersioningEnabled) {
            List versionAnns = methodEl.getAnnotationValuesByType(Version.class);
            if (CollectionUtils.isNotEmpty((Collection)versionAnns)) {
                version = ((AnnotationValue)versionAnns.get(0)).stringValue().orElse(null);
            }
            if (version != null) {
                Utils.getAllKnownVersions().add(version);
            }
            if (versioningProperties.isParameterEnabled()) {
                ParamUtils.addVersionParameters(swaggerOperation, versioningProperties.getParameterNames(), false);
            }
            if (versioningProperties.isHeaderEnabled()) {
                ParamUtils.addVersionParameters(swaggerOperation, versioningProperties.getHeaderNames(), true);
            }
        }
        if ((endpointInfosMap = Utils.getEndpointInfos()) == null) {
            endpointInfosMap = new HashMap<String, List<EndpointInfo>>();
            Utils.setEndpointInfos(endpointInfosMap);
        }
        List endpointInfos = endpointInfosMap.computeIfAbsent(methodKey, k -> new ArrayList());
        endpointInfos.add(new EndpointInfo(url, httpMethod, methodEl, swaggerOperation, version, groups, excludedGroups));
    }

    public static void processGroups(Map<String, EndpointGroupInfo> groups, List<String> excludedGroups, List<AnnotationValue<OpenAPIGroup>> annotationValues, Map<String, GroupProperties> groupPropertiesMap) {
        if (CollectionUtils.isEmpty(annotationValues)) {
            return;
        }
        for (AnnotationValue<OpenAPIGroup> groupAnn : annotationValues) {
            excludedGroups.addAll(List.of(groupAnn.stringValues("exclude")));
            List extensionAnns = groupAnn.getAnnotations("extensions");
            for (String groupName : groupAnn.stringValues("value")) {
                EndpointGroupInfo groupInfo;
                HashMap<String, Object> extensions = new HashMap<String, Object>();
                if (CollectionUtils.isNotEmpty((Collection)extensionAnns)) {
                    for (Object extensionAnn : extensionAnns) {
                        SchemaUtils.processExtensions(extensions, (AnnotationValue<Extension>)((AnnotationValue)extensionAnn));
                    }
                }
                if ((groupInfo = groups.get(groupName)) == null) {
                    groupInfo = new EndpointGroupInfo(groupName);
                    groups.put(groupName, groupInfo);
                }
                groupInfo.getExtensions().putAll(extensions);
            }
        }
        Set<String> allKnownGroups = Utils.getAllKnownGroups();
        allKnownGroups.addAll(groups.keySet());
        allKnownGroups.addAll(excludedGroups);
    }

    public static void processGroupsFromIncludedEndpoints(Map<String, EndpointGroupInfo> groups, List<String> excludedGroups, String className) {
        if (CollectionUtils.isEmpty(Utils.getIncludedClassesGroups()) && CollectionUtils.isEmpty(Utils.getIncludedClassesGroupsExcluded())) {
            return;
        }
        List<String> classGroups = Utils.getIncludedClassesGroups() != null ? Utils.getIncludedClassesGroups().get(className) : Collections.emptyList();
        List classExcludedGroups = Utils.getIncludedClassesGroupsExcluded() != null ? Utils.getIncludedClassesGroupsExcluded().get(className) : Collections.emptyList();
        for (String classGroup : classGroups) {
            if (groups.containsKey(classGroup)) continue;
            groups.put(classGroup, new EndpointGroupInfo(classGroup));
        }
        excludedGroups.addAll(classExcludedGroups);
        Set<String> allKnownGroups = Utils.getAllKnownGroups();
        allKnownGroups.addAll(classGroups);
        allKnownGroups.addAll(classExcludedGroups);
    }
}

