/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.scan.DefaultClassPathResourceLoader;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.OpenApiUtils;
import io.micronaut.openapi.annotation.OpenAPIGroupInfo;
import io.micronaut.openapi.annotation.OpenAPIGroupInfos;
import io.micronaut.openapi.postprocessors.JacksonDiscriminatorPostProcessor;
import io.micronaut.openapi.postprocessors.OpenApiOperationsPostProcessor;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.visitor.AbstractOpenApiVisitor;
import io.micronaut.openapi.visitor.AdocModule;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.FileUtils;
import io.micronaut.openapi.visitor.OpenApiConfigProperty;
import io.micronaut.openapi.visitor.OpenApiEndpointVisitor;
import io.micronaut.openapi.visitor.OpenApiExtraSchemaVisitor;
import io.micronaut.openapi.visitor.OpenApiGroupInfoVisitor;
import io.micronaut.openapi.visitor.OpenApiNormalizeUtils;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.SchemaDefinitionUtils;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.micronaut.openapi.visitor.SecurityUtils;
import io.micronaut.openapi.visitor.TagUtils;
import io.micronaut.openapi.visitor.Utils;
import io.micronaut.openapi.visitor.group.EndpointGroupInfo;
import io.micronaut.openapi.visitor.group.EndpointInfo;
import io.micronaut.openapi.visitor.group.GroupProperties;
import io.micronaut.openapi.visitor.group.OpenApiInfo;
import io.micronaut.openapi.visitor.management.EndpointProperties;
import io.micronaut.openapi.visitor.management.EndpointUtils;
import io.micronaut.openapi.visitor.management.EndpointsConfig;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.SpecVersion;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class OpenApiApplicationVisitor
extends AbstractOpenApiVisitor
implements TypeElementVisitor<Object, Object> {
    public static final String DEFAULT_OPENAPI_TITLE = "Service";
    public static final String DEFAULT_OPENAPI_VERSION = "1.0.0";
    public static final String DEFAULT_DOCUMENT_TITLE = "OpenAPI";
    public static final String PREFIX_DUMMY_FILE = "dummy";
    private static final int MAX_ITERATIONS = 100;
    private ClassElement classElement;
    private int visitedElements = -1;

    public void start(VisitorContext context) {
        Utils.init(context);
    }

    public Set<String> getSupportedOptions() {
        return OpenApiConfigProperty.ALL;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        try {
            if (!ConfigUtils.isOpenApiEnabled(context) || !ConfigUtils.isSpecGenerationEnabled(context)) {
                return;
            }
            if (this.ignore(element)) {
                return;
            }
            this.incrementVisitedElements(context);
            ContextUtils.info("Generating OpenAPI Documentation", context);
            OpenAPI openApi = this.readOpenApi(element, context);
            SecurityUtils.processSecuritySchemes(element, context);
            List<io.swagger.v3.oas.models.tags.Tag> tagList = TagUtils.processOpenApiAnnotation((Element)element, context, Tag.class, io.swagger.v3.oas.models.tags.Tag.class, openApi.getTags());
            openApi.setTags(tagList);
            List<SecurityRequirement> securityRequirements = SecurityUtils.readSecurityRequirements((Element)element);
            if (openApi.getSecurity() != null) {
                securityRequirements.addAll(openApi.getSecurity());
            }
            openApi.setSecurity(securityRequirements);
            List<Server> servers = TagUtils.processOpenApiAnnotation((Element)element, context, io.swagger.v3.oas.annotations.servers.Server.class, Server.class, openApi.getServers());
            openApi.setServers(servers);
            OpenAPI existing = ContextUtils.get("io.micronaut.OPENAPI", OpenAPI.class, context);
            if (existing != null) {
                if (openApi.getInfo() != null) {
                    existing.setInfo(openApi.getInfo());
                }
                SchemaUtils.copyOpenApi(existing, openApi, false);
            } else {
                ContextUtils.put("io.micronaut.OPENAPI", openApi, context);
            }
            if (Utils.isTestMode()) {
                Utils.resolveOpenApi(context);
            }
            this.classElement = element;
        }
        catch (Exception e) {
            ContextUtils.warn("Error with processing class:\n" + Utils.printStackTrace(e), context, (Element)this.classElement);
        }
    }

    private boolean ignore(ClassElement element) {
        return !element.isAnnotationPresent(OpenAPIDefinition.class) && !element.isAnnotationPresent(OpenAPIGroupInfo.class) && !element.isAnnotationPresent(OpenAPIGroupInfos.class);
    }

    /*
     * WARNING - void declaration
     */
    private void mergeAdditionalOpenApiFiles(OpenAPI openApi, VisitorContext context) {
        List<String> additionalSwaggerFiles = ConfigUtils.getAdditionalFiles(context);
        if (CollectionUtils.isEmpty(additionalSwaggerFiles)) {
            return;
        }
        for (String string : additionalSwaggerFiles) {
            void var5_16;
            String string2 = string.trim();
            if (string2.startsWith("classpath:")) {
                void var5_10;
                Optional inOpt;
                DefaultClassPathResourceLoader resourceLoader = new DefaultClassPathResourceLoader(this.getClass().getClassLoader());
                String string3 = string2.substring("classpath:".length());
                if (string3.startsWith("/")) {
                    String string4 = string3.substring("/".length());
                }
                if ((inOpt = resourceLoader.getResourceAsStream((String)var5_10)).isEmpty()) {
                    ContextUtils.warn("Fail to load " + (String)var5_10, context);
                    continue;
                }
                try {
                    InputStream in = (InputStream)inOpt.get();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                        String openapiFile = FileUtils.readFile(reader);
                        boolean isYaml = FileUtils.isYaml(var5_10.toLowerCase());
                        ContextUtils.info("Reading OpenAPI " + (isYaml ? "YAML" : "JSON") + " file " + (String)var5_10, context);
                        OpenAPI parsedOpenApi = null;
                        try {
                            parsedOpenApi = (OpenAPI)(isYaml ? Utils.getYamlMapper() : Utils.getJsonMapper()).readValue(openapiFile, OpenAPI.class);
                        }
                        catch (IOException e) {
                            ContextUtils.warn("Unable to read file " + (String)var5_10 + ": " + e.getMessage(), context);
                        }
                        SchemaUtils.copyOpenApi(openApi, parsedOpenApi, ConfigUtils.getAdditionalFilesMergeMode(context) == ConfigUtils.MergeMode.REPLACE);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (IOException e) {
                    ContextUtils.warn("Fail to load " + (String)var5_10 + "\n" + Utils.printStackTrace(e), context);
                }
                continue;
            }
            if (string2.startsWith("project:")) {
                void var5_13;
                String string5 = string2.substring("project:".length());
                Object projectDir = "";
                Path projectPath = ConfigUtils.getProjectPath(context);
                if (projectPath != null) {
                    projectDir = projectPath.toString().replace("\\\\", "/").replace("\\", "/");
                }
                if (!((String)projectDir).endsWith("/")) {
                    projectDir = (String)projectDir + "/";
                }
                if (string5.startsWith("/")) {
                    String string6 = string5.substring("/".length());
                }
                String string7 = (String)projectDir + (String)var5_13;
            } else if (string2.startsWith("file:")) {
                String string8 = string2.substring("file:".length());
            }
            Path path = FileUtils.resolve(context, Path.of((String)var5_16, new String[0]));
            if (!Files.exists(path, new LinkOption[0])) {
                ContextUtils.warn(path + " does not exist", context);
                continue;
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                ContextUtils.info("Merging OpenAPI YAML and JSON files from location: " + path, context);
                AtomicBoolean foundAnyFile = new AtomicBoolean(false);
                try (DirectoryStream<Path> paths = Files.newDirectoryStream(path, p -> {
                    String pathStr = p.toString().toLowerCase();
                    return FileUtils.isYaml(pathStr) || FileUtils.isJson(pathStr);
                });){
                    foundAnyFile.set(true);
                    for (Path pathInDir : paths) {
                        this.readAndMergeAdditionalFile(pathInDir, openApi, context);
                    }
                }
                catch (IOException e) {
                    ContextUtils.warn("Unable to read  file from " + path + ": " + e.getMessage(), context);
                }
                if (foundAnyFile.get()) continue;
                ContextUtils.warn("Not found any OpenAPI YAML or JSON files in directory " + path, context);
                continue;
            }
            String pathStr = path.toString().toLowerCase();
            if (!FileUtils.isYaml(pathStr) && !FileUtils.isJson(pathStr)) {
                ContextUtils.warn("Unknown file type: " + path + ". Must be json, yaml or yml", context);
                return;
            }
            this.readAndMergeAdditionalFile(path, openApi, context);
        }
    }

    private void readAndMergeAdditionalFile(Path path, OpenAPI openApi, VisitorContext context) {
        boolean isYaml = FileUtils.isYaml(path.toString().toLowerCase());
        ContextUtils.info("Reading OpenAPI " + (isYaml ? "YAML" : "JSON") + " file " + path.getFileName(), context);
        OpenAPI parsedOpenApi = null;
        try {
            parsedOpenApi = (OpenAPI)(isYaml ? Utils.getYamlMapper() : Utils.getJsonMapper()).readValue(path.toFile(), OpenAPI.class);
        }
        catch (IOException e) {
            ContextUtils.warn("Unable to read file " + path.getFileName() + ": " + e.getMessage(), context);
        }
        SchemaUtils.copyOpenApi(openApi, parsedOpenApi, ConfigUtils.getAdditionalFilesMergeMode(context) == ConfigUtils.MergeMode.REPLACE);
    }

    private OpenAPI readOpenApi(ClassElement element, VisitorContext context) {
        List secRequirementAnns;
        AnnotationValue openApiDefAnn = element.findAnnotation(OpenAPIDefinition.class).orElse(null);
        if (openApiDefAnn == null) {
            OpenAPI openApi = new OpenAPI();
            if (Utils.isOpenapi31()) {
                openApi.openapi("3.1.0").jsonSchemaDialect(ConfigUtils.getJsonSchemaDialect(context)).specVersion(SpecVersion.V31);
            }
            return openApi;
        }
        OpenAPI openApi = SchemaDefinitionUtils.toValue(openApiDefAnn.getAnnotationName(), openApiDefAnn.getValues(), context, OpenAPI.class, null);
        if (openApi == null) {
            openApi = new OpenAPI();
        }
        if (Utils.isOpenapi31()) {
            openApi.openapi("3.1.0").jsonSchemaDialect(ConfigUtils.getJsonSchemaDialect(context)).specVersion(SpecVersion.V31);
        }
        if (CollectionUtils.isNotEmpty((Collection)(secRequirementAnns = openApiDefAnn.getAnnotations("security", io.swagger.v3.oas.annotations.security.SecurityRequirement.class)))) {
            ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>();
            for (AnnotationValue secRequirementAnn : secRequirementAnns) {
                securityRequirements.add(ConvertUtils.mapToSecurityRequirement((AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>)secRequirementAnn));
            }
            openApi.setSecurity(securityRequirements);
        }
        return openApi;
    }

    private void renderViews(String title, Map<Pair<String, String>, OpenApiInfo> openApiInfos, Path destinationDir, VisitorContext context) throws IOException {
        String viewSpecification = ConfigUtils.getConfigProperty("micronaut.openapi.views.spec", context);
        OpenApiViewConfig cfg = OpenApiViewConfig.fromSpecification(viewSpecification, openApiInfos, ConfigUtils.readOpenApiConfigFile(context), context);
        if (cfg.isEnabled()) {
            cfg.setTitle(title);
            if (CollectionUtils.isNotEmpty(openApiInfos)) {
                cfg.setSpecFile(openApiInfos.values().iterator().next().getSpecFilePath());
            }
            cfg.render(destinationDir, context);
        }
    }

    private void applyPropertyNamingStrategy(OpenAPI openApi, VisitorContext context) {
        PropertyNamingStrategies.NamingBase propertyNamingStrategy = ConfigUtils.getPropertyNamingStrategy(context);
        if (propertyNamingStrategy == null) {
            return;
        }
        ContextUtils.info("Using " + propertyNamingStrategy.getClass().getSimpleName() + " property naming strategy.", context);
        if (openApi.getComponents() == null || CollectionUtils.isEmpty((Map)openApi.getComponents().getSchemas())) {
            return;
        }
        for (Schema schema : openApi.getComponents().getSchemas().values()) {
            List required;
            Map properties = schema.getProperties();
            if (properties != null) {
                LinkedHashMap<String, Schema> newProps = new LinkedHashMap<String, Schema>(properties.size());
                for (Map.Entry entry : properties.entrySet()) {
                    newProps.put(propertyNamingStrategy.translate((String)entry.getKey()), (Schema)entry.getValue());
                }
                schema.setProperties(newProps);
            }
            if (!CollectionUtils.isNotEmpty((Collection)(required = schema.getRequired()))) continue;
            ArrayList<String> newRequired = new ArrayList<String>(required.size());
            for (String req : required) {
                newRequired.add(propertyNamingStrategy.translate(req));
            }
            schema.setRequired(newRequired);
        }
    }

    private void applyPropertyServerContextPath(OpenAPI openApi, VisitorContext context) {
        String serverContextPath = ConfigUtils.getConfigProperty("micronaut.openapi.server.context.path", context);
        if (StringUtils.isEmpty((CharSequence)serverContextPath)) {
            return;
        }
        ContextUtils.info("Applying server context path: " + serverContextPath + " to Paths.", context);
        Paths paths = openApi.getPaths();
        if (CollectionUtils.isEmpty((Map)paths)) {
            return;
        }
        Paths newPaths = new Paths();
        for (Map.Entry path : paths.entrySet()) {
            Object newPath;
            String mapping = (String)path.getKey();
            Object object = newPath = mapping.startsWith(serverContextPath) ? mapping : StringUtils.prependUri((String)serverContextPath, (String)mapping);
            if (!((String)newPath).startsWith("/") && !((String)newPath).startsWith("$")) {
                newPath = "/" + (String)newPath;
            }
            newPaths.addPathItem((String)newPath, (PathItem)path.getValue());
        }
        openApi.setPaths(newPaths);
    }

    public static JsonNode resolvePlaceholders(ArrayNode anode, UnaryOperator<String> propertyExpander) {
        for (int i = 0; i < anode.size(); ++i) {
            anode.set(i, OpenApiApplicationVisitor.resolvePlaceholders(anode.get(i), propertyExpander));
        }
        return anode;
    }

    public static JsonNode resolvePlaceholders(ObjectNode onode, UnaryOperator<String> propertyExpander) {
        if (onode.isEmpty()) {
            return onode;
        }
        ObjectNode newNode = onode.objectNode();
        Iterator i = onode.fields();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            newNode.set((String)propertyExpander.apply((String)entry.getKey()), OpenApiApplicationVisitor.resolvePlaceholders((JsonNode)entry.getValue(), propertyExpander));
        }
        return newNode;
    }

    public static JsonNode resolvePlaceholders(JsonNode node, UnaryOperator<String> propertyExpander) {
        if (node.isTextual()) {
            String text = node.textValue();
            if (text == null || text.isBlank()) {
                return node;
            }
            String newText = (String)propertyExpander.apply(text);
            return text.equals(newText) ? node : TextNode.valueOf((String)newText);
        }
        if (node.isArray()) {
            return OpenApiApplicationVisitor.resolvePlaceholders((ArrayNode)node, propertyExpander);
        }
        if (node.isObject()) {
            return OpenApiApplicationVisitor.resolvePlaceholders((ObjectNode)node, propertyExpander);
        }
        return node;
    }

    public static String expandProperties(String s, List<Pair<String, String>> properties, VisitorContext context) {
        if (StringUtils.isEmpty((CharSequence)s) || !s.contains("${")) {
            return s;
        }
        if (CollectionUtils.isNotEmpty(properties)) {
            for (Pair<String, String> entry : properties) {
                s = s.replaceAll(entry.getFirst(), entry.getSecond());
            }
        }
        return OpenApiApplicationVisitor.replacePlaceholders(s, context);
    }

    public static String replacePlaceholders(String value, VisitorContext context) {
        if (StringUtils.isEmpty((CharSequence)value) || !value.contains("${")) {
            return value;
        }
        if (CollectionUtils.isNotEmpty((Map)System.getProperties())) {
            for (Map.Entry<Object, Object> sysProp : System.getProperties().entrySet()) {
                value = value.replace("${" + sysProp.getKey().toString() + "}", sysProp.getValue().toString());
            }
        }
        for (Map.Entry<Object, Object> fileProp : ConfigUtils.readOpenApiConfigFile(context).entrySet()) {
            value = value.replace("${" + fileProp.getKey().toString() + "}", fileProp.getValue().toString());
        }
        Environment environment = ConfigUtils.getEnv(context);
        if (environment != null) {
            value = environment.getPlaceholderResolver().resolvePlaceholders(value).orElse(value);
        }
        return value;
    }

    private static OpenAPI resolvePropertyPlaceHolders(OpenAPI openApi, VisitorContext context) {
        List<Pair<String, String>> expandableProperties = ConfigUtils.getExpandableProperties(context);
        if (CollectionUtils.isNotEmpty(expandableProperties)) {
            ContextUtils.info("Expanding properties: " + expandableProperties, context);
        }
        JsonNode root = OpenApiApplicationVisitor.resolvePlaceholders((ObjectNode)Utils.getYamlMapper().convertValue((Object)openApi, ObjectNode.class), s -> OpenApiApplicationVisitor.expandProperties(s, expandableProperties, context));
        return (OpenAPI)Utils.getYamlMapper().convertValue((Object)root, OpenAPI.class);
    }

    public void finish(VisitorContext context) {
        try {
            if (!ConfigUtils.isOpenApiEnabled(context)) {
                return;
            }
            if (this.visitedElements == this.visitedElements(context)) {
                return;
            }
            Map<Pair<String, String>, OpenApiInfo> openApiInfos = null;
            String documentTitle = DEFAULT_DOCUMENT_TITLE;
            if (ConfigUtils.isSpecGenerationEnabled(context)) {
                String isJson;
                OpenAPI openApi = ContextUtils.get("io.micronaut.OPENAPI", OpenAPI.class, context);
                if (openApi == null) {
                    return;
                }
                this.processEndpoints(context);
                this.mergeMicronautEndpointInfos(openApi, context);
                openApiInfos = this.divideOpenapiByGroupsAndVersions(openApi, context);
                if (Utils.isTestMode()) {
                    Utils.setTestReferences(openApiInfos);
                }
                boolean isYaml = StringUtils.isEmpty((CharSequence)(isJson = ConfigUtils.getConfigProperty("micronaut.openapi.json.format", context))) || !isJson.equalsIgnoreCase("true");
                String ext = isYaml ? ".yml" : ".json";
                for (Map.Entry<Pair<String, String>, OpenApiInfo> entry : openApiInfos.entrySet()) {
                    OpenApiInfo openApiInfo = entry.getValue();
                    openApi = openApiInfo.getOpenApi();
                    openApi = this.postProcessOpenApi(openApi, context);
                    openApiInfo.setOpenApi(openApi);
                    if (Utils.isTestMode()) {
                        Utils.setTestReference(openApi);
                    }
                    Pair<String, String> titleAndFilename = FileUtils.calcFinalFilename(openApiInfo.getFilename(), openApiInfo, openApiInfos.size() == 1, ext, context);
                    documentTitle = titleAndFilename.getFirst();
                    openApiInfo.setFilename(titleAndFilename.getSecond());
                }
                this.writeYamlToFile(openApiInfos, documentTitle, context, isYaml);
            }
            this.generateViews(documentTitle, openApiInfos, context);
            this.visitedElements = this.visitedElements(context);
        }
        catch (Exception e) {
            ContextUtils.warn("Error:\n" + Utils.printStackTrace(e), context);
            throw e;
        }
    }

    private Map<Pair<String, String>, OpenApiInfo> divideOpenapiByGroupsAndVersions(OpenAPI openApi, VisitorContext context) {
        Map<String, List<EndpointInfo>> endpointInfosMap = Utils.getEndpointInfos();
        Set<String> allVersions = Utils.getAllKnownVersions();
        Set<String> allGroups = Utils.getAllKnownGroups();
        if (CollectionUtils.isEmpty(endpointInfosMap) || CollectionUtils.isEmpty(allVersions) && CollectionUtils.isEmpty(allGroups)) {
            return Collections.singletonMap(Pair.NULL_STRING_PAIR, new OpenApiInfo(openApi));
        }
        ArrayList<EndpointInfo> commonEndpoints = new ArrayList<EndpointInfo>();
        HashMap<Pair<String, String>, OpenApiInfo> result = new HashMap<Pair<String, String>, OpenApiInfo>();
        for (List<EndpointInfo> list : endpointInfosMap.values()) {
            for (EndpointInfo endpointInfo : list) {
                if (CollectionUtils.isEmpty(endpointInfo.getGroups()) && endpointInfo.getVersion() == null) {
                    commonEndpoints.add(endpointInfo);
                    continue;
                }
                for (EndpointGroupInfo endpointGroupInfo : endpointInfo.getGroups().values()) {
                    if (CollectionUtils.isNotEmpty(endpointInfo.getExcludedGroups()) && endpointInfo.getExcludedGroups().contains(endpointGroupInfo.getName())) continue;
                    OpenAPI newOpenApi = this.addOpenApiInfo(endpointGroupInfo.getName(), endpointInfo.getVersion(), openApi, result, context);
                    this.addOperation(endpointInfo, newOpenApi, endpointGroupInfo, context);
                }
                if (!CollectionUtils.isEmpty(endpointInfo.getGroups())) continue;
                OpenAPI newOpenApi = this.addOpenApiInfo(null, endpointInfo.getVersion(), openApi, result, context);
                this.addOperation(endpointInfo, newOpenApi, null, context);
            }
        }
        for (Map.Entry entry : result.entrySet()) {
            String group = (String)((Pair)entry.getKey()).getFirst();
            GroupProperties groupProperties = ConfigUtils.getGroupProperties(group, context);
            if (groupProperties != null && groupProperties.getCommonExclude() != null && groupProperties.getCommonExclude().booleanValue()) continue;
            OpenAPI groupOpenApi = ((OpenApiInfo)entry.getValue()).getOpenApi();
            for (EndpointInfo commonEndpoint : commonEndpoints) {
                if (CollectionUtils.isNotEmpty(commonEndpoint.getExcludedGroups()) && commonEndpoint.getExcludedGroups().contains(group)) continue;
                this.addOperation(commonEndpoint, groupOpenApi, null, context);
            }
        }
        return result;
    }

    private void addOperation(EndpointInfo endpointInfo, OpenAPI openApi, @Nullable EndpointGroupInfo endpointGroupInfo, VisitorContext context) {
        PathItem pathItem;
        Operation operation;
        if (openApi == null) {
            return;
        }
        Paths paths = openApi.getPaths();
        if (paths == null) {
            paths = new Paths();
            openApi.setPaths(paths);
        }
        if ((operation = SchemaUtils.getOperationOnPathItem(pathItem = (PathItem)paths.computeIfAbsent((Object)endpointInfo.getUrl(), pathUrl -> new PathItem()), endpointInfo.getHttpMethod())) == null) {
            Operation opCopy = null;
            try {
                opCopy = (Operation)OpenApiUtils.getJsonMapper().treeToValue((TreeNode)OpenApiUtils.getJsonMapper().valueToTree((Object)endpointInfo.getOperation()), Operation.class);
                if (endpointGroupInfo != null) {
                    this.addExtensions(opCopy, endpointGroupInfo.getExtensions());
                }
            }
            catch (JsonProcessingException e) {
                ContextUtils.warn("Error\n" + Utils.printStackTrace(e), context);
            }
            SchemaUtils.setOperationOnPathItem(pathItem, endpointInfo.getHttpMethod(), opCopy != null ? opCopy : endpointInfo.getOperation());
            return;
        }
        Operation mergedOp = SchemaUtils.mergeOperations(operation, endpointInfo.getOperation());
        if (endpointGroupInfo != null) {
            this.addExtensions(mergedOp, endpointGroupInfo.getExtensions());
        }
        SchemaUtils.setOperationOnPathItem(pathItem, endpointInfo.getHttpMethod(), mergedOp);
    }

    private void addExtensions(Operation operation, Map<CharSequence, Object> extensions) {
        if (CollectionUtils.isEmpty(extensions)) {
            return;
        }
        for (Map.Entry<CharSequence, Object> ext : extensions.entrySet()) {
            operation.addExtension(ext.getKey().toString(), ext.getValue());
        }
    }

    private OpenAPI addOpenApiInfo(String groupName, String version, OpenAPI openApi, Map<Pair<String, String>, OpenApiInfo> openApiInfoMap, VisitorContext context) {
        OpenAPI newOpenApi;
        GroupProperties groupProperties = ConfigUtils.getGroupProperties(groupName, context);
        boolean hasGroupProperties = groupProperties != null;
        Pair<String, String> key = Pair.of(groupName, version);
        OpenApiInfo openApiInfo = openApiInfoMap.get(key);
        if (openApiInfo == null) {
            Map groupSecuritySchemes;
            OpenAPI openApiCopy;
            Map<String, OpenAPI> knownOpenApis = Utils.getOpenApis();
            newOpenApi = CollectionUtils.isNotEmpty(knownOpenApis) && knownOpenApis.containsKey(groupName) ? knownOpenApis.get(groupName) : new OpenAPI();
            openApiInfo = new OpenApiInfo(version, groupName, hasGroupProperties ? groupProperties.getDisplayName() : null, hasGroupProperties ? groupProperties.getFilename() : null, !hasGroupProperties || groupProperties.getAdocEnabled() == null || groupProperties.getAdocEnabled() != false, hasGroupProperties ? groupProperties.getAdocFilename() : null, newOpenApi);
            openApiInfoMap.put(key, openApiInfo);
            try {
                openApiCopy = (OpenAPI)Utils.getJsonMapper().treeToValue((TreeNode)Utils.getJsonMapper().valueToTree((Object)openApi), OpenAPI.class);
            }
            catch (JsonProcessingException e) {
                ContextUtils.warn("Error\n" + Utils.printStackTrace(e), context);
                return null;
            }
            if (CollectionUtils.isEmpty(knownOpenApis) || !knownOpenApis.containsKey(groupName)) {
                newOpenApi.setTags(openApiCopy.getTags());
                newOpenApi.setServers(openApiCopy.getServers());
                newOpenApi.setInfo(openApiCopy.getInfo());
                newOpenApi.setSecurity(openApiCopy.getSecurity());
                newOpenApi.setExternalDocs(openApiCopy.getExternalDocs());
                newOpenApi.setExtensions(openApiCopy.getExtensions());
            }
            Map map = groupSecuritySchemes = newOpenApi.getComponents() != null ? newOpenApi.getComponents().getSecuritySchemes() : null;
            if (CollectionUtils.isNotEmpty((Map)groupSecuritySchemes) && openApiCopy.getComponents() != null && CollectionUtils.isNotEmpty((Map)openApiCopy.getComponents().getSecuritySchemes())) {
                for (Map.Entry entry : openApiCopy.getComponents().getSecuritySchemes().entrySet()) {
                    if (groupSecuritySchemes.containsKey(entry.getKey())) continue;
                    groupSecuritySchemes.put((String)entry.getKey(), (SecurityScheme)entry.getValue());
                }
            }
            newOpenApi.setComponents(openApiCopy.getComponents());
            if (CollectionUtils.isNotEmpty((Map)groupSecuritySchemes)) {
                Utils.resolveComponents(newOpenApi).setSecuritySchemes(groupSecuritySchemes);
            }
        } else {
            newOpenApi = openApiInfo.getOpenApi();
        }
        return newOpenApi;
    }

    private void mergeMicronautEndpointInfos(OpenAPI openApi, VisitorContext context) {
        Map<String, List<EndpointInfo>> endpointInfosMap = Utils.getEndpointInfos();
        if (CollectionUtils.isEmpty(endpointInfosMap)) {
            return;
        }
        for (List<EndpointInfo> endpointInfos : endpointInfosMap.values()) {
            for (EndpointInfo endpointInfo : endpointInfos) {
                PathItem pathItem = (PathItem)openApi.getPaths().get((Object)endpointInfo.getUrl());
                Operation operation = SchemaUtils.getOperationOnPathItem(pathItem, endpointInfo.getHttpMethod());
                if (operation == null) {
                    SchemaUtils.setOperationOnPathItem(pathItem, endpointInfo.getHttpMethod(), endpointInfo.getOperation());
                    continue;
                }
                if (endpointInfo.getVersion() != null || !CollectionUtils.isEmpty(endpointInfo.getGroups())) continue;
                SchemaUtils.setOperationOnPathItem(pathItem, endpointInfo.getHttpMethod(), SchemaUtils.mergeOperations(operation, endpointInfo.getOperation()));
            }
        }
    }

    public int getOrder() {
        return 100;
    }

    private OpenAPI postProcessOpenApi(OpenAPI openApi, VisitorContext context) {
        this.fixInfoBlockIfNeeded(openApi, context);
        this.applyPropertyNamingStrategy(openApi, context);
        this.applyPropertyServerContextPath(openApi, context);
        OpenApiNormalizeUtils.normalizeOpenApi(openApi, context);
        OpenApiNormalizeUtils.normalizeOpenApi(openApi, context);
        new JacksonDiscriminatorPostProcessor().addMissingDiscriminatorType(openApi);
        new OpenApiOperationsPostProcessor().processOperations(openApi);
        OpenApiApplicationVisitor.removeUnusedSchemas(openApi);
        this.mergeAdditionalOpenApiFiles(openApi, context);
        OpenApiNormalizeUtils.removeEmptyComponents(openApi);
        OpenApiNormalizeUtils.findAndRemoveDuplicates(openApi);
        this.addExtraSchemas(openApi, context);
        openApi = OpenApiApplicationVisitor.resolvePropertyPlaceHolders(openApi, context);
        return openApi;
    }

    private void fixInfoBlockIfNeeded(OpenAPI openApi, VisitorContext context) {
        Info info;
        if (openApi.getInfo() == null) {
            openApi.setInfo(new Info());
        }
        if ((info = openApi.getInfo()).getTitle() == null) {
            String applicationName = ConfigUtils.getConfigProperty("micronaut.application.name", context);
            if (applicationName == null) {
                applicationName = ConfigUtils.getConfigProperty("spring.application.name", context);
            }
            info.setTitle(applicationName != null ? applicationName : DEFAULT_OPENAPI_TITLE);
        }
        if (info.getVersion() == null) {
            info.setVersion(DEFAULT_OPENAPI_VERSION);
        }
    }

    public static void removeUnusedSchemas(OpenAPI openApi) {
        for (int i = 0; OpenApiApplicationVisitor.removeUnusedSchemasIter(openApi) && i < 100; ++i) {
        }
    }

    public static boolean removeUnusedSchemasIter(OpenAPI openApi) {
        if (openApi.getComponents() == null) {
            return false;
        }
        Map schemas = openApi.getComponents().getSchemas();
        if (CollectionUtils.isEmpty((Map)schemas)) {
            return false;
        }
        Map<String, Schema> extraSchemas = OpenApiExtraSchemaVisitor.getExtraSchemas();
        boolean removed = false;
        try {
            String openApiJson = Utils.getJsonMapper().writeValueAsString((Object)openApi);
            HashSet keySet = new HashSet(schemas.keySet());
            for (String schemaName : keySet) {
                if (openApiJson.contains("\"#/components/schemas/" + schemaName + "\"") || extraSchemas.containsKey(schemaName)) continue;
                schemas.remove(schemaName);
                removed = true;
            }
            for (String schemaName : OpenApiExtraSchemaVisitor.getExcludedExtraSchemas()) {
                schemas.remove(schemaName);
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return removed;
    }

    private void addExtraSchemas(OpenAPI openApi, VisitorContext context) {
        Map<String, Schema> extraSchemas = OpenApiExtraSchemaVisitor.getExtraSchemas();
        if (CollectionUtils.isEmpty(extraSchemas)) {
            return;
        }
        Map<String, Schema> schemas = SchemaUtils.resolveSchemas(openApi);
        for (Map.Entry<String, Schema> entry : extraSchemas.entrySet()) {
            if (schemas.containsKey(entry.getKey())) continue;
            schemas.put(entry.getKey(), entry.getValue());
        }
    }

    private void generateViews(@Nullable String documentTitle, @Nullable Map<Pair<String, String>, OpenApiInfo> openApiInfos, VisitorContext context) {
        Path viewsDestDirs = FileUtils.getViewsDestDir(context);
        if (viewsDestDirs == null) {
            return;
        }
        String viewSpecification = ConfigUtils.getConfigProperty("micronaut.openapi.views.spec", context);
        OpenApiViewConfig cfg = OpenApiViewConfig.fromSpecification(viewSpecification, openApiInfos, ConfigUtils.readOpenApiConfigFile(context), context);
        if (!cfg.isEnabled()) {
            return;
        }
        if (context != null) {
            ContextUtils.info("Writing OpenAPI views to destination: " + viewsDestDirs, context);
            Path classesOutputPath = ContextUtils.getClassesOutputPath(context);
            if (classesOutputPath != null) {
                ContextUtils.addGeneratedResource(classesOutputPath.relativize(viewsDestDirs).toString(), context);
                ContextUtils.addGeneratedResource(classesOutputPath.relativize(viewsDestDirs.getParent()).toString(), context);
            }
        }
        try {
            this.renderViews(documentTitle, openApiInfos, viewsDestDirs, context);
        }
        catch (Exception e) {
            String swaggerFiles = "";
            if (openApiInfos != null) {
                swaggerFiles = openApiInfos.values().stream().map(OpenApiInfo::getSpecFilePath).collect(Collectors.joining(", ", "files ", ""));
            }
            ContextUtils.warn("Unable to render OpenAPI view: " + swaggerFiles + " - " + e.getMessage() + ".\n" + Utils.printStackTrace(e), context, (Element)this.classElement);
        }
    }

    private void writeYamlToFile(Map<Pair<String, String>, OpenApiInfo> openApiInfos, String documentTitle, VisitorContext context, boolean isYaml) {
        boolean isAdocModuleInClassPath = false;
        boolean isGlobalAdocEnabled = ConfigUtils.isAdocEnabled(context);
        try {
            Class.forName("io.micronaut.openapi.adoc.OpenApiToAdocConverter");
            isAdocModuleInClassPath = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ObjectMapper objectMapper = isYaml ? Utils.getYamlMapper() : Utils.getJsonMapper();
        for (OpenApiInfo openApiInfo : openApiInfos.values()) {
            Path specFile = FileUtils.openApiSpecFile(openApiInfo.getFilename(), context);
            try {
                Writer writer = this.getFileWriter(specFile);
                try {
                    objectMapper.writeValue(writer, (Object)openApiInfo.getOpenApi());
                    if (Utils.isTestMode()) {
                        Utils.setTestFileName(openApiInfo.getFilename());
                        if (isYaml) {
                            Utils.setTestYamlReference(writer.toString());
                        } else {
                            Utils.setTestJsonReference(writer.toString());
                        }
                    } else {
                        ContextUtils.info("Writing OpenAPI file to destination: " + specFile, context);
                        Path classesOutputPath = ContextUtils.getClassesOutputPath(context);
                        if (classesOutputPath != null) {
                            ContextUtils.addGeneratedResource(classesOutputPath.relativize(specFile).toString(), context);
                            ContextUtils.addGeneratedResource(classesOutputPath.relativize(specFile.getParent()).toString(), context);
                        }
                        openApiInfo.setSpecFilePath(specFile.getFileName().toString());
                    }
                    if (!isAdocModuleInClassPath || !isGlobalAdocEnabled || !openApiInfo.isAdocEnabled()) continue;
                    Map<String, String> adocProperties = ConfigUtils.getAdocProperties(openApiInfo, openApiInfos.size() == 1, context);
                    AdocModule.convert(openApiInfo, adocProperties, context);
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (Exception e) {
                ContextUtils.warn("Unable to generate swagger" + (isYaml ? ".yml" : ".json") + ": " + specFile + " - " + e.getMessage() + ".\n" + Utils.printStackTrace(e), context, (Element)this.classElement);
            }
        }
    }

    private Writer getFileWriter(Path specFile) throws IOException {
        if (Utils.isTestMode()) {
            return new StringWriter();
        }
        if (specFile != null) {
            return Files.newBufferedWriter(specFile, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        throw new IOException("OpenAPI spec file location is not present");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEndpoints(VisitorContext context) {
        if (!ConfigUtils.isEndpointsEnabled(context)) {
            return;
        }
        EndpointsConfig endpointsConfig = ConfigUtils.getEndpointsConfig(context);
        if (CollectionUtils.isEmpty(endpointsConfig.getEndpoints())) {
            return;
        }
        EndpointProperties allEndpointsProps = endpointsConfig.getEndpoints().get("all");
        boolean isAllEnabled = allEndpointsProps != null && allEndpointsProps.getEnabled() != null ? allEndpointsProps.getEnabled() : true;
        OpenApiEndpointVisitor visitor = new OpenApiEndpointVisitor(true);
        OpenApiGroupInfoVisitor groupVisitor = new OpenApiGroupInfoVisitor(endpointsConfig.getGroups(), endpointsConfig.getGroupsExcluded());
        for (EndpointProperties endpointProps : endpointsConfig.getEndpoints().values()) {
            ClassElement classEl;
            if (!isAllEnabled || endpointProps.getEnabled() != null && !endpointProps.getEnabled().booleanValue() || (classEl = endpointProps.getElement()) == null || !this.canProcessEndpoint(classEl, context)) continue;
            ArrayList<io.swagger.v3.oas.models.tags.Tag> tags = new ArrayList<io.swagger.v3.oas.models.tags.Tag>(endpointsConfig.getTags());
            tags.addAll(endpointProps.getTags());
            ContextUtils.put("micronaut.internal.openapi.endpoint.class.tags", tags, context);
            ArrayList<Server> servers = new ArrayList<Server>(endpointsConfig.getServers());
            servers.addAll(endpointProps.getServers());
            ContextUtils.put("micronaut.internal.openapi.endpoint.servers", servers, context);
            ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>(endpointsConfig.getSecurityRequirements());
            securityRequirements.addAll(endpointProps.getSecurityRequirements());
            ContextUtils.put("micronaut.internal.openapi.endpoint.security.requirements", securityRequirements, context);
            HashMap<String, Object> extensions = new HashMap<String, Object>(endpointsConfig.getExtensions());
            extensions.putAll(endpointProps.getExtensions());
            ContextUtils.put("micronaut.internal.openapi.endpoint.extensions", extensions, context);
            ContextUtils.put("micronaut.internal.openapi.endpoint.description", endpointProps.getDescription(), context);
            ContextUtils.put("micronaut.internal.openapi.endpoint.props", endpointProps, context);
            if ("prometheus".equals(endpointProps.getId())) {
                ContextUtils.put("micronaut.internal.endpoint.is-prometheus", true, context);
            }
            groupVisitor.visitClass(classEl, context);
            try {
                visitor.visitClass(classEl, context);
                for (MethodElement methodEl : classEl.getEnclosedElements(ElementQuery.ALL_METHODS.modifiers(mods -> !mods.contains(ElementModifier.STATIC) && !mods.contains(ElementModifier.PRIVATE)).named(name -> !name.contains("$")))) {
                    visitor.visitMethod(methodEl, context);
                }
            }
            catch (Exception e) {
                ContextUtils.warn("Can't process endpoint " + endpointProps.getId() + ". Skip it", context);
            }
            finally {
                ContextUtils.remove("micronaut.internal.endpoint.is-prometheus", context);
            }
        }
    }

    private boolean canProcessEndpoint(ClassElement classEl, VisitorContext context) {
        String classToCheck = EndpointUtils.SPECIFIC_ENDPOINTS.get(classEl.getName());
        if (classToCheck == null) {
            return true;
        }
        ClassElement checkedClassEl = ContextUtils.getClassElement(classToCheck, context);
        return checkedClassEl != null;
    }
}

