/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.MediaType;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.visitor.AbstractOpenApiEndpointVisitor;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.SecurityUtils;
import io.micronaut.openapi.visitor.TagUtils;
import io.micronaut.openapi.visitor.Utils;
import io.micronaut.openapi.visitor.management.EndpointProperties;
import io.micronaut.openapi.visitor.management.EndpointsConfig;
import io.micronaut.openapi.visitor.management.SpringActuatorUtils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.SupportedOptions;

@SupportedOptions(value={"micronaut.openapi.enabled"})
public class OpenApiEndpointVisitor
extends AbstractOpenApiEndpointVisitor
implements TypeElementVisitor<Object, Object> {
    private String id;
    private HttpMethodDescription methodDescription;
    private Boolean enabled;
    private String path;
    private String description;
    private Map<String, Object> extensions;
    private List<Server> servers;
    private List<io.swagger.v3.oas.models.tags.Tag> tags;
    private List<SecurityRequirement> securityRequirements;
    private List<AnnotationValue<Extension>> additionalExtensions;
    private List<AnnotationValue<Tag>> additionalTags;
    private List<AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>> additionalSecurityRequirements;

    public OpenApiEndpointVisitor() {
    }

    public OpenApiEndpointVisitor(boolean enabled) {
        this.enabled = enabled;
    }

    public OpenApiEndpointVisitor(boolean enabled, String description, List<AnnotationValue<Extension>> additionalExtensions, List<AnnotationValue<Tag>> additionalTags, List<AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>> additionalSecurityRequirements) {
        this.enabled = enabled;
        this.description = description;
        this.additionalExtensions = additionalExtensions;
        this.additionalTags = additionalTags;
        this.additionalSecurityRequirements = additionalSecurityRequirements;
    }

    public void start(VisitorContext context) {
        Utils.init(context);
    }

    @Override
    public void visitClass(ClassElement element, VisitorContext context) {
        if (!ConfigUtils.isOpenApiEnabled(context) || !ConfigUtils.isSpecGenerationEnabled(context)) {
            return;
        }
        EndpointsConfig endpointsConfig = ConfigUtils.getEndpointsConfig(context);
        if (this.enabled == null) {
            this.enabled = endpointsConfig.isEnabled();
        }
        if (this.path == null) {
            this.path = endpointsConfig.getPath();
            if (this.path == null) {
                String allEndpointsPath;
                String allEndpointsContextPath;
                EndpointProperties allEndpointsProps = endpointsConfig.getEndpoints().get("all");
                String string = allEndpointsContextPath = allEndpointsProps != null && StringUtils.isNotEmpty((CharSequence)allEndpointsProps.getContextPath()) ? allEndpointsProps.getContextPath() : null;
                if (allEndpointsContextPath != null) {
                    this.path = allEndpointsContextPath;
                }
                if (this.path != null && this.path.startsWith("/") && this.path.length() > 1) {
                    this.path = "/" + this.path;
                }
                String string2 = allEndpointsPath = allEndpointsProps != null && StringUtils.isNotEmpty((CharSequence)allEndpointsProps.getPath()) ? allEndpointsProps.getPath() : null;
                if (allEndpointsPath != null) {
                    String string3 = this.path = this.path != null ? StringUtils.prependUri((String)this.path, (String)allEndpointsPath) : allEndpointsPath;
                }
                if (this.path != null && this.path.endsWith("/") && this.path.length() > 1) {
                    this.path = this.path.substring(0, this.path.length() - 1);
                }
                if (this.path == null) {
                    this.path = "/";
                }
            }
        }
        if (this.ignore(element, context)) {
            return;
        }
        if (this.servers == null) {
            this.servers = endpointsConfig.getServers();
            if (this.servers == null) {
                this.servers = Collections.emptyList();
            }
        }
        if (this.tags == null) {
            this.tags = endpointsConfig.getTags();
            if (this.tags == null) {
                this.tags = Collections.emptyList();
            }
        }
        if (this.extensions == null) {
            this.extensions = endpointsConfig.getExtensions();
            if (this.extensions == null) {
                this.extensions = Collections.emptyMap();
            }
        }
        if (this.securityRequirements == null) {
            this.securityRequirements = endpointsConfig.getSecurityRequirements();
            if (this.securityRequirements == null) {
                this.securityRequirements = Collections.emptyList();
            }
        }
        if (this.additionalTags != null) {
            this.tags = new ArrayList<io.swagger.v3.oas.models.tags.Tag>(this.tags);
            this.tags.addAll(TagUtils.readTags(this.additionalTags, context));
        }
        if (this.additionalExtensions != null) {
            if (this.extensions == null) {
                this.extensions = this.readExtensions(this.additionalExtensions);
            } else {
                this.extensions.putAll(this.readExtensions(this.additionalExtensions));
            }
            if (this.extensions == null) {
                this.extensions = Collections.emptyMap();
            }
        }
        if (this.additionalSecurityRequirements != null) {
            if (this.securityRequirements == null) {
                this.securityRequirements = SecurityUtils.readSecurityRequirements(this.additionalSecurityRequirements);
            } else {
                this.securityRequirements = new ArrayList<SecurityRequirement>(this.securityRequirements);
                this.securityRequirements.addAll(SecurityUtils.readSecurityRequirements(this.additionalSecurityRequirements));
            }
        }
        super.visitClass(element, context);
    }

    @Override
    protected boolean ignore(ClassElement element, VisitorContext context) {
        EndpointProperties endpointProps;
        Object endpointPath;
        if (this.enabled != null && !this.enabled.booleanValue()) {
            return true;
        }
        AnnotationValue ann = null;
        if (element.isAnnotationPresent("io.micronaut.management.endpoint.annotation.Endpoint")) {
            ann = element.getAnnotation("io.micronaut.management.endpoint.annotation.Endpoint");
        } else if (element.isAnnotationPresent("org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint")) {
            ann = element.getAnnotation("org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint");
        }
        if (ann == null) {
            return true;
        }
        String idAnn = ann.stringValue("id").orElse(ann.stringValue("value").orElse(null));
        if (StringUtils.isEmpty((CharSequence)idAnn)) {
            idAnn = NameUtils.hyphenate((String)element.getSimpleName());
        }
        Object object = endpointPath = (endpointProps = ContextUtils.get("micronaut.internal.openapi.endpoint.props", EndpointProperties.class, context)) != null && StringUtils.isNotEmpty((CharSequence)endpointProps.getPath()) ? endpointProps.getPath() : idAnn;
        if (this.path.endsWith("/") && ((String)endpointPath).startsWith("/")) {
            endpointPath = ((String)endpointPath).substring(1);
        } else if (!this.path.endsWith("/") && !((String)endpointPath).startsWith("/")) {
            endpointPath = "/" + (String)endpointPath;
        }
        this.id = this.path + (String)endpointPath;
        if (!this.id.startsWith("/")) {
            this.id = "/" + this.id;
        }
        return false;
    }

    @Override
    protected boolean ignore(MethodElement element, VisitorContext context) {
        if (this.enabled != null && !this.enabled.booleanValue()) {
            return true;
        }
        AnnotationValue operationAnn = element.getAnnotation(Operation.class);
        boolean isHidden = operationAnn != null && operationAnn.booleanValue("hidden").orElse(false) != false;
        AnnotationValue jsonAnySetterAnn = element.getAnnotation(JsonAnySetter.class);
        if (isHidden || element.isAnnotationPresent(Hidden.class) || jsonAnySetterAnn != null && jsonAnySetterAnn.booleanValue("enabled").orElse(true).booleanValue()) {
            return true;
        }
        this.methodDescription = OpenApiEndpointVisitor.httpMethodDescription(element, context);
        return this.methodDescription == null;
    }

    @Override
    protected HttpMethod httpMethod(MethodElement element) {
        return this.methodDescription != null ? this.methodDescription.httpMethod : null;
    }

    @Override
    protected List<UriMatchTemplate> uriMatchTemplates(MethodElement element, VisitorContext context) {
        UriMatchTemplate uriTemplate = UriMatchTemplate.of((String)this.id);
        for (ParameterElement param : element.getParameters()) {
            if (!param.hasAnnotation("io.micronaut.management.endpoint.annotation.Selector")) continue;
            uriTemplate = uriTemplate.nest((CharSequence)("/{" + param.getName() + "}"));
        }
        return Collections.singletonList(uriTemplate);
    }

    @Override
    protected List<MediaType> consumesMediaTypes(MethodElement element) {
        return OpenApiEndpointVisitor.mediaTypes(this.methodDescription.consumes);
    }

    @Override
    protected List<MediaType> producesMediaTypes(MethodElement element) {
        return OpenApiEndpointVisitor.mediaTypes(this.methodDescription.produces);
    }

    @Override
    protected String getClassDescription(VisitorContext context) {
        return null;
    }

    @Override
    protected String getMethodDescription(VisitorContext context) {
        String description = ContextUtils.get("micronaut.internal.openapi.endpoint.description", String.class, null, context);
        if (StringUtils.isNotEmpty((CharSequence)description)) {
            return description;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.description)) {
            return this.description;
        }
        return this.methodDescription.description;
    }

    @Override
    protected List<io.swagger.v3.oas.models.tags.Tag> getUserDefinedClassTags(ClassElement element, VisitorContext context) {
        ArrayList<io.swagger.v3.oas.models.tags.Tag> allTags = new ArrayList<io.swagger.v3.oas.models.tags.Tag>(this.tags);
        allTags.addAll(ContextUtils.get("micronaut.internal.openapi.endpoint.class.tags", ContextUtils.TAGS_LIST_ARGUMENT, Collections.emptyList(), context));
        return allTags;
    }

    @Override
    protected List<Server> methodServers(MethodElement element, VisitorContext context) {
        ArrayList<Server> servers = new ArrayList<Server>(this.servers);
        servers.addAll(ContextUtils.get("micronaut.internal.openapi.endpoint.servers", ContextUtils.SERVERS_LIST_ARGUMENT, Collections.emptyList(), context));
        return servers;
    }

    @Override
    protected Map<String, Object> operationExtensions(MethodElement element, VisitorContext context) {
        HashMap<String, Object> extensions = this.extensions != null ? new HashMap<String, Object>(this.extensions) : new HashMap();
        extensions.putAll(ContextUtils.get("micronaut.internal.openapi.endpoint.extensions", ContextUtils.EXTENSIONS_MAP_ARGUMENT, Collections.emptyMap(), context));
        return extensions;
    }

    @Override
    protected List<SecurityRequirement> methodSecurityRequirements(MethodElement element, VisitorContext context) {
        ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>(this.securityRequirements);
        securityRequirements.addAll(ContextUtils.get("micronaut.internal.openapi.endpoint.security.requirements", List.class, Collections.emptyList(), context));
        return securityRequirements;
    }

    public int getOrder() {
        return 40;
    }

    private static List<MediaType> mediaTypes(List<String> mediaTypes) {
        if (CollectionUtils.isEmpty(mediaTypes)) {
            return Utils.DEFAULT_MEDIA_TYPES;
        }
        return mediaTypes.stream().map(Utils::getMediaType).toList();
    }

    private static HttpMethodDescription httpMethodDescription(MethodElement element, VisitorContext context) {
        HttpMethodDescription httpMethodDescription = OpenApiEndpointVisitor.methodDescription(element, "io.micronaut.management.endpoint.annotation.Write", HttpMethod.POST, context);
        if (httpMethodDescription != null) {
            return httpMethodDescription;
        }
        httpMethodDescription = OpenApiEndpointVisitor.methodDescription(element, "io.micronaut.management.endpoint.annotation.Read", HttpMethod.GET, context);
        if (httpMethodDescription != null) {
            return httpMethodDescription;
        }
        httpMethodDescription = OpenApiEndpointVisitor.methodDescription(element, "io.micronaut.management.endpoint.annotation.Delete", HttpMethod.DELETE, context);
        if (httpMethodDescription != null) {
            return httpMethodDescription;
        }
        httpMethodDescription = OpenApiEndpointVisitor.methodDescription(element, "org.springframework.boot.actuate.endpoint.annotation.WriteOperation", HttpMethod.POST, context);
        if (httpMethodDescription != null) {
            return httpMethodDescription;
        }
        httpMethodDescription = OpenApiEndpointVisitor.methodDescription(element, "org.springframework.boot.actuate.endpoint.annotation.ReadOperation", HttpMethod.GET, context);
        if (httpMethodDescription != null) {
            return httpMethodDescription;
        }
        return OpenApiEndpointVisitor.methodDescription(element, "org.springframework.boot.actuate.endpoint.annotation.DeleteOperation", HttpMethod.DELETE, context);
    }

    private static HttpMethodDescription methodDescription(MethodElement element, String endpointManagementAnnName, HttpMethod httpMethod, VisitorContext context) {
        if (element.isAnnotationPresent(endpointManagementAnnName)) {
            AnnotationValue annotation = element.getAnnotation(endpointManagementAnnName);
            assert (annotation != null);
            List<String> produces = Arrays.asList(annotation.stringValues("produces"));
            List<String> consumes = Arrays.asList(annotation.stringValues("consumes"));
            if (CollectionUtils.isEmpty(produces) && CollectionUtils.isNotEmpty(produces = SpringActuatorUtils.getProducesFrom(context))) {
                consumes = produces;
            }
            return new HttpMethodDescription(httpMethod, annotation.stringValue("description").orElse(null), produces, consumes);
        }
        return null;
    }

    @Internal
    private record HttpMethodDescription(HttpMethod httpMethod, String description, List<String> produces, List<String> consumes) {
    }
}

