/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.annotation.OpenAPIExtraSchema;
import io.micronaut.openapi.annotation.OpenAPIExtraSchemas;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.SchemaDefinitionUtils;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.SupportedOptions;

@Internal
@SupportedOptions(value={"micronaut.openapi.enabled"})
public class OpenApiExtraSchemaVisitor
implements TypeElementVisitor<OpenAPIExtraSchemas, Object> {
    private static Map<String, Schema> extraSchemas = new LinkedHashMap<String, Schema>();
    private static Map<String, String> extraSchemaClassnamesToNames = new LinkedHashMap<String, String>();
    private static Set<String> excludedExtraSchemaClassNames = new LinkedHashSet<String>();
    private static Set<String> excludedExtraSchemas = new LinkedHashSet<String>();
    private static Set<String> excludedExtraSchemaPackages = new LinkedHashSet<String>();

    public Set<String> getSupportedAnnotationNames() {
        return CollectionUtils.setOf((Object[])new String[]{OpenAPIExtraSchema.class.getName(), OpenAPIExtraSchemas.class.getName()});
    }

    public void start(VisitorContext context) {
        Utils.init(context);
    }

    public void finish(VisitorContext context) {
        if (!(ConfigUtils.isOpenApiEnabled(context) && ConfigUtils.isSpecGenerationEnabled(context) && ConfigUtils.isExtraSchemasEnabled(context))) {
            return;
        }
        for (String excludedExtraSchemaPackage : excludedExtraSchemaPackages) {
            for (Map.Entry<String, String> entry : extraSchemaClassnamesToNames.entrySet()) {
                this.addToExcludeExtraSchema(entry.getKey(), excludedExtraSchemaPackage, context);
            }
            for (Map.Entry<String, String> entry : SchemaDefinitionUtils.getSchemaNameToClassNameMap().entrySet()) {
                this.addToExcludeExtraSchema(entry.getValue(), excludedExtraSchemaPackage, context);
            }
        }
        for (String excludedExtraSchemaClassName : excludedExtraSchemaClassNames) {
            String schemaName = extraSchemaClassnamesToNames.get(excludedExtraSchemaClassName);
            if (schemaName == null) {
                for (Map.Entry<String, String> entry : SchemaDefinitionUtils.getSchemaNameToClassNameMap().entrySet()) {
                    if (!entry.getValue().equals(excludedExtraSchemaClassName)) continue;
                    schemaName = entry.getKey();
                    break;
                }
            }
            if (schemaName == null) continue;
            extraSchemas.remove(schemaName);
            excludedExtraSchemas.add(schemaName);
        }
    }

    private void addToExcludeExtraSchema(String className, String excludedExtraSchemaPackage, VisitorContext context) {
        ClassElement classEl = ContextUtils.getClassElement(className, context);
        if (classEl != null && classEl.getPackageName().equals(excludedExtraSchemaPackage)) {
            excludedExtraSchemaClassNames.add(className);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        if (!(ConfigUtils.isOpenApiEnabled(context) && ConfigUtils.isSpecGenerationEnabled(context) && ConfigUtils.isExtraSchemasEnabled(context))) {
            return;
        }
        for (AnnotationValue extraSchemaAnn : element.getAnnotationValuesByType(OpenAPIExtraSchema.class)) {
            Object[] classes = extraSchemaAnn.stringValues();
            Object[] excludeClasses = extraSchemaAnn.stringValues("excludeClasses");
            Object[] excludeClassNames = extraSchemaAnn.stringValues("excludeClassNames");
            Object[] packages = extraSchemaAnn.stringValues("packages");
            Object[] excludePackages = extraSchemaAnn.stringValues("excludePackages");
            if (ArrayUtils.isEmpty((Object[])classes) && ArrayUtils.isEmpty((Object[])excludeClasses) && ArrayUtils.isEmpty((Object[])excludeClassNames) && ArrayUtils.isEmpty((Object[])packages) && ArrayUtils.isEmpty((Object[])excludePackages)) {
                this.processExtraSchemaClass(element, context);
                continue;
            }
            if (ArrayUtils.isNotEmpty((Object[])excludeClasses)) {
                excludedExtraSchemaClassNames.addAll(Arrays.asList(excludeClasses));
            }
            if (ArrayUtils.isNotEmpty((Object[])excludeClassNames)) {
                excludedExtraSchemaClassNames.addAll(Arrays.asList(excludeClassNames));
            }
            if (ArrayUtils.isNotEmpty((Object[])excludePackages)) {
                excludedExtraSchemaPackages.addAll(Arrays.asList(excludePackages));
            }
            if (ArrayUtils.isNotEmpty((Object[])packages)) {
                for (Object packageName : packages) {
                    ClassElement[] classEls;
                    if (((String)packageName).endsWith(".*")) {
                        packageName = ((String)packageName).substring(0, ((String)packageName).length() - 2);
                    }
                    for (ClassElement classEl : classEls = ContextUtils.getClassElements((String)packageName, context)) {
                        this.processExtraSchemaClass(classEl, context);
                    }
                }
            }
            if (!ArrayUtils.isNotEmpty((Object[])classes)) continue;
            for (Object className : classes) {
                ClassElement classEl = ContextUtils.getClassElement((String)className, context);
                this.processExtraSchemaClass(classEl, context);
            }
        }
    }

    private void processExtraSchemaClass(ClassElement classEl, VisitorContext context) {
        if (classEl == null) {
            return;
        }
        String nameFromAnn = SchemaDefinitionUtils.getNameFromAnn((Element)classEl);
        String schemaName = SchemaDefinitionUtils.computeDefaultSchemaName(nameFromAnn, null, (Element)classEl, classEl.getTypeArguments(), context, null);
        Schema schema = SchemaDefinitionUtils.getSchemaDefinition(Utils.resolveOpenApi(context), context, classEl, classEl.getTypeArguments(), null, Collections.emptyList(), null);
        if (schema == null) {
            return;
        }
        if (schema.get$ref().equals("#/components/schemas/" + schemaName)) {
            Map<String, Schema> schemas = SchemaUtils.resolveSchemas(Utils.resolveOpenApi(context));
            schema = schemas.get(schemaName);
        }
        extraSchemas.put(schemaName, schema);
        extraSchemaClassnamesToNames.put(classEl.getName(), schemaName);
    }

    public static Map<String, Schema> getExtraSchemas() {
        return extraSchemas;
    }

    public static Collection<String> getExcludedExtraSchemas() {
        return excludedExtraSchemas;
    }

    public static void clean() {
        extraSchemas = new LinkedHashMap<String, Schema>();
        extraSchemaClassnamesToNames = new LinkedHashMap<String, String>();
        excludedExtraSchemaClassNames = new LinkedHashSet<String>();
        excludedExtraSchemas = new LinkedHashSet<String>();
        excludedExtraSchemaPackages = new LinkedHashSet<String>();
    }
}

