/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.PathMatcher;
import io.micronaut.http.HttpMethod;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.Utils;
import io.micronaut.openapi.visitor.security.InterceptUrlMapPattern;
import io.micronaut.openapi.visitor.security.SecurityProperties;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Internal
public final class SecurityUtils {
    private SecurityUtils() {
    }

    public static void readSecurityRequirements(MethodElement element, HttpMethod httpMethod, String path, Operation operation, List<SecurityRequirement> securityRequirements, VisitorContext context) {
        if (CollectionUtils.isNotEmpty(securityRequirements)) {
            for (SecurityRequirement securityItem : securityRequirements) {
                operation.addSecurityItem(securityItem);
            }
            return;
        }
        SecurityUtils.processMicronautSecurityConfig(element, httpMethod, path, operation, context);
    }

    private static void processMicronautSecurityConfig(MethodElement element, HttpMethod httpMethod, String path, Operation operation, VisitorContext context) {
        String securitySchemeName;
        SecurityProperties securityProperties = ConfigUtils.getSecurityProperties(context);
        if (!(securityProperties.isEnabled() && securityProperties.isMicronautSecurityEnabled() && (securityProperties.isTokenEnabled() || securityProperties.isJwtEnabled() || securityProperties.isBasicAuthEnabled() || securityProperties.isOauth2Enabled()))) {
            return;
        }
        OpenAPI openApi = Utils.resolveOpenApi(context);
        Components components = openApi.getComponents();
        if (components != null && CollectionUtils.isNotEmpty((Map)components.getSecuritySchemes())) {
            securitySchemeName = (String)components.getSecuritySchemes().keySet().iterator().next();
        } else {
            if (components == null) {
                components = new Components();
                openApi.setComponents(components);
            }
            if (components.getSecuritySchemes() == null) {
                components.setSecuritySchemes(new HashMap());
            }
            securitySchemeName = securityProperties.getDefaultSchemaName();
            SecurityScheme securityScheme = (SecurityScheme)components.getSecuritySchemes().get(securitySchemeName);
            if (securityScheme == null) {
                securityScheme = new SecurityScheme();
                if (securityProperties.isOauth2Enabled()) {
                    securityScheme.setType(SecurityScheme.Type.OAUTH2);
                } else if (securityProperties.isBasicAuthEnabled() || securityProperties.isTokenEnabled() || securityProperties.isJwtEnabled()) {
                    securityScheme.setType(SecurityScheme.Type.HTTP);
                    if (securityProperties.isJwtEnabled()) {
                        securityScheme.setBearerFormat("JWT");
                    }
                }
                if (securityProperties.isJwtEnabled() || securityProperties.isJwtBearerEnabled()) {
                    securityScheme.setScheme("bearer");
                } else if (securityProperties.isBasicAuthEnabled()) {
                    securityScheme.setScheme("basic");
                }
                components.addSecuritySchemes(securitySchemeName, securityScheme);
            }
        }
        AnnotationValue classLevelSecuredAnn = element.getOwningType().getAnnotation("io.micronaut.security.annotation.Secured");
        AnnotationValue methodLevelSecuredAnn = element.getAnnotation("io.micronaut.security.annotation.Secured");
        List access = Collections.emptyList();
        if (methodLevelSecuredAnn != null) {
            access = methodLevelSecuredAnn.getValue(Argument.LIST_OF_STRING).orElse(null);
        } else if (classLevelSecuredAnn != null) {
            access = classLevelSecuredAnn.getValue(Argument.LIST_OF_STRING).orElse(null);
        }
        SecurityUtils.processSecurityAccess(securitySchemeName, access, operation);
        List<InterceptUrlMapPattern> securityRules = securityProperties.getInterceptUrlMapPatterns();
        if (CollectionUtils.isNotEmpty(securityRules)) {
            for (InterceptUrlMapPattern securityRule : securityRules) {
                if (!PathMatcher.ANT.matches(securityRule.getPattern(), path) || httpMethod != null && securityRule.getHttpMethod() != null && httpMethod != securityRule.getHttpMethod()) continue;
                SecurityUtils.processSecurityAccess(securitySchemeName, securityRule.getAccess(), operation);
            }
        }
    }

    private static void processSecurityAccess(String securitySchemeName, List<String> access, Operation operation) {
        if (securitySchemeName == null || CollectionUtils.isEmpty(access)) {
            return;
        }
        String firstAccessItem = access.get(0);
        if (access.size() == 1 && (firstAccessItem.equals("isAnonymous()") || firstAccessItem.equals("denyAll()"))) {
            return;
        }
        if (access.size() == 1 && firstAccessItem.equals("isAuthenticated()")) {
            access = Collections.emptyList();
        }
        SecurityRequirement existedSecurityRequirement = null;
        List existedSecList = null;
        if (CollectionUtils.isNotEmpty((Collection)operation.getSecurity())) {
            for (SecurityRequirement securityRequirement : operation.getSecurity()) {
                if (!securityRequirement.containsKey((Object)securitySchemeName)) continue;
                existedSecList = (List)securityRequirement.get((Object)securitySchemeName);
                existedSecurityRequirement = securityRequirement;
                break;
            }
        }
        if (existedSecList != null) {
            if (access.isEmpty()) {
                return;
            }
            if (existedSecList.isEmpty()) {
                existedSecurityRequirement.put((Object)securitySchemeName, access);
            } else {
                HashSet<String> finalAccess = new HashSet<String>(existedSecList);
                finalAccess.addAll(access);
                existedSecurityRequirement.put((Object)securitySchemeName, new ArrayList(finalAccess));
            }
        } else {
            SecurityRequirement securityRequirement = new SecurityRequirement();
            securityRequirement.put((Object)securitySchemeName, access);
            operation.addSecurityItem(securityRequirement);
        }
    }

    public static List<SecurityRequirement> readSecurityRequirements(Element element) {
        return SecurityUtils.readSecurityRequirements(element.getAnnotationValuesByType(io.swagger.v3.oas.annotations.security.SecurityRequirement.class));
    }

    public static List<SecurityRequirement> readSecurityRequirements(List<AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>> annotations) {
        ArrayList<SecurityRequirement> result = new ArrayList<SecurityRequirement>(annotations.size());
        for (AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement> ann : annotations) {
            result.add(ConvertUtils.mapToSecurityRequirement(ann));
        }
        return result;
    }

    public static void processSecuritySchemes(ClassElement element, VisitorContext context) {
        List values = element.getAnnotationValuesByType(io.swagger.v3.oas.annotations.security.SecurityScheme.class);
        OpenAPI openApi = Utils.resolveOpenApi(context);
        ConvertUtils.addSecuritySchemes(openApi, values, context);
    }
}

