/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.javadoc;

import com.github.chhorz.javadoc.JavaDoc;
import com.github.chhorz.javadoc.JavaDocParser;
import com.github.chhorz.javadoc.JavaDocParserBuilder;
import com.github.chhorz.javadoc.OutputType;
import com.github.chhorz.javadoc.tags.BlockTag;
import com.github.chhorz.javadoc.tags.DeprecatedTag;
import com.github.chhorz.javadoc.tags.ParamTag;
import com.github.chhorz.javadoc.tags.PropertyTag;
import com.github.chhorz.javadoc.tags.ReturnTag;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.anchorlink.AnchorLinkExtension;
import com.vladsch.flexmark.ext.aside.AsideExtension;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.definition.DefinitionExtension;
import com.vladsch.flexmark.ext.emoji.EmojiExtension;
import com.vladsch.flexmark.ext.escaped.character.EscapedCharacterExtension;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.SubscriptExtension;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListExtension;
import com.vladsch.flexmark.ext.ins.InsExtension;
import com.vladsch.flexmark.ext.jekyll.front.matter.JekyllFrontMatterExtension;
import com.vladsch.flexmark.ext.superscript.SuperscriptExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.toc.SimTocExtension;
import com.vladsch.flexmark.ext.toc.TocExtension;
import com.vladsch.flexmark.ext.typographic.TypographicExtension;
import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.ext.yaml.front.matter.YamlFrontMatterExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.javadoc.DocsFormat;
import io.micronaut.openapi.javadoc.JavadocDescription;
import io.micronaut.openapi.visitor.ContextUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class JavadocParser {
    private static final String TAG_OPEN_P = "<p>";
    private static final String TAG_CLOSE_P = "</p>";
    private static final Set<String> IGNORED = CollectionUtils.setOf((Object[])new String[]{"see", "since", "author", "version", "throws", "exception", "category"});
    private final DocsFormat docsFormat;
    private final JavaDocParser javaDocParser;
    @Nullable
    private final VisitorContext context;
    private FlexmarkHtmlConverter htmlToMarkdownConverter;
    private Parser mdParser;
    private HtmlRenderer htmlRenderer;

    public JavadocParser(DocsFormat docsFormat) {
        this(docsFormat, null);
    }

    public JavadocParser(DocsFormat docsFormat, @Nullable VisitorContext context) {
        this.docsFormat = docsFormat;
        this.context = context;
        this.javaDocParser = JavaDocParserBuilder.withAllKnownTags().withOutputType(OutputType.HTML).build();
        List<Object> extensions = Collections.emptyList();
        if (docsFormat == DocsFormat.MD_TO_HTML || docsFormat == DocsFormat.HTML_TO_MD) {
            extensions = List.of(AbbreviationExtension.create(), AnchorLinkExtension.create(), AsideExtension.create(), AutolinkExtension.create(), DefinitionExtension.create(), EmojiExtension.create(), EscapedCharacterExtension.create(), FootnoteExtension.create(), SubscriptExtension.create(), TaskListExtension.create(), InsExtension.create(), JekyllFrontMatterExtension.create(), SuperscriptExtension.create(), TablesExtension.create(), SimTocExtension.create(), TocExtension.create(), TypographicExtension.create(), WikiLinkExtension.create(), YamlFrontMatterExtension.create());
        }
        if (docsFormat == DocsFormat.MD_TO_HTML) {
            this.htmlRenderer = ((HtmlRenderer.Builder)HtmlRenderer.builder().extensions(extensions)).build();
            this.mdParser = ((Parser.Builder)Parser.builder().extensions(extensions)).build();
        } else if (docsFormat == DocsFormat.HTML_TO_MD) {
            this.htmlToMarkdownConverter = ((FlexmarkHtmlConverter.Builder)FlexmarkHtmlConverter.builder().extensions(extensions)).build();
        }
    }

    public JavadocDescription parse(String text) {
        if (text == null) {
            return null;
        }
        JavaDoc javaDoc = this.javaDocParser.parse(text.strip());
        JavadocDescription javadocDescription = new JavadocDescription();
        javadocDescription.setMethodSummary(this.format(javaDoc.getSummary(), true));
        javadocDescription.setMethodDescription(this.format(javaDoc.getDescription()));
        if (CollectionUtils.isNotEmpty((Collection)javaDoc.getTags())) {
            for (BlockTag tag : javaDoc.getTags()) {
                if (IGNORED.contains(tag.getTagName())) continue;
                if (tag instanceof ReturnTag) {
                    ReturnTag returnTag = (ReturnTag)tag;
                    javadocDescription.setReturnDescription(this.format(returnTag.getDescription(), true));
                    continue;
                }
                if (tag instanceof ParamTag) {
                    ParamTag paramTag = (ParamTag)tag;
                    javadocDescription.getParameters().put(paramTag.getParamName(), this.format(paramTag.getParamDescription(), true));
                    continue;
                }
                if (tag instanceof PropertyTag) {
                    PropertyTag propertyTag = (PropertyTag)tag;
                    javadocDescription.getParameters().put(propertyTag.getPropertyName(), this.format(propertyTag.getParamDescription(), true));
                    continue;
                }
                if (!(tag instanceof DeprecatedTag)) continue;
                DeprecatedTag deprecatedTag = (DeprecatedTag)tag;
                javadocDescription.setDeprecatedDescription(this.format(deprecatedTag.getDeprecatedText(), true));
            }
        }
        return javadocDescription;
    }

    private String format(String text) {
        return this.format(text, false);
    }

    private String format(String text, boolean withRemoveP) {
        try {
            return switch (this.docsFormat) {
                default -> throw new IncompatibleClassChangeError();
                case DocsFormat.PLAIN -> text.strip();
                case DocsFormat.HTML_TO_MD -> this.htmlToMarkdownConverter.convert(text.strip()).trim();
                case DocsFormat.MD_TO_HTML -> {
                    String result = this.htmlRenderer.render((Node)this.mdParser.parse(text.strip())).trim();
                    if (withRemoveP && result.startsWith(TAG_OPEN_P)) {
                        result = result.substring(TAG_OPEN_P.length());
                        result = result.substring(0, result.indexOf(TAG_CLOSE_P));
                    }
                    yield result = result.replaceAll("&ldquo;|&rdquo;|&quot;", "\"");
                }
            };
        }
        catch (Exception e) {
            ContextUtils.warn("Error with converting javadoc: " + e.getMessage(), this.context);
            return text.strip();
        }
    }
}

