/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.view;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.view.AbstractViewConfig;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.group.OpenApiInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

public final class RapiPDFConfig
extends AbstractViewConfig {
    private static final String DEFAULT_RAPIPDF_JS_PATH = "res/";
    private static final List<String> RESOURCE_FILES = Collections.singletonList("res/rapipdf-min.js");
    private static final String SCRIPT_RAPIPDF = "script(contextPath + \"{{rapipdf.js.url.prefix}}rapipdf-min.js\", head)";
    private static final String TAG = "<rapi-pdf id='rapi-pdf' {{rapipdf.attributes}}></rapi-pdf>";
    private static final String SPEC = "document.getElementById('rapi-pdf').setAttribute('spec-url', contextPath + '{{specURL}}');";
    private static final Map<String, Object> DEFAULT_OPTIONS = new HashMap<String, Object>(6);
    private static final String DEFAULT_RAPIDOC_STYLE = "width: 122px;height: 26px;font-size: 15px;padding-bottom: 0px;padding-top: 5px;padding-left: 12px;margin-left: 12px";
    private static final String DEFAULT_REDOC_STYLE = "width: 122px;height: 26px;font-size: 15px;padding-bottom: 5px;padding-top: 5px;margin-left: 2px";
    private static final String DEFAULT_SWAGGER_UI_STYLE = "width: 122px;height: 26px;font-size: 15px;padding-bottom: 5px;padding-top: 5px;margin-left: 2px";
    private static final Map<String, Function<String, Object>> VALID_OPTIONS = new HashMap<String, Function<String, Object>>(18);
    boolean enabled;

    private RapiPDFConfig(Map<Pair<String, String>, OpenApiInfo> openApiInfos) {
        super("rapipdf.", openApiInfos);
        this.jsUrl = DEFAULT_RAPIPDF_JS_PATH;
        this.withFinalUrlPrefixCache = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    static RapiPDFConfig fromProperties(Map<String, String> properties, Map<Pair<String, String>, OpenApiInfo> openApiInfos, VisitorContext context) {
        RapiPDFConfig cfg = new RapiPDFConfig(openApiInfos);
        cfg.enabled = "true".equals(properties.getOrDefault("rapipdf.enabled", Boolean.FALSE.toString()));
        return AbstractViewConfig.fromProperties(cfg, DEFAULT_OPTIONS, properties, null, context);
    }

    String render(String template, OpenApiViewConfig.RendererType rendererType, VisitorContext context) {
        if (this.isEnabled()) {
            String style = (String)this.options.get("style");
            boolean styleUpdated = false;
            if (style == null || style.isBlank()) {
                styleUpdated = true;
                if (OpenApiViewConfig.RendererType.REDOC == rendererType) {
                    this.options.put("style", "width: 122px;height: 26px;font-size: 15px;padding-bottom: 5px;padding-top: 5px;margin-left: 2px");
                } else if (OpenApiViewConfig.RendererType.SWAGGER_UI == rendererType) {
                    this.options.put("style", "width: 122px;height: 26px;font-size: 15px;padding-bottom: 5px;padding-top: 5px;margin-left: 2px");
                } else {
                    this.options.put("style", DEFAULT_RAPIDOC_STYLE);
                }
            }
            String script = OpenApiViewConfig.replacePlaceHolder(SCRIPT_RAPIPDF, "rapipdf.js.url.prefix", this.isDefaultJsUrl ? this.getFinalUrlPrefix(rendererType, context) : this.jsUrl);
            String rapipdfTag = OpenApiViewConfig.replacePlaceHolder(TAG, "rapipdf.attributes", this.toHtmlAttributes());
            if (styleUpdated) {
                this.options.remove("style");
            }
            template = OpenApiViewConfig.replacePlaceHolder(template, "rapipdf.script", script);
            template = OpenApiViewConfig.replacePlaceHolder(template, "rapipdf.specurl", SPEC);
            return OpenApiViewConfig.replacePlaceHolder(template, "rapipdf.tag", rapipdfTag);
        }
        template = OpenApiViewConfig.replacePlaceHolder(template, "rapipdf.script", "");
        template = OpenApiViewConfig.replacePlaceHolder(template, "rapipdf.specurl", "");
        return OpenApiViewConfig.replacePlaceHolder(template, "rapipdf.tag", "");
    }

    @Override
    protected Function<String, Object> getConverter(String key) {
        return VALID_OPTIONS.get(key);
    }

    @Override
    protected List<String> getResources() {
        return RESOURCE_FILES;
    }

    @Override
    public String render(String template, @Nullable VisitorContext context) {
        throw new IllegalStateException("RapiPDF doesn't support render");
    }

    static {
        VALID_OPTIONS.put("style", AbstractViewConfig::asString);
        VALID_OPTIONS.put("button-label", AbstractViewConfig::asString);
        VALID_OPTIONS.put("button-bg", AbstractViewConfig::asString);
        VALID_OPTIONS.put("button-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("input-bg", AbstractViewConfig::asString);
        VALID_OPTIONS.put("input-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("hide-input", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("pdf-primary-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("pdf-alternate-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("pdf-title", AbstractViewConfig::asString);
        VALID_OPTIONS.put("pdf-footer-text", AbstractViewConfig::asString);
        VALID_OPTIONS.put("pdf-schema-style", new AbstractViewConfig.EnumConverter<SchemaStyle>(SchemaStyle.class));
        VALID_OPTIONS.put("include-info", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("include-toc", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("include-security", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("include-api-details", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("include-api-list", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("include-example", AbstractViewConfig::asBoolean);
        DEFAULT_OPTIONS.put("hide-input", Boolean.TRUE);
        DEFAULT_OPTIONS.put("button-bg", "#b44646");
        DEFAULT_OPTIONS.put("pdf-title", "{{title}}");
    }

    static enum SchemaStyle {
        OBJECT,
        TABLE;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

