/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.adoc.OpenApiToAdocConverter;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.FileUtils;
import io.micronaut.openapi.visitor.Utils;
import io.micronaut.openapi.visitor.group.OpenApiInfo;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;

public final class AdocModule {
    private AdocModule() {
    }

    public static void convert(OpenApiInfo openApiInfo, Map<String, String> props, VisitorContext context) {
        try {
            StringWriter writer = new StringWriter();
            OpenApiToAdocConverter.convert((OpenAPI)openApiInfo.getOpenApi(), props, (Writer)writer);
            String adoc = writer.toString();
            Path outputPath = AdocModule.getOutputPath(openApiInfo, props, context);
            ContextUtils.info("Writing AsciiDoc OpenAPI file to destination: " + String.valueOf(outputPath), context);
            Path classesOutputPath = ContextUtils.getClassesOutputPath(context);
            if (classesOutputPath != null) {
                ContextUtils.addGeneratedResource(classesOutputPath.relativize(outputPath).toString(), context);
            }
            if (Files.exists(outputPath, new LinkOption[0])) {
                Files.writeString(outputPath, (CharSequence)adoc, StandardOpenOption.APPEND);
            } else {
                Files.writeString(outputPath, (CharSequence)adoc, new OpenOption[0]);
            }
        }
        catch (Exception e) {
            ContextUtils.warn("Can't convert to ADoc format\n" + Utils.printStackTrace(e), context);
        }
    }

    private static Path getOutputPath(OpenApiInfo openApiInfo, Map<String, String> props, VisitorContext context) {
        Path outputPath;
        String outputDir;
        Object fileName = props.get("micronaut.openapi.adoc.output.filename");
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            String openApiFilename = openApiInfo.getFilename();
            if (openApiFilename.endsWith(".json") || openApiFilename.endsWith(".yml") || openApiFilename.endsWith(".yaml")) {
                fileName = openApiFilename.substring(0, openApiFilename.lastIndexOf(46));
            }
            fileName = (String)fileName + ".adoc";
        }
        if (StringUtils.isNotEmpty((CharSequence)(outputDir = props.get("micronaut.openapi.adoc.output.dir")))) {
            outputPath = FileUtils.resolve(context, Path.of(outputDir, new String[0]));
        } else {
            Path defaultFilePath = FileUtils.getDefaultFilePath((String)fileName, context);
            if (defaultFilePath == null) {
                ContextUtils.warn("Can't read defaultFilePath property", context);
                throw new RuntimeException("Can't read defaultFilePath property");
            }
            outputPath = defaultFilePath.getParent();
        }
        outputPath = outputPath.resolve((String)fileName);
        FileUtils.createDirectories(outputPath, context);
        return outputPath;
    }
}

