/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.util.NamingStrategyImpls;
import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.DefaultMutableConversionService;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.io.scan.DefaultClassPathResourceLoader;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.PathMatcher;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.OpenApiUtils;
import io.micronaut.openapi.javadoc.DocsFormat;
import io.micronaut.openapi.visitor.AnnProcessorEnvironment;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.FileUtils;
import io.micronaut.openapi.visitor.IncludeExcludeProperties;
import io.micronaut.openapi.visitor.OpenApiConfigProperty;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.micronaut.openapi.visitor.UrlUtils;
import io.micronaut.openapi.visitor.Utils;
import io.micronaut.openapi.visitor.group.GroupProperties;
import io.micronaut.openapi.visitor.group.OpenApiInfo;
import io.micronaut.openapi.visitor.group.RouterVersioningProperties;
import io.micronaut.openapi.visitor.management.EndpointProperties;
import io.micronaut.openapi.visitor.management.EndpointUtils;
import io.micronaut.openapi.visitor.management.EndpointsConfig;
import io.micronaut.openapi.visitor.management.SpringActuatorConfigUtils;
import io.micronaut.openapi.visitor.security.InterceptUrlMapConverter;
import io.micronaut.openapi.visitor.security.InterceptUrlMapPattern;
import io.micronaut.openapi.visitor.security.SecurityProperties;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.jsoup.helper.Validate;

@Internal
public final class ConfigUtils {
    public static final String ALL_ENDPOINTS_NAME = "all";
    public static final String ALL_SPRING_ACTUATOR_ENDPOINTS_NAME = "*";
    private static final String LOADED_POSTFIX = ".loaded";
    private static final String VALUE_POSTFIX = ".value";
    private static final List<String> DEFAULT_PREFIXES = List.of("");
    private static final List<String> DEFAULT_POSTFIXES = List.of("controller", "api", "endpoints", "endpoint");
    private static final String DEFAULT_SECURITY_SCHEMA_NAME = "Authorization";
    private static final TypeReference<Map<String, Object>> TYPE_EXTENSIONS = new TypeReference<Map<String, Object>>(){};
    private static final TypeReference<List<Server>> TYPE_SERVERS_LIST = new TypeReference<List<Server>>(){};
    private static final TypeReference<List<SecurityRequirement>> TYPE_SECURITY_REQUIREMENTS_LIST = new TypeReference<List<SecurityRequirement>>(){};

    private ConfigUtils() {
    }

    public static SchemaDecorator getSchemaDecoration(String packageName, VisitorContext context) {
        Map<String, SchemaDecorator> schemaDecorators = ContextUtils.get("micronaut.internal.schema-decorators", ContextUtils.ARGUMENT_SCHEMA_DECORATORS_MAP, context);
        if (schemaDecorators != null) {
            return schemaDecorators.get(packageName);
        }
        schemaDecorators = new HashMap<String, SchemaDecorator>();
        Properties sysProps = System.getProperties();
        ConfigUtils.readSchemaDecorators(sysProps, schemaDecorators, context);
        Properties fileProps = ConfigUtils.readOpenApiConfigFile(context);
        ConfigUtils.readSchemaDecorators(fileProps, schemaDecorators, context);
        Environment environment = ConfigUtils.getEnv(context);
        if (environment != null) {
            SchemaDecorator decorator;
            for (Map.Entry entry : environment.getProperties("micronaut.openapi.schema-prefix", StringConvention.RAW).entrySet()) {
                decorator = schemaDecorators.computeIfAbsent((String)entry.getKey(), k -> new SchemaDecorator());
                decorator.setPrefix((String)entry.getValue());
            }
            for (Map.Entry entry : environment.getProperties("micronaut.openapi.schema-postfix", StringConvention.RAW).entrySet()) {
                decorator = schemaDecorators.computeIfAbsent((String)entry.getKey(), k -> new SchemaDecorator());
                decorator.setPostfix((String)entry.getValue());
            }
            for (Map.Entry entry : environment.getProperties("micronaut.openapi.schema.decorator.prefix", StringConvention.RAW).entrySet()) {
                decorator = schemaDecorators.computeIfAbsent((String)entry.getKey(), k -> new SchemaDecorator());
                decorator.setPrefix((String)entry.getValue());
            }
            for (Map.Entry entry : environment.getProperties("micronaut.openapi.schema.decorator.postfix", StringConvention.RAW).entrySet()) {
                decorator = schemaDecorators.computeIfAbsent((String)entry.getKey(), k -> new SchemaDecorator());
                decorator.setPostfix((String)entry.getValue());
            }
        }
        ContextUtils.put("micronaut.internal.schema-decorators", schemaDecorators, context);
        return schemaDecorators.get(packageName);
    }

    public static ClassElement getCustomSchema(String className, Map<String, ClassElement> typeArgs, VisitorContext context) {
        Map<String, CustomSchema> customSchemas = ContextUtils.get("micronaut.internal.custom.schemas", ContextUtils.ARGUMENT_CUSTOM_SCHEMA_MAP, context);
        if (customSchemas != null) {
            String key = ConfigUtils.getClassNameWithGenerics(className, typeArgs);
            CustomSchema customSchema = customSchemas.get(key);
            if (customSchema != null) {
                return customSchema.classElement;
            }
            customSchema = customSchemas.get(className);
            return customSchema != null ? customSchema.classElement : null;
        }
        customSchemas = new HashMap<String, CustomSchema>();
        Properties sysProps = System.getProperties();
        ConfigUtils.readCustomSchemas(sysProps, customSchemas, context);
        Properties fileProps = ConfigUtils.readOpenApiConfigFile(context);
        ConfigUtils.readCustomSchemas(fileProps, customSchemas, context);
        Environment environment = ConfigUtils.getEnv(context);
        if (environment != null) {
            String targetClassName;
            String prop;
            String configuredClassName;
            for (Map.Entry entry : environment.getProperties("micronaut.openapi.schema", StringConvention.RAW).entrySet()) {
                configuredClassName = (String)entry.getKey();
                prop = "micronaut.openapi.schema." + configuredClassName;
                if (ConfigUtils.isMicronautProperty(prop)) continue;
                targetClassName = (String)entry.getValue();
                ConfigUtils.readCustomSchema(configuredClassName, targetClassName, customSchemas, context);
            }
            for (Map.Entry entry : environment.getProperties("micronaut.openapi.schema.mapping", StringConvention.RAW).entrySet()) {
                configuredClassName = (String)entry.getKey();
                prop = "micronaut.openapi.schema." + configuredClassName;
                if (ConfigUtils.isMicronautProperty(prop)) continue;
                targetClassName = (String)entry.getValue();
                ConfigUtils.readCustomSchema(configuredClassName, targetClassName, customSchemas, context);
            }
        }
        ContextUtils.put("micronaut.internal.custom.schemas", customSchemas, context);
        if (customSchemas.isEmpty()) {
            return null;
        }
        String key = ConfigUtils.getClassNameWithGenerics(className, typeArgs);
        CustomSchema customSchema = customSchemas.get(key);
        if (customSchema != null) {
            return customSchema.classElement;
        }
        customSchema = customSchemas.get(className);
        return customSchema != null ? customSchema.classElement : null;
    }

    private static boolean isMicronautProperty(String prop) {
        return prop.startsWith("micronaut.openapi.schema-prefix") || prop.startsWith("micronaut.openapi.schema-postfix") || prop.startsWith("micronaut.openapi.schema.decorator.prefix") || prop.startsWith("micronaut.openapi.schema.decorator.postfix") || prop.startsWith("micronaut.openapi.schema.name.separator.empty") || prop.startsWith("micronaut.openapi.schema.name.separator.generic") || prop.startsWith("micronaut.openapi.schema.name.separator.inner-class") || prop.startsWith("micronaut.openapi.schema.duplicate-resolution") || prop.startsWith("micronaut.openapi.schema.extra.enabled");
    }

    private static String getClassNameWithGenerics(String className, Map<String, ClassElement> typeArgs) {
        StringBuilder key = new StringBuilder(className);
        if (!typeArgs.isEmpty()) {
            key.append('<');
            boolean isFirst = true;
            for (ClassElement typeArg : typeArgs.values()) {
                if (!isFirst) {
                    key.append(',');
                }
                key.append(typeArg.getName());
                isFirst = false;
            }
            key.append('>');
        }
        return key.toString();
    }

    @NonNull
    public static String getServerContextPath(VisitorContext context) {
        String contextPath = ConfigUtils.getConfigProperty("micronaut.server.context-path", context);
        if (contextPath == null) {
            contextPath = ConfigUtils.getConfigProperty("server.servlet.context-path", context);
        }
        if (contextPath == null) {
            contextPath = ConfigUtils.getConfigProperty("spring.webflux.base-path", context);
        }
        if (contextPath == null) {
            contextPath = "";
        }
        return contextPath;
    }

    public static DuplicateResolution getSchemaDuplicateResolution(VisitorContext context) {
        String value = ConfigUtils.getConfigProperty("micronaut.openapi.schema.duplicate-resolution", context);
        if (StringUtils.isNotEmpty((CharSequence)value) && DuplicateResolution.ERROR.name().equalsIgnoreCase(value)) {
            return DuplicateResolution.ERROR;
        }
        return DuplicateResolution.AUTO;
    }

    public static boolean isConstructorArgumentsAsRequired(VisitorContext context) {
        return ConfigUtils.getBooleanProperty("micronaut.openapi.constructor-arguments-as-required", true, context);
    }

    public static boolean isResponseReadSuccessfulFromCode(VisitorContext context) {
        return ConfigUtils.getBooleanProperty("micronaut.openapi.response.read-successful-from-code", true, context);
    }

    public static boolean isOpenApiEnabled(VisitorContext context) {
        boolean value = ConfigUtils.getBooleanProperty("micronaut.openapi.enabled", true, context);
        System.setProperty("micronaut.openapi.enabled", Boolean.toString(value));
        return value;
    }

    public static boolean isSchemaNameSeparatorEmpty(VisitorContext context) {
        boolean value = ConfigUtils.getBooleanProperty("micronaut.openapi.schema.name.separator.empty", false, context);
        System.setProperty("micronaut.openapi.schema.name.separator.empty", Boolean.toString(value));
        return value;
    }

    public static String getGenericSeparator(VisitorContext context) {
        if (ConfigUtils.isSchemaNameSeparatorEmpty(context)) {
            return "";
        }
        String value = ConfigUtils.getConfigProperty("micronaut.openapi.schema.name.separator.generic", context);
        return StringUtils.isNotEmpty((CharSequence)value) ? value : "_";
    }

    public static String getInnerClassSeparator(VisitorContext context) {
        if (ConfigUtils.isSchemaNameSeparatorEmpty(context)) {
            return "";
        }
        String value = ConfigUtils.getConfigProperty("micronaut.openapi.schema.name.separator.inner-class", context);
        return StringUtils.isNotEmpty((CharSequence)value) ? value : ".";
    }

    public static String getJsonSchemaDialect(VisitorContext context) {
        String value = ConfigUtils.getConfigProperty("micronaut.openapi.openapi31.json-schema-dialect", context);
        return StringUtils.isNotEmpty((CharSequence)value) ? value : null;
    }

    public static boolean isSpecGenerationEnabled(VisitorContext context) {
        boolean value = ConfigUtils.getBooleanProperty("micronaut.openapi.swagger.file.generation.enabled", true, context);
        System.setProperty("micronaut.openapi.swagger.file.generation.enabled", Boolean.toString(value));
        return value;
    }

    public static boolean isTagGenerationByClassEnabled(VisitorContext context) {
        return ConfigUtils.getBooleanProperty("micronaut.openapi.tag.generation.by.class.enabled", false, context);
    }

    public static boolean isTagGenerationByPackageEnabled(VisitorContext context) {
        return ConfigUtils.getBooleanProperty("micronaut.openapi.tag.generation.by.package.enabled", false, context);
    }

    public static int getTagGenerationDescriptionMaxLength(VisitorContext context) {
        String descriptionLengthStr = ConfigUtils.getConfigProperty("micronaut.openapi.tag.generation.description.max.length", context);
        try {
            return Integer.parseInt(descriptionLengthStr);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static PropertyNamingStrategies.NamingBase getTagGenerationNamingStrategy(VisitorContext context) {
        String value = ConfigUtils.getConfigProperty("micronaut.openapi.tag.generation.naming.strategy", context);
        if (value == null) {
            return null;
        }
        try {
            return ConfigUtils.toJacksonStrategy(value.toUpperCase(Locale.ENGLISH), context);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<String> getTagGenerationRemovePrefixes(VisitorContext context) {
        return ConfigUtils.readTagGenerationProperty("micronaut.openapi.tag.generation.remove.prefixes", "micronaut.internal.tag.generation.remove.prefixes", DEFAULT_PREFIXES, context);
    }

    public static List<String> getTagGenerationRemovePostfixes(VisitorContext context) {
        return ConfigUtils.readTagGenerationProperty("micronaut.openapi.tag.generation.remove.postfixes", "micronaut.internal.tag.generation.remove.postfixes", DEFAULT_POSTFIXES, context);
    }

    private static List<String> readTagGenerationProperty(String configProp, String cacheProp, List<String> defaultVal, VisitorContext context) {
        List<String> result;
        List loadedValues = (List)ContextUtils.get(cacheProp, Argument.LIST_OF_STRING, context);
        if (loadedValues != null) {
            return loadedValues;
        }
        String configPropStr = ConfigUtils.getConfigProperty(configProp, context);
        if ("".equals(configPropStr)) {
            result = Collections.emptyList();
        } else if (configPropStr == null) {
            result = defaultVal;
        } else {
            String[] values;
            result = new ArrayList();
            for (String value : values = configPropStr.split(",")) {
                result.add(value.trim().toLowerCase(Locale.ENGLISH));
            }
        }
        ContextUtils.put(cacheProp, result, context);
        return result;
    }

    public static boolean isExtraSchemasEnabled(VisitorContext context) {
        return ConfigUtils.getBooleanProperty("micronaut.openapi.schema.extra.enabled", true, context);
    }

    public static boolean isJsonViewDefaultInclusion(VisitorContext context) {
        return ConfigUtils.getBooleanProperty("micronaut.openapi.json.view.default.inclusion", true, context);
    }

    public static boolean isGeneratorExtensionsEnabled(VisitorContext context) {
        return ConfigUtils.getBooleanProperty("micronaut.openapi.generator.extensions.enabled", true, context);
    }

    public static boolean isAdocEnabled(VisitorContext context) {
        return ConfigUtils.getBooleanProperty("micronaut.openapi.adoc.enabled", true, context);
    }

    public static boolean isJsonViewEnabled(VisitorContext context) {
        return ConfigUtils.getBooleanProperty("jackson.json-view.enabled", false, context);
    }

    public static boolean isEndpointsEnabled(VisitorContext context) {
        return ConfigUtils.getBooleanProperty("endpoints.enabled", false, context);
    }

    public static List<Pair<String, String>> getExpandableProperties(VisitorContext context) {
        String key;
        Boolean propertiesLoaded = ContextUtils.get("micronaut.internal.expandable.props.loaded", Boolean.class, context);
        if (propertiesLoaded != null) {
            return ContextUtils.get("micronaut.internal.expandable.props", ContextUtils.EXPANDABLE_PROPERTIES_ARGUMENT, context);
        }
        ArrayList<Pair<String, String>> expandableProperties = new ArrayList<Pair<String, String>>();
        String expandPrefix = "micronaut.openapi.expand.";
        AnnProcessorEnvironment env = (AnnProcessorEnvironment)ConfigUtils.getEnv(context);
        Map propertiesFromEnv = null;
        if (env != null) {
            try {
                propertiesFromEnv = env.getProperties(expandPrefix.substring(0, expandPrefix.length() - 1), null);
            }
            catch (Exception e) {
                ContextUtils.warn("Error:\n" + Utils.printStackTrace(e), context);
            }
        }
        HashMap<String, String> expandedPropsMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(propertiesFromEnv)) {
            for (Map.Entry entry : propertiesFromEnv.entrySet()) {
                expandedPropsMap.put((String)entry.getKey(), entry.getValue().toString());
            }
        }
        Properties openapiProps = ConfigUtils.readOpenApiConfigFile(context);
        for (Map.Entry<Object, Object> entry : openapiProps.entrySet()) {
            key = entry.getKey().toString();
            if (!key.startsWith(expandPrefix)) continue;
            expandedPropsMap.put(key, entry.getValue().toString());
        }
        if (CollectionUtils.isNotEmpty((Map)System.getProperties())) {
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                key = entry.getKey().toString();
                if (!key.startsWith(expandPrefix)) continue;
                expandedPropsMap.put(key, entry.getValue().toString());
            }
        }
        for (Map.Entry<Object, Object> entry : expandedPropsMap.entrySet()) {
            Pair<CallSite, String> prop;
            key = (String)entry.getKey();
            if (key.startsWith(expandPrefix)) {
                key = key.substring(expandPrefix.length());
            }
            if (expandableProperties.contains(prop = Pair.of("\\$\\{" + key + "}", (String)entry.getValue()))) continue;
            expandableProperties.add(prop);
        }
        ContextUtils.put("micronaut.internal.expandable.props", expandableProperties, context);
        ContextUtils.put("micronaut.internal.expandable.props.loaded", true, context);
        return expandableProperties;
    }

    public static Map<String, String> getAdocProperties(OpenApiInfo openApiInfo, boolean isSingleGroup, VisitorContext context) {
        String key;
        HashMap<String, String> adocProperties = new HashMap<String, String>();
        adocProperties.put("micronaut.openapi.adoc.template.dir", ConfigUtils.getConfigProperty("micronaut.openapi.adoc.template.dir", context));
        adocProperties.put("micronaut.openapi.adoc.template.filename", ConfigUtils.getConfigProperty("micronaut.openapi.adoc.template.filename", context));
        adocProperties.put("micronaut.openapi.adoc.output.dir", ConfigUtils.getConfigProperty("micronaut.openapi.adoc.output.dir", context));
        adocProperties.put("micronaut.openapi.adoc.output.filename", ConfigUtils.getConfigProperty("micronaut.openapi.adoc.output.filename", context));
        adocProperties.put("micronaut.openapi.adoc.openapi.path", ConfigUtils.getConfigProperty("micronaut.openapi.adoc.openapi.path", context));
        String expandPrefix = "micronaut.openapi.expand.";
        AnnProcessorEnvironment env = (AnnProcessorEnvironment)ConfigUtils.getEnv(context);
        Map propertiesFromEnv = null;
        if (env != null) {
            try {
                propertiesFromEnv = env.getProperties("micronaut.openapi.adoc.templates.".substring(0, "micronaut.openapi.adoc.templates.".length() - 1), null);
            }
            catch (Exception e) {
                ContextUtils.warn("Error:\n" + Utils.printStackTrace(e), context);
            }
        }
        if (CollectionUtils.isNotEmpty(propertiesFromEnv)) {
            for (Map.Entry entry : propertiesFromEnv.entrySet()) {
                adocProperties.put((String)entry.getKey(), entry.getValue().toString());
            }
        }
        Properties openapiProps = ConfigUtils.readOpenApiConfigFile(context);
        for (Map.Entry<Object, Object> entry : openapiProps.entrySet()) {
            key = entry.getKey().toString();
            if (!key.startsWith(expandPrefix)) continue;
            adocProperties.put(key, entry.getValue().toString());
        }
        if (CollectionUtils.isNotEmpty((Map)System.getProperties())) {
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                key = entry.getKey().toString();
                if (!key.startsWith(expandPrefix)) continue;
                adocProperties.put(key, entry.getValue().toString());
            }
        }
        String string = StringUtils.isNotEmpty((CharSequence)openApiInfo.getAdocFilename()) ? openApiInfo.getAdocFilename() : (String)adocProperties.get("micronaut.openapi.adoc.output.filename");
        Pair<String, String> titleAndFilename = FileUtils.calcFinalFilename(openApiInfo.getAdocFilename(), openApiInfo, isSingleGroup, "adoc", context);
        return adocProperties;
    }

    public static SecurityProperties getSecurityProperties(VisitorContext context) {
        SecurityProperties securityProperties = ContextUtils.get("micronaut.internal.security.properties", SecurityProperties.class, context);
        if (securityProperties != null) {
            return securityProperties;
        }
        Environment environment = ConfigUtils.getEnv(context);
        List<InterceptUrlMapPattern> interceptUrlMapPatterns = environment != null ? environment.get((CharSequence)"micronaut.security.intercept-url-map", Argument.listOf(InterceptUrlMapPattern.class)).orElse(Collections.emptyList()) : Collections.emptyList();
        String defaultSchemaName = ConfigUtils.getConfigProperty("micronaut.openapi.security.default-schema-name", context);
        if (StringUtils.isEmpty((CharSequence)defaultSchemaName)) {
            defaultSchemaName = DEFAULT_SECURITY_SCHEMA_NAME;
        }
        boolean tokenEnabled = ConfigUtils.getBooleanProperty("micronaut.security.token.enabled", false, context);
        securityProperties = new SecurityProperties(ConfigUtils.getBooleanProperty("micronaut.openapi.security.enabled", true, context), ConfigUtils.getBooleanProperty("micronaut.security.enabled", false, context), defaultSchemaName, interceptUrlMapPatterns, tokenEnabled, ConfigUtils.getBooleanProperty("micronaut.security.token.jwt.enabled", tokenEnabled, context), ConfigUtils.getBooleanProperty("micronaut.security.token.jwt.bearer", tokenEnabled, context), ConfigUtils.getBooleanProperty("micronaut.security.token.jwt.cookie.enabled", false, context), ConfigUtils.getBooleanProperty("micronaut.security.oauth2.enabled", false, context), ConfigUtils.getBooleanProperty("micronaut.security.basic-auth.enabled", false, context));
        ContextUtils.put("micronaut.internal.security.properties", securityProperties, context);
        return securityProperties;
    }

    public static RouterVersioningProperties getRouterVersioningProperties(VisitorContext context) {
        RouterVersioningProperties routerVersioningProperties = ContextUtils.get("micronaut.internal.router.versioning.properties", RouterVersioningProperties.class, context);
        if (routerVersioningProperties != null) {
            return routerVersioningProperties;
        }
        routerVersioningProperties = new RouterVersioningProperties(ConfigUtils.getBooleanProperty("micronaut.openapi.versioning.enabled", true, context), ConfigUtils.getBooleanProperty("micronaut.router.versioning.enabled", false, context), ConfigUtils.getBooleanProperty("micronaut.router.versioning.header.enabled", false, context), ConfigUtils.getListStringsProperty("micronaut.router.versioning.header.names", Collections.singletonList("X-API-VERSION"), context), ConfigUtils.getBooleanProperty("micronaut.router.versioning.parameter.enabled", false, context), ConfigUtils.getListStringsProperty("micronaut.router.versioning.parameter.names", Collections.singletonList("api-version"), context));
        ContextUtils.put("micronaut.internal.router.versioning.properties", routerVersioningProperties, context);
        return routerVersioningProperties;
    }

    public static List<String> getListStringsProperty(String property, List<String> defaultValue, VisitorContext context) {
        String strValue = System.getProperty(property);
        if (StringUtils.isEmpty((CharSequence)strValue)) {
            strValue = ConfigUtils.readOpenApiConfigFile(context).getProperty(property);
        }
        if (StringUtils.isNotEmpty((CharSequence)strValue)) {
            ArrayList<String> result = new ArrayList<String>();
            for (String item : strValue.split(",")) {
                result.add(item.strip());
            }
            return result;
        }
        Environment env = ConfigUtils.getEnv(context);
        if (env != null) {
            return env.get((CharSequence)property, Argument.LIST_OF_STRING).orElse(defaultValue);
        }
        return defaultValue;
    }

    public static GroupProperties getGroupProperties(String groupName, VisitorContext context) {
        if (groupName == null) {
            return null;
        }
        Map<String, GroupProperties> allGroupsProperties = ConfigUtils.getGroupsPropertiesMap(context);
        return CollectionUtils.isNotEmpty(allGroupsProperties) ? allGroupsProperties.get(groupName) : null;
    }

    public static Map<String, GroupProperties> getGroupsPropertiesMap(VisitorContext context) {
        if (context == null) {
            return Collections.emptyMap();
        }
        Map<String, GroupProperties> groupPropertiesMap = ContextUtils.get("micronaut.internal.groups", ContextUtils.ARGUMENT_GROUP_PROPERTIES_MAP, context);
        if (groupPropertiesMap != null) {
            return groupPropertiesMap;
        }
        groupPropertiesMap = new HashMap<String, GroupProperties>();
        Properties sysProps = System.getProperties();
        ConfigUtils.readGroupsProperties(sysProps, groupPropertiesMap, context);
        Properties fileProps = ConfigUtils.readOpenApiConfigFile(context);
        ConfigUtils.readGroupsProperties(fileProps, groupPropertiesMap, context);
        Environment environment = ConfigUtils.getEnv(context);
        if (environment != null) {
            for (Map.Entry entry : environment.getProperties("micronaut.openapi.groups", StringConvention.RAW).entrySet()) {
                String entryKey = (String)entry.getKey();
                String[] propParts = entryKey.split("\\.");
                String propName = propParts[propParts.length - 1];
                String groupName = entryKey.substring(0, entryKey.length() - propName.length() - 1);
                ConfigUtils.setGroupProperty(groupName, propName, entry.getValue(), groupPropertiesMap, context);
            }
        }
        Utils.getAllKnownGroups().addAll(groupPropertiesMap.keySet());
        ContextUtils.put("micronaut.internal.groups", groupPropertiesMap, context);
        return groupPropertiesMap;
    }

    private static void readGroupsProperties(Properties props, Map<String, GroupProperties> groupPropertiesMap, VisitorContext context) {
        for (String prop : props.stringPropertyNames()) {
            int groupNameIndexEnd;
            if (!prop.startsWith("micronaut.openapi.groups") || (groupNameIndexEnd = prop.indexOf(46, "micronaut.openapi.groups".length() + 1)) < 0) continue;
            String groupName = prop.substring("micronaut.openapi.groups".length() + 1, groupNameIndexEnd);
            String propertyName = prop.substring(groupNameIndexEnd + 1);
            String value = props.getProperty(prop);
            ConfigUtils.setGroupProperty(groupName, propertyName, value, groupPropertiesMap, context);
        }
    }

    private static void setGroupProperty(String groupName, String propertyName, Object value, Map<String, GroupProperties> groupPropertiesMap, VisitorContext context) {
        if (value == null) {
            return;
        }
        String valueStr = value.toString();
        GroupProperties groupProperties = groupPropertiesMap.computeIfAbsent(groupName, GroupProperties::new);
        switch (propertyName.toLowerCase(Locale.ENGLISH)) {
            case "display-name": 
            case "displayname": {
                if (groupProperties.getDisplayName() != null) break;
                groupProperties.setDisplayName(valueStr);
                break;
            }
            case "file-name": 
            case "filename": {
                if (groupProperties.getFilename() != null) break;
                groupProperties.setFilename(valueStr);
                break;
            }
            case "adoc-file-name": 
            case "adocfilename": {
                if (groupProperties.getAdocFilename() != null) break;
                groupProperties.setAdocFilename(valueStr);
                break;
            }
            case "adoc-enabled": 
            case "adocenabled": {
                if (groupProperties.getAdocEnabled() != null) break;
                groupProperties.setAdocEnabled(Boolean.valueOf(valueStr));
                break;
            }
            case "packages": {
                if (groupProperties.getPackages() != null) break;
                ArrayList<GroupProperties.PackageProperties> packages = new ArrayList<GroupProperties.PackageProperties>();
                for (String groupPackage : valueStr.split(",")) {
                    packages.add(ConfigUtils.getPackageProperties(groupPackage));
                }
                groupProperties.setPackages(packages);
                break;
            }
            case "primary": {
                if (groupProperties.getPrimary() != null) break;
                groupProperties.setPrimary(Boolean.valueOf(valueStr));
                break;
            }
            case "common-exclude": 
            case "commonexclude": {
                if (groupProperties.getCommonExclude() != null) break;
                groupProperties.setCommonExclude(Boolean.valueOf(valueStr));
                break;
            }
            case "packages-exclude": 
            case "packagesexclude": {
                if (groupProperties.getPackagesExclude() != null) break;
                ArrayList<GroupProperties.PackageProperties> packagesExclude = new ArrayList<GroupProperties.PackageProperties>();
                for (String groupPackage : valueStr.split(",")) {
                    packagesExclude.add(ConfigUtils.getPackageProperties(groupPackage));
                }
                groupProperties.setPackagesExclude(packagesExclude);
                break;
            }
        }
    }

    public static EndpointsConfig getEndpointsConfig(VisitorContext context) {
        EndpointsConfig endpointsConfig = ContextUtils.get("micronaut.internal.openapi.endpoints", EndpointsConfig.class, context);
        if (endpointsConfig != null) {
            return endpointsConfig;
        }
        endpointsConfig = new EndpointsConfig(ConfigUtils.isEndpointsEnabled(context));
        endpointsConfig.setPath(UrlUtils.parsePath(ConfigUtils.getConfigProperty("endpoints.path", context)));
        endpointsConfig.setTags(ConfigUtils.parseTags(ConfigUtils.getConfigProperty("endpoints.tags", context)));
        endpointsConfig.setServers(ConfigUtils.parseServers(ConfigUtils.getConfigProperty("endpoints.servers", context), context));
        endpointsConfig.setSecurityRequirements(ConfigUtils.parseSecurityRequirements(ConfigUtils.getConfigProperty("endpoints.security-requirements", context), context));
        endpointsConfig.setExtensions(ConfigUtils.parseExtensions(ConfigUtils.getConfigProperty("endpoints.extensions", context), context));
        endpointsConfig.setGroups(ConfigUtils.getListStringsProperty("endpoints.groups", Collections.emptyList(), context));
        endpointsConfig.setGroupsExcluded(ConfigUtils.getListStringsProperty("endpoints.groups-excluded", Collections.emptyList(), context));
        endpointsConfig.setEndpoints(ConfigUtils.endpointsProperties(context));
        SpringActuatorConfigUtils.mergeWithActuatorProperties(endpointsConfig, context);
        ContextUtils.put("micronaut.internal.openapi.endpoints", endpointsConfig, context);
        return endpointsConfig;
    }

    public static Map<String, EndpointProperties> endpointsProperties(VisitorContext context) {
        HashMap<String, EndpointProperties> endpointPropertiesMap = new HashMap<String, EndpointProperties>();
        Properties sysProps = System.getProperties();
        ConfigUtils.readEndpointsProperties(sysProps, endpointPropertiesMap, context);
        Properties fileProps = ConfigUtils.readOpenApiConfigFile(context);
        ConfigUtils.readEndpointsProperties(fileProps, endpointPropertiesMap, context);
        Environment environment = ConfigUtils.getEnv(context);
        if (environment != null) {
            for (Map.Entry<String, String> entry : environment.getProperties("endpoints", StringConvention.RAW).entrySet()) {
                String entryKey = entry.getKey();
                int dotIndex = entryKey.indexOf(46);
                if (dotIndex < 0) continue;
                String endpointName = entryKey.substring(0, dotIndex);
                String propName = entryKey.substring(endpointName.length() + 1);
                ConfigUtils.setEndpointProperty(endpointName, propName, entry.getValue(), endpointPropertiesMap, context);
            }
        }
        for (Map.Entry<String, String> entry : EndpointUtils.ALL_MICRONAUT_MANAGEMENT_ENDPOINTS.entrySet()) {
            String className;
            String endpointName = entry.getKey();
            EndpointProperties endpointProperties = endpointPropertiesMap.get(endpointName);
            if (endpointProperties == null) {
                endpointProperties = new EndpointProperties(endpointName);
                endpointPropertiesMap.put(endpointName, endpointProperties);
            }
            if (endpointProperties.getElement() != null || (className = entry.getValue()) == null) continue;
            ClassElement classEl = ContextUtils.getClassElement(className, context);
            endpointProperties.setElement(classEl);
        }
        return endpointPropertiesMap;
    }

    private static void readEndpointsProperties(Properties props, Map<String, EndpointProperties> endpointPropertiesMap, VisitorContext context) {
        for (String prop : props.stringPropertyNames()) {
            int endpointNameIndexEnd;
            if (!prop.startsWith("endpoints") || (endpointNameIndexEnd = prop.indexOf(46, "endpoints".length() + 1)) < 0) continue;
            String endpointName = prop.substring("endpoints".length() + 1, endpointNameIndexEnd);
            String propertyName = prop.substring(endpointNameIndexEnd + 1);
            String value = props.getProperty(prop);
            ConfigUtils.setEndpointProperty(endpointName, propertyName, value, endpointPropertiesMap, context);
        }
    }

    private static void setEndpointProperty(String endpointName, String propertyName, Object value, Map<String, EndpointProperties> endpointPropertiesMap, VisitorContext context) {
        if (value == null) {
            return;
        }
        String valueStr = value.toString();
        String simplePropName = propertyName.toLowerCase(Locale.ENGLISH);
        if (propertyName.contains(".")) {
            simplePropName = propertyName.substring(0, propertyName.indexOf(".")).toLowerCase(Locale.ENGLISH);
        }
        EndpointProperties endpointProperties = endpointPropertiesMap.computeIfAbsent(endpointName, EndpointProperties::new);
        switch (simplePropName) {
            case "enabled": {
                if (endpointProperties.getEnabled() != null) break;
                endpointProperties.setEnabled(Boolean.parseBoolean(valueStr));
                break;
            }
            case "path": {
                if (endpointProperties.getPath() != null) break;
                endpointProperties.setPath(valueStr);
                break;
            }
            case "context-path": 
            case "contextpath": {
                if (!ALL_ENDPOINTS_NAME.equals(endpointName) || endpointProperties.getContextPath() != null) break;
                endpointProperties.setContextPath(valueStr);
                break;
            }
            case "sensitive": {
                if (endpointProperties.getSensitive() != null) break;
                endpointProperties.setSensitive(Boolean.parseBoolean(valueStr));
                break;
            }
            case "description": {
                if (endpointProperties.getDescription() != null) break;
                endpointProperties.setDescription(valueStr);
                break;
            }
            case "extensions": {
                if (CollectionUtils.isEmpty(endpointProperties.getExtensions())) {
                    endpointProperties.setExtensions(new HashMap<String, Object>());
                }
                String extName = propertyName.substring("extensions".length() + 1);
                endpointProperties.getExtensions().put(SchemaUtils.prependIfMissing(extName, "x-"), ConfigUtils.parseExtensions(valueStr, context));
                break;
            }
            case "security-requirements": 
            case "securityrequirements": {
                if (CollectionUtils.isEmpty(endpointProperties.getSecurityRequirements())) {
                    endpointProperties.setSecurityRequirements(new ArrayList<SecurityRequirement>());
                }
                endpointProperties.getSecurityRequirements().addAll(ConfigUtils.parseSecurityRequirements(valueStr, context));
                break;
            }
            case "servers": {
                if (CollectionUtils.isEmpty(endpointProperties.getServers())) {
                    endpointProperties.setServers(new ArrayList<Server>());
                }
                endpointProperties.getServers().addAll(ConfigUtils.parseServers(valueStr, context));
                break;
            }
            case "tags": {
                if (CollectionUtils.isEmpty(endpointProperties.getTags())) {
                    endpointProperties.setTags(new ArrayList<Tag>());
                }
                endpointProperties.getTags().addAll(ConfigUtils.parseTags(valueStr));
                break;
            }
            case "class": {
                if (endpointProperties.getElement() != null) break;
                endpointProperties.setElement(ContextUtils.getClassElement(valueStr, context));
                break;
            }
        }
    }

    public static Map<String, Object> parseExtensions(String value, VisitorContext context) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return Collections.emptyMap();
        }
        try {
            return (Map)OpenApiUtils.getConvertJsonMapper().readValue(value, TYPE_EXTENSIONS);
        }
        catch (JsonProcessingException e) {
            ContextUtils.warn("Fail to parse " + TYPE_EXTENSIONS.getType().toString() + ": " + value + " - " + e.getMessage(), context);
            return Collections.emptyMap();
        }
    }

    public static List<Server> parseServers(String servers, VisitorContext context) {
        return ConfigUtils.parseModel(servers, context, TYPE_SERVERS_LIST);
    }

    public static List<SecurityRequirement> parseSecurityRequirements(String securityRequirements, VisitorContext context) {
        return ConfigUtils.parseModel(securityRequirements, context, TYPE_SECURITY_REQUIREMENTS_LIST);
    }

    private static <T> List<T> parseModel(String s, VisitorContext context, TypeReference<List<T>> typeReference) {
        if (StringUtils.isEmpty((CharSequence)s) || !s.startsWith("[") && !s.endsWith("]")) {
            return Collections.emptyList();
        }
        try {
            return (List)OpenApiUtils.getConvertJsonMapper().readValue(s, typeReference);
        }
        catch (JsonProcessingException e) {
            ContextUtils.warn("Fail to parse " + typeReference.getType().toString() + ": " + s + " - " + e.getMessage(), context);
            return Collections.emptyList();
        }
    }

    public static List<Tag> parseTags(String stringTagsStr) {
        if (StringUtils.isEmpty((CharSequence)stringTagsStr)) {
            return Collections.emptyList();
        }
        String[] stringTags = stringTagsStr.split(",");
        if (stringTags.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(stringTags.length);
        for (String name : stringTags) {
            if (StringUtils.isEmpty((CharSequence)name)) continue;
            tags.add(new Tag().name(name));
        }
        return tags;
    }

    private static GroupProperties.PackageProperties getPackageProperties(String groupPackage) {
        boolean includeSubpackages = (groupPackage = groupPackage.strip()).endsWith(ALL_SPRING_ACTUATOR_ENDPOINTS_NAME);
        if (includeSubpackages) {
            groupPackage = groupPackage.substring(0, groupPackage.length() - 2);
        }
        if (groupPackage.endsWith(".")) {
            groupPackage = groupPackage.substring(0, groupPackage.length() - 2);
        }
        return new GroupProperties.PackageProperties(groupPackage, includeSubpackages);
    }

    private static void readSchemaDecorators(Properties props, Map<String, SchemaDecorator> schemaDecorators, VisitorContext context) {
        for (String prop : props.stringPropertyNames()) {
            boolean isPrefix = false;
            String packageName = null;
            if (prop.startsWith("micronaut.openapi.schema-prefix")) {
                packageName = prop.substring("micronaut.openapi.schema-prefix".length() + 1);
                isPrefix = true;
            } else if (prop.startsWith("micronaut.openapi.schema-postfix")) {
                packageName = prop.substring("micronaut.openapi.schema-postfix".length() + 1);
            } else if (prop.startsWith("micronaut.openapi.schema.decorator.prefix")) {
                packageName = prop.substring("micronaut.openapi.schema.decorator.prefix".length() + 1);
                isPrefix = true;
            } else if (prop.startsWith("micronaut.openapi.schema.decorator.postfix")) {
                packageName = prop.substring("micronaut.openapi.schema.decorator.postfix".length() + 1);
            }
            if (StringUtils.isEmpty((CharSequence)packageName)) continue;
            SchemaDecorator schemaDecorator = schemaDecorators.computeIfAbsent(packageName, k -> new SchemaDecorator());
            if (isPrefix) {
                schemaDecorator.setPrefix(props.getProperty(prop));
                continue;
            }
            schemaDecorator.setPostfix(props.getProperty(prop));
        }
    }

    private static void readCustomSchemas(Properties props, Map<String, CustomSchema> customSchemas, VisitorContext context) {
        for (String prop : props.stringPropertyNames()) {
            String className;
            if (ConfigUtils.isMicronautProperty(prop)) continue;
            if (prop.startsWith("micronaut.openapi.schema.mapping")) {
                className = prop.substring("micronaut.openapi.schema.mapping".length() + 1);
            } else {
                if (!prop.startsWith("micronaut.openapi.schema")) continue;
                className = prop.substring("micronaut.openapi.schema".length() + 1);
            }
            String targetClassName = props.getProperty(prop);
            ConfigUtils.readCustomSchema(className, targetClassName, customSchemas, context);
        }
    }

    private static void readCustomSchema(String className, String targetClassName, Map<String, CustomSchema> customSchemas, VisitorContext context) {
        if (customSchemas.containsKey(className) || context == null) {
            return;
        }
        ClassElement targetClassElement = ContextUtils.getClassElement(targetClassName, context);
        if (targetClassElement == null) {
            ContextUtils.warn("Can't find class " + targetClassName + " for className " + className + " in classpath. Custom schemas: " + String.valueOf(customSchemas) + ". Skip it.", context);
            return;
        }
        ArrayList<String> configuredTypeArgs = null;
        int genericNameStart = className.indexOf(60);
        if (genericNameStart > 0) {
            String[] generics = className.substring(genericNameStart + 1, className.indexOf(62)).split(",");
            configuredTypeArgs = new ArrayList<String>();
            for (String generic : generics) {
                configuredTypeArgs.add(generic.strip());
            }
        }
        customSchemas.put(className, new CustomSchema(configuredTypeArgs, targetClassElement));
    }

    @Nullable
    public static Path getProjectPath(VisitorContext context) {
        Path projectPath = ContextUtils.get("micronaut.internal.openapi.project.dir", Path.class, context);
        if (projectPath != null) {
            return projectPath;
        }
        String projectDir = ContextUtils.getOptions(context).get("micronaut.openapi.project.dir");
        if (projectDir != null) {
            projectPath = Path.of(projectDir, new String[0]);
            if (Utils.isKsp(context)) {
                String classesOutputDir = projectPath.toString().replace('\\', '/') + "/build/generated/ksp/main/resources";
                ContextUtils.put("micronaut.internal.classpath.output", classesOutputDir, context);
            }
        }
        if (projectPath == null) {
            try {
                if (context != null) {
                    projectPath = ContextUtils.getProjectDir(context);
                }
                if (projectPath == null) {
                    projectPath = context.getProjectDir().orElse(null);
                }
                if (projectPath == null && Utils.isTestMode()) {
                    projectPath = Path.of(System.getProperty("user.dir"), new String[0]);
                }
            }
            catch (Exception e) {
                projectPath = Path.of(System.getProperty("user.dir"), new String[0]);
            }
        }
        ContextUtils.put("micronaut.internal.openapi.project.dir", projectPath, context);
        return projectPath;
    }

    public static PropertyNamingStrategies.NamingBase getPropertyNamingStrategy(VisitorContext context) {
        String value = ConfigUtils.getConfigProperty("micronaut.openapi.property.naming.strategy", context);
        if (value == null) {
            return null;
        }
        return ConfigUtils.toJacksonStrategy(value.toUpperCase(Locale.ENGLISH), context);
    }

    private static PropertyNamingStrategies.NamingBase toJacksonStrategy(String namingStrategy, VisitorContext context) {
        if (namingStrategy == null) {
            return null;
        }
        try {
            return switch (NamingStrategyImpls.valueOf((String)namingStrategy.toUpperCase(Locale.ENGLISH))) {
                default -> throw new IncompatibleClassChangeError();
                case NamingStrategyImpls.LOWER_CAMEL_CASE -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.LOWER_CAMEL_CASE;
                case NamingStrategyImpls.UPPER_CAMEL_CASE -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.UPPER_CAMEL_CASE;
                case NamingStrategyImpls.SNAKE_CASE -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.SNAKE_CASE;
                case NamingStrategyImpls.UPPER_SNAKE_CASE -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.UPPER_SNAKE_CASE;
                case NamingStrategyImpls.LOWER_CASE -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.LOWER_CASE;
                case NamingStrategyImpls.KEBAB_CASE -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.KEBAB_CASE;
                case NamingStrategyImpls.LOWER_DOT_CASE -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.LOWER_DOT_CASE;
            };
        }
        catch (Exception e) {
            ContextUtils.warn("Unknown naming strategy value: " + namingStrategy, context);
            return null;
        }
    }

    public static JsonInclude.Include getJacksonIncludeMode(VisitorContext context) {
        String value = ConfigUtils.getConfigProperty("micronaut.openapi.property.include", context);
        if (value == null) {
            return JsonInclude.Include.USE_DEFAULTS;
        }
        return value.toUpperCase(Locale.ENGLISH).equals(JsonInclude.Include.ALWAYS.name()) ? JsonInclude.Include.ALWAYS : JsonInclude.Include.USE_DEFAULTS;
    }

    public static String getConfigProperty(String key, VisitorContext context) {
        Boolean isLoaded;
        if (context != null && (isLoaded = ContextUtils.get(key + LOADED_POSTFIX, Boolean.class, context)) != null) {
            return ContextUtils.get(key + VALUE_POSTFIX, String.class, context);
        }
        String value = OpenApiConfigProperty.ALL.contains(key) && context != null ? ContextUtils.getOptions(context).get(key) : System.getProperty(key);
        if (value == null) {
            value = ConfigUtils.readOpenApiConfigFile(context).getProperty(key);
        }
        if (value != null) {
            return value;
        }
        Environment environment = ConfigUtils.getEnv(context);
        String string = value = environment != null ? (String)environment.get((CharSequence)key, String.class).orElse(null) : null;
        if (context != null) {
            ContextUtils.put(key + LOADED_POSTFIX, true, context);
            if (value != null) {
                ContextUtils.put(key + VALUE_POSTFIX, value, context);
            }
        }
        return value;
    }

    public static AdditionalFilesProperties getAdditionalFilesProperties(VisitorContext context) {
        AdditionalFilesProperties additionalFilesProps = ContextUtils.get("micronaut.internal.openapi.additional.files.properties", AdditionalFilesProperties.class, context);
        if (additionalFilesProps != null) {
            return additionalFilesProps;
        }
        additionalFilesProps = new AdditionalFilesProperties(ConfigUtils.getListStringsProperty("micronaut.openapi.additional.files", null, context), ConfigUtils.getAdditionalFilesMergeMode(context), ConfigUtils.getListStringsProperty("micronaut.openapi.additional.include-patterns", null, context), ConfigUtils.getPatternStyle("micronaut.openapi.additional.include-pattern-style", context), ConfigUtils.getListStringsProperty("micronaut.openapi.additional.exclude-patterns", null, context), ConfigUtils.getPatternStyle("micronaut.openapi.additional.exclude-pattern-style", context));
        ContextUtils.put("micronaut.internal.openapi.additional.files.properties", additionalFilesProps, context);
        return additionalFilesProps;
    }

    private static MergeMode getAdditionalFilesMergeMode(VisitorContext context) {
        String str = ConfigUtils.getConfigProperty("micronaut.openapi.additional.files-merge-mode", context);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return MergeMode.REPLACE;
        }
        try {
            return MergeMode.valueOf(str.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception e) {
            ContextUtils.warn("Unknown additional files mergeMode value: " + str, context);
            return MergeMode.REPLACE;
        }
    }

    private static PatternStyle getPatternStyle(String propName, VisitorContext context) {
        String str = ConfigUtils.getConfigProperty(propName, context);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return PatternStyle.ANT;
        }
        try {
            return PatternStyle.valueOf(str.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception e) {
            ContextUtils.warn("Unknown pattern style value: " + str, context);
            return PatternStyle.ANT;
        }
    }

    public static boolean getBooleanProperty(String property, boolean defaultValue, VisitorContext context) {
        String str = ConfigUtils.getConfigProperty(property, context);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return defaultValue;
        }
        return !"false".equalsIgnoreCase(str);
    }

    public static Properties readOpenApiConfigFile(VisitorContext context) {
        String cfgFile;
        Properties props = ContextUtils.get("micronaut.internal.openapi.properties", Properties.class, context);
        if (props != null) {
            return props;
        }
        Properties openApiProperties = new Properties();
        String string = cfgFile = context != null ? ContextUtils.getOptions(context).getOrDefault("micronaut.openapi.config.file", System.getProperty("micronaut.openapi.config.file", "openapi.properties")) : System.getProperty("micronaut.openapi.config.file", "openapi.properties");
        if (StringUtils.isNotEmpty((CharSequence)cfgFile)) {
            Path cfg = FileUtils.resolve(context, Path.of(cfgFile, new String[0]));
            if (Files.isReadable(cfg)) {
                try (BufferedReader reader = Files.newBufferedReader(cfg);){
                    openApiProperties.load(reader);
                }
                catch (IOException e) {
                    ContextUtils.warn("Fail to read OpenAPI configuration file: " + e.getMessage(), null);
                }
            } else if (Files.exists(cfg, new LinkOption[0])) {
                ContextUtils.warn("Can not read configuration file: " + String.valueOf(cfg), context);
            }
        }
        if (context != null) {
            ContextUtils.put("micronaut.internal.openapi.properties", openApiProperties, context);
        }
        return openApiProperties;
    }

    @Nullable
    public static Environment getEnv(VisitorContext context) {
        if (!ConfigUtils.isEnvEnabled(context)) {
            return null;
        }
        Boolean envCreated = ContextUtils.get("micronaut.internal.environment.created", Boolean.class, context);
        if (envCreated != null && envCreated.booleanValue()) {
            return ContextUtils.get("micronaut.internal.environment", Environment.class, context);
        }
        Environment environment = ConfigUtils.createEnv(context);
        ContextUtils.put("micronaut.internal.environment", environment, context);
        ContextUtils.put("micronaut.internal.environment.created", true, context);
        return environment;
    }

    private static Environment createEnv(final VisitorContext context) {
        ApplicationContextConfiguration configuration = new ApplicationContextConfiguration(){

            public Optional<MutableConversionService> getConversionService() {
                DefaultMutableConversionService conversionService = new DefaultMutableConversionService();
                conversionService.addConverter(Map.class, InterceptUrlMapPattern.class, (TypeConverter)new InterceptUrlMapConverter((ConversionService)conversionService));
                return Optional.of(conversionService);
            }

            public ClassPathResourceLoader getResourceLoader() {
                ClassLoader classLoader = ApplicationContextConfiguration.class.getClassLoader();
                if (classLoader == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                if (classLoader == null) {
                    classLoader = ClassPathResourceLoader.class.getClassLoader();
                }
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                return new DefaultClassPathResourceLoader(classLoader, null, false, false);
            }

            @NonNull
            public List<String> getEnvironments() {
                return ConfigUtils.getActiveEnvs(context);
            }
        };
        AnnProcessorEnvironment environment = null;
        try {
            environment = new AnnProcessorEnvironment(configuration, context);
            environment.start();
            return environment;
        }
        catch (Exception e) {
            ContextUtils.warn("Can't create environment: " + e.getMessage() + ".\n" + Utils.printStackTrace(e), context);
            return environment;
        }
    }

    public static List<String> getActiveEnvs(VisitorContext context) {
        if (!ConfigUtils.isEnvEnabled(context)) {
            return Collections.emptyList();
        }
        String activeEnvStr = System.getProperty("micronaut.openapi.environments", ConfigUtils.readOpenApiConfigFile(context).getProperty("micronaut.openapi.environments"));
        ArrayList<String> activeEnvs = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)activeEnvStr)) {
            for (String activeEnv : activeEnvStr.split(",")) {
                activeEnvs.add(activeEnv.strip());
            }
        }
        return activeEnvs;
    }

    private static boolean isEnvEnabled(VisitorContext context) {
        if (context == null) {
            return true;
        }
        boolean isEnabled = true;
        String isEnabledStr = ContextUtils.getOptions(context).get("micronaut.environment.enabled");
        if (StringUtils.isEmpty((CharSequence)isEnabledStr)) {
            isEnabledStr = ConfigUtils.readOpenApiConfigFile(context).getProperty("micronaut.environment.enabled");
        }
        if (StringUtils.isNotEmpty((CharSequence)isEnabledStr)) {
            isEnabled = Boolean.parseBoolean(isEnabledStr);
        }
        ContextUtils.put("micronaut.environment.enabled", isEnabled, context);
        return isEnabled;
    }

    public static IncludeExcludeProperties getIncludeExcludeProperties(VisitorContext context) {
        IncludeExcludeProperties includeExcludeProperties = ContextUtils.get("micronaut.internal.openapi.include-exclude.properties", IncludeExcludeProperties.class, context);
        if (includeExcludeProperties != null) {
            return includeExcludeProperties;
        }
        includeExcludeProperties = new IncludeExcludeProperties(ConfigUtils.getListStringsProperty("micronaut.openapi.exclude.classes", null, context), ConfigUtils.getListStringsProperty("micronaut.openapi.exclude.packages", null, context));
        ContextUtils.put("micronaut.internal.openapi.include-exclude.properties", includeExcludeProperties, context);
        return includeExcludeProperties;
    }

    public static DocsFormat getDocsFormat(@Nullable VisitorContext context) {
        if (context == null) {
            return DocsFormat.HTML_TO_MD;
        }
        String value = ConfigUtils.getConfigProperty("micronaut.openapi.docs.format", context);
        if (value == null) {
            return DocsFormat.HTML_TO_MD;
        }
        try {
            return DocsFormat.valueOf(value.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception e) {
            Validate.fail((String)("Unknown docs format value: " + value + ". Available values: " + String.join((CharSequence)", ", DocsFormat.NAMES)), (Object[])new Object[]{context});
            throw e;
        }
    }

    public static final class SchemaDecorator {
        private String prefix;
        private String postfix;

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getPostfix() {
            return this.postfix;
        }

        public void setPostfix(String postfix) {
            this.postfix = postfix;
        }
    }

    public record CustomSchema(List<String> typeArgs, ClassElement classElement) {
    }

    public static enum DuplicateResolution {
        AUTO,
        ERROR;

    }

    @Internal
    public record AdditionalFilesProperties(List<String> additionalFiles, MergeMode mergeMode, List<String> includePatterns, PatternStyle includePatternStyle, List<String> excludePatterns, PatternStyle excludePatternStyle) {
    }

    public static enum MergeMode {
        APPEND,
        REPLACE;

    }

    public static enum PatternStyle {
        ANT,
        REGEX;


        public PathMatcher getPathMatcher() {
            return this.equals((Object)REGEX) ? PathMatcher.REGEX : PathMatcher.ANT;
        }
    }
}

