/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum MnParamFormat {
    CSV("csv", Parameter.StyleEnum.SIMPLE),
    SSV("ssv", Parameter.StyleEnum.SPACEDELIMITED),
    PIPES("pipes", Parameter.StyleEnum.PIPEDELIMITED),
    MULTI("multi", Parameter.StyleEnum.FORM),
    DEEP_OBJECT("deepobject", Parameter.StyleEnum.DEEPOBJECT);

    public static final Map<String, MnParamFormat> BY_NAME;
    private final String name;
    private final Parameter.StyleEnum style;

    private MnParamFormat(String name, Parameter.StyleEnum style) {
        this.name = name;
        this.style = style;
    }

    public String getName() {
        return this.name;
    }

    public Parameter.StyleEnum getStyle() {
        return this.style;
    }

    public static Parameter.StyleEnum getStyleByFormatName(String name, String in) {
        MnParamFormat format = BY_NAME.get(name);
        if ("query".equalsIgnoreCase(in) && format != MULTI && format != SSV && format != PIPES && format != DEEP_OBJECT) {
            return null;
        }
        if ("cookie".equalsIgnoreCase(in) && format != MULTI) {
            return null;
        }
        if ("header".equalsIgnoreCase(in) && format != CSV) {
            return null;
        }
        if ("path".equalsIgnoreCase(in) && format != CSV) {
            return null;
        }
        if (format != null) {
            if ("query".equalsIgnoreCase(in) && format == MULTI) {
                return null;
            }
            if ("cookie".equalsIgnoreCase(in) && format == MULTI) {
                return null;
            }
            if ("header".equalsIgnoreCase(in) && format == CSV) {
                return null;
            }
            if ("path".equalsIgnoreCase(in) && format == CSV) {
                return null;
            }
        }
        return format != null ? format.getStyle() : null;
    }

    public static MnParamFormat getByName(String name) {
        return BY_NAME.get(name);
    }

    static {
        BY_NAME = Map.copyOf(Arrays.stream(MnParamFormat.values()).collect(Collectors.toMap(v -> v.name, Function.identity())));
    }
}

