/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.annotation.OpenAPIExclude;
import io.micronaut.openapi.annotation.OpenAPIExcludes;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.SupportedOptions;

@SupportedOptions(value={"micronaut.openapi.enabled"})
public class OpenApiExcludeVisitor
implements TypeElementVisitor<OpenAPIExcludes, Object> {
    private static List<String> excludedPackages = new ArrayList<String>();
    private static List<String> excludedClasses = new ArrayList<String>();

    public OpenApiExcludeVisitor() {
    }

    public OpenApiExcludeVisitor(List<String> excludedPackages, List<String> excludedClasses) {
        OpenApiExcludeVisitor.excludedPackages = excludedPackages;
        OpenApiExcludeVisitor.excludedClasses = excludedClasses;
    }

    public void start(VisitorContext context) {
        Utils.init(context);
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        if (!ConfigUtils.isOpenApiEnabled(context) || !ConfigUtils.isSpecGenerationEnabled(context)) {
            return;
        }
        for (AnnotationValue excludeAnn : element.getAnnotationValuesByType(OpenAPIExclude.class)) {
            Object[] packages;
            Object[] classesValue = excludeAnn.stringValues();
            if (ArrayUtils.isEmpty((Object[])classesValue) && ArrayUtils.isEmpty((Object[])(classesValue = excludeAnn.stringValues("classes")))) {
                classesValue = excludeAnn.stringValues("classNames");
            }
            if (ArrayUtils.isNotEmpty((Object[])classesValue)) {
                excludedClasses.addAll(Arrays.asList(classesValue));
            }
            if (!ArrayUtils.isNotEmpty((Object[])(packages = excludeAnn.stringValues("packages")))) continue;
            Collections.addAll(excludedPackages, packages);
        }
    }

    public static List<String> getExcludedPackages() {
        return excludedPackages;
    }

    public static List<String> getExcludedClasses() {
        return excludedClasses;
    }

    public static void clean() {
        excludedPackages = new ArrayList<String>();
        excludedClasses = new ArrayList<String>();
    }

    public int getOrder() {
        return 80;
    }
}

