/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.PackageElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.annotation.OpenAPIGroupInfo;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.SupportedOptions;

@Internal
@SupportedOptions(value={"micronaut.openapi.enabled"})
public class OpenApiGroupInfoVisitor
implements TypeElementVisitor<Object, Object> {
    private List<String> groups;
    private List<String> groupsExcluded;

    public OpenApiGroupInfoVisitor() {
    }

    public OpenApiGroupInfoVisitor(List<String> groups, List<String> groupsExcluded) {
        this.groups = groups;
        this.groupsExcluded = groupsExcluded;
    }

    public void start(VisitorContext context) {
        Utils.init(context);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void visitClass(ClassElement classEl, VisitorContext context) {
        if (!ConfigUtils.isOpenApiEnabled(context) || !ConfigUtils.isSpecGenerationEnabled(context)) {
            return;
        }
        if (CollectionUtils.isNotEmpty(this.groups)) {
            Map<String, List<String>> includedClassesGroups = Utils.getIncludedClassesGroups();
            if (includedClassesGroups == null) {
                includedClassesGroups = new HashMap<String, List<String>>();
                Utils.setIncludedClassesGroups(includedClassesGroups);
            }
            includedClassesGroups.put(classEl.getName(), this.groups);
        }
        if (CollectionUtils.isNotEmpty(this.groupsExcluded)) {
            Map<String, List<String>> includedClassesGroupsExcluded = Utils.getIncludedClassesGroupsExcluded();
            if (includedClassesGroupsExcluded == null) {
                includedClassesGroupsExcluded = new HashMap<String, List<String>>();
                Utils.setIncludedClassesGroupsExcluded(includedClassesGroupsExcluded);
            }
            includedClassesGroupsExcluded.put(classEl.getName(), this.groupsExcluded);
        }
        PackageElement packageEl = classEl.getPackage();
        List classAnns = classEl.getAnnotationValuesByType(OpenAPIGroupInfo.class);
        List packageAnns = packageEl.getAnnotationValuesByType(OpenAPIGroupInfo.class);
        if (CollectionUtils.isEmpty((Collection)classAnns) && CollectionUtils.isEmpty((Collection)packageAnns)) {
            return;
        }
        Map<String, OpenAPI> openApis = Utils.getOpenApis();
        if (openApis == null) {
            openApis = new HashMap<String, OpenAPI>();
            Utils.setOpenApis(openApis);
        }
        this.addOpenApis(packageAnns, openApis, classEl, context);
        this.addOpenApis(classAnns, openApis, classEl, context);
    }

    private void addOpenApis(List<AnnotationValue<OpenAPIGroupInfo>> groupInfoAnns, Map<String, OpenAPI> openApis, ClassElement classEl, VisitorContext context) {
        if (CollectionUtils.isEmpty(groupInfoAnns)) {
            return;
        }
        for (AnnotationValue<OpenAPIGroupInfo> groupInfoAnn : groupInfoAnns) {
            Object[] groupNames;
            OpenAPI openApi;
            AnnotationValue openApiAnn = groupInfoAnn.getAnnotation("info", OpenAPIDefinition.class).orElse(null);
            if (openApiAnn == null || (openApi = ConvertUtils.toValue(openApiAnn.getValues(), context, OpenAPI.class)) == null) continue;
            List securityRequirementAnns = openApiAnn.getAnnotations("security", io.swagger.v3.oas.annotations.security.SecurityRequirement.class);
            ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>();
            for (AnnotationValue securityRequirementAnn : securityRequirementAnns) {
                securityRequirements.add(ConvertUtils.mapToSecurityRequirement((AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>)securityRequirementAnn));
            }
            openApi.setSecurity(securityRequirements);
            List securitySchemeAnns = groupInfoAnn.getAnnotations("securitySchemes", SecurityScheme.class);
            if (CollectionUtils.isNotEmpty((Collection)securitySchemeAnns)) {
                ConvertUtils.addSecuritySchemes(openApi, securitySchemeAnns, context);
            }
            if (ArrayUtils.isEmpty((Object[])(groupNames = groupInfoAnn.stringValues()))) {
                groupNames = groupInfoAnn.stringValues("names");
            }
            for (Object groupName : groupNames) {
                openApis.put((String)groupName, openApi);
            }
        }
    }
}

