/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.annotation.Controller;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.annotation.OpenAPIInclude;
import io.micronaut.openapi.annotation.OpenAPIIncludes;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.OpenApiControllerVisitor;
import io.micronaut.openapi.visitor.OpenApiEndpointVisitor;
import io.micronaut.openapi.visitor.OpenApiGroupInfoVisitor;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.processing.SupportedOptions;

@SupportedOptions(value={"micronaut.openapi.enabled"})
public class OpenApiIncludeVisitor
implements TypeElementVisitor<OpenAPIIncludes, Object> {
    public void start(VisitorContext context) {
        Utils.init(context);
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        if (!ConfigUtils.isOpenApiEnabled(context) || !ConfigUtils.isSpecGenerationEnabled(context)) {
            return;
        }
        for (AnnotationValue includeAnn : element.getAnnotationValuesByType(OpenAPIInclude.class)) {
            String description = includeAnn.stringValue("description").orElse(null);
            List extensionAnns = includeAnn.getAnnotations("extensions", Extension.class);
            List tagAnns = includeAnn.getAnnotations("tags", Tag.class);
            List securityAnns = includeAnn.getAnnotations("security", SecurityRequirement.class);
            String customUri = includeAnn.stringValue("uri").orElse(null);
            List<String> groups = List.of(includeAnn.stringValues("groups"));
            List<String> groupsExcluded = List.of(includeAnn.stringValues("groupsExcluded"));
            OpenApiGroupInfoVisitor groupVisitor = new OpenApiGroupInfoVisitor(groups, groupsExcluded);
            OpenApiControllerVisitor controllerVisitor = new OpenApiControllerVisitor(description, extensionAnns.isEmpty() ? null : extensionAnns, tagAnns, securityAnns, customUri);
            OpenApiEndpointVisitor endpointVisitor = new OpenApiEndpointVisitor(true, description, extensionAnns.isEmpty() ? null : extensionAnns, tagAnns.isEmpty() ? null : tagAnns, securityAnns.isEmpty() ? null : securityAnns);
            List<Object> classesValue = List.of();
            Object[] classesValueArr = includeAnn.stringValues();
            if (ArrayUtils.isEmpty((Object[])classesValueArr) && ArrayUtils.isEmpty((Object[])(classesValueArr = includeAnn.stringValues("classes")))) {
                classesValueArr = includeAnn.stringValues("classNames");
            }
            if (ArrayUtils.isNotEmpty((Object[])classesValueArr)) {
                classesValue = List.of(classesValueArr);
            }
            if (CollectionUtils.isNotEmpty(classesValue)) {
                for (String string : classesValue) {
                    ClassElement classEl = ContextUtils.getClassElement(string, context);
                    this.processClassEl(classEl, groupVisitor, controllerVisitor, endpointVisitor, context);
                }
            }
            List<Object> packages = List.of();
            Object[] objectArray = includeAnn.stringValues("packages");
            if (ArrayUtils.isNotEmpty((Object[])objectArray)) {
                packages = List.of(objectArray);
            }
            if (!CollectionUtils.isNotEmpty(packages)) continue;
            for (String string : packages) {
                Object[] classEls = ContextUtils.getClassElements(string, context);
                if (ArrayUtils.isEmpty((Object[])classEls)) continue;
                for (Object classEl : classEls) {
                    this.processClassEl((ClassElement)classEl, groupVisitor, controllerVisitor, endpointVisitor, context);
                }
            }
        }
    }

    private void processClassEl(ClassElement classEl, OpenApiGroupInfoVisitor groupVisitor, OpenApiControllerVisitor controllerVisitor, OpenApiEndpointVisitor endpointVisitor, VisitorContext context) {
        if (classEl == null) {
            return;
        }
        groupVisitor.visitClass(classEl, context);
        if (classEl.isAnnotationPresent(Controller.class)) {
            this.visit(controllerVisitor, context, classEl);
        } else if (classEl.isAnnotationPresent("io.micronaut.management.endpoint.annotation.Endpoint")) {
            this.visit(endpointVisitor, context, classEl);
        }
    }

    private void visit(TypeElementVisitor<?, ?> visitor, VisitorContext context, ClassElement ce) {
        visitor.visitClass(ce, context);
        ce.getEnclosedElements(ElementQuery.ALL_METHODS.modifiers(mods -> !mods.contains(ElementModifier.STATIC) && !mods.contains(ElementModifier.PRIVATE)).named(name -> !name.contains("$"))).forEach(method -> visitor.visitMethod(method, context));
    }

    public int getOrder() {
        return 70;
    }
}

