/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.swagger.core.util.PrimitiveType;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;

@Internal
public final class OpenApiNormalizeUtils {
    private OpenApiNormalizeUtils() {
    }

    public static void normalizeOpenApi(OpenAPI openApi, VisitorContext context) {
        Components components;
        if (CollectionUtils.isEmpty((Map)openApi.getExtensions())) {
            openApi.setExtensions(null);
        }
        if (CollectionUtils.isNotEmpty((Collection)openApi.getServers())) {
            for (Server server : openApi.getServers()) {
                if (!CollectionUtils.isEmpty((Map)server.getExtensions())) continue;
                server.setExtensions(null);
            }
        }
        if (openApi.getPaths() != null) {
            Paths sortedPaths = new Paths();
            new TreeMap<String, PathItem>((Map<String, PathItem>)openApi.getPaths()).forEach((arg_0, arg_1) -> ((Paths)sortedPaths).addPathItem(arg_0, arg_1));
            if (openApi.getPaths().getExtensions() != null) {
                sortedPaths.setExtensions(new TreeMap(openApi.getPaths().getExtensions()));
            }
            openApi.setPaths(sortedPaths);
            for (PathItem pathItem : sortedPaths.values()) {
                if (CollectionUtils.isNotEmpty((Map)pathItem.getExtensions())) {
                    pathItem.getExtensions().remove("x-micronaut-op-postfix");
                }
                if (CollectionUtils.isEmpty((Map)pathItem.getExtensions())) {
                    pathItem.setExtensions(null);
                }
                OpenApiNormalizeUtils.normalizeOperation(pathItem.getGet(), openApi, context);
                OpenApiNormalizeUtils.normalizeOperation(pathItem.getPut(), openApi, context);
                OpenApiNormalizeUtils.normalizeOperation(pathItem.getPost(), openApi, context);
                OpenApiNormalizeUtils.normalizeOperation(pathItem.getDelete(), openApi, context);
                OpenApiNormalizeUtils.normalizeOperation(pathItem.getOptions(), openApi, context);
                OpenApiNormalizeUtils.normalizeOperation(pathItem.getHead(), openApi, context);
                OpenApiNormalizeUtils.normalizeOperation(pathItem.getPatch(), openApi, context);
                OpenApiNormalizeUtils.normalizeOperation(pathItem.getTrace(), openApi, context);
            }
        }
        if ((components = openApi.getComponents()) == null) {
            return;
        }
        OpenApiNormalizeUtils.normalizeSchemas(components.getSchemas(), openApi, context);
        OpenApiNormalizeUtils.sortComponent(components, Components::getSchemas, Components::setSchemas);
        OpenApiNormalizeUtils.sortComponent(components, Components::getResponses, Components::setResponses);
        OpenApiNormalizeUtils.sortComponent(components, Components::getParameters, Components::setParameters);
        OpenApiNormalizeUtils.sortComponent(components, Components::getExamples, Components::setExamples);
        OpenApiNormalizeUtils.sortComponent(components, Components::getRequestBodies, Components::setRequestBodies);
        OpenApiNormalizeUtils.sortComponent(components, Components::getHeaders, Components::setHeaders);
        OpenApiNormalizeUtils.sortComponent(components, Components::getSecuritySchemes, Components::setSecuritySchemes);
        OpenApiNormalizeUtils.sortComponent(components, Components::getLinks, Components::setLinks);
        OpenApiNormalizeUtils.sortComponent(components, Components::getCallbacks, Components::setCallbacks);
        if (Utils.isOpenapi31()) {
            OpenApiNormalizeUtils.sortComponent(components, Components::getPathItems, Components::setPathItems);
            if (CollectionUtils.isNotEmpty((Map)openApi.getWebhooks())) {
                openApi.setWebhooks(new TreeMap(openApi.getWebhooks()));
            }
        }
    }

    public static void normalizeOperation(Operation operation, OpenAPI openApi, VisitorContext context) {
        ApiResponses responses;
        if (operation == null) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)operation.getParameters())) {
            for (Parameter parameter : operation.getParameters()) {
                Object object;
                Schema paramSchema;
                if (parameter == null) continue;
                if (CollectionUtils.isEmpty((Map)parameter.getExtensions())) {
                    parameter.setExtensions(null);
                }
                if ((paramSchema = parameter.getSchema()) == null) continue;
                Schema<?> normalizedSchema = OpenApiNormalizeUtils.normalizeSchema(paramSchema, openApi, context);
                if (normalizedSchema != null) {
                    parameter.setSchema(normalizedSchema);
                } else if (paramSchema.equals(SchemaUtils.EMPTY_ARBITRARY_SCHEMA)) {
                    paramSchema.setType("object");
                }
                if (parameter.getExample() != null && (object = parameter.getExample()) instanceof String) {
                    String exampleStr = (String)object;
                    if (parameter.getSchema() != null) {
                        parameter.setExample(ConvertUtils.parseByTypeAndFormat(exampleStr, parameter.getSchema().getType(), parameter.getSchema().getFormat(), context, false));
                    }
                }
                OpenApiNormalizeUtils.normalizeExamples(parameter.getExamples());
            }
        }
        if (CollectionUtils.isEmpty((Map)operation.getExtensions())) {
            operation.setExtensions(null);
        }
        if (operation.getRequestBody() != null) {
            OpenApiNormalizeUtils.normalizeContent(operation.getRequestBody().getContent(), openApi, context);
        }
        if (CollectionUtils.isNotEmpty((Map)(responses = operation.getResponses()))) {
            if (CollectionUtils.isNotEmpty((Map)responses.getExtensions())) {
                responses.getExtensions().remove("x-micronaut-parent-response");
            }
            if (CollectionUtils.isEmpty((Map)responses.getExtensions())) {
                responses.setExtensions(null);
            }
            Iterator iter = responses.keySet().iterator();
            while (iter.hasNext()) {
                String responseName = (String)iter.next();
                ApiResponse response = (ApiResponse)responses.get((Object)responseName);
                if (response == null) {
                    iter.remove();
                    continue;
                }
                OpenApiNormalizeUtils.normalizeContent(response.getContent(), openApi, context);
                OpenApiNormalizeUtils.normalizeHeaders(response.getHeaders(), openApi, context);
                if (!CollectionUtils.isEmpty((Map)response.getExtensions())) continue;
                response.setExtensions(null);
            }
        }
    }

    public static void normalizeHeaders(Map<String, Header> headers, OpenAPI openApi, VisitorContext context) {
        if (CollectionUtils.isEmpty(headers)) {
            return;
        }
        for (Header header : headers.values()) {
            Object object;
            Schema<?> normalizedSchema;
            Schema headerSchema;
            if (CollectionUtils.isEmpty((Map)header.getExtensions())) {
                header.setExtensions(null);
            }
            if ((headerSchema = header.getSchema()) == null) {
                headerSchema = PrimitiveType.STRING.createProperty(Utils.isOpenapi31());
                header.setSchema(headerSchema);
            }
            if ((normalizedSchema = OpenApiNormalizeUtils.normalizeSchema(headerSchema, openApi, context)) != null) {
                header.setSchema(normalizedSchema);
            } else if (headerSchema.equals(SchemaUtils.EMPTY_ARBITRARY_SCHEMA)) {
                headerSchema.setType("object");
            }
            if (header.getExample() != null && (object = header.getExample()) instanceof String) {
                String exampleStr = (String)object;
                header.setExample(ConvertUtils.parseByTypeAndFormat(exampleStr, header.getSchema().getType(), header.getSchema().getFormat(), context, false));
            }
            OpenApiNormalizeUtils.normalizeExamples(header.getExamples());
            OpenApiNormalizeUtils.normalizeContent(header.getContent(), openApi, context);
        }
    }

    public static void normalizeContent(Content content, OpenAPI openApi, VisitorContext context) {
        if (CollectionUtils.isEmpty((Map)content)) {
            return;
        }
        for (MediaType mediaType : content.values()) {
            Schema mediaTypeSchema;
            if (CollectionUtils.isEmpty((Map)mediaType.getExtensions())) {
                mediaType.setExtensions(null);
            }
            if ((mediaTypeSchema = mediaType.getSchema()) == null) continue;
            Schema<?> normalizedSchema = OpenApiNormalizeUtils.normalizeSchema(mediaTypeSchema, openApi, context);
            if (normalizedSchema != null) {
                mediaType.setSchema(normalizedSchema);
            } else if (mediaTypeSchema.equals(SchemaUtils.EMPTY_ARBITRARY_SCHEMA)) {
                mediaTypeSchema.setType("object");
            }
            OpenApiNormalizeUtils.normalizeExamples(mediaType.getExamples());
            Map paramSchemas = mediaTypeSchema.getProperties();
            if (!CollectionUtils.isNotEmpty((Map)paramSchemas)) continue;
            HashMap paramNormalizedSchemas = new HashMap();
            for (Map.Entry paramEntry : paramSchemas.entrySet()) {
                Schema paramSchema = (Schema)paramEntry.getValue();
                Schema<?> paramNormalizedSchema = OpenApiNormalizeUtils.normalizeSchema(paramSchema, openApi, context);
                if (paramNormalizedSchema == null) continue;
                paramNormalizedSchemas.put((String)paramEntry.getKey(), paramNormalizedSchema);
            }
            if (!CollectionUtils.isNotEmpty(paramNormalizedSchemas)) continue;
            paramSchemas.putAll(paramNormalizedSchemas);
        }
    }

    public static void normalizeExamples(Map<String, Example> examples) {
        if (CollectionUtils.isEmpty(examples)) {
            return;
        }
        Iterator<String> iter = examples.keySet().iterator();
        while (iter.hasNext()) {
            String exampleName = iter.next();
            Example example = examples.get(exampleName);
            if (example == null) {
                iter.remove();
                continue;
            }
            if (!CollectionUtils.isEmpty((Map)example.getExtensions())) continue;
            example.setExtensions(null);
        }
    }

    public static <T> void sortComponent(Components components, Function<Components, Map<String, T>> getter, BiConsumer<Components, Map<String, T>> setter) {
        if (components != null && getter.apply(components) != null) {
            Map<String, T> component = getter.apply(components);
            setter.accept(components, new TreeMap<String, T>(component));
        }
    }

    public static Schema<?> normalizeSchema(Schema<?> schema, OpenAPI openApi, VisitorContext context) {
        List allOf;
        if (schema == null) {
            return null;
        }
        if (CollectionUtils.isEmpty((Map)schema.getExtensions())) {
            schema.setExtensions(null);
        }
        if (CollectionUtils.isEmpty((Collection)schema.getTypes()) || schema.getTypes().size() == 1 && schema.getTypes().iterator().next() == null) {
            schema.setTypes(null);
        }
        OpenApiNormalizeUtils.removeDuplicateSchemasInOneOf(schema.getOneOf(), schema.getAllOf(), openApi);
        if (schema.getOneOf() != null && schema.getOneOf().isEmpty()) {
            schema.setOneOf(null);
        }
        if (CollectionUtils.isNotEmpty((Collection)(allOf = schema.getAllOf()))) {
            if (allOf.size() == 1) {
                Object object;
                boolean isSameType;
                String serializedAllOfDefaultValue;
                String serializedDefaultValue;
                Schema allOfSchema = (Schema)allOf.get(0);
                if (CollectionUtils.isEmpty((Map)allOfSchema.getExtensions())) {
                    allOfSchema.setExtensions(null);
                }
                schema.setAllOf(null);
                Object defaultValue = schema.getDefault();
                String type = schema.getType();
                try {
                    serializedDefaultValue = defaultValue != null ? Utils.getJsonMapper().writeValueAsString(defaultValue) : null;
                }
                catch (JsonProcessingException e) {
                    return null;
                }
                schema.setDefault(null);
                schema.setType(null);
                Schema normalizedSchema = null;
                Object allOfDefaultValue = allOfSchema.getDefault();
                try {
                    serializedAllOfDefaultValue = allOfDefaultValue != null ? Utils.getJsonMapper().writeValueAsString(allOfDefaultValue) : null;
                }
                catch (JsonProcessingException e) {
                    return null;
                }
                boolean bl = isSameType = allOfSchema.getType() == null || allOfSchema.getType().equals(type);
                if (SchemaUtils.isEmptySchema(schema) && (serializedDefaultValue == null || serializedDefaultValue.equals(serializedAllOfDefaultValue)) && (type == null || isSameType)) {
                    normalizedSchema = allOfSchema;
                }
                schema.setType(type);
                schema.setAllOf(allOf);
                schema.setDefault(defaultValue);
                if (!"string".equals(schema.getType()) && (object = schema.getExample()) instanceof String) {
                    String exampleStr = (String)object;
                    schema.setExample(ConvertUtils.parseByTypeAndFormat(exampleStr, type, schema.getFormat(), context, false));
                }
                OpenApiNormalizeUtils.normalizeSchemaProperties(schema, context);
                OpenApiNormalizeUtils.normalizeSchemaProperties(normalizedSchema, context);
                OpenApiNormalizeUtils.unwrapAllOff(normalizedSchema);
                OpenApiNormalizeUtils.normalizeSchema(schema.getItems(), openApi, context);
                if (normalizedSchema != null) {
                    OpenApiNormalizeUtils.normalizeSchema(normalizedSchema.getItems(), openApi, context);
                }
                return normalizedSchema;
            }
            ArrayList<Object> finalList = new ArrayList<Object>(allOf.size());
            ArrayList schemasWithoutRef = new ArrayList(allOf.size() - 1);
            for (Schema<?> schemaAllOf : allOf) {
                Map paramSchemas;
                Schema<?> normalizedSchema = OpenApiNormalizeUtils.normalizeSchema(schemaAllOf, openApi, context);
                if (normalizedSchema != null) {
                    schemaAllOf = normalizedSchema;
                }
                if (CollectionUtils.isNotEmpty((Map)(paramSchemas = schemaAllOf.getProperties()))) {
                    HashMap paramNormalizedSchemas = new HashMap();
                    for (Map.Entry paramEntry : paramSchemas.entrySet()) {
                        Schema paramSchema = (Schema)paramEntry.getValue();
                        Schema<?> paramNormalizedSchema = OpenApiNormalizeUtils.normalizeSchema(paramSchema, openApi, context);
                        if (paramNormalizedSchema == null) continue;
                        paramNormalizedSchemas.put((String)paramEntry.getKey(), paramNormalizedSchema);
                    }
                    if (CollectionUtils.isNotEmpty(paramNormalizedSchemas)) {
                        paramSchemas.putAll(paramNormalizedSchemas);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)schemaAllOf.get$ref())) {
                    schemasWithoutRef.add(schemaAllOf);
                    if (StringUtils.isNotEmpty((CharSequence)schema.getDescription()) && StringUtils.isNotEmpty((CharSequence)schemaAllOf.getDescription())) {
                        schemaAllOf.setDescription(null);
                    }
                    if (schema.getDefault() == null || schemaAllOf.getDefault() == null || !schema.getDefault().equals(schemaAllOf.getDefault())) continue;
                    schema.setDefault(null);
                    continue;
                }
                finalList.add(schemaAllOf);
            }
            finalList.addAll(schemasWithoutRef);
            schema.setAllOf(finalList);
        }
        OpenApiNormalizeUtils.normalizeSchemaProperties(schema, context);
        OpenApiNormalizeUtils.unwrapAllOff(schema);
        OpenApiNormalizeUtils.normalizeSchema(schema.getItems(), openApi, context);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static void removeDuplicateSchemasInOneOf(List<Schema> oneOf, List<Schema> allOf, OpenAPI openApi) {
        if (CollectionUtils.isEmpty(oneOf) || CollectionUtils.isEmpty(allOf)) {
            return;
        }
        Iterator<Schema> iter = oneOf.iterator();
        while (iter.hasNext()) {
            Schema oneOfSchema = iter.next();
            block1: for (Schema schema : allOf) {
                void var6_6;
                if (schema.get$ref() != null) {
                    Schema<?> schema2 = SchemaUtils.getSchemaByRef(schema.get$ref(), openApi);
                }
                if (var6_6 == null) continue;
                OpenApiNormalizeUtils.removeDuplicateSchemasInOneOf(oneOf, var6_6.getAllOf(), openApi);
                if (CollectionUtils.isEmpty((Collection)var6_6.getOneOf())) continue;
                for (Schema allOfOneOfSchema : var6_6.getOneOf()) {
                    if (!SchemaUtils.isEquals(oneOfSchema, allOfOneOfSchema)) continue;
                    iter.remove();
                    continue block1;
                }
            }
        }
    }

    private static void normalizeSchemaProperties(Schema<?> schema, VisitorContext context) {
        Object object;
        if (schema == null) {
            return;
        }
        String type = schema.getType();
        if (!"string".equals(type) && (object = schema.getExample()) instanceof String) {
            String exampleStr = (String)object;
            schema.setExample(ConvertUtils.parseByTypeAndFormat(exampleStr, type, schema.getFormat(), context, false));
        }
    }

    public static void normalizeSchemas(Map<String, Schema> schemas, OpenAPI openApi, VisitorContext context) {
        if (CollectionUtils.isEmpty(schemas)) {
            return;
        }
        HashMap normalizedSchemas = new HashMap();
        for (Map.Entry<String, Schema> entry : schemas.entrySet()) {
            Map paramSchemas;
            Schema schema = entry.getValue();
            Schema<?> normalizedSchema = OpenApiNormalizeUtils.normalizeSchema(schema, openApi, context);
            if (normalizedSchema != null) {
                normalizedSchemas.put(entry.getKey(), normalizedSchema);
            } else if (schema.equals(SchemaUtils.EMPTY_ARBITRARY_SCHEMA)) {
                schema.setType("object");
            }
            if (!CollectionUtils.isNotEmpty((Map)(paramSchemas = schema.getProperties()))) continue;
            HashMap paramNormalizedSchemas = new HashMap();
            for (Map.Entry paramEntry : paramSchemas.entrySet()) {
                Schema paramSchema = (Schema)paramEntry.getValue();
                Schema<?> paramNormalizedSchema = OpenApiNormalizeUtils.normalizeSchema(paramSchema, openApi, context);
                if (paramNormalizedSchema != null) {
                    paramNormalizedSchemas.put((String)paramEntry.getKey(), paramNormalizedSchema);
                    continue;
                }
                if (!paramSchema.equals(SchemaUtils.EMPTY_ARBITRARY_SCHEMA)) continue;
                paramSchema.setType("object");
            }
            if (!CollectionUtils.isNotEmpty(paramNormalizedSchemas)) continue;
            paramSchemas.putAll(paramNormalizedSchemas);
        }
        if (CollectionUtils.isNotEmpty(normalizedSchemas)) {
            schemas.putAll(normalizedSchemas);
        }
    }

    public static void removeEmptyComponents(OpenAPI openApi) {
        Components components;
        if (CollectionUtils.isEmpty((Map)openApi.getWebhooks())) {
            openApi.setWebhooks(null);
        }
        if ((components = openApi.getComponents()) == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Map)components.getSchemas())) {
            components.setSchemas(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getResponses())) {
            components.setResponses(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getParameters())) {
            components.setParameters(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getExamples())) {
            components.setExamples(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getRequestBodies())) {
            components.setRequestBodies(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getHeaders())) {
            components.setHeaders(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getSecuritySchemes())) {
            components.setSecuritySchemes(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getLinks())) {
            components.setLinks(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getCallbacks())) {
            components.setCallbacks(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getExtensions())) {
            components.setExtensions(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getPathItems())) {
            components.setPathItems(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getSchemas()) && CollectionUtils.isEmpty((Map)components.getResponses()) && CollectionUtils.isEmpty((Map)components.getParameters()) && CollectionUtils.isEmpty((Map)components.getExamples()) && CollectionUtils.isEmpty((Map)components.getRequestBodies()) && CollectionUtils.isEmpty((Map)components.getHeaders()) && CollectionUtils.isEmpty((Map)components.getSecuritySchemes()) && CollectionUtils.isEmpty((Map)components.getLinks()) && CollectionUtils.isEmpty((Map)components.getCallbacks()) && CollectionUtils.isEmpty((Map)components.getExtensions()) && CollectionUtils.isEmpty((Map)components.getPathItems())) {
            openApi.setComponents(null);
        }
    }

    public static void findAndRemoveDuplicates(OpenAPI openApi) {
        openApi.setTags(Utils.findAndRemoveDuplicates(openApi.getTags(), (el1, el2) -> el1.getName() != null && el1.getName().equals(el2.getName())));
        openApi.setServers(Utils.findAndRemoveDuplicates(openApi.getServers(), (el1, el2) -> el1.getUrl() != null && el1.getUrl().equals(el2.getUrl())));
        openApi.setSecurity(Utils.findAndRemoveDuplicates(openApi.getSecurity(), (el1, el2) -> el1 != null && el1.equals(el2)));
        if (CollectionUtils.isNotEmpty((Map)openApi.getPaths())) {
            for (PathItem path : openApi.getPaths().values()) {
                path.setServers(Utils.findAndRemoveDuplicates(path.getServers(), (el1, el2) -> el1.getUrl() != null && el1.getUrl().equals(el2.getUrl())));
                path.setParameters(Utils.findAndRemoveDuplicates(path.getParameters(), (el1, el2) -> el1.getName() != null && el1.getName().equals(el2.getName()) && el1.getIn() != null && el1.getIn().equals(el2.getIn())));
                OpenApiNormalizeUtils.findAndRemoveDuplicates(path.getGet());
                OpenApiNormalizeUtils.findAndRemoveDuplicates(path.getPut());
                OpenApiNormalizeUtils.findAndRemoveDuplicates(path.getPost());
                OpenApiNormalizeUtils.findAndRemoveDuplicates(path.getDelete());
                OpenApiNormalizeUtils.findAndRemoveDuplicates(path.getOptions());
                OpenApiNormalizeUtils.findAndRemoveDuplicates(path.getHead());
                OpenApiNormalizeUtils.findAndRemoveDuplicates(path.getPatch());
                OpenApiNormalizeUtils.findAndRemoveDuplicates(path.getTrace());
            }
        }
        if (openApi.getComponents() != null && CollectionUtils.isNotEmpty((Map)openApi.getComponents().getSchemas())) {
            for (Schema schema : openApi.getComponents().getSchemas().values()) {
                OpenApiNormalizeUtils.findAndRemoveDuplicates(schema);
            }
        }
    }

    public static void findAndRemoveDuplicates(Operation operation) {
        if (operation == null) {
            return;
        }
        operation.setTags(Utils.findAndRemoveDuplicates(operation.getTags(), (el1, el2) -> el1 != null && el1.equals(el2)));
        operation.setServers(Utils.findAndRemoveDuplicates(operation.getServers(), (el1, el2) -> el1.getUrl() != null && el1.getUrl().equals(el2.getUrl())));
        operation.setSecurity(Utils.findAndRemoveDuplicates(operation.getSecurity(), (el1, el2) -> el1 != null && el1.equals(el2)));
        if (CollectionUtils.isNotEmpty((Collection)operation.getParameters())) {
            for (Parameter param : operation.getParameters()) {
                OpenApiNormalizeUtils.findAndRemoveDuplicates(param.getContent());
                OpenApiNormalizeUtils.findAndRemoveDuplicates(param.getSchema());
            }
            operation.setParameters(Utils.findAndRemoveDuplicates(operation.getParameters(), (el1, el2) -> el1.getName() != null && el1.getName().equals(el2.getName()) && el1.getIn() != null && el1.getIn().equals(el2.getIn())));
        }
        if (operation.getRequestBody() != null) {
            OpenApiNormalizeUtils.findAndRemoveDuplicates(operation.getRequestBody().getContent());
        }
        if (CollectionUtils.isNotEmpty((Map)operation.getResponses())) {
            for (ApiResponse response : operation.getResponses().values()) {
                OpenApiNormalizeUtils.findAndRemoveDuplicates(response.getContent());
            }
        }
    }

    public static void findAndRemoveDuplicates(Content content) {
        if (CollectionUtils.isEmpty((Map)content)) {
            return;
        }
        for (MediaType mediaType : content.values()) {
            OpenApiNormalizeUtils.findAndRemoveDuplicates(mediaType.getSchema());
        }
    }

    public static void findAndRemoveDuplicates(Schema<?> schema) {
        if (schema == null) {
            return;
        }
        schema.setRequired(Utils.findAndRemoveDuplicates(schema.getRequired(), (el1, el2) -> el1 != null && el1.equals(el2)));
        schema.setPrefixItems(Utils.findAndRemoveDuplicates(schema.getPrefixItems(), (el1, el2) -> el1 != null && el1.equals(el2)));
        schema.setAllOf(Utils.findAndRemoveDuplicates(schema.getAllOf(), SchemaUtils::isEquals));
        schema.setAnyOf(Utils.findAndRemoveDuplicates(schema.getAnyOf(), SchemaUtils::isEquals));
        schema.setOneOf(Utils.findAndRemoveDuplicates(schema.getOneOf(), SchemaUtils::isEquals));
    }

    private static void unwrapAllOff(Schema<?> schema) {
        if (schema == null || CollectionUtils.isEmpty((Collection)schema.getAllOf())) {
            return;
        }
        ArrayList<Schema> mergedAllOf = new ArrayList<Schema>();
        Schema firstAllOfSchema = null;
        for (Schema innerSchema : schema.getAllOf()) {
            if (innerSchema.get$ref() != null) {
                mergedAllOf.add(innerSchema);
                continue;
            }
            if (firstAllOfSchema == null) {
                firstAllOfSchema = innerSchema;
                mergedAllOf.add(firstAllOfSchema);
                continue;
            }
            SchemaUtils.appendSchema(firstAllOfSchema, innerSchema);
        }
        schema.setAllOf(mergedAllOf);
        int index = 0;
        HashMap<Integer, Schema> innerSchemas = new HashMap<Integer, Schema>();
        for (Schema schema2 : schema.getAllOf()) {
            if (StringUtils.isEmpty((CharSequence)schema2.get$ref())) {
                innerSchemas.put(index, schema2);
            }
            ++index;
        }
        if (innerSchemas.isEmpty()) {
            return;
        }
        for (Map.Entry entry : innerSchemas.entrySet()) {
            Schema innerSchema = (Schema)entry.getValue();
            innerSchema.setName(null);
            if (CollectionUtils.isNotEmpty((Map)innerSchema.getExtensions())) {
                innerSchema.getExtensions().forEach((k, v) -> schema.addExtension(k.toString(), v));
            }
            innerSchema.setExtensions(null);
            if (schema.getType() == null && innerSchema.getType() != null) {
                schema.setType(innerSchema.getType());
                innerSchema.setType(null);
            }
            if (StringUtils.isNotEmpty((CharSequence)innerSchema.getTitle())) {
                schema.setTitle(innerSchema.getTitle());
                innerSchema.setTitle(null);
            }
            if (StringUtils.isNotEmpty((CharSequence)innerSchema.getDescription())) {
                schema.setDescription(innerSchema.getDescription());
                innerSchema.setDescription(null);
                Map jsonSchema = innerSchema.getJsonSchema();
                if (CollectionUtils.isNotEmpty((Map)jsonSchema)) {
                    jsonSchema.remove("description");
                }
                if (CollectionUtils.isEmpty((Map)jsonSchema)) {
                    innerSchema.setJsonSchema(null);
                }
            }
            if (innerSchema.getDeprecated() != null) {
                schema.setDeprecated(innerSchema.getDeprecated());
                if (!schema.getDeprecated().booleanValue()) {
                    schema.setDeprecated(Boolean.valueOf(false));
                }
                innerSchema.setDeprecated(null);
            }
            if (innerSchema.getNullable() != null) {
                schema.setNullable(innerSchema.getNullable());
                if (!schema.getNullable().booleanValue()) {
                    schema.setNullable(Boolean.valueOf(false));
                }
                innerSchema.setNullable(null);
            }
            if (innerSchema.getDefault() != null) {
                schema.setDefault(innerSchema.getDefault());
                innerSchema.setDefault(null);
            }
            if (innerSchema.getAnyOf() != null && schema.getAnyOf() == null) {
                schema.setAnyOf(innerSchema.getAnyOf());
                innerSchema.setAnyOf(null);
            }
            if (innerSchema.getOneOf() != null && schema.getOneOf() == null) {
                schema.setOneOf(innerSchema.getOneOf());
                innerSchema.setOneOf(null);
            }
            if (innerSchema.getNot() != null && schema.getNot() == null) {
                schema.setNot(innerSchema.getNot());
                innerSchema.setNot(null);
            }
            if (CollectionUtils.isNotEmpty((Collection)innerSchema.getRequired())) {
                schema.setRequired(innerSchema.getRequired());
                innerSchema.setRequired(null);
            }
            if (innerSchema.getExample() != null) {
                schema.setExampleSetFlag(innerSchema.getExampleSetFlag());
                schema.setExample(innerSchema.getExample());
                innerSchema.setExample(null);
                innerSchema.setExampleSetFlag(false);
            }
            if (CollectionUtils.isNotEmpty((Collection)innerSchema.getExamples())) {
                schema.setExamples(innerSchema.getExamples());
                innerSchema.setExamples(null);
            }
            if (innerSchema.getExternalDocs() != null) {
                schema.setExternalDocs(innerSchema.getExternalDocs());
                innerSchema.setExternalDocs(null);
            }
            if (innerSchema.getReadOnly() != null) {
                schema.setReadOnly(innerSchema.getReadOnly());
                innerSchema.setReadOnly(null);
            }
            if (innerSchema.getAdditionalProperties() != null) {
                schema.setAdditionalProperties(innerSchema.getAdditionalProperties());
                innerSchema.setAdditionalProperties(null);
            }
            if (SchemaUtils.isEmptySchema(innerSchema) && CollectionUtils.isNotEmpty((Collection)schema.getAllOf())) {
                schema.getAllOf().remove((Integer)entry.getKey());
            }
            if (!CollectionUtils.isEmpty((Collection)schema.getAllOf())) continue;
            schema.setAllOf(null);
        }
    }
}

