/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.javadoc.JavadocDescription;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.SchemaDefinitionUtils;
import io.micronaut.openapi.visitor.StringUtil;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@Internal
public final class TagUtils {
    public static <T, A extends Annotation> List<T> processOpenApiAnnotation(Element element, VisitorContext context, Class<A> annotationType, Class<T> modelType, List<T> tagList) {
        List annotations = element.getAnnotationValuesByType(annotationType);
        if (CollectionUtils.isEmpty(tagList)) {
            tagList = new ArrayList<T>();
        }
        if (CollectionUtils.isEmpty((Collection)annotations)) {
            return tagList;
        }
        for (AnnotationValue tag : annotations) {
            T tagObj;
            Map<CharSequence, Object> values;
            Map<CharSequence, Object> tagValues = tag.getValues();
            if (tag.getAnnotationName().equals(SecurityRequirement.class.getName()) && !tagValues.isEmpty()) {
                Object name = tagValues.get("name");
                Object scopes = tagValues.computeIfAbsent("scopes", key -> new ArrayList());
                values = Collections.singletonMap((CharSequence)name, scopes);
            } else {
                values = tagValues;
            }
            if ((tagObj = SchemaDefinitionUtils.toValue(tag.getAnnotationName(), values, context, modelType, null)) == null) continue;
            boolean alreadyExists = false;
            if (CollectionUtils.isNotEmpty(tagList) && tag.getAnnotationName().equals(Tag.class.getName())) {
                String newTagName = ((io.swagger.v3.oas.models.tags.Tag)tagObj).getName();
                for (T existedTag : tagList) {
                    if (!((io.swagger.v3.oas.models.tags.Tag)existedTag).getName().equals(newTagName)) continue;
                    alreadyExists = true;
                    break;
                }
            }
            if (alreadyExists) continue;
            tagList.add(tagObj);
        }
        return tagList;
    }

    public static void readTags(MethodElement element, VisitorContext context, Operation swaggerOperation, List<io.swagger.v3.oas.models.tags.Tag> classTags, OpenAPI openApi) {
        element.getAnnotationValuesByType(Tag.class).forEach(av -> av.stringValue("name").ifPresent(arg_0 -> ((Operation)swaggerOperation).addTagsItem(arg_0)));
        ArrayList copyTags = openApi.getTags() != null ? new ArrayList(openApi.getTags()) : null;
        List<io.swagger.v3.oas.models.tags.Tag> operationTags = TagUtils.processOpenApiAnnotation((Element)element, context, Tag.class, io.swagger.v3.oas.models.tags.Tag.class, copyTags);
        ArrayList<io.swagger.v3.oas.models.tags.Tag> complexTags = null;
        if (CollectionUtils.isNotEmpty(operationTags)) {
            complexTags = new ArrayList<io.swagger.v3.oas.models.tags.Tag>();
            for (io.swagger.v3.oas.models.tags.Tag operationTag : operationTags) {
                if (!StringUtils.hasText((CharSequence)operationTag.getDescription()) && !CollectionUtils.isNotEmpty((Map)operationTag.getExtensions()) && operationTag.getExternalDocs() == null) continue;
                complexTags.add(operationTag);
            }
        }
        if (CollectionUtils.isNotEmpty(complexTags)) {
            if (CollectionUtils.isEmpty((Collection)openApi.getTags())) {
                openApi.setTags(complexTags);
            } else {
                for (io.swagger.v3.oas.models.tags.Tag complexTag : complexTags) {
                    boolean alreadyExists = false;
                    for (io.swagger.v3.oas.models.tags.Tag apiTag : openApi.getTags()) {
                        if (!apiTag.getName().equals(complexTag.getName())) continue;
                        alreadyExists = true;
                        break;
                    }
                    if (alreadyExists) continue;
                    openApi.getTags().add(complexTag);
                }
            }
        }
        element.getValues(Tags.class, AnnotationValue.class).forEach((k, v) -> v.stringValue("name").ifPresent(name -> TagUtils.addTagIfNotPresent((String)name, swaggerOperation)));
        classTags.forEach(tag -> TagUtils.addTagIfNotPresent(tag.getName(), swaggerOperation));
        if (CollectionUtils.isNotEmpty((Collection)swaggerOperation.getTags())) {
            swaggerOperation.getTags().sort(Comparator.naturalOrder());
        }
    }

    public static void addTagIfNotPresent(String tag, Operation swaggerOperation) {
        List tags = swaggerOperation.getTags();
        if (tags == null || !tags.contains(tag)) {
            swaggerOperation.addTagsItem(tag);
        }
    }

    public static List<io.swagger.v3.oas.models.tags.Tag> readTags(ClassElement element, VisitorContext context) {
        return TagUtils.readTags(element.getAnnotationValuesByType(Tag.class), context);
    }

    public static List<io.swagger.v3.oas.models.tags.Tag> readTags(List<AnnotationValue<Tag>> tagAnns, VisitorContext context) {
        ArrayList<io.swagger.v3.oas.models.tags.Tag> tags = new ArrayList<io.swagger.v3.oas.models.tags.Tag>();
        for (AnnotationValue<Tag> tagAnn : tagAnns) {
            io.swagger.v3.oas.models.tags.Tag tag = SchemaDefinitionUtils.toValue(tagAnn.getAnnotationName(), tagAnn.getValues(), context, io.swagger.v3.oas.models.tags.Tag.class, null);
            if (tag == null) continue;
            tags.add(tag);
        }
        return tags;
    }

    public static List<io.swagger.v3.oas.models.tags.Tag> generationTags(ClassElement element, String classDescription, VisitorContext context) {
        io.swagger.v3.oas.models.tags.Tag tagByClass = null;
        if (ConfigUtils.isTagGenerationByClassEnabled(context)) {
            tagByClass = TagUtils.generateTag(element.getSimpleName(), StringUtils.isNotEmpty((CharSequence)classDescription) ? classDescription : (String)element.getDocumentation().orElse(null), false, context);
        }
        io.swagger.v3.oas.models.tags.Tag tagByPackage = null;
        if (ConfigUtils.isTagGenerationByPackageEnabled(context)) {
            tagByPackage = TagUtils.generateTag(element.getPackageName(), element.getPackage().getDocumentation().orElse(null), true, context);
        }
        if (tagByClass == null && tagByPackage == null) {
            return Collections.emptyList();
        }
        List<io.swagger.v3.oas.models.tags.Tag> globalTags = Utils.resolveTags(Utils.resolveOpenApi(context));
        ArrayList<io.swagger.v3.oas.models.tags.Tag> operationTags = new ArrayList<io.swagger.v3.oas.models.tags.Tag>();
        TagUtils.addIfDoesntExist(tagByClass, operationTags, globalTags);
        TagUtils.addIfDoesntExist(tagByPackage, operationTags, globalTags);
        return operationTags;
    }

    private static void addIfDoesntExist(io.swagger.v3.oas.models.tags.Tag tag, List<io.swagger.v3.oas.models.tags.Tag> operationTags, List<io.swagger.v3.oas.models.tags.Tag> globalTags) {
        if (tag == null) {
            return;
        }
        boolean opTagAlreadyExists = false;
        for (io.swagger.v3.oas.models.tags.Tag opTag : operationTags) {
            if (!opTag.getName().equals(tag.getName())) continue;
            opTagAlreadyExists = true;
            break;
        }
        if (!opTagAlreadyExists) {
            operationTags.add(new io.swagger.v3.oas.models.tags.Tag().name(tag.getName()));
        }
        if (StringUtils.isEmpty((CharSequence)tag.getDescription())) {
            return;
        }
        boolean globalTagAlreadyExists = false;
        for (io.swagger.v3.oas.models.tags.Tag globalTag : globalTags) {
            if (!globalTag.getName().equals(tag.getName())) continue;
            globalTagAlreadyExists = true;
            break;
        }
        if (!globalTagAlreadyExists) {
            globalTags.add(tag);
        }
    }

    private static io.swagger.v3.oas.models.tags.Tag generateTag(String elementName, String javadocStr, boolean isPackageName, VisitorContext context) {
        PropertyNamingStrategies.NamingBase namingBase;
        String tagName = elementName;
        String tagNameLower = tagName.toLowerCase(Locale.ENGLISH);
        List<String> prefixes = ConfigUtils.getTagGenerationRemovePrefixes(context);
        if (CollectionUtils.isNotEmpty(prefixes)) {
            for (String string : prefixes) {
                if (string.isEmpty() || !tagNameLower.startsWith(string)) continue;
                tagName = tagName.substring(string.length());
                break;
            }
        }
        tagNameLower = tagName.toLowerCase(Locale.ENGLISH);
        List<String> postfixes = ConfigUtils.getTagGenerationRemovePostfixes(context);
        if (CollectionUtils.isNotEmpty(postfixes)) {
            for (String postfix : postfixes) {
                if (postfix.isEmpty() || !tagNameLower.endsWith(postfix)) continue;
                tagName = tagName.substring(0, tagNameLower.indexOf(postfix));
                break;
            }
        }
        if ((namingBase = ConfigUtils.getTagGenerationNamingStrategy(context)) != null) {
            if (isPackageName) {
                tagName = NameUtils.camelCase((String)tagName.replace(".", "_"));
            }
            tagName = namingBase.translate(tagName);
        }
        io.swagger.v3.oas.models.tags.Tag tag = new io.swagger.v3.oas.models.tags.Tag().name(tagName);
        JavadocDescription javadoc = Utils.getJavadocParser().parse(javadocStr);
        if (javadoc != null) {
            String descFromJavaDoc;
            String string = descFromJavaDoc = StringUtils.isNotEmpty((CharSequence)javadoc.getMethodSummary()) ? javadoc.getMethodSummary() : javadoc.getMethodDescription();
            if (StringUtils.isNotEmpty((CharSequence)descFromJavaDoc)) {
                int descriptionLength = ConfigUtils.getTagGenerationDescriptionMaxLength(context);
                if (descriptionLength > 0) {
                    descFromJavaDoc = StringUtil.left(descFromJavaDoc, descriptionLength);
                }
                tag.description(descFromJavaDoc);
            }
        }
        return tag;
    }
}

