/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.MediaType;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.OpenApiUtils;
import io.micronaut.openapi.javadoc.JavadocParser;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.OpenApiExcludeVisitor;
import io.micronaut.openapi.visitor.OpenApiExtraSchemaVisitor;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.SchemaDefinitionUtils;
import io.micronaut.openapi.visitor.group.EndpointInfo;
import io.micronaut.openapi.visitor.group.OpenApiInfo;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.SpecVersion;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;

@Internal
public final class Utils {
    public static final String ATTR_OPENAPI = "io.micronaut.OPENAPI";
    public static final String ATTR_TEST_MODE = "io.micronaut.OPENAPI_TEST";
    public static final String ATTR_TEST_SPRING_ACTUATOR = "io.micronaut.OPENAPI_TEST_SPRING_ACTUATOR";
    public static final String ATTR_VISITED_ELEMENTS = "io.micronaut.OPENAPI.visited.elements";
    public static final List<MediaType> DEFAULT_MEDIA_TYPES = Collections.singletonList(MediaType.APPLICATION_JSON_TYPE);
    private static Map<String, MethodElement> creatorConstructorsCache = new HashMap<String, MethodElement>();
    private static boolean openapi31;
    private static boolean initialized;
    private static Set<String> allKnownVersions;
    private static Set<String> allKnownGroups;
    private static Map<String, List<EndpointInfo>> endpointInfos;
    private static Map<String, OpenAPI> openApis;
    private static Map<String, List<String>> includedClassesGroups;
    private static Map<String, List<String>> includedClassesGroupsExcluded;
    private static OpenAPI testReference;
    private static Map<Pair<String, String>, OpenApiInfo> testReferences;
    private static String testFileName;
    private static String testYamlReference;
    private static String testJsonReference;
    private static JavadocParser javadocParser;

    private Utils() {
    }

    public static boolean isKsp(VisitorContext context) {
        return context.getClass().getName().equals("io.micronaut.kotlin.processing.visitor.KotlinVisitorContext");
    }

    public static void init(VisitorContext context) {
        if (initialized) {
            return;
        }
        Utils.setOpenapi31(ConfigUtils.getBooleanProperty("micronaut.openapi.openapi31.enabled", false, context));
        javadocParser = new JavadocParser(ConfigUtils.getDocsFormat(context), context);
        initialized = true;
    }

    public static MediaType getMediaType(String mediaTypeName) {
        try {
            return MediaType.of((String)mediaTypeName);
        }
        catch (Exception e) {
            return new MediaType(mediaTypeName);
        }
    }

    public static <T extends Enum<T>> void normalizeEnumValues(Map<CharSequence, Object> paramValues, Map<String, Class<T>> enumTypes) {
        for (Map.Entry<String, Class<T>> entry : enumTypes.entrySet()) {
            String name = entry.getKey();
            Class<T> enumType = entry.getValue();
            Object in = paramValues.get(name);
            if (in == null) continue;
            try {
                T enumInstance = Enum.valueOf(enumType, in.toString());
                paramValues.put(name, ((Enum)enumInstance).toString());
            }
            catch (Exception exception) {}
        }
    }

    public static <T> List<T> findAndRemoveDuplicates(List<T> elements, BiPredicate<T, T> predicate) {
        if (CollectionUtils.isEmpty(elements)) {
            return elements;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T element : elements) {
            boolean found = false;
            for (Object el : result) {
                if (!predicate.test(element, el)) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(element);
        }
        if (result.size() != elements.size()) {
            return result;
        }
        return elements;
    }

    public static Components resolveComponents(OpenAPI openApi) {
        Components components = openApi.getComponents();
        if (components == null) {
            components = new Components();
            openApi.setComponents(components);
        }
        return components;
    }

    public static Map<String, PathItem> resolveWebhooks(OpenAPI openApi) {
        HashMap webhooks = openApi.getWebhooks();
        if (webhooks == null) {
            webhooks = new HashMap();
            openApi.setWebhooks(webhooks);
        }
        return webhooks;
    }

    public static List<Tag> resolveTags(OpenAPI openApi) {
        ArrayList tags = openApi.getTags();
        if (tags == null) {
            tags = new ArrayList();
            openApi.setTags(tags);
        }
        return tags;
    }

    public static OpenAPI resolveOpenApi(VisitorContext context) {
        OpenAPI openApi = ContextUtils.get(ATTR_OPENAPI, OpenAPI.class, context);
        if (openApi == null) {
            openApi = new OpenAPI();
            if (Utils.isOpenapi31()) {
                openApi.openapi("3.1.0").jsonSchemaDialect(ConfigUtils.getJsonSchemaDialect(context)).specVersion(SpecVersion.V31);
            }
            ContextUtils.put(ATTR_OPENAPI, openApi, context);
        }
        return openApi;
    }

    public static String printStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        sw.append(t.getMessage()).append('\n');
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static boolean isTestMode() {
        return Boolean.getBoolean(ATTR_TEST_MODE);
    }

    public static boolean isTestSpringActuator() {
        return Boolean.getBoolean(ATTR_TEST_SPRING_ACTUATOR);
    }

    public static OpenAPI getTestReference() {
        return testReference;
    }

    public static void setTestReference(OpenAPI testReference) {
        Utils.testReference = testReference;
    }

    public static Map<Pair<String, String>, OpenApiInfo> getTestReferences() {
        return testReferences;
    }

    public static void setTestReferences(Map<Pair<String, String>, OpenApiInfo> testReferences) {
        Utils.testReferences = testReferences;
    }

    public static String getTestYamlReference() {
        return testYamlReference;
    }

    public static void setTestYamlReference(String testYamlReference) {
        Utils.testYamlReference = testYamlReference;
    }

    public static String getTestJsonReference() {
        return testJsonReference;
    }

    public static String getTestFileName() {
        return testFileName;
    }

    public static void setTestFileName(String testFileName) {
        Utils.testFileName = testFileName;
    }

    public static void setTestJsonReference(String testJsonReference) {
        Utils.testJsonReference = testJsonReference;
    }

    public static JavadocParser getJavadocParser() {
        return javadocParser;
    }

    public static void setJavadocParser(JavadocParser javadocParser) {
        Utils.javadocParser = javadocParser;
    }

    public static Set<String> getAllKnownVersions() {
        if (allKnownVersions == null) {
            allKnownVersions = new HashSet<String>();
        }
        return allKnownVersions;
    }

    public static void setAllKnownVersions(Set<String> allKnownVersions) {
        Utils.allKnownVersions = allKnownVersions;
    }

    public static Set<String> getAllKnownGroups() {
        if (allKnownGroups == null) {
            allKnownGroups = new HashSet<String>();
        }
        return allKnownGroups;
    }

    public static void setAllKnownGroups(Set<String> allKnownGroups) {
        Utils.allKnownGroups = allKnownGroups;
    }

    public static Map<String, List<EndpointInfo>> getEndpointInfos() {
        return endpointInfos;
    }

    public static void setEndpointInfos(Map<String, List<EndpointInfo>> endpointInfos) {
        Utils.endpointInfos = endpointInfos;
    }

    public static Map<String, OpenAPI> getOpenApis() {
        return openApis;
    }

    public static void setOpenApis(Map<String, OpenAPI> openApis) {
        Utils.openApis = openApis;
    }

    public static Map<String, List<String>> getIncludedClassesGroups() {
        return includedClassesGroups;
    }

    public static void setIncludedClassesGroups(Map<String, List<String>> includedClassesGroups) {
        Utils.includedClassesGroups = includedClassesGroups;
    }

    public static Map<String, List<String>> getIncludedClassesGroupsExcluded() {
        return includedClassesGroupsExcluded;
    }

    public static void setIncludedClassesGroupsExcluded(Map<String, List<String>> includedClassesGroupsExcluded) {
        Utils.includedClassesGroupsExcluded = includedClassesGroupsExcluded;
    }

    public static Map<String, MethodElement> getCreatorConstructorsCache() {
        return creatorConstructorsCache;
    }

    public static ObjectMapper getJsonMapper() {
        return openapi31 ? OpenApiUtils.getJsonMapper31() : OpenApiUtils.getJsonMapper();
    }

    public static ObjectMapper getYamlMapper() {
        return openapi31 ? OpenApiUtils.getYamlMapper31() : OpenApiUtils.getYamlMapper();
    }

    public static boolean isOpenapi31() {
        return openapi31;
    }

    public static void setOpenapi31(boolean openapi31) {
        System.setProperty("bind-type", "true");
        Utils.openapi31 = openapi31;
    }

    public static void clean() {
        openapi31 = false;
        initialized = false;
        openApis = null;
        endpointInfos = null;
        includedClassesGroups = null;
        includedClassesGroupsExcluded = null;
        allKnownGroups = null;
        allKnownVersions = null;
        testReference = null;
        testReferences = null;
        testFileName = null;
        testYamlReference = null;
        testJsonReference = null;
        creatorConstructorsCache = new HashMap<String, MethodElement>();
        System.clearProperty("bind-type");
        SchemaDefinitionUtils.clean();
        OpenApiExtraSchemaVisitor.clean();
        OpenApiExcludeVisitor.clean();
    }
}

