/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor.management;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Internal
public final class EndpointUtils {
    public static final Map<String, String> ALL_MICRONAUT_MANAGEMENT_ENDPOINTS = Map.of("beans", "io.micronaut.management.endpoint.beans.BeansEndpoint", "env", "io.micronaut.management.endpoint.env.EnvironmentEndpoint", "health", "io.micronaut.management.endpoint.health.HealthEndpoint", "info", "io.micronaut.management.endpoint.info.InfoEndpoint", "loggers", "io.micronaut.management.endpoint.loggers.LoggersEndpoint", "refresh", "io.micronaut.management.endpoint.refresh.RefreshEndpoint", "routes", "io.micronaut.management.endpoint.routes.RoutesEndpoint", "stop", "io.micronaut.management.endpoint.stop.ServerStopEndpoint", "threaddump", "io.micronaut.management.endpoint.threads.ThreadDumpEndpoint");
    public static final Map<String, String> ALL_SPRING_ACTUATOR_ENDPOINTS = Map.ofEntries(Map.entry("auditevents", "org.springframework.boot.actuate.audit.AuditEventsEndpoint"), Map.entry("beans", "org.springframework.boot.actuate.beans.BeansEndpoint"), Map.entry("caches", "org.springframework.boot.actuate.cache.CachesEndpoint"), Map.entry("configprops", "org.springframework.boot.actuate.context.properties.ConfigurationPropertiesReportEndpoint"), Map.entry("conditions", "org.springframework.boot.actuate.autoconfigure.condition.ConditionsReportEndpoint"), Map.entry("shutdown", "org.springframework.boot.actuate.context.ShutdownEndpoint"), Map.entry("env", "org.springframework.boot.actuate.env.EnvironmentEndpoint"), Map.entry("flyway", "org.springframework.boot.actuate.flyway.FlywayEndpoint"), Map.entry("health", "org.springframework.boot.actuate.health.HealthEndpoint"), Map.entry("info", "org.springframework.boot.actuate.info.InfoEndpoint"), Map.entry("integrationgraph", "org.springframework.boot.actuate.integration.IntegrationGraphEndpoint"), Map.entry("liquibase", "org.springframework.boot.actuate.liquibase.LiquibaseEndpoint"), Map.entry("logfile", "org.springframework.boot.actuate.logging.LogFileWebEndpoint"), Map.entry("loggers", "org.springframework.boot.actuate.logging.LoggersEndpoint"), Map.entry("heapdump", "org.springframework.boot.actuate.management.HeapDumpWebEndpoint"), Map.entry("threaddump", "org.springframework.boot.actuate.management.ThreadDumpEndpoint"), Map.entry("metrics", "org.springframework.boot.actuate.metrics.MetricsEndpoint"), Map.entry("quartz", "org.springframework.boot.actuate.quartz.QuartzEndpoint"), Map.entry("sbom", "org.springframework.boot.actuate.sbom.SbomEndpoint"), Map.entry("scheduledtasks", "org.springframework.boot.actuate.scheduling.ScheduledTasksEndpoint"), Map.entry("sessions", "org.springframework.boot.actuate.session.SessionsEndpoint"), Map.entry("startup", "org.springframework.boot.actuate.startup.StartupEndpoint"), Map.entry("httpexchanges", "org.springframework.boot.actuate.web.exchanges.HttpExchangesEndpoint"), Map.entry("mappings", "org.springframework.boot.actuate.web.mappings.MappingsEndpoint"), Map.entry("prometheus", "org.springframework.boot.actuate.metrics.export.prometheus.PrometheusScrapeEndpoint"));
    public static final Map<String, String> SPECIFIC_ENDPOINTS = Map.of("org.springframework.boot.actuate.integration.IntegrationGraphEndpoint", "org.springframework.integration.graph.IntegrationGraphServer", "org.springframework.boot.actuate.metrics.MetricsEndpoint", "io.micrometer.core.instrument.Meter", "org.springframework.boot.actuate.flyway.FlywayEndpoint", "org.flywaydb.core.Flyway", "org.springframework.boot.actuate.session.SessionsEndpoint", "org.springframework.session.Session", "org.springframework.boot.actuate.quartz.QuartzEndpoint", "org.quartz.Job", "org.springframework.boot.actuate.liquibase.LiquibaseEndpoint", "liquibase.integration.spring.SpringLiquibase", "org.springframework.boot.actuate.metrics.export.prometheus.PrometheusScrapeEndpoint", "io.prometheus.metrics.model.registry.PrometheusRegistry");
    public static final List<String> ALL_MANAGEMENT_ENDPOINT_CLASSES;
    public static final String[] ALL_MANAGEMENT_ENDPOINT_CLASSES_ARRAY;

    private EndpointUtils() {
    }

    static {
        ArrayList<String> knownEndpoints = new ArrayList<String>(ALL_MICRONAUT_MANAGEMENT_ENDPOINTS.values());
        knownEndpoints.addAll(ALL_SPRING_ACTUATOR_ENDPOINTS.values());
        ALL_MANAGEMENT_ENDPOINT_CLASSES = List.copyOf(knownEndpoints);
        ALL_MANAGEMENT_ENDPOINT_CLASSES_ARRAY = ALL_MANAGEMENT_ENDPOINT_CLASSES.toArray(StringUtils.EMPTY_STRING_ARRAY);
    }
}

