/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor.management;

import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.Utils;
import io.micronaut.openapi.visitor.management.EndpointProperties;
import io.micronaut.openapi.visitor.management.EndpointUtils;
import io.micronaut.openapi.visitor.management.EndpointsConfig;
import io.micronaut.openapi.visitor.management.SpringActuatorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

@Internal
public final class SpringActuatorConfigUtils {
    public static final String DEFAULT_ACTUATOR_BASE_PATH = "/actuator";

    private SpringActuatorConfigUtils() {
    }

    public static SpringActuatorProperties getSpringActuatorProperties(VisitorContext context) {
        SpringActuatorProperties springActuatorProperties = ContextUtils.get("micronaut.internal.spring.openapi.endpoints", SpringActuatorProperties.class, context);
        if (springActuatorProperties != null) {
            return springActuatorProperties;
        }
        springActuatorProperties = new SpringActuatorProperties();
        Properties sysProps = System.getProperties();
        SpringActuatorConfigUtils.readActuatorProperties(sysProps, springActuatorProperties, context);
        Properties fileProps = ConfigUtils.readOpenApiConfigFile(context);
        SpringActuatorConfigUtils.readActuatorProperties(fileProps, springActuatorProperties, context);
        Environment environment = ConfigUtils.getEnv(context);
        if (environment != null) {
            for (Map.Entry entry : environment.getProperties("management.endpoints.web", StringConvention.RAW).entrySet()) {
                SpringActuatorConfigUtils.setEndpointProperty((String)entry.getKey(), entry.getValue(), springActuatorProperties, context);
            }
        }
        ContextUtils.put("micronaut.internal.spring.openapi.endpoints", springActuatorProperties, context);
        return springActuatorProperties;
    }

    private static void readActuatorProperties(Properties props, SpringActuatorProperties springActuatorProperties, VisitorContext context) {
        for (String prop : props.stringPropertyNames()) {
            int endpointNameIndexEnd;
            if (!prop.startsWith("management.endpoints.web") || (endpointNameIndexEnd = prop.indexOf(46, "management.endpoints.web".length() + 1)) < 0) continue;
            String propertyName = prop.substring("management.endpoints.web".length() + 1, endpointNameIndexEnd).toLowerCase(Locale.ENGLISH);
            SpringActuatorConfigUtils.setEndpointProperty(propertyName, props.get(prop), springActuatorProperties, context);
        }
    }

    private static void setEndpointProperty(String propertyName, Object value, SpringActuatorProperties springActuatorProperties, VisitorContext context) {
        if (value == null) {
            return;
        }
        String valueStr = value.toString();
        String simplePropName = propertyName = propertyName.toLowerCase(Locale.ENGLISH);
        if (propertyName.contains(".")) {
            simplePropName = propertyName.substring(0, propertyName.indexOf("."));
        }
        switch (simplePropName) {
            case "base-path": 
            case "basepath": {
                if (springActuatorProperties.getBasePath() != null) break;
                springActuatorProperties.setBasePath(valueStr);
                break;
            }
            case "exposure": {
                if (propertyName.contains("include") && springActuatorProperties.getIncludedEndpoints() == null) {
                    ArrayList<String> includedEndpoints = new ArrayList<String>();
                    if (value instanceof List) {
                        List includedList = (List)value;
                        for (Object endpointName : includedList) {
                            includedEndpoints.add(endpointName.toString());
                        }
                    } else if (valueStr != null) {
                        for (String string : valueStr.split(",")) {
                            includedEndpoints.add(string.trim().toLowerCase(Locale.ENGLISH));
                        }
                    }
                    springActuatorProperties.setIncludedEndpoints(includedEndpoints);
                }
                if (!propertyName.contains("exclude") || springActuatorProperties.getExcludedEndpoints() != null) break;
                ArrayList<String> excludedEndpoints = new ArrayList<String>();
                if (value instanceof List) {
                    List excludedList = (List)value;
                    for (Object endpointName : excludedList) {
                        excludedEndpoints.add(endpointName.toString());
                    }
                    break;
                }
                if (valueStr == null) break;
                for (String string : valueStr.split(",")) {
                    excludedEndpoints.add(string.trim().toLowerCase(Locale.ENGLISH));
                }
                springActuatorProperties.setIncludedEndpoints(excludedEndpoints);
                break;
            }
            case "path-mapping": 
            case "pathmapping": {
                HashMap<String, String> endpointPaths = springActuatorProperties.getPathMapping() != null ? springActuatorProperties.getPathMapping() : new HashMap<String, String>();
                String endpointName = propertyName.substring(simplePropName.length() + 1);
                if (!endpointPaths.containsKey(endpointName)) {
                    endpointPaths.put(endpointName, valueStr);
                }
                springActuatorProperties.setPathMapping(endpointPaths);
                break;
            }
        }
    }

    public static void mergeWithActuatorProperties(EndpointsConfig endpointsConfig, VisitorContext context) {
        if (!Utils.isTestSpringActuator() && ContextUtils.getClassElement("org.springframework.boot.actuate.endpoint.InvocationContext", context) == null) {
            return;
        }
        Map<String, EndpointProperties> endpointPropertiesMap = endpointsConfig.getEndpoints();
        SpringActuatorProperties springActuatorProperties = SpringActuatorConfigUtils.getSpringActuatorProperties(context);
        boolean allEnabled = CollectionUtils.isEmpty(springActuatorProperties.getIncludedEndpoints()) && CollectionUtils.isEmpty(springActuatorProperties.getExcludedEndpoints()) || springActuatorProperties.getIncludedEndpoints().contains("*");
        ArrayList<String> enabledEndpointIds = new ArrayList<String>();
        ArrayList<Map.Entry<String, String>> enabledEndpoints = new ArrayList<Map.Entry<String, String>>();
        if (allEnabled) {
            enabledEndpoints.addAll(EndpointUtils.ALL_SPRING_ACTUATOR_ENDPOINTS.entrySet());
            enabledEndpointIds.addAll(EndpointUtils.ALL_SPRING_ACTUATOR_ENDPOINTS.keySet());
        } else {
            for (String string : springActuatorProperties.getIncludedEndpoints()) {
                if (!EndpointUtils.ALL_SPRING_ACTUATOR_ENDPOINTS.containsKey(string)) {
                    ContextUtils.warn("Unknown actuator endpoint: " + string + ". Skip it", context);
                    continue;
                }
                enabledEndpoints.add(Map.entry(string, EndpointUtils.ALL_SPRING_ACTUATOR_ENDPOINTS.get(string)));
                enabledEndpointIds.add(string);
            }
        }
        for (Map.Entry entry : enabledEndpoints) {
            ClassElement classEl;
            String endpointName = (String)entry.getKey();
            EndpointProperties endpointProperties = endpointPropertiesMap.get(endpointName);
            if (endpointProperties == null) {
                endpointProperties = new EndpointProperties(endpointName);
                endpointPropertiesMap.put(endpointName, endpointProperties);
            }
            if (endpointProperties.getElement() == null && (classEl = ContextUtils.getClassElement((String)entry.getValue(), context)) != null) {
                endpointProperties.setElement(classEl);
            }
            if (endpointProperties.getEnabled() == null) {
                endpointProperties.setEnabled(true);
            }
            if (endpointProperties.getPath() != null || !CollectionUtils.isNotEmpty(springActuatorProperties.getPathMapping())) continue;
            endpointProperties.setPath(springActuatorProperties.getPathMapping().get(endpointName));
        }
        for (EndpointProperties endpointProperties : endpointsConfig.getEndpoints().values()) {
            if (enabledEndpointIds.contains(endpointProperties.getId())) continue;
            endpointProperties.setEnabled(false);
        }
        if (CollectionUtils.isNotEmpty(springActuatorProperties.getExcludedEndpoints())) {
            for (String string : springActuatorProperties.getExcludedEndpoints()) {
                EndpointProperties endpointProperties = endpointsConfig.getEndpoints().get(string);
                if (endpointProperties == null) continue;
                endpointProperties.setEnabled(false);
            }
        }
        EndpointProperties allEndpointsProperties = endpointsConfig.getEndpoints().get("all");
        String string = ConfigUtils.getConfigProperty("management.server.base-path", context);
        if (StringUtils.isNotEmpty((CharSequence)springActuatorProperties.getBasePath()) || StringUtils.isNotEmpty((CharSequence)string)) {
            if (allEndpointsProperties == null) {
                allEndpointsProperties = new EndpointProperties("all");
            }
            if (allEnabled && allEndpointsProperties.getEnabled() == null) {
                allEndpointsProperties.setEnabled(true);
            }
            if (allEndpointsProperties.getPath() == null) {
                allEndpointsProperties.setPath(springActuatorProperties.getBasePath());
            }
            if (allEndpointsProperties.getContextPath() == null) {
                allEndpointsProperties.setContextPath(string);
            }
        }
        if (StringUtils.isEmpty((CharSequence)endpointsConfig.getPath())) {
            endpointsConfig.setPath(springActuatorProperties.getBasePath());
        }
        if (StringUtils.isEmpty((CharSequence)endpointsConfig.getPath())) {
            endpointsConfig.setPath(DEFAULT_ACTUATOR_BASE_PATH);
        }
    }
}

