/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.view;

import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.view.AbstractViewConfig;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.view.RapiPDFConfig;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.group.OpenApiInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

final class OpenApiExplorerConfig
extends AbstractViewConfig {
    public static final String OPENAPI_EXPLORER_PREFIX = "openapi-explorer.";
    private static final String DEFAULT_OPENAPI_EXPLORER_JS_PATH = "res/";
    private static final List<String> RESOURCE_FILES = List.of("res/default.min.css", "res/bootstrap.min.css", "res/font-awesome.min.css", "res/highlight.min.js", "res/openapi-explorer.min.js");
    private static final Map<String, Object> DEFAULT_OPTIONS = new HashMap<String, Object>();
    private static final Map<String, Function<String, Object>> VALID_OPTIONS = new HashMap<String, Function<String, Object>>(61);
    RapiPDFConfig rapiPDFConfig;

    private OpenApiExplorerConfig(Map<Pair<String, String>, OpenApiInfo> openApiInfos) {
        super(OPENAPI_EXPLORER_PREFIX, openApiInfos);
        this.jsUrl = DEFAULT_OPENAPI_EXPLORER_JS_PATH;
    }

    static OpenApiExplorerConfig fromProperties(Map<String, String> properties, Map<Pair<String, String>, OpenApiInfo> openApiInfos, VisitorContext context) {
        return AbstractViewConfig.fromProperties(new OpenApiExplorerConfig(openApiInfos), DEFAULT_OPTIONS, properties, OpenApiViewConfig.RendererType.OPENAPI_EXPLORER, context);
    }

    @Override
    public String render(String template, VisitorContext context) {
        template = this.rapiPDFConfig.render(template, OpenApiViewConfig.RendererType.OPENAPI_EXPLORER, context);
        template = OpenApiViewConfig.replacePlaceHolder(template, "openapi-explorer.js.url.prefix", this.isDefaultJsUrl ? this.getFinalUrlPrefix(OpenApiViewConfig.RendererType.OPENAPI_EXPLORER, context) : this.jsUrl, "");
        return OpenApiViewConfig.replacePlaceHolder(template, "openapi-explorer.attributes", this.toHtmlAttributes(), "");
    }

    @Override
    protected Function<String, Object> getConverter(String key) {
        return VALID_OPTIONS.get(key);
    }

    @Override
    protected List<String> getResources() {
        return RESOURCE_FILES;
    }

    static {
        VALID_OPTIONS.put("explorer-location", AbstractViewConfig::asString);
        VALID_OPTIONS.put("spec-url", AbstractViewConfig::asString);
        VALID_OPTIONS.put("server-url", AbstractViewConfig::asString);
        VALID_OPTIONS.put("display-nulls", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("hide-defaults", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("collapse", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("table", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("schema-expand-level", AbstractViewConfig::asInt);
        VALID_OPTIONS.put("hide-console", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("hide-authentication", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("hide-server-selection", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("hide-component", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("default-schema-tab", new AbstractViewConfig.EnumConverter<DefaultSchemaTab>(DefaultSchemaTab.class));
        VALID_OPTIONS.put("use-path-in-nav-bar", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("nav-item-spacing", new AbstractViewConfig.EnumConverter<NavItemSpacing>(NavItemSpacing.class));
        VALID_OPTIONS.put("bg-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("header-bg-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("primary-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("secondary-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("text-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("nav-bg-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("nav-hover-text-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("nav-text-color", AbstractViewConfig::asString);
    }

    static enum DefaultSchemaTab {
        MODEL,
        BODY;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static enum NavItemSpacing {
        DEFAULT,
        COMPACT,
        RELAXED;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

