/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.GenericArgument;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.GeneratedFile;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.group.GroupProperties;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

@Internal
public final class ContextUtils {
    public static final Argument<List<Pair<String, String>>> EXPANDABLE_PROPERTIES_ARGUMENT = new GenericArgument<List<Pair<String, String>>>(){};
    public static final Argument<Map<String, ConfigUtils.SchemaDecorator>> ARGUMENT_SCHEMA_DECORATORS_MAP = new GenericArgument<Map<String, ConfigUtils.SchemaDecorator>>(){};
    public static final Argument<Map<String, ConfigUtils.CustomSchema>> ARGUMENT_CUSTOM_SCHEMA_MAP = new GenericArgument<Map<String, ConfigUtils.CustomSchema>>(){};
    public static final Argument<Map<String, GroupProperties>> ARGUMENT_GROUP_PROPERTIES_MAP = new GenericArgument<Map<String, GroupProperties>>(){};

    private ContextUtils() {
    }

    public static Integer getVisitedElements(VisitorContext context) {
        Integer visitedElements = context.get((CharSequence)"io.micronaut.OPENAPI.visited.elements", Integer.class).orElse(null);
        if (visitedElements == null) {
            visitedElements = 0;
            context.put((CharSequence)"io.micronaut.OPENAPI.visited.elements", (Object)visitedElements);
        }
        return visitedElements;
    }

    public static Path getClassesOutputPath(VisitorContext context) {
        Path outputPath = context.get((CharSequence)"micronaut.internal.classpath.output", Path.class).orElse(null);
        if (outputPath != null) {
            return outputPath;
        }
        ContextUtils.visitMetaInfFile("dummy" + System.nanoTime(), context);
        return context.get((CharSequence)"micronaut.internal.classpath.output", Path.class).orElse(null);
    }

    public static GeneratedFile visitMetaInfFile(String path, VisitorContext context) {
        URI uri;
        GeneratedFile cachedFile = context.get((CharSequence)("micronaut.internal.generated.file" + path), GeneratedFile.class).orElse(null);
        if (cachedFile != null) {
            return cachedFile;
        }
        GeneratedFile generatedFile = context.visitMetaInfFile(path, Element.EMPTY_ELEMENT_ARRAY).orElse(null);
        if (generatedFile == null) {
            context.warn("Unable to get " + path + " file.", null);
            return null;
        }
        context.put((CharSequence)("micronaut.internal.generated.file" + path), (Object)generatedFile);
        if (!context.contains("micronaut.internal.classpath.output") && (uri = generatedFile.toURI()).getScheme() != null && !uri.getScheme().equals("mem")) {
            Path generatedFilePath = Path.of(uri);
            int count = 0;
            for (int i = 0; i < path.length(); ++i) {
                if (path.charAt(i) != '/') continue;
                generatedFilePath = generatedFilePath.getParent();
                ++count;
            }
            generatedFilePath = generatedFilePath.getParent();
            context.put((CharSequence)"micronaut.internal.classpath.output", (Object)generatedFilePath);
        }
        return generatedFile;
    }
}

