/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.OpenApiUtils;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.Endpoint;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public class EndpointsConfiguration {
    private static final TypeReference<List<Server>> TYPE_SERVERS_LIST = new TypeReference<List<Server>>(){};
    private static final TypeReference<List<SecurityRequirement>> TYPE_SECURITY_REQUIREMENTS_LIST = new TypeReference<List<SecurityRequirement>>(){};
    private static final String ENDPOINTS_PREFIX = "endpoints.";
    public static final String ENDPOINTS_ENABLED = "endpoints.enabled";
    public static final String ENDPOINTS_TAGS = "endpoints.tags";
    public static final String ENDPOINTS_PATH = "endpoints.path";
    public static final String ENDPOINTS_SERVERS = "endpoints.servers";
    public static final String ENDPOINTS_SECURITY_REQUIREMENTS = "endpoints.security-requirements";
    private final boolean enabled;
    private String path;
    private List<Tag> tags;
    private List<Server> servers;
    private List<SecurityRequirement> securityRequirements;
    private Map<String, Endpoint> endpoints;

    EndpointsConfiguration(VisitorContext context, Properties properties) {
        String enabledStr = ConfigUtils.getConfigProperty(ENDPOINTS_ENABLED, context);
        boolean bl = this.enabled = StringUtils.hasText((CharSequence)enabledStr) && Boolean.parseBoolean(enabledStr);
        if (!this.enabled) {
            return;
        }
        this.path = EndpointsConfiguration.parsePath(ConfigUtils.getConfigProperty(ENDPOINTS_PATH, context));
        this.tags = EndpointsConfiguration.parseTags(ConfigUtils.getConfigProperty(ENDPOINTS_TAGS, context));
        this.servers = EndpointsConfiguration.parseServers(ConfigUtils.getConfigProperty(ENDPOINTS_SERVERS, context), context);
        this.securityRequirements = EndpointsConfiguration.parseSecurityRequirements(ConfigUtils.getConfigProperty(ENDPOINTS_SECURITY_REQUIREMENTS, context), context);
        this.endpoints = new LinkedHashMap<String, Endpoint>();
        HashMap map = new HashMap(properties.size());
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> map.put((String)key, (String)value)));
        map.entrySet().stream().filter(EndpointsConfiguration::validEntry).forEach(entry -> {
            int idx = ((String)entry.getKey()).lastIndexOf(46);
            if (idx <= 0 || idx == ((String)entry.getKey()).length() - 1 || entry.getValue() == null) {
                return;
            }
            String entryType = ((String)entry.getKey()).substring(idx + 1);
            String name = ((String)entry.getKey()).substring(ENDPOINTS_PREFIX.length(), idx);
            Endpoint endpoint = this.endpoints.computeIfAbsent(name, key -> new Endpoint());
            switch (entryType) {
                case "security-requirements": {
                    endpoint.setSecurityRequirements(EndpointsConfiguration.parseSecurityRequirements((String)entry.getValue(), context));
                    break;
                }
                case "servers": {
                    endpoint.setServers(EndpointsConfiguration.parseServers((String)entry.getValue(), context));
                    break;
                }
                case "tags": {
                    endpoint.setTags(EndpointsConfiguration.parseTags((String)entry.getValue()));
                    break;
                }
                case "class": {
                    endpoint.setClassElement(context.getClassElement((String)entry.getValue()).orElse(null));
                    break;
                }
                default: {
                    context.warn("Unknown value " + entryType, null);
                }
            }
        });
    }

    String getPath() {
        return this.path;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    List<Tag> getTags() {
        return this.tags;
    }

    Map<String, Endpoint> getEndpoints() {
        return this.endpoints;
    }

    List<Server> getServers() {
        return this.servers;
    }

    List<SecurityRequirement> getSecurityRequirements() {
        return this.securityRequirements;
    }

    public String toString() {
        return "EndpointsConfiguration [enabled=" + this.enabled + ", path=" + this.path + ", tags=" + this.tags + ", endpoints=" + this.endpoints + "]";
    }

    private static List<Server> parseServers(String servers, VisitorContext context) {
        return EndpointsConfiguration.parseModel(servers, context, TYPE_SERVERS_LIST);
    }

    private static List<SecurityRequirement> parseSecurityRequirements(String securityRequirements, VisitorContext context) {
        return EndpointsConfiguration.parseModel(securityRequirements, context, TYPE_SECURITY_REQUIREMENTS_LIST);
    }

    private static <T> List<T> parseModel(String s, VisitorContext context, TypeReference<List<T>> typeReference) {
        if (StringUtils.isEmpty((CharSequence)s) || !s.startsWith("[") && !s.endsWith("]")) {
            return Collections.emptyList();
        }
        try {
            return (List)OpenApiUtils.getConvertJsonMapper().readValue(s, typeReference);
        }
        catch (JsonProcessingException e) {
            context.warn("Fail to parse " + typeReference.getType().toString() + ": " + s + " - " + e.getMessage(), null);
            return Collections.emptyList();
        }
    }

    private static boolean validEntry(Map.Entry<String, String> entry) {
        return entry.getKey().startsWith(ENDPOINTS_PREFIX) && !entry.getKey().equals(ENDPOINTS_ENABLED) && !entry.getKey().equals(ENDPOINTS_TAGS) && !entry.getKey().equals(ENDPOINTS_SERVERS) && !entry.getKey().equals(ENDPOINTS_SECURITY_REQUIREMENTS) && !entry.getKey().equals(ENDPOINTS_PATH);
    }

    private static List<Tag> parseTags(String stringTagsStr) {
        if (StringUtils.isEmpty((CharSequence)stringTagsStr)) {
            return Collections.emptyList();
        }
        String[] stringTags = stringTagsStr.split(",");
        if (stringTags.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(stringTags.length);
        for (String name : stringTags) {
            if (name == null || name.isEmpty()) continue;
            Tag tag = new Tag();
            tag.setName(name);
            tags.add(tag);
        }
        return tags;
    }

    private static String parsePath(String path) {
        if (StringUtils.isNotEmpty((CharSequence)path) && !path.endsWith("/")) {
            return path + "/";
        }
        return path;
    }
}

