/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.OpenApiUtils;
import io.micronaut.openapi.postprocessors.JacksonDiscriminatorPostProcessor;
import io.micronaut.openapi.postprocessors.OpenApiOperationsPostProcessor;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.visitor.AbstractOpenApiVisitor;
import io.micronaut.openapi.visitor.AdocModule;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.ConvertUtils;
import io.micronaut.openapi.visitor.Endpoint;
import io.micronaut.openapi.visitor.EndpointsConfiguration;
import io.micronaut.openapi.visitor.FileUtils;
import io.micronaut.openapi.visitor.OpenApiConfigProperty;
import io.micronaut.openapi.visitor.OpenApiEndpointVisitor;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.micronaut.openapi.visitor.Utils;
import io.micronaut.openapi.visitor.group.EndpointInfo;
import io.micronaut.openapi.visitor.group.GroupProperties;
import io.micronaut.openapi.visitor.group.OpenApiInfo;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class OpenApiApplicationVisitor
extends AbstractOpenApiVisitor
implements TypeElementVisitor<OpenAPIDefinition, Object> {
    private ClassElement classElement;
    private int visitedElements = -1;

    public Set<String> getSupportedOptions() {
        return OpenApiConfigProperty.ALL;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        try {
            this.incrementVisitedElements(context);
            if (!ConfigUtils.isOpenApiEnabled(context)) {
                return;
            }
            context.info("Generating OpenAPI Documentation");
            OpenAPI openApi = this.readOpenApi(element, context);
            this.processSecuritySchemes(element, context);
            this.mergeAdditionalSwaggerFiles(element, context, openApi);
            List<io.swagger.v3.oas.models.tags.Tag> tagList = this.processOpenApiAnnotation((Element)element, context, Tag.class, io.swagger.v3.oas.models.tags.Tag.class, openApi.getTags());
            openApi.setTags(tagList);
            List<SecurityRequirement> securityRequirements = this.readSecurityRequirements((Element)element);
            if (openApi.getSecurity() != null) {
                securityRequirements.addAll(openApi.getSecurity());
            }
            openApi.setSecurity(securityRequirements);
            List<io.swagger.v3.oas.models.servers.Server> servers = this.processOpenApiAnnotation((Element)element, context, Server.class, io.swagger.v3.oas.models.servers.Server.class, openApi.getServers());
            openApi.setServers(servers);
            Optional attr = context.get((CharSequence)"io.micronaut.OPENAPI", OpenAPI.class);
            if (attr.isPresent()) {
                OpenAPI existing = (OpenAPI)attr.get();
                Optional.ofNullable(openApi.getInfo()).ifPresent(arg_0 -> ((OpenAPI)existing).setInfo(arg_0));
                this.copyOpenApi(existing, openApi);
            } else {
                context.put((CharSequence)"io.micronaut.OPENAPI", (Object)openApi);
            }
            if (Utils.isTestMode()) {
                Utils.resolveOpenApi(context);
            }
            this.classElement = element;
        }
        catch (Throwable t) {
            context.warn("Error with processing class:\n" + Utils.printStackTrace(t), (Element)this.classElement);
        }
    }

    private void mergeAdditionalSwaggerFiles(ClassElement element, VisitorContext context, OpenAPI openAPI) {
        String additionalSwaggerFiles = ConfigUtils.getConfigProperty("micronaut.openapi.additional.files", context);
        if (StringUtils.isNotEmpty((CharSequence)additionalSwaggerFiles)) {
            Path directory = FileUtils.resolve(context, java.nio.file.Paths.get(additionalSwaggerFiles, new String[0]));
            if (Files.isDirectory(directory, new LinkOption[0])) {
                context.info("Merging Swagger OpenAPI YAML and JSON files from location: " + directory);
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, path -> FileUtils.isYaml(path.toString().toLowerCase()) || path.toString().toLowerCase().endsWith(".json"));){
                    stream.forEach(path -> {
                        boolean isYaml = FileUtils.isYaml(path.toString().toLowerCase());
                        context.info("Reading Swagger OpenAPI " + (isYaml ? "YAML" : "JSON") + " file " + path.getFileName());
                        OpenAPI parsedOpenApi = null;
                        try {
                            parsedOpenApi = (OpenAPI)(isYaml ? OpenApiUtils.getYamlMapper() : OpenApiUtils.getJsonMapper()).readValue(path.toFile(), OpenAPI.class);
                        }
                        catch (IOException e) {
                            context.warn("Unable to read file " + path.getFileName() + ": " + e.getMessage(), (Element)element);
                        }
                        this.copyOpenApi(openAPI, parsedOpenApi);
                    });
                }
                catch (IOException e) {
                    context.warn("Unable to read  file from " + directory + ": " + e.getMessage(), (Element)element);
                }
            } else {
                context.warn(directory + " does not exist or is not a directory", (Element)element);
            }
        }
    }

    private void copyOpenApi(OpenAPI to, OpenAPI from) {
        if (to != null && from != null) {
            Optional.ofNullable(from.getTags()).ifPresent(tags -> tags.forEach(arg_0 -> ((OpenAPI)to).addTagsItem(arg_0)));
            Optional.ofNullable(from.getServers()).ifPresent(servers -> servers.forEach(arg_0 -> ((OpenAPI)to).addServersItem(arg_0)));
            Optional.ofNullable(from.getSecurity()).ifPresent(securityRequirements -> securityRequirements.forEach(arg_0 -> ((OpenAPI)to).addSecurityItem(arg_0)));
            Optional.ofNullable(from.getPaths()).ifPresent(paths -> paths.forEach((arg_0, arg_1) -> ((OpenAPI)to).path(arg_0, arg_1)));
            Optional.ofNullable(from.getComponents()).ifPresent(components -> {
                Map securitySchemes;
                Map schemas = components.getSchemas();
                if (CollectionUtils.isNotEmpty((Map)schemas)) {
                    schemas.forEach((k, v) -> {
                        if (v.getName() == null) {
                            v.setName(k);
                        }
                    });
                    schemas.forEach((arg_0, arg_1) -> ((OpenAPI)to).schema(arg_0, arg_1));
                }
                if ((securitySchemes = components.getSecuritySchemes()) != null && !securitySchemes.isEmpty()) {
                    securitySchemes.forEach((arg_0, arg_1) -> ((OpenAPI)to).schemaRequirement(arg_0, arg_1));
                }
            });
            Optional.ofNullable(from.getExternalDocs()).ifPresent(arg_0 -> ((OpenAPI)to).externalDocs(arg_0));
            Optional.ofNullable(from.getExtensions()).ifPresent(extensions -> extensions.forEach((arg_0, arg_1) -> ((OpenAPI)to).addExtension(arg_0, arg_1)));
        }
    }

    private OpenAPI readOpenApi(ClassElement element, VisitorContext context) {
        return element.findAnnotation(OpenAPIDefinition.class).flatMap(o -> {
            Optional<OpenAPI> result = this.toValue(o.getValues(), context, OpenAPI.class, null);
            result.ifPresent(openAPI -> {
                ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>();
                for (AnnotationValue secRequirementAnn : o.getAnnotations("security", io.swagger.v3.oas.annotations.security.SecurityRequirement.class)) {
                    securityRequirements.add(ConvertUtils.mapToSecurityRequirement((AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>)secRequirementAnn));
                }
                openAPI.setSecurity(securityRequirements);
            });
            return result;
        }).orElse(new OpenAPI());
    }

    private void renderViews(String title, Map<Pair<String, String>, OpenApiInfo> openApiInfos, Path destinationDir, VisitorContext context) throws IOException {
        String viewSpecification = ConfigUtils.getConfigProperty("micronaut.openapi.views.spec", context);
        OpenApiViewConfig cfg = OpenApiViewConfig.fromSpecification(viewSpecification, openApiInfos, ConfigUtils.readOpenApiConfigFile(context), context);
        if (cfg.isEnabled()) {
            cfg.setTitle(title);
            cfg.setSpecFile(openApiInfos.values().iterator().next().getSpecFilePath());
            cfg.setServerContextPath(ConfigUtils.getConfigProperty("micronaut.openapi.server.context.path", context));
            cfg.render(destinationDir, context);
        }
    }

    private static PropertyNamingStrategies.NamingBase fromName(String name) {
        if (name == null) {
            return null;
        }
        return switch (name.toUpperCase(Locale.US)) {
            case "LOWER_CAMEL_CASE" -> new LowerCamelCasePropertyNamingStrategy();
            case "UPPER_CAMEL_CASE" -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.UPPER_CAMEL_CASE;
            case "SNAKE_CASE" -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.SNAKE_CASE;
            case "UPPER_SNAKE_CASE" -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.UPPER_SNAKE_CASE;
            case "LOWER_CASE" -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.LOWER_CASE;
            case "KEBAB_CASE" -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.KEBAB_CASE;
            case "LOWER_DOT_CASE" -> (PropertyNamingStrategies.NamingBase)PropertyNamingStrategies.LOWER_DOT_CASE;
            default -> null;
        };
    }

    private void applyPropertyNamingStrategy(OpenAPI openAPI, VisitorContext context) {
        String namingStrategyName = ConfigUtils.getConfigProperty("micronaut.openapi.property.naming.strategy", context);
        PropertyNamingStrategies.NamingBase propertyNamingStrategy = OpenApiApplicationVisitor.fromName(namingStrategyName);
        if (propertyNamingStrategy != null) {
            context.info("Using " + namingStrategyName + " property naming strategy.");
            if (openAPI.getComponents() != null && CollectionUtils.isNotEmpty((Map)openAPI.getComponents().getSchemas())) {
                openAPI.getComponents().getSchemas().values().forEach(model -> {
                    List required;
                    Map properties = model.getProperties();
                    if (properties != null) {
                        Map newProperties = properties.entrySet().stream().collect(Collectors.toMap(entry -> propertyNamingStrategy.translate((String)entry.getKey()), Map.Entry::getValue, (prop1, prop2) -> prop1, LinkedHashMap::new));
                        model.getProperties().clear();
                        model.setProperties(newProperties);
                    }
                    if ((required = model.getRequired()) != null) {
                        List<String> updatedRequired = required.stream().map(arg_0 -> ((PropertyNamingStrategies.NamingBase)propertyNamingStrategy).translate(arg_0)).toList();
                        required.clear();
                        required.addAll(updatedRequired);
                    }
                });
            }
        }
    }

    private void applyPropertyServerContextPath(OpenAPI openAPI, VisitorContext context) {
        String serverContextPath = ConfigUtils.getConfigProperty("micronaut.openapi.server.context.path", context);
        if (serverContextPath == null || serverContextPath.isEmpty()) {
            return;
        }
        context.info("Applying server context path: " + serverContextPath + " to Paths.");
        Paths paths = openAPI.getPaths();
        if (paths == null || paths.isEmpty()) {
            return;
        }
        Paths newPaths = new Paths();
        for (Map.Entry path : paths.entrySet()) {
            Object newPath;
            String mapping = (String)path.getKey();
            Object object = newPath = mapping.startsWith(serverContextPath) ? mapping : StringUtils.prependUri((String)serverContextPath, (String)mapping);
            if (!((String)newPath).startsWith("/") && !((String)newPath).startsWith("$")) {
                newPath = "/" + (String)newPath;
            }
            newPaths.addPathItem((String)newPath, (PathItem)path.getValue());
        }
        openAPI.setPaths(newPaths);
    }

    public static JsonNode resolvePlaceholders(ArrayNode anode, UnaryOperator<String> propertyExpander) {
        for (int i = 0; i < anode.size(); ++i) {
            anode.set(i, OpenApiApplicationVisitor.resolvePlaceholders(anode.get(i), propertyExpander));
        }
        return anode;
    }

    public static JsonNode resolvePlaceholders(ObjectNode onode, UnaryOperator<String> propertyExpander) {
        if (onode.isEmpty()) {
            return onode;
        }
        ObjectNode newNode = onode.objectNode();
        Iterator i = onode.fields();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            newNode.set((String)propertyExpander.apply((String)entry.getKey()), OpenApiApplicationVisitor.resolvePlaceholders((JsonNode)entry.getValue(), propertyExpander));
        }
        return newNode;
    }

    public static JsonNode resolvePlaceholders(JsonNode node, UnaryOperator<String> propertyExpander) {
        if (node.isTextual()) {
            String text = node.textValue();
            if (text == null || text.isBlank()) {
                return node;
            }
            String newText = (String)propertyExpander.apply(text);
            return text.equals(newText) ? node : TextNode.valueOf((String)newText);
        }
        if (node.isArray()) {
            return OpenApiApplicationVisitor.resolvePlaceholders((ArrayNode)node, propertyExpander);
        }
        if (node.isObject()) {
            return OpenApiApplicationVisitor.resolvePlaceholders((ObjectNode)node, propertyExpander);
        }
        return node;
    }

    public static String expandProperties(String s, List<Pair<String, String>> properties, VisitorContext context) {
        if (StringUtils.isEmpty((CharSequence)s) || !s.contains("${")) {
            return s;
        }
        if (CollectionUtils.isNotEmpty(properties)) {
            for (Pair<String, String> entry : properties) {
                s = s.replaceAll(entry.getFirst(), entry.getSecond());
            }
        }
        return OpenApiApplicationVisitor.replacePlaceholders(s, context);
    }

    public static String replacePlaceholders(String value, VisitorContext context) {
        if (StringUtils.isEmpty((CharSequence)value) || !value.contains("${")) {
            return value;
        }
        if (CollectionUtils.isNotEmpty((Map)System.getProperties())) {
            for (Map.Entry<Object, Object> sysProp : System.getProperties().entrySet()) {
                value = value.replace("${" + sysProp.getKey().toString() + "}", sysProp.getValue().toString());
            }
        }
        for (Map.Entry<Object, Object> fileProp : ConfigUtils.readOpenApiConfigFile(context).entrySet()) {
            value = value.replace("${" + fileProp.getKey().toString() + "}", fileProp.getValue().toString());
        }
        Environment environment = ConfigUtils.getEnv(context);
        if (environment != null) {
            value = environment.getPlaceholderResolver().resolvePlaceholders(value).orElse(value);
        }
        return value;
    }

    private static OpenAPI resolvePropertyPlaceHolders(OpenAPI openAPI, VisitorContext context) {
        List<Pair<String, String>> expandableProperties = ConfigUtils.getExpandableProperties(context);
        if (CollectionUtils.isNotEmpty(expandableProperties)) {
            context.info("Expanding properties: " + expandableProperties);
        }
        JsonNode root = OpenApiApplicationVisitor.resolvePlaceholders((ObjectNode)OpenApiUtils.getYamlMapper().convertValue((Object)openAPI, ObjectNode.class), s -> OpenApiApplicationVisitor.expandProperties(s, expandableProperties, context));
        return (OpenAPI)OpenApiUtils.getYamlMapper().convertValue((Object)root, OpenAPI.class);
    }

    public void finish(VisitorContext context) {
        try {
            String isJson;
            if (!ConfigUtils.isOpenApiEnabled(context)) {
                return;
            }
            if (this.visitedElements == this.visitedElements(context)) {
                return;
            }
            Optional attr = context.get((CharSequence)"io.micronaut.OPENAPI", OpenAPI.class);
            if (attr.isEmpty()) {
                return;
            }
            OpenAPI openApi = (OpenAPI)attr.get();
            this.processEndpoints(context);
            this.mergeMicronautEndpointInfos(openApi, context);
            Map<Pair<String, String>, OpenApiInfo> openApiInfos = this.divideOpenapiByGroupsAndVersions(openApi, context);
            if (Utils.isTestMode()) {
                Utils.setTestReferences(openApiInfos);
            }
            boolean isYaml = !StringUtils.isNotEmpty((CharSequence)(isJson = ConfigUtils.getConfigProperty("micronaut.openapi.json.format", context))) || !isJson.equalsIgnoreCase("true");
            String documentTitle = "OpenAPI";
            for (Map.Entry<Pair<String, String>, OpenApiInfo> entry : openApiInfos.entrySet()) {
                OpenApiInfo openApiInfo = entry.getValue();
                openApi = openApiInfo.getOpenApi();
                openApi = this.postProcessOpenApi(openApi, context);
                openApiInfo.setOpenApi(openApi);
                if (Utils.isTestMode()) {
                    Utils.setTestReference(openApi);
                }
                String ext = isYaml ? ".yml" : ".json";
                Pair<String, String> titleAndFilename = FileUtils.calcFinalFilename(openApiInfo.getFilename(), openApiInfo, openApiInfos.size() == 1, ext, context);
                documentTitle = titleAndFilename.getFirst();
                openApiInfo.setFilename(titleAndFilename.getSecond());
            }
            this.writeYamlToFile(openApiInfos, documentTitle, context, isYaml);
            this.visitedElements = this.visitedElements(context);
        }
        catch (Throwable t) {
            context.warn("Error:\n" + Utils.printStackTrace(t), null);
            throw t;
        }
    }

    private Map<Pair<String, String>, OpenApiInfo> divideOpenapiByGroupsAndVersions(OpenAPI openApi, VisitorContext context) {
        Map<String, List<EndpointInfo>> endpointInfosMap = Utils.getEndpointInfos();
        Set<String> allVersions = Utils.getAllKnownVersions();
        Set<String> allGroups = Utils.getAllKnownGroups();
        if (CollectionUtils.isEmpty(endpointInfosMap) || CollectionUtils.isEmpty(allVersions) && CollectionUtils.isEmpty(allGroups)) {
            return Collections.singletonMap(Pair.NULL_STRING_PAIR, new OpenApiInfo(openApi));
        }
        ArrayList<EndpointInfo> commonEndpoints = new ArrayList<EndpointInfo>();
        HashMap<Pair<String, String>, OpenApiInfo> result = new HashMap<Pair<String, String>, OpenApiInfo>();
        for (List<EndpointInfo> list : endpointInfosMap.values()) {
            for (EndpointInfo endpointInfo : list) {
                if (CollectionUtils.isEmpty(endpointInfo.getGroups()) && endpointInfo.getVersion() == null) {
                    commonEndpoints.add(endpointInfo);
                    continue;
                }
                for (String group : endpointInfo.getGroups()) {
                    if (CollectionUtils.isNotEmpty(endpointInfo.getExcludedGroups()) && endpointInfo.getExcludedGroups().contains(group)) continue;
                    OpenAPI newOpenApi = this.addOpenApiInfo(group, endpointInfo.getVersion(), openApi, result, context);
                    this.addOperation(endpointInfo, newOpenApi);
                }
                if (!CollectionUtils.isEmpty(endpointInfo.getGroups())) continue;
                OpenAPI newOpenApi = this.addOpenApiInfo(null, endpointInfo.getVersion(), openApi, result, context);
                this.addOperation(endpointInfo, newOpenApi);
            }
        }
        for (Map.Entry entry : result.entrySet()) {
            String group = (String)((Pair)entry.getKey()).getFirst();
            GroupProperties groupProperties = ConfigUtils.getGroupProperties(group, context);
            if (groupProperties != null && groupProperties.getCommonExclude() != null && groupProperties.getCommonExclude().booleanValue()) continue;
            OpenAPI openAPI = ((OpenApiInfo)entry.getValue()).getOpenApi();
            for (EndpointInfo commonEndpoint : commonEndpoints) {
                if (CollectionUtils.isNotEmpty(commonEndpoint.getExcludedGroups()) && commonEndpoint.getExcludedGroups().contains(group)) continue;
                this.addOperation(commonEndpoint, openAPI);
            }
        }
        return result;
    }

    private void addOperation(EndpointInfo endpointInfo, OpenAPI openApi) {
        PathItem pathItem;
        Operation operation;
        if (openApi == null) {
            return;
        }
        Paths paths = openApi.getPaths();
        if (paths == null) {
            paths = new Paths();
            openApi.setPaths(paths);
        }
        if ((operation = SchemaUtils.getOperationOnPathItem(pathItem = (PathItem)paths.computeIfAbsent((Object)endpointInfo.getUrl(), pathUrl -> new PathItem()), endpointInfo.getHttpMethod())) == null) {
            SchemaUtils.setOperationOnPathItem(pathItem, endpointInfo.getHttpMethod(), endpointInfo.getOperation());
            return;
        }
        SchemaUtils.setOperationOnPathItem(pathItem, endpointInfo.getHttpMethod(), SchemaUtils.mergeOperations(operation, endpointInfo.getOperation()));
    }

    private OpenAPI addOpenApiInfo(String group, String version, OpenAPI openApi, Map<Pair<String, String>, OpenApiInfo> openApiInfoMap, VisitorContext context) {
        OpenAPI newOpenApi;
        GroupProperties groupProperties = ConfigUtils.getGroupProperties(group, context);
        boolean hasGroupProperties = groupProperties != null;
        Pair<String, String> key = Pair.of(group, version);
        OpenApiInfo openApiInfo = openApiInfoMap.get(key);
        if (openApiInfo == null) {
            OpenAPI openApiCopy;
            Map<String, OpenAPI> knownOpenApis = Utils.getOpenApis();
            newOpenApi = CollectionUtils.isNotEmpty(knownOpenApis) && knownOpenApis.containsKey(group) ? knownOpenApis.get(group) : new OpenAPI();
            openApiInfo = new OpenApiInfo(version, group, hasGroupProperties ? groupProperties.getDisplayName() : null, hasGroupProperties ? groupProperties.getFilename() : null, !hasGroupProperties || groupProperties.getAdocEnabled() == null || groupProperties.getAdocEnabled() != false, hasGroupProperties ? groupProperties.getAdocFilename() : null, newOpenApi);
            openApiInfoMap.put(key, openApiInfo);
            try {
                openApiCopy = (OpenAPI)OpenApiUtils.getJsonMapper().treeToValue((TreeNode)OpenApiUtils.getJsonMapper().valueToTree((Object)openApi), OpenAPI.class);
            }
            catch (JsonProcessingException e) {
                context.warn("Error\n" + Utils.printStackTrace(e), null);
                return null;
            }
            if (CollectionUtils.isEmpty(knownOpenApis) || !knownOpenApis.containsKey(group)) {
                newOpenApi.setTags(openApiCopy.getTags());
                newOpenApi.setServers(openApiCopy.getServers());
                newOpenApi.setInfo(openApiCopy.getInfo());
                newOpenApi.setSecurity(openApiCopy.getSecurity());
                newOpenApi.setExternalDocs(openApiCopy.getExternalDocs());
            }
            newOpenApi.setComponents(openApiCopy.getComponents());
        } else {
            newOpenApi = openApiInfo.getOpenApi();
        }
        return newOpenApi;
    }

    private void mergeMicronautEndpointInfos(OpenAPI openApi, VisitorContext context) {
        Map<String, List<EndpointInfo>> endpointInfosMap = Utils.getEndpointInfos();
        if (CollectionUtils.isEmpty(endpointInfosMap)) {
            return;
        }
        for (List<EndpointInfo> endpointInfos : endpointInfosMap.values()) {
            for (EndpointInfo endpointInfo : endpointInfos) {
                PathItem pathItem = (PathItem)openApi.getPaths().get((Object)endpointInfo.getUrl());
                Operation operation = SchemaUtils.getOperationOnPathItem(pathItem, endpointInfo.getHttpMethod());
                if (operation == null) {
                    SchemaUtils.setOperationOnPathItem(pathItem, endpointInfo.getHttpMethod(), endpointInfo.getOperation());
                    continue;
                }
                if (endpointInfo.getVersion() != null) continue;
                SchemaUtils.setOperationOnPathItem(pathItem, endpointInfo.getHttpMethod(), SchemaUtils.mergeOperations(operation, endpointInfo.getOperation()));
            }
        }
    }

    public int getOrder() {
        return 100;
    }

    private OpenAPI postProcessOpenApi(OpenAPI openApi, VisitorContext context) {
        this.applyPropertyNamingStrategy(openApi, context);
        this.applyPropertyServerContextPath(openApi, context);
        this.normalizeOpenApi(openApi);
        new JacksonDiscriminatorPostProcessor().addMissingDiscriminatorType(openApi);
        new OpenApiOperationsPostProcessor().processOperations(openApi);
        try {
            Map schemas;
            if (openApi.getComponents() != null && CollectionUtils.isNotEmpty((Map)(schemas = openApi.getComponents().getSchemas()))) {
                String openApiJson = OpenApiUtils.getJsonMapper().writeValueAsString((Object)openApi);
                HashSet keySet = new HashSet(schemas.keySet());
                for (String schemaName : keySet) {
                    if (openApiJson.contains("\"#/components/schemas/" + schemaName + "\"")) continue;
                    schemas.remove(schemaName);
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        this.removeEmtpyComponents(openApi);
        this.findAndRemoveDuplicates(openApi);
        openApi = OpenApiApplicationVisitor.resolvePropertyPlaceHolders(openApi, context);
        return openApi;
    }

    void findAndRemoveDuplicates(OpenAPI openApi) {
        openApi.setTags(Utils.findAndRemoveDuplicates(openApi.getTags(), (el1, el2) -> el1.getName() != null && el1.getName().equals(el2.getName())));
        openApi.setServers(Utils.findAndRemoveDuplicates(openApi.getServers(), (el1, el2) -> el1.getUrl() != null && el1.getUrl().equals(el2.getUrl())));
        openApi.setSecurity(Utils.findAndRemoveDuplicates(openApi.getSecurity(), (el1, el2) -> el1 != null && el1.equals(el2)));
        if (CollectionUtils.isNotEmpty((Map)openApi.getPaths())) {
            for (PathItem path : openApi.getPaths().values()) {
                path.setServers(Utils.findAndRemoveDuplicates(path.getServers(), (el1, el2) -> el1.getUrl() != null && el1.getUrl().equals(el2.getUrl())));
                path.setParameters(Utils.findAndRemoveDuplicates(path.getParameters(), (el1, el2) -> el1.getName() != null && el1.getName().equals(el2.getName()) && el1.getIn() != null && el1.getIn().equals(el2.getIn())));
                this.findAndRemoveDuplicates(path.getGet());
                this.findAndRemoveDuplicates(path.getPut());
                this.findAndRemoveDuplicates(path.getPost());
                this.findAndRemoveDuplicates(path.getDelete());
                this.findAndRemoveDuplicates(path.getOptions());
                this.findAndRemoveDuplicates(path.getHead());
                this.findAndRemoveDuplicates(path.getPatch());
                this.findAndRemoveDuplicates(path.getTrace());
            }
        }
        if (openApi.getComponents() != null && CollectionUtils.isNotEmpty((Map)openApi.getComponents().getSchemas())) {
            for (Schema schema : openApi.getComponents().getSchemas().values()) {
                this.findAndRemoveDuplicates(schema);
            }
        }
        if (openApi.getComponents() != null && CollectionUtils.isNotEmpty((Map)openApi.getComponents().getSchemas())) {
            for (Schema schema : openApi.getComponents().getSchemas().values()) {
                this.findAndRemoveDuplicates(schema);
            }
        }
    }

    private void findAndRemoveDuplicates(Schema schema) {
        if (schema == null) {
            return;
        }
        schema.setRequired(Utils.findAndRemoveDuplicates(schema.getRequired(), (el1, el2) -> el1 != null && el1.equals(el2)));
        schema.setPrefixItems(Utils.findAndRemoveDuplicates(schema.getPrefixItems(), (el1, el2) -> el1 != null && el1.equals(el2)));
        schema.setAllOf(Utils.findAndRemoveDuplicates(schema.getAllOf(), (el1, el2) -> el1 != null && el1.equals(el2)));
        schema.setAnyOf(Utils.findAndRemoveDuplicates(schema.getAnyOf(), (el1, el2) -> el1 != null && el1.equals(el2)));
        schema.setOneOf(Utils.findAndRemoveDuplicates(schema.getOneOf(), (el1, el2) -> el1 != null && el1.equals(el2)));
    }

    private void findAndRemoveDuplicates(Operation operation) {
        if (operation == null) {
            return;
        }
        operation.setTags(Utils.findAndRemoveDuplicates(operation.getTags(), (el1, el2) -> el1 != null && el1.equals(el2)));
        operation.setServers(Utils.findAndRemoveDuplicates(operation.getServers(), (el1, el2) -> el1.getUrl() != null && el1.getUrl().equals(el2.getUrl())));
        operation.setSecurity(Utils.findAndRemoveDuplicates(operation.getSecurity(), (el1, el2) -> el1 != null && el1.equals(el2)));
        if (CollectionUtils.isNotEmpty((Collection)operation.getParameters())) {
            for (Parameter param : operation.getParameters()) {
                this.findAndRemoveDuplicates(param.getContent());
                this.findAndRemoveDuplicates(param.getSchema());
            }
            operation.setParameters(Utils.findAndRemoveDuplicates(operation.getParameters(), (el1, el2) -> el1.getName() != null && el1.getName().equals(el2.getName()) && el1.getIn() != null && el1.getIn().equals(el2.getIn())));
        }
        if (operation.getRequestBody() != null) {
            this.findAndRemoveDuplicates(operation.getRequestBody().getContent());
        }
        if (CollectionUtils.isNotEmpty((Map)operation.getResponses())) {
            for (ApiResponse response : operation.getResponses().values()) {
                this.findAndRemoveDuplicates(response.getContent());
            }
        }
    }

    private void findAndRemoveDuplicates(Content content) {
        if (CollectionUtils.isEmpty((Map)content)) {
            return;
        }
        for (MediaType mediaType : content.values()) {
            this.findAndRemoveDuplicates(mediaType.getSchema());
        }
    }

    private void removeEmtpyComponents(OpenAPI openAPI) {
        Components components = openAPI.getComponents();
        if (components == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Map)components.getSchemas())) {
            components.setSchemas(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getResponses())) {
            components.setResponses(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getParameters())) {
            components.setParameters(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getExamples())) {
            components.setExamples(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getRequestBodies())) {
            components.setRequestBodies(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getHeaders())) {
            components.setHeaders(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getSecuritySchemes())) {
            components.setSecuritySchemes(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getLinks())) {
            components.setLinks(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getCallbacks())) {
            components.setCallbacks(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getExtensions())) {
            components.setExtensions(null);
        }
        if (CollectionUtils.isEmpty((Map)components.getSchemas()) && CollectionUtils.isEmpty((Map)components.getResponses()) && CollectionUtils.isEmpty((Map)components.getParameters()) && CollectionUtils.isEmpty((Map)components.getExamples()) && CollectionUtils.isEmpty((Map)components.getRequestBodies()) && CollectionUtils.isEmpty((Map)components.getHeaders()) && CollectionUtils.isEmpty((Map)components.getSecuritySchemes()) && CollectionUtils.isEmpty((Map)components.getLinks()) && CollectionUtils.isEmpty((Map)components.getCallbacks()) && CollectionUtils.isEmpty((Map)components.getExtensions())) {
            openAPI.setComponents(null);
        }
    }

    private void normalizeOpenApi(OpenAPI openAPI) {
        Components components;
        if (openAPI.getPaths() != null) {
            Paths sortedPaths = new Paths();
            new TreeMap<String, PathItem>((Map<String, PathItem>)openAPI.getPaths()).forEach((arg_0, arg_1) -> ((Paths)sortedPaths).addPathItem(arg_0, arg_1));
            if (openAPI.getPaths().getExtensions() != null) {
                sortedPaths.setExtensions(new TreeMap(openAPI.getPaths().getExtensions()));
            }
            openAPI.setPaths(sortedPaths);
            for (PathItem pathItem : sortedPaths.values()) {
                this.normalizeOperation(pathItem.getGet());
                this.normalizeOperation(pathItem.getPut());
                this.normalizeOperation(pathItem.getPost());
                this.normalizeOperation(pathItem.getDelete());
                this.normalizeOperation(pathItem.getOptions());
                this.normalizeOperation(pathItem.getHead());
                this.normalizeOperation(pathItem.getPatch());
                this.normalizeOperation(pathItem.getTrace());
            }
        }
        if ((components = openAPI.getComponents()) == null) {
            return;
        }
        this.normalizeSchemas(components.getSchemas());
        this.sortComponent(components, Components::getSchemas, Components::setSchemas);
        this.sortComponent(components, Components::getResponses, Components::setResponses);
        this.sortComponent(components, Components::getParameters, Components::setParameters);
        this.sortComponent(components, Components::getExamples, Components::setExamples);
        this.sortComponent(components, Components::getRequestBodies, Components::setRequestBodies);
        this.sortComponent(components, Components::getHeaders, Components::setHeaders);
        this.sortComponent(components, Components::getSecuritySchemes, Components::setSecuritySchemes);
        this.sortComponent(components, Components::getLinks, Components::setLinks);
        this.sortComponent(components, Components::getCallbacks, Components::setCallbacks);
    }

    private void normalizeOperation(Operation operation) {
        if (operation == null) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)operation.getParameters())) {
            for (Parameter parameter : operation.getParameters()) {
                Schema paramSchema;
                if (parameter == null || (paramSchema = parameter.getSchema()) == null) continue;
                Schema<?> normalizedSchema = this.normalizeSchema(paramSchema);
                if (normalizedSchema != null) {
                    parameter.setSchema(normalizedSchema);
                    continue;
                }
                if (!paramSchema.equals(SchemaUtils.EMPTY_SIMPLE_SCHEMA)) continue;
                paramSchema.setType("object");
            }
        }
        if (operation.getRequestBody() != null) {
            this.normalizeContent(operation.getRequestBody().getContent());
        }
        if (CollectionUtils.isNotEmpty((Map)operation.getResponses())) {
            for (ApiResponse apiResponse : operation.getResponses().values()) {
                this.normalizeContent(apiResponse.getContent());
            }
        }
    }

    private void normalizeContent(Content content) {
        if (CollectionUtils.isEmpty((Map)content)) {
            return;
        }
        for (MediaType mediaType : content.values()) {
            Map paramSchemas;
            Schema mediaTypeSchema = mediaType.getSchema();
            if (mediaTypeSchema == null) continue;
            Schema<?> normalizedSchema = this.normalizeSchema(mediaTypeSchema);
            if (normalizedSchema != null) {
                mediaType.setSchema(normalizedSchema);
            } else if (mediaTypeSchema.equals(SchemaUtils.EMPTY_SIMPLE_SCHEMA)) {
                mediaTypeSchema.setType("object");
            }
            if (!CollectionUtils.isNotEmpty((Map)(paramSchemas = mediaTypeSchema.getProperties()))) continue;
            HashMap paramNormalizedSchemas = new HashMap();
            for (Map.Entry paramEntry : paramSchemas.entrySet()) {
                Schema paramSchema = (Schema)paramEntry.getValue();
                Schema<?> paramNormalizedSchema = this.normalizeSchema(paramSchema);
                if (paramNormalizedSchema == null) continue;
                paramNormalizedSchemas.put((String)paramEntry.getKey(), paramNormalizedSchema);
            }
            if (!CollectionUtils.isNotEmpty(paramNormalizedSchemas)) continue;
            paramSchemas.putAll(paramNormalizedSchemas);
        }
    }

    private <T> void sortComponent(Components components, Function<Components, Map<String, T>> getter, BiConsumer<Components, Map<String, T>> setter) {
        if (components != null && getter.apply(components) != null) {
            Map<String, T> component = getter.apply(components);
            setter.accept(components, new TreeMap<String, T>(component));
        }
    }

    private Schema<?> normalizeSchema(Schema<?> schema) {
        List allOf = schema.getAllOf();
        if (CollectionUtils.isEmpty((Collection)allOf)) {
            return null;
        }
        if (allOf.size() == 1) {
            boolean isSameType;
            String serializedAllOfDefaultValue;
            String serializedDefaultValue;
            Schema allOfSchema = (Schema)allOf.get(0);
            schema.setAllOf(null);
            Object defaultValue = schema.getDefault();
            String type = schema.getType();
            try {
                serializedDefaultValue = defaultValue != null ? OpenApiUtils.getJsonMapper().writeValueAsString(defaultValue) : null;
            }
            catch (JsonProcessingException e) {
                return null;
            }
            schema.setDefault(null);
            schema.setType(null);
            Schema normalizedSchema = null;
            Object allOfDefaultValue = allOfSchema.getDefault();
            try {
                serializedAllOfDefaultValue = allOfDefaultValue != null ? OpenApiUtils.getJsonMapper().writeValueAsString(allOfDefaultValue) : null;
            }
            catch (JsonProcessingException e) {
                return null;
            }
            boolean bl = isSameType = allOfSchema.getType() == null || allOfSchema.getType().equals(type);
            if (SchemaUtils.isEmptySchema(schema) && (serializedDefaultValue == null || serializedDefaultValue.equals(serializedAllOfDefaultValue)) && (type == null || allOfSchema.getType() == null || allOfSchema.getType().equals(type))) {
                normalizedSchema = allOfSchema;
            }
            schema.setType(type);
            schema.setAllOf(allOf);
            schema.setDefault(defaultValue);
            return normalizedSchema;
        }
        ArrayList<Object> finalList = new ArrayList<Object>(allOf.size());
        ArrayList schemasWithoutRef = new ArrayList(allOf.size() - 1);
        for (Schema<?> schemaAllOf : allOf) {
            Map paramSchemas;
            Schema<?> normalizedSchema = this.normalizeSchema(schemaAllOf);
            if (normalizedSchema != null) {
                schemaAllOf = normalizedSchema;
            }
            if (CollectionUtils.isNotEmpty((Map)(paramSchemas = schemaAllOf.getProperties()))) {
                HashMap paramNormalizedSchemas = new HashMap();
                for (Map.Entry paramEntry : paramSchemas.entrySet()) {
                    Schema paramSchema = (Schema)paramEntry.getValue();
                    Schema<?> paramNormalizedSchema = this.normalizeSchema(paramSchema);
                    if (paramNormalizedSchema == null) continue;
                    paramNormalizedSchemas.put((String)paramEntry.getKey(), paramNormalizedSchema);
                }
                if (CollectionUtils.isNotEmpty(paramNormalizedSchemas)) {
                    paramSchemas.putAll(paramNormalizedSchemas);
                }
            }
            if (StringUtils.isEmpty((CharSequence)schemaAllOf.get$ref())) {
                schemasWithoutRef.add(schemaAllOf);
                if (StringUtils.isNotEmpty((CharSequence)schema.getDescription()) && StringUtils.isNotEmpty((CharSequence)schemaAllOf.getDescription())) {
                    schemaAllOf.setDescription(null);
                }
                if (schema.getDefault() == null || schemaAllOf.getDefault() == null || !schema.getDefault().equals(schemaAllOf.getDefault())) continue;
                schema.setDefault(null);
                continue;
            }
            finalList.add(schemaAllOf);
        }
        finalList.addAll(schemasWithoutRef);
        schema.setAllOf(finalList);
        return null;
    }

    private void normalizeSchemas(Map<String, Schema> schemas) {
        if (CollectionUtils.isEmpty(schemas)) {
            return;
        }
        HashMap normalizedSchemas = new HashMap();
        for (Map.Entry<String, Schema> entry : schemas.entrySet()) {
            Map paramSchemas;
            Schema schema = entry.getValue();
            Schema<?> normalizedSchema = this.normalizeSchema(schema);
            if (normalizedSchema != null) {
                normalizedSchemas.put(entry.getKey(), normalizedSchema);
            } else if (schema.equals(SchemaUtils.EMPTY_SIMPLE_SCHEMA)) {
                schema.setType("object");
            }
            if (!CollectionUtils.isNotEmpty((Map)(paramSchemas = schema.getProperties()))) continue;
            HashMap paramNormalizedSchemas = new HashMap();
            for (Map.Entry paramEntry : paramSchemas.entrySet()) {
                Schema paramSchema = (Schema)paramEntry.getValue();
                Schema<?> paramNormalizedSchema = this.normalizeSchema(paramSchema);
                if (paramNormalizedSchema != null) {
                    paramNormalizedSchemas.put((String)paramEntry.getKey(), paramNormalizedSchema);
                    continue;
                }
                if (!paramSchema.equals(SchemaUtils.EMPTY_SIMPLE_SCHEMA)) continue;
                paramSchema.setType("object");
            }
            if (!CollectionUtils.isNotEmpty(paramNormalizedSchemas)) continue;
            paramSchemas.putAll(paramNormalizedSchemas);
        }
        if (CollectionUtils.isNotEmpty(normalizedSchemas)) {
            schemas.putAll(normalizedSchemas);
        }
    }

    private void writeYamlToFile(Map<Pair<String, String>, OpenApiInfo> openApiInfos, String documentTitle, VisitorContext context, boolean isYaml) {
        Path viewsDestDirs = null;
        boolean isAdocModuleInClassPath = false;
        boolean isGlobalAdocEnabled = ConfigUtils.getBooleanProperty("micronaut.openapi.adoc.enabled", true, context);
        if (!Utils.isTestMode()) {
            try {
                Class<?> converterClass = Class.forName("io.micronaut.openapi.adoc.OpenApiToAdocConverter");
                isAdocModuleInClassPath = true;
            }
            catch (ClassNotFoundException converterClass) {
                // empty catch block
            }
        }
        for (OpenApiInfo openApiInfo : openApiInfos.values()) {
            Path specFile = FileUtils.openApiSpecFile(openApiInfo.getFilename(), context);
            try {
                Writer writer = this.getFileWriter(specFile);
                try {
                    (isYaml ? OpenApiUtils.getYamlMapper() : OpenApiUtils.getJsonMapper()).writeValue(writer, (Object)openApiInfo.getOpenApi());
                    if (Utils.isTestMode()) {
                        Utils.setTestFileName(openApiInfo.getFilename());
                        if (isYaml) {
                            Utils.setTestYamlReference(writer.toString());
                            continue;
                        }
                        Utils.setTestJsonReference(writer.toString());
                        continue;
                    }
                    context.info("Writing OpenAPI file to destination: " + specFile);
                    viewsDestDirs = FileUtils.getViewsDestDir(FileUtils.getDefaultFilePath(openApiInfo.getFilename(), context), context);
                    context.info("Writing OpenAPI views to destination: " + viewsDestDirs);
                    Path viewsDestDirsFinal = viewsDestDirs;
                    Path classesOutputPath = ContextUtils.getClassesOutputPath(context);
                    if (classesOutputPath != null) {
                        context.addGeneratedResource(classesOutputPath.relativize(specFile).toString());
                        context.addGeneratedResource(classesOutputPath.relativize(specFile.getParent()).toString());
                        context.addGeneratedResource(classesOutputPath.relativize(viewsDestDirsFinal).toString());
                    }
                    openApiInfo.setSpecFilePath(specFile.getFileName().toString());
                    if (!isAdocModuleInClassPath || !isGlobalAdocEnabled || !openApiInfo.isAdocEnabled()) continue;
                    Map<String, String> adocProperties = ConfigUtils.getAdocProperties(openApiInfo, openApiInfos.size() == 1, context);
                    AdocModule.convert(openApiInfo, adocProperties, context);
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (Exception e) {
                context.warn("Unable to generate swagger" + (isYaml ? ".yml" : ".json") + ": " + specFile + " - " + e.getMessage() + ".\n" + Utils.printStackTrace(e), (Element)this.classElement);
            }
        }
        if (!Utils.isTestMode() && viewsDestDirs != null) {
            try {
                this.renderViews(documentTitle, openApiInfos, viewsDestDirs, context);
            }
            catch (Exception e) {
                context.warn("Unable to render swagger" + (isYaml ? ".yml" : ".json") + ": " + openApiInfos.values().stream().map(OpenApiInfo::getSpecFilePath).collect(Collectors.joining(", ", "files ", "")) + " - " + e.getMessage() + ".\n" + Utils.printStackTrace(e), (Element)this.classElement);
            }
        }
    }

    private Writer getFileWriter(Path specFile) throws IOException {
        if (Utils.isTestMode()) {
            return new StringWriter();
        }
        if (specFile != null) {
            return Files.newBufferedWriter(specFile, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        throw new IOException("Swagger spec file location is not present");
    }

    private void processEndpoints(VisitorContext context) {
        EndpointsConfiguration endpointsCfg = ConfigUtils.endpointsConfiguration(context);
        if (endpointsCfg.isEnabled() && CollectionUtils.isNotEmpty(endpointsCfg.getEndpoints())) {
            OpenApiEndpointVisitor visitor = new OpenApiEndpointVisitor(true);
            for (Endpoint endpoint : endpointsCfg.getEndpoints().values()) {
                ClassElement classEl = endpoint.getClassElement();
                if (classEl == null) continue;
                context.put((CharSequence)"micronaut.internal.openapi.endpoint.class.tags", endpoint.getTags());
                context.put((CharSequence)"micronaut.internal.openapi.endpoint.servers", endpoint.getServers());
                context.put((CharSequence)"micronaut.internal.openapi.endpoint.security.requirements", endpoint.getSecurityRequirements());
                visitor.visitClass(classEl, context);
                for (MethodElement methodEl : classEl.getEnclosedElements(ElementQuery.ALL_METHODS.modifiers(mods -> !mods.contains(ElementModifier.STATIC) && !mods.contains(ElementModifier.PRIVATE)).named(name -> !name.contains("$")))) {
                    visitor.visitMethod(methodEl, context);
                }
            }
        }
    }

    static class LowerCamelCasePropertyNamingStrategy
    extends PropertyNamingStrategies.NamingBase {
        private static final long serialVersionUID = -2750503285679998670L;

        LowerCamelCasePropertyNamingStrategy() {
        }

        public String translate(String propertyName) {
            return propertyName;
        }
    }
}

