/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.postprocessors;

import io.micronaut.core.util.CollectionUtils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.HashMap;
import java.util.Map;

public class OpenApiOperationsPostProcessor {
    public void processOperations(OpenAPI openApi) {
        if (CollectionUtils.isEmpty((Map)openApi.getPaths())) {
            return;
        }
        HashMap<String, Integer> operationIdsIndex = new HashMap<String, Integer>();
        for (PathItem pathItem : openApi.getPaths().values()) {
            for (Operation operation : pathItem.readOperations()) {
                String operationId = operation.getOperationId();
                if (!operationIdsIndex.containsKey(operationId)) {
                    operationIdsIndex.put(operationId, 1);
                    continue;
                }
                int nextValue = (Integer)operationIdsIndex.get(operationId);
                String newOperationId = operationId + "_" + nextValue;
                operation.setOperationId(newOperationId);
                OpenApiOperationsPostProcessor.updateResponseDescription(operation, operationId, newOperationId);
                operationIdsIndex.put(operationId, ++nextValue);
            }
        }
    }

    private static void updateResponseDescription(Operation operation, String originalId, String newOperationId) {
        if (CollectionUtils.isEmpty((Map)operation.getResponses())) {
            return;
        }
        for (ApiResponse apiResponse : operation.getResponses().values()) {
            if (apiResponse == null || apiResponse.getDescription() == null) continue;
            apiResponse.setDescription(apiResponse.getDescription().replaceFirst(originalId, newOperationId));
        }
    }
}

