/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.GenericArgument;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.GeneratedFile;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.group.GroupProperties;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Internal
public final class ContextUtils {
    public static final Argument<List<Tag>> TAGS_LIST_ARGUMENT = new GenericArgument<List<Tag>>(){};
    public static final Argument<List<Server>> SERVERS_LIST_ARGUMENT = new GenericArgument<List<Server>>(){};
    public static final Argument<List<Pair<String, String>>> EXPANDABLE_PROPERTIES_ARGUMENT = new GenericArgument<List<Pair<String, String>>>(){};
    public static final Argument<Map<String, ConfigUtils.SchemaDecorator>> ARGUMENT_SCHEMA_DECORATORS_MAP = new GenericArgument<Map<String, ConfigUtils.SchemaDecorator>>(){};
    public static final Argument<Map<String, ConfigUtils.CustomSchema>> ARGUMENT_CUSTOM_SCHEMA_MAP = new GenericArgument<Map<String, ConfigUtils.CustomSchema>>(){};
    public static final Argument<Map<String, GroupProperties>> ARGUMENT_GROUP_PROPERTIES_MAP = new GenericArgument<Map<String, GroupProperties>>(){};
    public static final Argument<Boolean> ARGUMENT_BOOLEAN = Argument.of(Boolean.TYPE);

    private ContextUtils() {
    }

    public static Integer getVisitedElements(VisitorContext context) {
        Integer visitedElements = ContextUtils.get("io.micronaut.OPENAPI.visited.elements", Integer.class, null, context);
        if (visitedElements == null) {
            visitedElements = 0;
            ContextUtils.put("io.micronaut.OPENAPI.visited.elements", visitedElements, context);
        }
        return visitedElements;
    }

    public static Path getClassesOutputPath(VisitorContext context) {
        if (context == null) {
            return null;
        }
        Path outputPath = ContextUtils.get("micronaut.internal.classpath.output", Path.class, null, context);
        if (outputPath != null) {
            return outputPath;
        }
        ContextUtils.visitMetaInfFile("dummy" + System.nanoTime(), context);
        return ContextUtils.get("micronaut.internal.classpath.output", Path.class, null, context);
    }

    public static GeneratedFile visitMetaInfFile(String path, VisitorContext context) {
        URI uri;
        if (context == null) {
            return null;
        }
        GeneratedFile cachedFile = ContextUtils.get("micronaut.internal.generated.file" + path, GeneratedFile.class, null, context);
        if (cachedFile != null) {
            return cachedFile;
        }
        GeneratedFile generatedFile = context.visitMetaInfFile(path, Element.EMPTY_ELEMENT_ARRAY).orElse(null);
        if (generatedFile == null) {
            ContextUtils.warn("Unable to get " + path + " file.", context);
            return null;
        }
        ContextUtils.put("micronaut.internal.generated.file" + path, generatedFile, context);
        if (!ContextUtils.contains("micronaut.internal.classpath.output", context) && (uri = generatedFile.toURI()).getScheme() != null && !uri.getScheme().equals("mem")) {
            Path generatedFilePath = Path.of(uri);
            int count = 0;
            for (int i = 0; i < path.length(); ++i) {
                if (path.charAt(i) != '/') continue;
                generatedFilePath = generatedFilePath.getParent();
                ++count;
            }
            generatedFilePath = generatedFilePath.getParent();
            ContextUtils.put("micronaut.internal.classpath.output", generatedFilePath, context);
        }
        return generatedFile;
    }

    public static void warn(String message, @Nullable VisitorContext context) {
        ContextUtils.warn(message, context, null);
    }

    public static void warn(String message, @Nullable VisitorContext context, @Nullable Element element) {
        if (context != null) {
            context.warn(message, element);
        } else {
            System.err.println(message);
        }
    }

    public static void info(String message, @Nullable VisitorContext context) {
        ContextUtils.info(message, context, null);
    }

    public static void info(String message, @Nullable VisitorContext context, @Nullable Element element) {
        if (context != null) {
            context.info(message, element);
        } else {
            System.out.println(message);
        }
    }

    public static void addGeneratedResource(String path, @Nullable VisitorContext context) {
        if (context == null) {
            return;
        }
        context.addGeneratedResource(path);
    }

    public static <T> T get(String paramName, Argument<T> arg, VisitorContext context) {
        return ContextUtils.get(paramName, arg, null, context);
    }

    public static <T> T get(String paramName, Argument<T> arg, T defaultValue, VisitorContext context) {
        return context != null ? context.get((CharSequence)paramName, arg).orElse(defaultValue) : defaultValue;
    }

    public static <T> T get(String paramName, Class<T> arg, VisitorContext context) {
        return ContextUtils.get(paramName, arg, null, context);
    }

    public static <T> T get(String paramName, Class<T> arg, T defaultValue, VisitorContext context) {
        return context != null ? context.get((CharSequence)paramName, arg).orElse(defaultValue) : defaultValue;
    }

    public static <T> void put(CharSequence paramName, T value, VisitorContext context) {
        if (context != null) {
            context.put(paramName, value);
        }
    }

    public static void remove(String paramName, VisitorContext context) {
        if (context != null) {
            context.remove((CharSequence)paramName);
        }
    }

    public static boolean contains(String paramName, VisitorContext context) {
        if (context != null) {
            return context.contains(paramName);
        }
        return false;
    }

    public static Map<String, String> getOptions(VisitorContext context) {
        if (context != null) {
            return context.getOptions();
        }
        return Collections.emptyMap();
    }

    public static ClassElement getClassElement(String className, VisitorContext context) {
        return context != null ? (ClassElement)context.getClassElement(className).orElse(null) : null;
    }
}

