/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.multipart.FileUpload;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;

@Internal
public final class ElementUtils {
    public static final List<String> CONTAINER_TYPES = List.of(Optional.class.getName(), Future.class.getName(), Callable.class.getName(), CompletionStage.class.getName(), "org.reactivestreams.Publisher", "io.reactivex.Single", "io.reactivex.Observable", "io.reactivex.Maybe", "io.reactivex.rxjava3.core.Single", "io.reactivex.rxjava3.core.Observable", "io.reactivex.rxjava3.core.Maybe", "kotlinx.coroutines.flow.Flow", "org.springframework.web.context.request.async.DeferredResult");
    public static final List<String> FILE_TYPES = List.of("io.micronaut.http.server.types.files.FileCustomizableResponseType", File.class.getName(), InputStream.class.getName(), ByteBuffer.class.getName());
    public static final List<String> VOID_TYPES = List.of(Void.TYPE.getName(), Void.class.getName(), "kotlin.Unit");

    private ElementUtils() {
    }

    public static boolean isJavaElement(ClassElement classElement, VisitorContext context) {
        return classElement != null && "io.micronaut.annotation.processing.visitor.JavaClassElement".equals(classElement.getClass().getName()) && context != null && "io.micronaut.annotation.processing.visitor.JavaVisitorContext".equals(context.getClass().getName());
    }

    public static boolean isNullable(TypedElement element) {
        return element.isNullable() || element.getType().isOptional();
    }

    public static boolean isAnnotationPresent(Element element, String className) {
        return element.findAnnotation(className).isPresent();
    }

    public static boolean isFileUpload(ClassElement type) {
        ClassElement typeArg;
        if (ElementUtils.isContainerType(type) && (typeArg = (ClassElement)type.getFirstTypeArgument().orElse(null)) != null) {
            type = typeArg;
        }
        String typeName = type.getName();
        return type.isAssignable(FileUpload.class) || "io.micronaut.http.multipart.StreamingFileUpload".equals(typeName) || "io.micronaut.http.multipart.CompletedFileUpload".equals(typeName) || "io.micronaut.http.multipart.CompletedPart".equals(typeName) || "io.micronaut.http.multipart.PartData".equals(typeName) || "org.springframework.web.multipart.MultipartFile".equals(typeName);
    }

    public static boolean isElementNotNullable(Element element, @Nullable Element classElement) {
        return element.isAnnotationPresent("javax.validation.constraints.NotNull$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotNull$List") || element.isAnnotationPresent("javax.validation.constraints.NotBlank$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotBlank$List") || element.isAnnotationPresent("javax.validation.constraints.NotEmpty$List") || element.isAnnotationPresent("jakarta.validation.constraints.NotEmpty$List") || element.isNonNull() || element.booleanValue(JsonProperty.class, "required").orElse(false) != false;
    }

    public static boolean isReturnTypeFile(ClassElement type) {
        return ElementUtils.findAnyAssignable(type, FILE_TYPES);
    }

    public static boolean isContainerType(ClassElement type) {
        return ElementUtils.findAnyAssignable(type, CONTAINER_TYPES);
    }

    public static boolean isVoid(ClassElement type) {
        return ElementUtils.findAnyAssignable(type, VOID_TYPES);
    }

    public static boolean isReactiveAndVoid(ClassElement type) {
        return type.isAssignable("io.reactivex.Completable") || type.isAssignable("io.reactivex.rxjava3.core.Completable") || ElementUtils.isContainerType(type) && type.getFirstTypeArgument().isPresent() && ElementUtils.isVoid((ClassElement)type.getFirstTypeArgument().get());
    }

    private static boolean findAnyAssignable(ClassElement type, List<String> typeNames) {
        for (String typeName : typeNames) {
            if (!type.isAssignable(typeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIgnoredParameter(TypedElement parameter) {
        AnnotationValue schemaAnn = parameter.getAnnotation(Schema.class);
        boolean isHidden = schemaAnn != null && schemaAnn.booleanValue("hidden").orElse(false) != false;
        return isHidden || parameter.isAnnotationPresent(Hidden.class) || parameter.isAnnotationPresent(JsonIgnore.class) || parameter.booleanValue(Parameter.class, "hidden").orElse(false) != false || ElementUtils.isAnnotationPresent((Element)parameter, "io.micronaut.session.annotation.SessionValue") || ElementUtils.isAnnotationPresent((Element)parameter, "org.springframework.web.bind.annotation.SessionAttribute") || ElementUtils.isAnnotationPresent((Element)parameter, "org.springframework.web.bind.annotation.SessionAttributes") || ElementUtils.isIgnoredParameterType(parameter.getType());
    }

    public static boolean isIgnoredParameterType(ClassElement parameterType) {
        return parameterType == null || parameterType.isAssignable(Principal.class) || parameterType.isAssignable("io.micronaut.session.Session") || parameterType.isAssignable("io.micronaut.security.authentication.Authentication") || parameterType.isAssignable("io.micronaut.http.HttpHeaders") || parameterType.isAssignable("kotlin.coroutines.Continuation") || parameterType.isAssignable(HttpRequest.class) || parameterType.isAssignable("io.micronaut.http.BasicAuth") || parameterType.isAssignable("jakarta.servlet.http.HttpServletRequest") || parameterType.isAssignable("jakarta.servlet.http.HttpServletResponse") || parameterType.isAssignable("jakarta.servlet.http.HttpSession") || parameterType.isAssignable("jakarta.servlet.http.PushBuilder") || parameterType.isAssignable("java.io.Reader") || parameterType.isAssignable("java.io.OutputStream") || parameterType.isAssignable("java.io.Writer") || parameterType.isAssignable("org.springframework.web.util.UriComponentsBuilder") || parameterType.isAssignable("org.springframework.web.bind.support.SessionStatus") || parameterType.isAssignable("org.springframework.web.context.request.RequestAttributes") || parameterType.isAssignable("org.springframework.http.HttpEntity") || parameterType.isAssignable("org.springframework.http.HttpMethod") || parameterType.isAssignable("org.springframework.validation.BindingResult") || parameterType.isAssignable("org.springframework.validation.Errors");
    }
}

