/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.EnumElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.OpenApiUtils;
import io.micronaut.openapi.swagger.core.util.PrimitiveType;
import io.micronaut.openapi.visitor.ContextUtils;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.micronaut.openapi.visitor.Utils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.servers.ServerVariable;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.xml.datatype.XMLGregorianCalendar;

@Internal
public final class ConvertUtils {
    public static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    public static final TypeReference<Map<CharSequence, Object>> MAP_TYPE = new TypeReference<Map<CharSequence, Object>>(){};

    private ConvertUtils() {
    }

    public static <T> T toValue(Map<CharSequence, Object> values, VisitorContext context, Class<T> type) {
        JsonNode node = ConvertUtils.toJson(values, context);
        try {
            return ConvertUtils.treeToValue(node, type, context);
        }
        catch (JsonProcessingException e) {
            ContextUtils.warn("Error converting  [" + node + "]: to " + type + ":\n" + Utils.printStackTrace(e), context);
            return null;
        }
    }

    public static JsonNode toJson(Map<CharSequence, Object> values, VisitorContext context) {
        Map<CharSequence, Object> newValues = ConvertUtils.toValueMap(values, context);
        return OpenApiUtils.JSON_MAPPER.valueToTree(newValues);
    }

    public static Map<CharSequence, Object> toValueMap(Map<CharSequence, Object> values, VisitorContext context) {
        HashMap<CharSequence, Object> newValues = new HashMap<CharSequence, Object>(values.size());
        for (Map.Entry<CharSequence, Object> entry : values.entrySet()) {
            CharSequence key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof AnnotationValue) {
                AnnotationValue av = (AnnotationValue)value;
                Map<CharSequence, Object> valueMap = ConvertUtils.toValueMap(av.getValues(), context);
                newValues.put(key, valueMap);
                continue;
            }
            if (value instanceof AnnotationClassValue) {
                AnnotationClassValue acv = (AnnotationClassValue)value;
                acv.getType().ifPresent(aClass -> newValues.put(key, aClass));
                continue;
            }
            if (value == null) continue;
            if (value.getClass().isArray()) {
                Object[] a = (Object[])value;
                if (ArrayUtils.isNotEmpty((Object[])a)) {
                    Object first = a[0];
                    boolean areAnnotationValues = first instanceof AnnotationValue;
                    boolean areClassValues = first instanceof AnnotationClassValue;
                    if (areClassValues) {
                        ArrayList classes = new ArrayList(a.length);
                        for (Object o : a) {
                            AnnotationClassValue acv = (AnnotationClassValue)o;
                            acv.getType().ifPresent(classes::add);
                        }
                        newValues.put(key, classes);
                        continue;
                    }
                    if (areAnnotationValues) {
                        AnnotationValue sv;
                        String annotationName = ((AnnotationValue)first).getAnnotationName();
                        if (io.swagger.v3.oas.annotations.security.SecurityRequirement.class.getName().equals(annotationName)) {
                            ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>(a.length);
                            for (Object o : a) {
                                securityRequirements.add(ConvertUtils.mapToSecurityRequirement((AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>)((AnnotationValue)o)));
                            }
                            newValues.put(key, securityRequirements);
                            continue;
                        }
                        if (Extension.class.getName().equals(annotationName)) {
                            HashMap<String, Object> extensions = new HashMap<String, Object>();
                            for (Object o : a) {
                                SchemaUtils.processExtensions(extensions, (AnnotationValue<Extension>)((AnnotationValue)o));
                            }
                            newValues.put("extensions", extensions);
                            continue;
                        }
                        if (Server.class.getName().equals(annotationName)) {
                            ArrayList<LinkedHashMap<CharSequence, Object>> servers = new ArrayList<LinkedHashMap<CharSequence, Object>>();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                LinkedHashMap<CharSequence, Object> variables = new LinkedHashMap<CharSequence, Object>(ConvertUtils.toValueMap(sv.getValues(), context));
                                servers.add(variables);
                            }
                            newValues.put(key, servers);
                            continue;
                        }
                        if (OAuthScope.class.getName().equals(annotationName)) {
                            Map<String, String> params = ConvertUtils.toTupleSubMap(a, "name", "description");
                            newValues.put(key, params);
                            continue;
                        }
                        if (ServerVariable.class.getName().equals(annotationName)) {
                            LinkedHashMap variables = new LinkedHashMap();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                sv.stringValue("name").ifPresent(name -> {
                                    Map<CharSequence, Object> map = ConvertUtils.toValueMap(sv.getValues(), context);
                                    Object dv = map.get("defaultValue");
                                    if (dv != null) {
                                        map.put("default", dv);
                                    }
                                    if (map.containsKey("allowableValues")) {
                                        map.put("enum", map.remove("allowableValues"));
                                    }
                                    variables.put(name, map);
                                });
                            }
                            newValues.put(key, variables);
                            continue;
                        }
                        if (a.length == 1) {
                            AnnotationValue av = (AnnotationValue)a[0];
                            Map<CharSequence, Object> valueMap = ConvertUtils.toValueMap(av.getValues(), context);
                            newValues.put(key, ConvertUtils.toValueMap(valueMap, context));
                            continue;
                        }
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (Object o : a) {
                            if (o instanceof AnnotationValue) {
                                AnnotationValue av = (AnnotationValue)o;
                                Map<CharSequence, Object> valueMap = ConvertUtils.toValueMap(av.getValues(), context);
                                list.add(valueMap);
                                continue;
                            }
                            list.add(o);
                        }
                        newValues.put(key, list);
                        continue;
                    }
                    newValues.put(key, value);
                    continue;
                }
                newValues.put(key, a);
                continue;
            }
            newValues.put(key, ConvertUtils.parseJsonString(value).orElse(value));
        }
        return newValues;
    }

    public static Optional<Object> parseJsonString(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            try {
                return Optional.of(OpenApiUtils.CONVERT_JSON_MAPPER.readValue(string, Map.class));
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static <T> T treeToValue(JsonNode jn, Class<T> clazz, VisitorContext context) throws JsonProcessingException {
        JsonNode allowableValuesNode;
        Object defaultValue;
        Object value;
        boolean fixed = false;
        try {
            value = OpenApiUtils.CONVERT_JSON_MAPPER.treeToValue((TreeNode)jn, clazz);
        }
        catch (Exception e) {
            if (context.getLanguage() == VisitorContext.Language.GROOVY) {
                value = ConvertUtils.fixForGroovy(jn, clazz, null);
                fixed = true;
            }
            throw e;
        }
        if (!fixed && context.getLanguage() == VisitorContext.Language.GROOVY) {
            value = ConvertUtils.fixForGroovy(jn, clazz, null);
        }
        if (value == null) {
            return null;
        }
        Object finalValue = value;
        ConvertUtils.resolveExtensions(jn).ifPresent(extensions -> BeanMap.of((Object)finalValue).put((Object)"extensions", extensions));
        String elType = jn.has("type") ? jn.get("type").textValue() : null;
        String elFormat = jn.has("format") ? jn.get("format").textValue() : null;
        JsonNode defaultValueNode = jn.get("defaultValue");
        try {
            defaultValue = ConvertUtils.normalizeValue(defaultValueNode != null ? defaultValueNode.textValue() : null, elType, elFormat, context);
        }
        catch (JsonProcessingException e) {
            defaultValue = defaultValueNode != null ? defaultValueNode.textValue() : null;
        }
        BeanMap beanMap = BeanMap.of((Object)value);
        if (defaultValue != null) {
            beanMap.put((Object)"default", defaultValue);
        }
        if ((allowableValuesNode = jn.get("allowableValues")) != null && allowableValuesNode.isArray()) {
            ArrayList<Object> allowableValues = new ArrayList<Object>(allowableValuesNode.size());
            for (JsonNode allowableValueNode : allowableValuesNode) {
                if (allowableValueNode == null) continue;
                try {
                    allowableValues.add(ConvertUtils.normalizeValue(allowableValueNode.textValue(), elType, elFormat, context));
                }
                catch (IOException e) {
                    allowableValues.add(allowableValueNode.textValue());
                }
            }
            beanMap.put((Object)"allowableValues", allowableValues);
        }
        return (T)value;
    }

    private static <T> Map<String, T> deserMap(String name, JsonNode jn, Class<T> clazz) throws JsonProcessingException {
        JsonNode mapNode = jn.get(name);
        if (mapNode == null) {
            return null;
        }
        ((ObjectNode)jn).remove(name);
        Iterator iter = mapNode.fieldNames();
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (iter.hasNext()) {
            String entryKey = (String)iter.next();
            JsonNode objectNode = mapNode.get(entryKey);
            Object object = OpenApiUtils.CONVERT_JSON_MAPPER.treeToValue((TreeNode)objectNode, clazz);
            result.put(entryKey, object);
        }
        return !result.isEmpty() ? result : null;
    }

    private static <T> T fixForGroovy(JsonNode jn, Class<T> clazz, Exception e) throws JsonProcessingException {
        if (clazz == Operation.class) {
            JsonNode requestBodyNode = jn.get("requestBody");
            ((ObjectNode)jn).remove("requestBody");
            Object value = OpenApiUtils.CONVERT_JSON_MAPPER.treeToValue((TreeNode)jn, clazz);
            RequestBody requestBody = ConvertUtils.fixContentForGroovy(requestBodyNode, RequestBody.class);
            ((Operation)value).setRequestBody(requestBody);
            JsonNode responsesNode = jn.get("responses");
            ((ObjectNode)jn).remove("responses");
            ApiResponses responses = null;
            if (responsesNode != null && !responsesNode.isEmpty()) {
                responses = new ApiResponses();
                Iterator iter = responsesNode.fields();
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    responses.put((Object)((String)entry.getKey()), (Object)ConvertUtils.fixContentForGroovy((JsonNode)entry.getValue(), ApiResponse.class));
                }
            }
            ((Operation)value).setResponses(responses);
            return (T)value;
        }
        if (clazz == ApiResponse.class || clazz == Header.class || clazz == Parameter.class || clazz == RequestBody.class) {
            return ConvertUtils.fixContentForGroovy(jn, clazz);
        }
        return (T)OpenApiUtils.CONVERT_JSON_MAPPER.treeToValue((TreeNode)jn, clazz);
    }

    private static <T> T fixContentForGroovy(JsonNode parentNode, Class<T> clazz) throws JsonProcessingException {
        if (parentNode == null) {
            return null;
        }
        Map<String, Example> examples = null;
        Map<String, Encoding> encoding = null;
        Map<String, Object> extensions = null;
        Schema schema = null;
        JsonNode mediaTypeNode = null;
        JsonNode contentNode = parentNode.get("content");
        if (contentNode != null) {
            examples = ConvertUtils.deserMap("examples", contentNode, Example.class);
            encoding = ConvertUtils.deserMap("encoding", contentNode, Encoding.class);
            extensions = ConvertUtils.deserMap("extensions", contentNode, Object.class);
            JsonNode schemaNode = contentNode.get("schema");
            if (schemaNode != null) {
                schema = (Schema)OpenApiUtils.CONVERT_JSON_MAPPER.treeToValue((TreeNode)schemaNode, Schema.class);
            }
            mediaTypeNode = contentNode.get("mediaType");
            ((ObjectNode)contentNode).remove("mediaType");
        }
        Object value = OpenApiUtils.CONVERT_JSON_MAPPER.treeToValue((TreeNode)parentNode, clazz);
        Content content = null;
        if (value instanceof ApiResponse) {
            ApiResponse apiResponse = (ApiResponse)value;
            content = apiResponse.getContent();
        } else if (value instanceof Header) {
            Header header = (Header)value;
            content = header.getContent();
        } else if (value instanceof Parameter) {
            Parameter parameter = (Parameter)value;
            content = parameter.getContent();
        } else if (value instanceof RequestBody) {
            RequestBody requestBody = (RequestBody)value;
            content = requestBody.getContent();
        }
        if (content != null) {
            MediaType mediaType = (MediaType)content.get((Object)"schema");
            content.remove((Object)"schema");
            if (mediaType == null) {
                mediaType = new MediaType();
            }
            String contentType = mediaTypeNode != null ? mediaTypeNode.textValue() : "application/json";
            content.put((Object)contentType, (Object)mediaType);
            mediaType.setExamples(examples);
            mediaType.setEncoding(encoding);
            if (extensions != null) {
                extensions.forEach((arg_0, arg_1) -> ((MediaType)mediaType).addExtension(arg_0, arg_1));
            }
            mediaType.setSchema(schema);
        }
        return (T)value;
    }

    private static void processMediaType(Content result, JsonNode content) throws JsonProcessingException {
        String mediaType = content.has("mediaType") ? content.get("mediaType").asText() : "application/json";
        MediaType mediaTypeObj = (MediaType)OpenApiUtils.CONVERT_JSON_MAPPER.treeToValue((TreeNode)content, MediaType.class);
        result.addMediaType(mediaType, mediaTypeObj);
    }

    public static Object normalizeValue(String valueStr, String type, String format, VisitorContext context) throws JsonProcessingException {
        return ConvertUtils.normalizeValue(valueStr, type, format, context, false);
    }

    public static Object normalizeValue(String valueStr, String type, String format, VisitorContext context, boolean isMicronautFormat) throws JsonProcessingException {
        if (valueStr == null) {
            return null;
        }
        if (type == null || type.equals("object")) {
            return OpenApiUtils.CONVERT_JSON_MAPPER.readValue(valueStr, Map.class);
        }
        return ConvertUtils.parseByTypeAndFormat(valueStr, type, format, context, isMicronautFormat);
    }

    public static Optional<Map<String, Object>> resolveExtensions(JsonNode jn) {
        try {
            JsonNode extensionsNode = jn.get("extensions");
            if (extensionsNode != null) {
                return Optional.ofNullable((Map)OpenApiUtils.CONVERT_JSON_MAPPER.convertValue((Object)extensionsNode, MAP_TYPE_REFERENCE));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static void addSecuritySchemes(OpenAPI openApi, List<AnnotationValue<SecurityScheme>> values, VisitorContext context) {
        for (AnnotationValue<SecurityScheme> securityRequirementAnnValue : values) {
            Map<CharSequence, Object> map = ConvertUtils.toValueMap(securityRequirementAnnValue.getValues(), context);
            String name = securityRequirementAnnValue.stringValue("name").orElse(null);
            if (StringUtils.isEmpty((CharSequence)name)) continue;
            if (map.containsKey("paramName")) {
                map.put("name", map.remove("paramName"));
            }
            Utils.normalizeEnumValues(map, CollectionUtils.mapOf((Object[])new Object[]{"type", SecurityScheme.Type.class, "in", SecurityScheme.In.class}));
            String type = (String)map.get("type");
            if (!SecurityScheme.Type.APIKEY.toString().equals(type)) {
                ConvertUtils.removeAndWarnSecSchemeProp(map, "name", context, false);
                ConvertUtils.removeAndWarnSecSchemeProp(map, "in", context);
            }
            if (!SecurityScheme.Type.OAUTH2.toString().equals(type)) {
                ConvertUtils.removeAndWarnSecSchemeProp(map, "flows", context);
            }
            if (!SecurityScheme.Type.OPENIDCONNECT.toString().equals(type)) {
                ConvertUtils.removeAndWarnSecSchemeProp(map, "openIdConnectUrl", context);
            }
            if (!SecurityScheme.Type.HTTP.toString().equals(type)) {
                ConvertUtils.removeAndWarnSecSchemeProp(map, "scheme", context);
                ConvertUtils.removeAndWarnSecSchemeProp(map, "bearerFormat", context);
            }
            if (SecurityScheme.Type.HTTP.toString().equals(type)) {
                if (!map.containsKey("scheme")) {
                    ContextUtils.warn("Can't use http security scheme without 'scheme' property", context);
                } else if (!map.get("scheme").equals("bearer") && map.containsKey("bearerFormat")) {
                    ContextUtils.warn("Should NOT have a `bearerFormat` property without `scheme: bearer` being set", context);
                }
            }
            if (map.containsKey("ref") || map.containsKey("$ref")) {
                Object ref = map.get("ref");
                if (ref == null) {
                    ref = map.get("$ref");
                }
                map.clear();
                map.put("$ref", ref);
            }
            try {
                JsonNode node = ConvertUtils.toJson(map, context);
                io.swagger.v3.oas.models.security.SecurityScheme securityScheme = ConvertUtils.treeToValue(node, io.swagger.v3.oas.models.security.SecurityScheme.class, context);
                if (securityScheme == null) continue;
                ConvertUtils.resolveExtensions(node).ifPresent(extensions -> BeanMap.of((Object)securityScheme).put((Object)"extensions", extensions));
                Utils.resolveComponents(openApi).addSecuritySchemes(name, securityScheme);
            }
            catch (JsonProcessingException jsonProcessingException) {}
        }
    }

    private static void removeAndWarnSecSchemeProp(Map<CharSequence, Object> map, String prop, VisitorContext context) {
        ConvertUtils.removeAndWarnSecSchemeProp(map, prop, context, true);
    }

    private static void removeAndWarnSecSchemeProp(Map<CharSequence, Object> map, String prop, VisitorContext context, boolean withWarn) {
        if (map.containsKey(prop) && withWarn) {
            ContextUtils.warn("'" + prop + "' property can't set for securityScheme with type " + map.get("type") + ". Skip it", context);
        }
        map.remove(prop);
    }

    public static SecurityRequirement mapToSecurityRequirement(AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement> r) {
        String name = (String)r.getRequiredValue("name", String.class);
        List<String> scopes = Arrays.asList(r.stringValues("scopes"));
        SecurityRequirement securityRequirement = new SecurityRequirement();
        securityRequirement.addList(name, scopes);
        return securityRequirement;
    }

    public static void setDefaultValueObject(Schema<?> schema, String defaultValue, @Nullable Element element, @Nullable String schemaType, @Nullable String schemaFormat, boolean isMicronautFormat, VisitorContext context) {
        try {
            Pair<String, String> typeAndFormat;
            if (element instanceof EnumElement) {
                EnumElement enumEl = (EnumElement)element;
                typeAndFormat = ConvertUtils.checkEnumJsonValueType(context, enumEl, schemaType, schemaFormat);
            } else {
                typeAndFormat = Pair.of(schemaType, schemaFormat);
            }
            schema.setDefault(ConvertUtils.normalizeValue(defaultValue, typeAndFormat.getFirst(), typeAndFormat.getSecond(), context, isMicronautFormat));
        }
        catch (JsonProcessingException e) {
            ContextUtils.warn("Can't convert " + defaultValue + " to " + schemaType + ": " + e.getMessage(), context);
            schema.setDefault((Object)defaultValue);
        }
    }

    @NonNull
    public static Pair<String, String> checkEnumJsonValueType(VisitorContext context, @NonNull EnumElement type, @Nullable String schemaType, @Nullable String schemaFormat) {
        List fields;
        MethodElement firstMethod;
        block7: {
            List methods;
            block6: {
                if (schemaType != null && !schemaType.equals(PrimitiveType.STRING.getCommonName())) {
                    return Pair.of(schemaType, schemaFormat);
                }
                firstMethod = null;
                methods = type.getEnclosedElements(ElementQuery.ALL_METHODS.annotated(metadata -> metadata.isAnnotationPresent(JsonValue.class)));
                if (!CollectionUtils.isNotEmpty((Collection)methods)) break block6;
                firstMethod = (MethodElement)methods.get(0);
                if (methods.size() <= 1) break block7;
                ContextUtils.warn("Found " + methods.size() + " methods with @JsonValue. Process method " + firstMethod, context, (Element)type);
                break block7;
            }
            for (ClassElement interfaceEl : type.getInterfaces()) {
                methods = interfaceEl.getEnclosedElements(ElementQuery.ALL_METHODS.annotated(metadata -> metadata.isAnnotationPresent(JsonValue.class)));
                if (methods.isEmpty()) continue;
                firstMethod = (MethodElement)methods.get(0);
                if (methods.size() <= 1) break;
                ContextUtils.warn("Found " + methods.size() + " methods with @JsonValue. Process method " + firstMethod, context, (Element)type);
                break;
            }
        }
        Pair<String, String> result = null;
        if (firstMethod != null) {
            ClassElement returnType = firstMethod.getReturnType();
            if (returnType.isEnum()) {
                return ConvertUtils.checkEnumJsonValueType(context, (EnumElement)returnType, null, null);
            }
            result = ConvertUtils.getTypeAndFormatByClass(returnType.getName(), returnType.isArray());
        }
        if (result == null && CollectionUtils.isNotEmpty((Collection)(fields = type.getEnclosedElements(ElementQuery.ALL_FIELDS.annotated(metadata -> metadata.isAnnotationPresent(JsonValue.class)))))) {
            FieldElement firstField = (FieldElement)fields.get(0);
            ClassElement fieldType = firstField.getType();
            if (fieldType.isEnum()) {
                return ConvertUtils.checkEnumJsonValueType(context, (EnumElement)fieldType, null, null);
            }
            result = ConvertUtils.getTypeAndFormatByClass(fieldType.getName(), fieldType.isArray());
        }
        return result != null ? result : Pair.of(PrimitiveType.STRING.getCommonName(), schemaFormat);
    }

    public static Pair<String, String> getTypeAndFormatByClass(String className, boolean isArray) {
        if (className == null) {
            return Pair.of("object", null);
        }
        if (String.class.getName().equals(className) || Character.TYPE.getName().equals(className) || Character.class.getName().equals(className)) {
            return Pair.of("string", null);
        }
        if (Boolean.class.getName().equals(className) || Boolean.TYPE.getName().equals(className)) {
            return Pair.of("boolean", null);
        }
        if (Integer.class.getName().equals(className) || Integer.TYPE.getName().equals(className) || Short.class.getName().equals(className) || Short.TYPE.getName().equals(className)) {
            return Pair.of("integer", "int32");
        }
        if (BigInteger.class.getName().equals(className)) {
            return Pair.of("integer", null);
        }
        if (Long.class.getName().equals(className) || Long.TYPE.getName().equals(className)) {
            return Pair.of("integer", "int64");
        }
        if (Float.class.getName().equals(className) || Float.TYPE.getName().equals(className)) {
            return Pair.of("number", "float");
        }
        if (Double.class.getName().equals(className) || Double.TYPE.getName().equals(className)) {
            return Pair.of("number", "double");
        }
        if (isArray && (Byte.class.getName().equals(className) || Byte.TYPE.getName().equals(className))) {
            return Pair.of("string", "byte");
        }
        if (Byte.class.getName().equals(className) || Byte.TYPE.getName().equals(className)) {
            return Pair.of("integer", "int32");
        }
        if (BigDecimal.class.getName().equals(className)) {
            return Pair.of("number", null);
        }
        if (URI.class.getName().equals(className)) {
            return Pair.of("string", "uri");
        }
        if (URL.class.getName().equals(className)) {
            return Pair.of("string", "url");
        }
        if (UUID.class.getName().equals(className)) {
            return Pair.of("string", "uuid");
        }
        if (Number.class.getName().equals(className)) {
            return Pair.of("number", null);
        }
        if (File.class.getName().equals(className)) {
            return Pair.of("string", "binary");
        }
        if (LocalDate.class.getName().equals(className)) {
            return Pair.of("string", "date");
        }
        if (Date.class.getName().equals(className) || Calendar.class.getName().equals(className) || Instant.class.getName().equals(className) || LocalDateTime.class.getName().equals(className) || OffsetDateTime.class.getName().equals(className) || XMLGregorianCalendar.class.getName().equals(className) || ZonedDateTime.class.getName().equals(className)) {
            return Pair.of("string", "date-time");
        }
        if (LocalTime.class.getName().equals(className)) {
            return Pair.of("string", "partial-time");
        }
        return Pair.of("object", null);
    }

    public static Object parseByTypeAndFormat(String valueStr, String type, String format, VisitorContext context, boolean isMicronautFormat) {
        if (valueStr == null) {
            return null;
        }
        if ("array".equals(type) && isMicronautFormat) {
            return valueStr.split(",");
        }
        if (valueStr.isEmpty()) {
            return null;
        }
        try {
            if ("string".equals(type)) {
                if ("uri".equals(format)) {
                    return new URI(valueStr);
                }
                if ("url".equals(format)) {
                    return new URL(valueStr);
                }
                if ("uuid".equals(format)) {
                    return UUID.fromString(valueStr);
                }
                if (format == null) {
                    return valueStr;
                }
            } else {
                if ("boolean".equals(type)) {
                    return Boolean.parseBoolean(valueStr);
                }
                if ("array".equals(type)) {
                    return OpenApiUtils.JSON_MAPPER.readValue(valueStr, List.class);
                }
                if ("integer".equals(type)) {
                    if ("int32".equals(format)) {
                        return Integer.parseInt(valueStr);
                    }
                    if ("int64".equals(format)) {
                        return Long.parseLong(valueStr);
                    }
                    return new BigInteger(valueStr);
                }
                if ("number".equals(type)) {
                    if ("float".equals(format)) {
                        return Float.valueOf(Float.parseFloat(valueStr));
                    }
                    if ("double".equals(format)) {
                        return Double.parseDouble(valueStr);
                    }
                    return new BigDecimal(valueStr);
                }
                if ("object".equals(type) || type == null) {
                    try {
                        return OpenApiUtils.getConvertJsonMapper().readValue(valueStr, Map.class);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            ContextUtils.warn("Can't parse value " + valueStr + " with type " + type + " and format " + format, context);
        }
        return valueStr;
    }

    public static Map<String, String> toTupleSubMap(Object[] a, String entryKey, String entryValue) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (Object o : a) {
            AnnotationValue sv = (AnnotationValue)o;
            Optional n = sv.stringValue(entryKey);
            Optional expr = sv.stringValue(entryValue);
            if (!n.isPresent() || !expr.isPresent()) continue;
            params.put((String)n.get(), (String)expr.get());
        }
        return params;
    }
}

