/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.opensearch;

import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import jakarta.inject.Singleton;
import org.opensearch.client.opensearch.OpenSearchAsyncClient;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.TransportOptions;

@Factory
@Requires(beans={OpenSearchTransport.class})
@Internal
final class OpenSearchFactory {
    OpenSearchFactory() {
    }

    @Singleton
    OpenSearchClient openSearchClient(OpenSearchTransport transport, TransportOptions.Builder builder) {
        return new OpenSearchClient(transport, (TransportOptions)builder.build());
    }

    @Singleton
    OpenSearchAsyncClient openSearchAsyncClient(OpenSearchTransport transport, TransportOptions.Builder builder) {
        return new OpenSearchAsyncClient(transport, (TransportOptions)builder.build());
    }

    @Prototype
    TransportOptions.Builder createTransportOptionsBuilder() {
        return TransportOptions.builder();
    }
}

