/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.opensearch.health;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Locale;
import org.opensearch.client.opensearch.OpenSearchAsyncClient;
import org.opensearch.client.opensearch.cluster.HealthResponse;
import org.reactivestreams.Publisher;

@Singleton
public class OpenSearchClientHealthIndicator
implements HealthIndicator {
    private static final String NAME = "opensearchclient";
    private final OpenSearchAsyncClient client;

    public OpenSearchClientHealthIndicator(OpenSearchAsyncClient client) {
        this.client = client;
    }

    public Publisher<HealthResult> getResult() {
        return subscriber -> {
            try {
                this.client.cluster().health().handle((health, exception) -> {
                    subscriber.onNext((Object)OpenSearchClientHealthIndicator.healthResult(health, exception));
                    subscriber.onComplete();
                    return health;
                });
            }
            catch (IOException ex) {
                subscriber.onNext((Object)OpenSearchClientHealthIndicator.healthResult(null, ex));
                subscriber.onComplete();
            }
        };
    }

    static HealthResult healthResult(@Nullable HealthResponse healthResponse, @Nullable Throwable exception) {
        HealthResult.Builder resultBuilder = HealthResult.builder((String)NAME);
        if (exception != null) {
            return resultBuilder.status(HealthStatus.DOWN).exception(exception).build();
        }
        if (healthResponse == null) {
            return resultBuilder.status(HealthStatus.DOWN).build();
        }
        HealthStatus status = healthResponse.status() == org.opensearch.client.opensearch._types.HealthStatus.Red ? HealthStatus.DOWN : HealthStatus.UP;
        return resultBuilder.status(status).details((Object)OpenSearchClientHealthIndicator.healthResultDetails(healthResponse)).build();
    }

    private static String healthResultDetails(HealthResponse response) {
        return "{\"cluster_name\":\"" + response.clusterName() + "\",\"status\":\"" + response.status().name().toLowerCase(Locale.ENGLISH) + "\",\"timed_out\":" + response.timedOut() + ",\"number_of_nodes\":" + response.numberOfNodes() + ",\"number_of_data_nodes\":" + response.numberOfDataNodes() + ",\"number_of_pending_tasks\":" + response.numberOfPendingTasks() + ",\"number_of_in_flight_fetch\":" + response.numberOfInFlightFetch() + ",\"task_max_waiting_in_queue\":\"" + response.taskMaxWaitingInQueueMillis() + "\",\"task_max_waiting_in_queue_millis\":" + response.taskMaxWaitingInQueueMillis() + ",\"active_shards_percent_as_number\":\"" + response.activeShardsPercentAsNumber() + "\",\"active_primary_shards\":" + response.activePrimaryShards() + ",\"active_shards\":" + response.activeShards() + ",\"relocating_shards\":" + response.relocatingShards() + ",\"initializing_shards\":" + response.initializingShards() + ",\"unassigned_shards\":" + response.unassignedShards() + ",\"delayed_unassigned_shards\":" + response.delayedUnassignedShards() + "}";
    }
}

