/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.atp.jdbc.upc;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.oraclecloud.atp.jdbc.AutonomousDatabaseConfiguration;
import io.micronaut.oraclecloud.atp.jdbc.OracleWalletArchiveProvider;
import io.micronaut.oraclecloud.atp.wallet.datasource.CanConfigureOracleDataSource;
import io.micronaut.oraclecloud.atp.wallet.datasource.OracleDataSourceAttributes;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.sql.SQLException;
import javax.net.ssl.SSLContext;
import javax.sql.DataSource;
import oracle.ucp.jdbc.PoolDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requirements(value={@Requires(sdk=Requires.Sdk.JAVA, value="11"), @Requires(classes={PoolDataSource.class}), @Requires(beans={OracleWalletArchiveProvider.class})})
@Internal
public class UcpPoolConfigurationListener
implements BeanCreatedEventListener<DataSource>,
Ordered {
    public static final int POSITION = -2147483548;
    private static final String ORACLE_JDBC_POOL_ORACLE_DATA_SOURCE = "oracle.jdbc.pool.OracleDataSource";
    private static final Logger LOG = LoggerFactory.getLogger(UcpPoolConfigurationListener.class);
    private final OracleWalletArchiveProvider walletArchiveProvider;
    private final BeanLocator beanLocator;

    protected UcpPoolConfigurationListener(OracleWalletArchiveProvider walletArchiveProvider, BeanLocator beanLocator) {
        this.walletArchiveProvider = walletArchiveProvider;
        this.beanLocator = beanLocator;
    }

    public int getOrder() {
        return -2147483548;
    }

    public DataSource onCreated(BeanCreatedEvent<DataSource> event) {
        DataSource dataSource = (DataSource)event.getBean();
        if (dataSource instanceof PoolDataSource) {
            final PoolDataSource bean = (PoolDataSource)dataSource;
            BeanIdentifier beanIdentifier = event.getBeanIdentifier();
            final String beanName = beanIdentifier.getName();
            AutonomousDatabaseConfiguration autonomousDatabaseConfiguration = this.beanLocator.findBean(AutonomousDatabaseConfiguration.class, Qualifiers.byName((String)beanName)).orElse(null);
            if (autonomousDatabaseConfiguration == null) {
                LOG.trace("No AutonomousDatabaseConfiguration for [{}] datasource", (Object)beanName);
            } else if (autonomousDatabaseConfiguration.getOcid() == null || autonomousDatabaseConfiguration.getWalletPassword() == null) {
                LOG.trace("Skipping configuration of Oracle Wallet due to missing ocid or wallet password in AutonomousDatabaseConfiguration for [{}] datasource", (Object)beanName);
            } else {
                LOG.trace("Retrieving Oracle Wallet for DataSource [{}]", (Object)beanName);
                CanConfigureOracleDataSource walletArchive = this.walletArchiveProvider.loadWalletArchive(autonomousDatabaseConfiguration);
                try {
                    if (StringUtils.isEmpty((CharSequence)bean.getConnectionFactoryClassName())) {
                        LOG.trace("Configured connection factory oracle.jdbc.pool.OracleDataSource for [{}] datasource", (Object)beanName);
                        bean.setConnectionFactoryClassName(ORACLE_JDBC_POOL_ORACLE_DATA_SOURCE);
                    }
                    walletArchive.configure(new OracleDataSourceAttributes(){
                        private SSLContext sslContext;

                        @Override
                        public SSLContext sslContext() {
                            return this.sslContext;
                        }

                        public OracleDataSourceAttributes sslContext(SSLContext sslContext) {
                            this.sslContext = sslContext;
                            bean.setSSLContext(sslContext);
                            return this;
                        }

                        @Override
                        public String url() {
                            return null;
                        }

                        public OracleDataSourceAttributes url(String url) {
                            try {
                                bean.setURL(url);
                                return this;
                            }
                            catch (SQLException e) {
                                throw new ConfigurationException("Error configuring the [" + beanName + "] datasource url: " + e.getMessage(), (Throwable)e);
                            }
                        }

                        @Override
                        public String user() {
                            return bean.getUser();
                        }

                        public OracleDataSourceAttributes user(String user) {
                            try {
                                bean.setUser(user);
                                return this;
                            }
                            catch (SQLException e) {
                                throw new ConfigurationException("Error configuring the [" + beanName + "] datasource user: " + e.getMessage(), (Throwable)e);
                            }
                        }

                        @Override
                        public char[] password() {
                            if (bean.getPassword() != null) {
                                return bean.getPassword().toCharArray();
                            }
                            return null;
                        }

                        public OracleDataSourceAttributes password(char[] password) {
                            try {
                                bean.setPassword(String.valueOf(password));
                                return this;
                            }
                            catch (SQLException e) {
                                throw new ConfigurationException("Error configuring the [" + beanName + "] datasource password: " + e.getMessage(), (Throwable)e);
                            }
                        }
                    });
                    LOG.debug("Successfully configured OracleWallet for [{}] datasource", (Object)beanName);
                }
                catch (IOException | SQLException e) {
                    throw new ConfigurationException("Error configuring the [" + beanName + "] datasource: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return dataSource;
    }
}

