/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.atp.wallet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;

class ByteStreams {
    private static final int BUFFER_SIZE = 65536;

    ByteStreams() {
    }

    static Reader reader(InputStream content) {
        return new InputStreamReader(content, StandardCharsets.UTF_8);
    }

    byte[] asByteArray(InputStream is) throws IOException {
        ReadableByteChannel source = Channels.newChannel(is);
        return this.asByteArray(source);
    }

    byte[] asByteArray(ReadableByteChannel source) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            WritableByteChannel destination = Channels.newChannel(os);
            this.copy(source, destination);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    String asString(InputStream is) throws IOException {
        byte[] bytes = this.asByteArray(is);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    InputStream asInputStream(byte[] bytes) {
        return new ByteArrayInputStream(bytes);
    }

    long copy(InputStream is, OutputStream os) throws IOException {
        if (is != null && os != null) {
            ReadableByteChannel source = Channels.newChannel(is);
            WritableByteChannel destination = Channels.newChannel(os);
            return this.copy(source, destination);
        }
        return -1L;
    }

    private long copy(ReadableByteChannel source, WritableByteChannel destination) throws IOException {
        long length = 0L;
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        while (source.read(buffer) != -1) {
            buffer.flip();
            while (buffer.hasRemaining()) {
                length += (long)destination.write(buffer);
            }
            buffer.clear();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            destination.write(buffer);
        }
        return length;
    }

    InputStream uncloseable(InputStream in) {
        return new Uncloseable(in);
    }

    private static final class Uncloseable
    extends FilterInputStream {
        Uncloseable(InputStream in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }
}

