/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.atp.wallet;

import io.micronaut.oraclecloud.atp.wallet.WalletException;
import io.micronaut.oraclecloud.atp.wallet.datasource.OracleDataSourceAttributes;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;

class DataSourceCredentials {
    private static final String ORACLE_THIN_JDBC_PREFIX = "jdbc:oracle:thin:";
    private static final String PASSWORD = "oracle.security.client.password";
    private static final String SERVICE_NAME_SYNTAX_PREFIX = "@//";
    private static final String USER = "oracle.security.client.username";
    private static final String CONNECT_STRING_PREFIX = "oracle.security.client.connect_string";
    private final int index;
    private final OracleSecretStore store;
    private final String url;
    private final String user;

    private DataSourceCredentials(OracleSecretStore store, int index, String url, String user) {
        this.store = store;
        this.index = index;
        this.url = url;
        this.user = user;
    }

    static Map<String, DataSourceCredentials> credentials(OracleSecretStore store) throws WalletException {
        try {
            LinkedHashMap<String, DataSourceCredentials> credentials = new LinkedHashMap<String, DataSourceCredentials>();
            int i = 1;
            boolean check = true;
            while (check) {
                if (store.containsAlias(CONNECT_STRING_PREFIX + i)) {
                    String serviceAlias = new String(store.getSecret(CONNECT_STRING_PREFIX + i));
                    DataSourceCredentials dataSourceCredentials = DataSourceCredentials.of(store, serviceAlias, i);
                    credentials.put(serviceAlias, dataSourceCredentials);
                    ++i;
                    continue;
                }
                check = false;
            }
            return credentials;
        }
        catch (OracleSecretStoreException e) {
            throw WalletException.of(e);
        }
    }

    private static DataSourceCredentials of(OracleSecretStore store, String serviceAlias, int index) throws WalletException {
        try {
            String url = null;
            String user = new String(store.getSecret(USER + index));
            if (serviceAlias.startsWith(SERVICE_NAME_SYNTAX_PREFIX)) {
                StringBuilder text = new StringBuilder();
                text.append(ORACLE_THIN_JDBC_PREFIX);
                text.append(serviceAlias);
                url = text.toString();
            }
            return new DataSourceCredentials(store, index, url, user);
        }
        catch (OracleSecretStoreException e) {
            throw WalletException.of(e);
        }
    }

    <T extends OracleDataSourceAttributes> T configure(T dataSource) throws WalletException {
        if (this.url != null) {
            dataSource.url(this.url);
        }
        dataSource.user(this.user);
        char[] password = this.secret(PASSWORD);
        try {
            dataSource.password(password);
        }
        finally {
            this.erase(password);
        }
        return dataSource;
    }

    private void erase(char[] password) {
        if (password != null) {
            for (int i = 0; i < password.length; ++i) {
                password[i] = 42;
            }
        }
    }

    private char[] secret(String prefix) throws WalletException {
        try {
            return this.store.getSecret(prefix + this.index);
        }
        catch (OracleSecretStoreException e) {
            throw WalletException.of(e);
        }
    }
}

