/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.atp.wallet;

import io.micronaut.oraclecloud.atp.wallet.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import oracle.security.pki.OracleWallet;

class OracleWallets {
    private final ByteStreams streams;

    OracleWallets(ByteStreams streams) {
        this.streams = streams;
    }

    OracleWallet read(byte[] payload, char[] password) throws IOException {
        OracleWallet wallet = new OracleWallet();
        InputStream bufferedStream = this.streams.asInputStream(payload);
        wallet.setWalletArray(bufferedStream, password);
        return wallet;
    }

    OracleWallet copy(OracleWallet existing, char[] password) throws IOException {
        try (InputStream payload = existing.getWalletArray(true);){
            OracleWallet duplicate;
            byte[] bytes = this.streams.asByteArray(payload);
            OracleWallet oracleWallet = duplicate = this.read(bytes, password);
            return oracleWallet;
        }
    }
}

