/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.atp.wallet;

import io.micronaut.oraclecloud.atp.wallet.ByteStreams;
import io.micronaut.oraclecloud.atp.wallet.ConnectionDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NLParamParser;
import oracle.net.jdbc.nl.NVPair;

final class TNSNames {
    static final String NAME = "tnsnames.ora";
    private final Map<String, ConnectionDescriptor> connectionDescriptors;

    private TNSNames(Map<String, ConnectionDescriptor> connectionDescriptors) {
        this.connectionDescriptors = Collections.unmodifiableMap(connectionDescriptors != null ? new TreeMap<String, ConnectionDescriptor>(connectionDescriptors) : new TreeMap());
    }

    static final TNSNames read(InputStream content) throws IOException {
        TNSNames tNSNames;
        block9: {
            Reader r = ByteStreams.reader(content);
            try {
                LinkedHashMap<String, ConnectionDescriptor> connectionDescriptors = new LinkedHashMap<String, ConnectionDescriptor>();
                NLParamParser parser = new NLParamParser(r);
                for (String serviceAlias : parser.getNLPAllNames()) {
                    NVPair value = parser.getNLPListElement(serviceAlias);
                    ConnectionDescriptor connectionDescriptor = new ConnectionDescriptor(value.valueToString());
                    connectionDescriptors.put(serviceAlias, connectionDescriptor);
                }
                tNSNames = new TNSNames(connectionDescriptors);
                if (r == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NLException e) {
                    throw new IOException(e);
                }
            }
            r.close();
        }
        return tNSNames;
    }

    public boolean isEmpty() {
        return this.connectionDescriptors.isEmpty();
    }

    public Collection<ConnectionDescriptor> tnsEntries() {
        return Collections.unmodifiableCollection(this.connectionDescriptors.values());
    }

    ConnectionDescriptor connectionDescriptor(String serviceAlias) {
        String normalized = serviceAlias.toUpperCase();
        ConnectionDescriptor connectionDescriptor = this.connectionDescriptors.get(normalized);
        return connectionDescriptor;
    }
}

