/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.atp.wallet;

import io.micronaut.oraclecloud.atp.wallet.DataSourceCredentials;
import io.micronaut.oraclecloud.atp.wallet.WalletException;
import io.micronaut.oraclecloud.atp.wallet.datasource.CanConfigureOracleDataSource;
import io.micronaut.oraclecloud.atp.wallet.datasource.OracleDataSourceAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;

final class Wallet
implements CanConfigureOracleDataSource {
    private static final String TLS_PROTOCOL = "TLS";
    private static final String CONNECT_STRING = "oracle.security.client.connect_string";
    private static final String PASSWORD = "oracle.security.client.password";
    private static final String USER = "oracle.security.client.username";
    final transient SSLContext sslContext;
    final OracleWallet wallet;
    private final Map<String, DataSourceCredentials> credentials;
    private final String serviceAlias;

    private Wallet(OracleWallet wallet, Map<String, DataSourceCredentials> credentials, SSLContext sslContext, String serviceAlias) {
        this.wallet = wallet;
        this.credentials = credentials;
        this.sslContext = sslContext;
        this.serviceAlias = serviceAlias;
    }

    static Wallet of(OracleWallet wallet) throws WalletException {
        try {
            OracleSecretStore store = wallet.getSecretStore();
            Map<String, DataSourceCredentials> credentials = DataSourceCredentials.credentials(store);
            SSLContext sslContext = Wallet.sslContext(wallet);
            return new Wallet(wallet, credentials, sslContext, null);
        }
        catch (IOException | OracleSecretStoreException e) {
            throw WalletException.of(e);
        }
    }

    private static SSLContext sslContext(OracleWallet wallet) throws WalletException {
        try {
            KeyStore walletKeyStore = wallet.getKeyStore();
            if (walletKeyStore == null || 0 == walletKeyStore.size()) {
                return null;
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(walletKeyStore);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(walletKeyStore, null);
            SSLContext sslContext = SSLContext.getInstance(TLS_PROTOCOL);
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            return sslContext;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw WalletException.of(e);
        }
    }

    public String serviceAlias() {
        return this.serviceAlias;
    }

    public Wallet with(String serviceAlias) {
        return new Wallet(this.wallet, this.credentials, this.sslContext, serviceAlias);
    }

    @Override
    public <T extends OracleDataSourceAttributes> T configure(T dataSource) throws WalletException {
        DataSourceCredentials credentials;
        if (this.sslContext != null) {
            dataSource.sslContext(this.sslContext);
        }
        if (this.serviceAlias != null && (credentials = this.credentials.get(this.serviceAlias)) != null) {
            credentials.configure(dataSource);
        }
        return dataSource;
    }

    public InputStream asInputStream() throws IOException {
        return this.wallet.getWalletArray(true);
    }

    public static class Builder {
        private final transient KeyStore keyStore;
        private final transient OracleSecretStore store;
        private final transient OracleWallet wallet;

        private Builder(OracleWallet wallet) throws IOException {
            try {
                this.wallet = wallet;
                this.store = wallet.getSecretStore();
                this.keyStore = wallet.getKeyStore();
            }
            catch (IOException | OracleSecretStoreException e) {
                throw WalletException.of(e);
            }
        }

        static Builder of(OracleWallet wallet) throws IOException {
            return new Builder(wallet);
        }

        public Wallet build() throws WalletException {
            try {
                this.wallet.setSecretStore(this.store);
                return Wallet.of(this.wallet);
            }
            catch (IOException | OracleSecretStoreException e) {
                throw WalletException.of(e);
            }
        }

        public int findIndex(String serviceAlias) throws WalletException {
            return this.findIndex(this.store, serviceAlias);
        }

        private int findIndex(OracleSecretStore store, String serviceAlias) throws WalletException {
            try {
                String aliasPrefix = Wallet.CONNECT_STRING;
                String expected = serviceAlias;
                Enumeration e = store.internalAliases();
                int index = 1;
                while (e.hasMoreElements()) {
                    String alias = (String)e.nextElement();
                    if (!alias.startsWith(Wallet.CONNECT_STRING)) continue;
                    char[] secret = store.getSecret(alias);
                    if (expected.equals(new String(secret))) {
                        return index;
                    }
                    ++index;
                }
                return index;
            }
            catch (OracleSecretStoreException e) {
                throw WalletException.of(e);
            }
        }

        public Builder set(String alias, Certificate cert) throws WalletException {
            try {
                if (this.keyStore.containsAlias(alias)) {
                    this.keyStore.deleteEntry(alias);
                }
                if (cert != null) {
                    this.keyStore.setCertificateEntry(alias, cert);
                }
                return this;
            }
            catch (KeyStoreException e) {
                throw WalletException.of(e);
            }
        }

        public Builder set(String alias, char[] secret) throws WalletException {
            try {
                if (secret == null) {
                    if (this.store.containsAlias(alias)) {
                        this.store.deleteSecret(alias);
                    }
                } else {
                    this.store.setSecret(alias, secret);
                }
                return this;
            }
            catch (OracleSecretStoreException e) {
                throw WalletException.of(e);
            }
        }

        private Builder set(String prefix, int index, char[] value) throws WalletException {
            if (index > 0) {
                String alias = prefix + index;
                this.set(alias, value);
            }
            return this;
        }

        public Builder set(String serviceAlias, String user, char[] password) throws WalletException {
            int index = this.findIndex(this.store, serviceAlias);
            this.set(Wallet.CONNECT_STRING, index, serviceAlias.toCharArray());
            this.set(Wallet.USER, index, user.toCharArray());
            this.set(Wallet.PASSWORD, index, password);
            return this;
        }
    }
}

